/*
	Audio File Library

	Copyright 1998, Michael Pruett <michael@68k.org>

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License as
	published by the Free Software Foundation; either version 2 of
	the License, or (at your option) any later version.

	This program is distributed in the hope that it will be
	useful, but WITHOUT ANY WARRANTY; without even the implied
	warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
	PURPOSE.  See the GNU General Public License for more details.

	You should have received a copy of the GNU General Public
	License along with this program; if not, write to the Free
	Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
	MA 02111-1307, USA.
*/

#include <sys/types.h>
#include <stdio.h>

#ifdef USE_SGI_HEADERS
#include <dmedia/audiofile.h>
#else
#include "audiofile.h"
#endif

char copyright[] = "1998 Michael Pruett";
char name[] = "Michael Pruett's home-brew methamphetamines";

/* Two frames of 16-bit stereo samples. */
u_int16_t data[] = {0, 1, 2, 3};

main (int ac, char **av)
{
	AFfilehandle	file;
	AFfilesetup		setup;
	int				miscids[] = {1, 2};
	int				result;

	if (ac < 2)
	{
		fprintf(stderr, "usage: %s <audio file>\n", av[0]);
		exit(0);
	}

	setup = afNewFileSetup();
	afInitMiscIDs(setup, miscids, 2);
	afInitMiscType(setup, 1, AF_MISC_COPY);
	afInitMiscType(setup, 2, AF_MISC_NAME);
	afInitMiscSize(setup, 1, strlen(copyright));
	afInitMiscSize(setup, 2, strlen(name));

	file = afOpenFile(av[1], "w", setup);

	result = afWriteMisc(file, 1, copyright, strlen(copyright));
	printf("result = %d\n", result);
	result = afWriteMisc(file, 2, name, strlen(name));
	printf("result = %d\n", result);

	/* Write out two token frames of sample data. */
	afWriteFrames(file, AF_DEFAULT_TRACK, data, 2);

	afCloseFile(file);
	afFreeFileSetup(setup);
}
