/*****************************************************************************
 *                                                                           *
 * Programm:  paul                                                           *
 *            (P)rogramm zur (A)uswertung und (U)mformung von                *
 *            (L)aserbildern                                                 *
 * Modul:     pngsave.c                                                      *
 *            Schreiben von PNG-Dateien                                      *
 * Autor:     Andreas Tille                                                  *
 * Datum:     01.04.1998                                                     *
 *                                                                           *
 *****************************************************************************/

#include <png.h>
#include "paul.h"

#ifdef __DMALLOC__
#include <dmalloc.h>
#endif

int WritePNGImage(PICTURE *bild, char *filename)
/* Schreiben von PNG-Dateien
 * --- Parameter: ---
 * PICTURE *bild       : zu schreibende Bild-Daten
 * char    *filename   : PNG-Dateiname (kann von bild->file abweichen!!)
 * --- R"uckgabe: ---
 * int WritePNGImage() : 0 fr OK
 */
{
   register   unsigned char *ap, *bp, *fip, **app, **fipp;
   int        rowbytes;
   png_info   *pngi;
   png_struct *png;
   unsigned   char *png_pixels, **scanlines;
   FILE       *fp;
   png_text   textp[1];
   CHUNK      *cp;
   png_time   zeit;

   if ( !(fp = fopen(filename,"w")) ) {
      fprintf(stderr, "Unable to open %s\n", filename);
      return -1;
   }
   if ( !(png = png_create_write_struct(PNG_LIBPNG_VER_STRING, NULL, NULL, NULL)) ) {
      fprintf(stderr, "Unable to open PNG write structure for %s\n", filename);
      fclose(fp);
      return -1;
   }
   if ( !(pngi = png_create_info_struct(png)) ) {
      fprintf(stderr, "Unable to create PNG info structure for %s\n", filename);
      fclose(fp);
      png_destroy_write_struct(&png, NULL);
      return -1;
   }
   if ( setjmp(png->jmpbuf) ) {
      png_destroy_write_struct(&png,&pngi);
      fclose(fp);
      return -1;
   }

   /* Prepare PNG for writing. */
printf("WritePNGImage %s\n", filename);
   png_init_io(png, fp);
   png_set_IHDR(png, pngi, bild->W, bild->H, 8,
                IsMonochrom(bild) ? PNG_COLOR_TYPE_GRAY : PNG_COLOR_TYPE_RGB,
		PNG_INTERLACE_NONE, PNG_COMPRESSION_TYPE_BASE, PNG_FILTER_TYPE_BASE);

   pngi->max_text=9;
   if ( !(pngi->text = malloc(pngi->max_text * sizeof(png_text))) ) {
      fprintf(stderr, "Unable to allocate memory for PNG text chunks for %s\n", filename);
      fclose(fp);
      png_destroy_write_struct(&png, NULL);
      return -1;
   }
   if ( bild->spec ) 
      for ( cp = bild->spec; cp->key != NULL; cp++ ) 
         if ( cp->value ) {
            textp->key         = cp->key;
            textp->text        = cp->value;
            textp->compression = (textp->text_length = strlen(cp->value)) < 256 
                                                     ? PNG_TEXT_COMPRESSION_NONE 
                                                     : PNG_TEXT_COMPRESSION_zTXt;
            png_set_text(png, pngi, textp, 1);
         }

   if ( bild->zeit > 0 ) png_convert_from_time_t(&zeit, bild->zeit);
   else                  png_convert_from_time_t(&zeit, time(NULL));
   png_set_tIME(png, pngi, &zeit);
   if ( bild->res ) 
      png_set_pHYs(png, pngi, bild->res, bild->res, PNG_RESOLUTION_UNKNOWN);
   if ( bild->x_offset != (unsigned long)-1 )
      png_set_oFFs(png, pngi, bild->x_offset, bild->y_offset, PNG_OFFSET_PIXEL);
   if ( bild->n_gamma && bild->gamma )
      png_set_PLTE(png, pngi, bild->gamma, bild->n_gamma);

   png_write_info(png, pngi);
   png_set_packing(png);

  /* Allocate memory. */
   rowbytes = bild->spp * bild->W;
   png_pixels = malloc(rowbytes * (bild->H));
   scanlines  = malloc(    4*    bild->H);
      /* Warum hier 4* stehen mu (!sonst SIGSEGV!) ist mir schleierhaft! */
   if ( !png_pixels || !scanlines ) {
      fprintf(stderr, "Unable to allocate PNG image memory for %s\n", filename);
      fclose(fp);
      if ( png_pixels ) free(png_pixels);
      png_destroy_write_struct(&png, NULL);
      return -1;
   }

   /* Initialize image scanlines. */
   for ( fipp = (app = scanlines) + bild->H, ap = png_pixels; app < fipp; 
         app++, ap += rowbytes )
      *app = ap;

   if ( IsMonochrom(bild) && bild->storepix == 3 )
      for ( fip = (ap = png_pixels) + rowbytes * (bild->H), bp = bild->DATA + 1;
            ap < fip; ap++, bp += 3)
         *ap = *bp;
   else
      memcpy(png_pixels, bild->DATA, rowbytes * bild->H);

   png_write_image(png, scanlines);

   free(scanlines);
   free(png_pixels);
   
   png_write_end(png,pngi);
   png_destroy_write_struct(&png, &pngi);
   fclose(fp);
   return 0;
}

















