/*****************************************************************************
 *                                                                           *
 * Program:   paul                                                           *
 *            (P)rogramm zur (A)uswertung und (U)mformung von                *
 *            (L)aserbildern                                                 *
 * Uses:      GTK                                                            *
 * Modul:     messages.c                                                     *
 *            various output staff                                           *
 * Author:    Andreas Tille                                                  *
 * Date:      18.09.1998                                                     *
 *                                                                           *
 *****************************************************************************/

#include "paul.h"
#include "callback.h"

enum { MESSAGE, WARNING, ERROR, LAST_TYPE };

static const char *MSG_TYPE[LAST_TYPE] = { "Message", "Warning", "Error" };

static void PrintIt(int type, char *str)
{
   static GtkWidget *window = NULL; 
   GtkWidget *text, *button;

   if ( !gtk_main_level() ) { 
/* if ( 1 ) { */
      char *buf = malloc(strlen(str)+17);

      buf = strcat(strcat(strcat(strcpy(buf, MSG_TYPE[type]), ": "), str), "\n");
      if ( type ) { fputs(buf, stderr); fflush(stderr); }      
      else        { fputs(buf, stdout); fflush(stdout); }
      free(buf);
      return;
   }

   if ( window ) {
      gtk_widget_destroy(window);
      window = NULL;
   }

   window = gtk_dialog_new();
   gtk_window_position(GTK_WINDOW(window), GTK_WIN_POS_MOUSE);
   gtk_signal_connect(GTK_OBJECT(window), "destroy", GTK_SIGNAL_FUNC(gtk_widget_destroyed), &window);
   gtk_window_set_title(GTK_WINDOW(window), MSG_TYPE[type]);

   text = gtk_label_new(str);
   gtk_container_border_width(GTK_CONTAINER(GTK_DIALOG(window)->vbox), 10);
   gtk_container_add(GTK_CONTAINER(GTK_DIALOG(window)->vbox), text);

   button = CreateCancelButton(window, GTK_DIALOG(window)->action_area);
   GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
   gtk_widget_grab_default(button);
  
   gtk_widget_show_all(window);
}

static void Message(char *str)
{
   PrintIt(MESSAGE, str);
}

static void Error(char *str)
{
   PrintIt(ERROR, str);
}

static void Warning(char *str)
{
   PrintIt(WARNING, str); 
}

void MessagesInit(void)
/* Initialize message functions
 */
{
   g_set_message_handler(Message);
   g_set_error_handler(Error);
   g_set_warning_handler(Warning);   
}

