/*****************************************************************************
 *                                                                           *
 * Programm:  paul                                                           *
 *            (P)rogramm zur (A)uswertung und (U)mformung von                *
 *            (L)aserbildern                                                 *
 * Modul:     extrema.c                                                      *
 *            Funktions to obtain extrema of brightness                      *
 * Autor:     Andreas Tille                                                  *
 * Datum:     04.05.1998                                                     *
 *                                                                           *
 *****************************************************************************/

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

#include "paul.h"

#ifdef __DMALLOC__
#include <dmalloc.h>
#endif

static void Extremum(PICTURE *ext, unsigned char **datamin, unsigned char **datamax, int ex, int ey)
/* bestimmt hellstes und dunkelstes Gebiet in einem Bild
 * --- Parameter: ---
 * PICTURE *ext           : Bildstruktur
 * unsigned char **datamin: Zeiger auf Beginn des Gebietes minimaler Helligkeit
 * unsigned char **datamax: Zeiger auf Beginn des Gebietes maximaler Helligkeit
 * int ex                 : Gebietbreite
 * int ey                 : Gebiethhe
 * --- Return: ---
 * unsigned char **datamin: Zeiger auf Beginn des Gebietes minimaler Helligkeit
 * unsigned char **datamax: Zeiger auf Beginn des Gebietes maximaler Helligkeit
 */
{
   register int            storepix = ext->storepix;
   register unsigned char *ap, *exmax, *exmin;
   register unsigned long  next;
   unsigned char          *bp, *fap, *fbp;
   int                     prz = 0, przstep, iprz = 1;
   unsigned long           min, max, first,
            step = ext->storepix * ext->W * ey,            /* olf box start until new box end */
            sl   = ext->storepix * ext->W * (ext->H - ey); /* length of column                */

   exmin = exmax = ext->DATA;
   min = max = first = next = brightness(ext->DATA, ex, ey, ext->W, storepix);
   printf("Search for extrema of %s: %3i%%", ext->file, prz);
   przstep = (ext->W - ex + 5) / 10;
   /* erste Spalte: */
   for ( fap = (ap = ext->DATA) + sl; ap < fap; ) {
      next += Xsum(ap + step, storepix*ex);
      next -= Xsum(ap, storepix*ex); /* wegen unsigned Werten in zwei Zeilen */
      ap   += storepix * ext->W;
      if ( next < min ) { min = next; exmin = ap; }
      else if ( next > max ) { max = next; exmax = ap; }
   }

   /* alle weiteren Spalten: */
   for ( fbp = (bp = ext->DATA + storepix) + storepix*(ext->W - ex - 1); bp < fbp; bp += storepix ) {
      if ( (przstep > 0) && (++iprz % przstep == 0) ) {
         printf("\x8\x8\x8\x8%3i%%", prz += 10); fflush(stdout); }
/* DAS FUNKTIONIERT NICHT FR storepix==1!!! Dann Ysum3 -> Ysum !!! */
      next = (first += (Ysum3(bp+storepix*(ex-1), ey, ext->W) - Ysum3(bp-storepix, ey, ext->W) ));
      if ( next < min ) { min = next; exmin = bp; }
      else if ( next > max ) { max = next; exmax = bp; }
      for ( fap = (ap = bp) + sl; ap < fap; ) {
         next += Xsum(ap + step, storepix*ex);
         next -= Xsum(ap, storepix*ex); /* wegen unsigned Werten in zwei Zeilen */
         ap   += storepix * ext->W;
         if ( next < min ) { min = next; exmin = ap; }
         else if ( next > max ) { max = next; exmax = ap; }
      }
   }
   puts("\x8\x8\x8\x8\x31\x30\x30%"); fflush(stdout);
   *datamin = exmin;
   *datamax = exmax;
}


int Extrema(PAUL *p)
/* estimate brightest and darkest box of given size in set of images
 * --- Parameter: ---
 * PAUL *p         : list of images, options
 *                   used options :
 *                   cut.x2 : width of box
 *                   cut.y2 : height of box
 *                   flag   : search for minima/maxima/both
 * --- Return: ---
 * p->piclist      : images of extrema
 * int   Extrema() : if OK 0, else -1
 */
{
   PICTURE        *bild, *zw;
   BOX             cut[1];
   int             check, bx, by;   
   char            buf[256];
   unsigned char  *max, *min;
   register GList *pl, *piclist, *fip;

   bx = p->opt->cut->x2;
   by = p->opt->cut->y2;   

   piclist = p->piclist;
   if ( !NBILDER(piclist) ) return 0;

   fip = g_list_last(piclist);  /* Da Liste anwchst */
   for ( bild = BILD(pl = piclist); pl <= fip; bild = BILD(pl = pl->next) ) {
      if ( bx < 0 ) continue;
      cut->x1 = cut->y1 = 0;
      cut->x2 = bx; cut->y2 = by;
      if ( (check = CheckInBounds(bild, cut)) < 1 ) continue;
      Extremum(bild, &min, &max, bx, by);
      if ( SaveExtrema(p->opt->f) ) {
         if ( SaveMinima(p->opt->f) ) {
            cut->x1  = (cut->y1 = (min - bild->DATA)/(bild->storepix)) % bild->W;
            cut->y1 /= bild->W;
            cut->x2  = cut->x1 + bx;
	    cut->y2  = cut->y1 + by;
            strcpy(buf, "Minimum of ");
            if ( bild->file ) strcat(buf, bild->file);
            if ( (zw = CutArea(bild, cut, p->opt->f, buf, APPMIN, 0)) == NULL ) {
               g_warning("Minimum of %s wasn't calculated due to wrong box coordinates", bild->file);
               continue;
            }
            bild->flag |= SAVEMINIMA;
            if ( SaveMaxima(p->opt->f) ) {
               piclist = g_list_append(piclist, zw);
               pl = g_list_find(piclist, bild);
	    } else 
               pl->data = zw;
         } 
         if ( SaveMaxima(p->opt->f) ) {
            cut->x1  = (cut->y1 = (max - bild->DATA)/(bild->storepix)) % bild->W;
            cut->y1 /= bild->W;
            cut->x2  = cut->x1 + bx;
	    cut->y2  = cut->y1 + by;
            strcpy(buf, "Maximum of ");
            if ( bild->file ) strcat(buf, bild->file);
            if ( (zw = CutArea(bild, cut, p->opt->f, buf, APPMAX, 1)) == NULL ) {
               g_warning("Minimum of %s wasn't calculated due to wrong box coordinates", bild->file);
               continue;
            }
            pl->data = zw;
            bild->flag |= SAVEMAXIMA;
         }
      }
   }
   FREE(p->opt->cut);
   p->piclist = piclist;
   return 0;
}


