/*****************************************************************************
 *                                                                           *
 * Programm:  paul                                                           *
 *            (P)rogramm zur (A)uswertung und (U)mformung von                *
 *            (L)aserbildern                                                 *
 * Verwendet: GTK, Imlib                                                     *
 * Modul:     callback.c                                                     *
 *            Callback functions for gtkpaul.c                               *
 * Autor:     Andreas Tille                                                  *
 * Datum:     14.06.1998                                                     *
 *                                                                           *
 *****************************************************************************/

#include <unistd.h>
#include <assert.h>
#include <gdk/gdkkeysyms.h>
#include "paul.h"
#include "callback.h"

/*****************************************************************************************
 * General callbacks                                                                     *
 *****************************************************************************************/

void PaulExit(GtkWidget *widget, PAUL *p)
/* clean all neccessary things
 */
{
   if ( p->opt ) {
      if ( DoMatchPictures(p->opt->f) && !IsMatchAuto(p->opt->mov) )
         if ( !(p->piclist =  EndMovedPictures(p->piclist, p->src, p->op, p->opt->f)) ) {
            FreeBild(p->src);
            g_list_free(p->src);
            gtk_exit(0);
         }
      if ( SaveBild(p->opt->f) ) SavePictures(p->piclist, p->opt->f);
      FREE(p->opt->cut);
   }
   FreeBild(p->piclist);
   g_list_free(p->piclist);
   gtk_exit(0);
}

void PictureKeyPressed(GtkWidget *show, GdkEvent *event, PAUL *p)
{
   GList *pl = NULL;
   int    select = 0;

   if ( !event || event->type != GDK_KEY_PRESS ) return;
   if ( !GTK_IS_WIDGET(show) ) {
      g_warning("Invalid data pointer\n");
      return;
   }
   
   if ( !(pl = p->activ) ) pl = p->piclist;
   if ( !pl ) {
      gdk_beep();
      g_warning("Empty picture list!");
      if ( show ) gtk_widget_destroy(show);
      return;
   }

   /*   mod = event->key.state;   */
   switch ( event->key.keyval ) {
   case GDK_Page_Up:   if ( !pl->prev ) {
			  gdk_beep();
                          return;
		       }
                       gtk_list_unselect_item(GTK_LIST(p->filelist), GetListPosition(p->piclist, pl));
                       select = 1;
                       p->activ = pl->prev;
                       break;
   case GDK_Page_Down: if ( !pl->next ) {
			  gdk_beep();
                          return;
		       }
                       gtk_list_unselect_item(GTK_LIST(p->filelist), GetListPosition(p->piclist, pl));
                       select = 1;
                       p->activ = pl->next;
                       break;
   case GDK_KP_Add:
   case GDK_plus:      GrowPic(show->window, BILD(pl));
                       return;
   case GDK_KP_Subtract:
   case GDK_minus:     ShrinkPic(show->window, BILD(pl));
                       return;

   case GDK_KP_Left:
   case GDK_Left:      if ( MovePic(p, -1, 0, ShiftValue(event->key.state)) ) select = -1;
                       break;
   case GDK_KP_Right:
   case GDK_Right:     if ( MovePic(p, +1, 0, ShiftValue(event->key.state)) ) select = -1;
                       break;
   case GDK_KP_Up:
   case GDK_Up:        if ( MovePic(p, 0, -1, ShiftValue(event->key.state)) ) select = -1;
                       break;
   case GDK_KP_Down:
   case GDK_Down:      if ( MovePic(p, 0, +1, ShiftValue(event->key.state)) ) select = -1;
                       break;
   case GDK_0:         if ( MovePic(p, -(BILD(pl))->roff_x, -(BILD(pl))->roff_y, 0) ) select = -1;
                       break;
   case GDK_space:     if ( MovePic(p, 0, 0, 0) ) select = -1;
                       break;
   case GDK_s :        /* raus und sichern */
   case GDK_S :        SetPNG(p->opt->f);
   case GDK_q :
   case GDK_Q :        /* raus und sichern wie per Option vorgegeben */
   case GDK_Escape:    PaulExit(NULL, p);
                       return;
   case GDK_x :        /* raus ohne sichern */
   case GDK_X :        DontSaveBild(p->opt->f);
                       PaulExit(NULL, p);
                       return;
   case GDK_v :        /* Mirror vertical */
                       ThisMirrorVerticalCallback(NULL, p);
                       return;
   case GDK_w :        /* Mirror horizontal */
                       ThisMirrorHorizontalCallback(NULL, p);
                       return;
   case GDK_Shift_L:
   case GDK_Shift_R:
   case GDK_Control_L:
   case GDK_Control_R:
   case GDK_Caps_Lock: 
   case GDK_Alt_L:
   case GDK_Alt_R:
                       return;
   case GDK_KP_2:      /* If <Shift> is pressed the arrow keys return these values. */
   case GDK_KP_4:      
   case GDK_KP_6:      
   case GDK_KP_8:      
                       return;
   default:            gdk_beep();
                       return;
   }
   if ( select == -1 ) 
      gdk_beep();
   else if ( select == 1 )
      /* This causes a call of ApplyImage so we dont need it here */
      gtk_list_select_item(GTK_LIST(p->filelist), GetListPosition(p->piclist, p->activ));
   else
      ApplyPicture(show->window, BILD(p->activ));

   return;
   
}

/*****************************************************************************************
 * Callback to change contrast or brightness of an image                                 *
 * related to: this/mark/all images                                                      *
 *****************************************************************************************/

void AllScaleCallback(GtkWidget *widget, PAUL *p)
{
   ApplyPaulFunc(p, (void *)SkaliereBilder, PAUL_FUNC_TYPE, ALL);
}

void MarkScaleCallback(GtkWidget *widget, PAUL *p)
{
   ApplyPaulFunc(p, (void *)SkaliereBilder, PAUL_FUNC_TYPE, MARK);
}

void ThisScaleCallback(GtkWidget *widget, PAUL *p)
{
   ApplyPaulFunc(p, (void *)SkaliereBilder, PAUL_FUNC_TYPE, THIS);
}

/*****************************************************************************************
 * Callbacks to cut white/black borders of images                                        *
 * related to: this/mark/all images                                                      *
 *****************************************************************************************/

void AllDelBorderCallback(GtkWidget *widget, PAUL *p)
{
   ApplyPaulFunc(p, (void *)SelectPictureWithoutBorder, PAUL_FUNC_TYPE, ALL);
}

void AllDelScanBorderCallback(GtkWidget *widget, PAUL *p)
{
   ApplyPaulFunc(p, (void *)DeleteScannerBorder, PAUL_FUNC_TYPE, ALL);
}

void MarkDelBorderCallback(GtkWidget *widget, PAUL *p)
{
   ApplyPaulFunc(p, (void *)SelectPictureWithoutBorder, PAUL_FUNC_TYPE, MARK);
}

void MarkDelScanBorderCallback(GtkWidget *widget, PAUL *p)
{
   ApplyPaulFunc(p, (void *)DeleteScannerBorder, PAUL_FUNC_TYPE, MARK);
}

void ThisDelBorderCallback(GtkWidget *widget, PAUL *p)
{
   ApplyPaulFunc(p, (void *)SelectPictureWithoutBorder, PAUL_FUNC_TYPE, THIS);
}

void ThisDelScanBorderCallback(GtkWidget *widget, PAUL *p)
{
   ApplyPaulFunc(p, (void *)DeleteScannerBorder, PAUL_FUNC_TYPE, THIS);
}


/*****************************************************************************************
 * Callback to filter images                                                             *
 * related to: this/marked/all images                                                    *
 *****************************************************************************************/

void AllFilterCallback(GtkWidget *widget, PAUL *p)
{
   p->opt->filter = 'h';
   ApplyPaulFunc(p, (void *)FilterBilder, PAUL_FUNC_TYPE, ALL);
}

void MarkFilterCallback(GtkWidget *widget, PAUL *p)
{
   p->opt->filter = 'h';
   ApplyPaulFunc(p, (void *)FilterBilder, PAUL_FUNC_TYPE, MARK);
}

void ThisFilterCallback(GtkWidget *widget, PAUL *p)
{
   p->opt->filter = 'h';
   ApplyPaulFunc(p, (void *)FilterBilder, PAUL_FUNC_TYPE, THIS);
}

/*****************************************************************************************
 * Callback for displaying histogram of an image                                         *
 * related to: single image                                                              *
 *****************************************************************************************/

void ThisHistogramCallback(GtkWidget *widget, PAUL *p)
{
   PICTURE                *bild = BILD(p->activ);
   unsigned long           max = 0;
   register unsigned long *hap;
   register gfloat        *ap, *fip;
   gfloat                  his[0x100];
   char                    buf[256];
   static GtkWidget       *window = NULL;
   GtkWidget              *curve, *main_vbox;
   
   if ( window ) {
      if (!GTK_WIDGET_VISIBLE(window) ) gtk_widget_show_all(window);
      else                              gtk_widget_destroy(window);
      return ;
   }
   
   window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
   gtk_signal_connect(GTK_OBJECT (window), "destroy", GTK_SIGNAL_FUNC(gtk_widget_destroyed),
                      &window);
   sprintf(buf, "Histogram of %s\n", bild->file);
   gtk_window_set_title(GTK_WINDOW (window), buf);
   main_vbox = gtk_vbox_new(FALSE, 5);
   gtk_container_border_width(GTK_CONTAINER(main_vbox), 10);
   gtk_container_add(GTK_CONTAINER(window), main_vbox);
      
   if ( !bild->his ) MakeHistogram(bild);
   
   for ( hap = bild->his, fip = (ap = his) + 0x100; ap < fip; ap++, hap++ ) {
      *ap = (gfloat)*hap;
      if ( *hap > max ) max = *hap;
   }

   max = (max/10 + 1) * 10;
   curve = gtk_curve_new();
   gtk_container_add(GTK_CONTAINER(main_vbox), curve);
   gtk_curve_set_range(GTK_CURVE(curve), 0.0, max, 0.0, (gfloat)max);
   gtk_curve_set_vector(GTK_CURVE(curve), 0x100, his);
  
   CreateCancelButton(window, main_vbox);
   if (!GTK_WIDGET_VISIBLE(window) ) gtk_widget_show_all(window);
}
 
/*****************************************************************************************
 * Callbacks to move images                                                              *
 * related to: all images                                                                *
 *****************************************************************************************/

void EndMatchPictures(GtkWidget *button, PAUL *p)
/* Stop moving of images because the macth each other
 * --- Parameter: ---
 * GtkWidget *button:
 * PAUL      *p
 */
{
   
   if ( !(p->piclist =  EndMovedPictures(p->piclist, p->src, p->op, p->opt->f)) ) {
      FreeBild(p->src);
      g_list_free(p->src);
      gtk_exit(0);
   }
   p->activ = p->piclist;
   MakeNewFileList(p);

   p->opt->f &= ~MATCHPICTURES;
   SetAnimateButton(p, GTK_SIGNAL_FUNC(PictureAnimate), ANIMATE);
}

void AllMoveImagesCallback(GtkWidget *widget, PAUL *p)
/* Start move images modus
 * --- Parameter: ---
 * GtkWidget *widget: can be ignored
 * PAUL      *p     : image structure
 */
{
   if ( NBILDER(p->piclist) < 2 ) {
      g_warning("You need at least two images in image list to move.");
      return;
   }
   
   if ( !(p->opt->mov) ) p->opt->mov = MATCHDIF;
   if ( CreateMatchPictures(p) ) return;
   p->activ = p->piclist;
   MakeNewFileList(p);
   SetAnimateButton(p, GTK_SIGNAL_FUNC(EndMatchPictures), ACCEPT);
}

/*****************************************************************************************
 * Make difference of images                                                             *
 * related to: all images                                                                *
 *****************************************************************************************/

void AllDifferenceCallback(GtkWidget *widget, PAUL *p)
/* build differences from images following each other
 * (number of images will be reduced by one)
 */
{

   if ( NBILDER(p->piclist) < 2 ) 
      g_warning("At least two images are neccessary to build differences");
/* Hmmm, resorting makes less sense, if differences are calculated from images following
 * each other
   if ( p->piclist != p->activ ) {
      p->piclist = g_list_remove_link(p->piclist, p->activ);
      p->piclist = g_list_prepend(p->piclist, BILD(p->activ));
      g_list_free(p->activ);
      p->activ   = p->piclist;
   }
 */

   DifferenzBilder(p);
   p->activ = p->piclist;
   MakeNewFileList(p);
}


/*****************************************************************************************
 * Make FFT of images                                                                    *
 * related to: this/marked/all images                                                    *
 *****************************************************************************************/

void AllFFTCallback(GtkWidget *widget, PAUL *p)
{
   ApplyPaulFunc(p, (void *)FastFourierTransform, PAUL_FUNC_TYPE, ALL);
}

void MarkFFTCallback(GtkWidget *widget, PAUL *p)
{
   ApplyPaulFunc(p, (void *)FastFourierTransform, PAUL_FUNC_TYPE, MARK);
}

void ThisFFTCallback(GtkWidget *widget, PAUL *p)
{
   ApplyPaulFunc(p, (void *)FastFourierTransform, PAUL_FUNC_TYPE, THIS);
}

/*****************************************************************************************
 * Make monochrome image                                                                 *
 * related to: this/marked/all images                                                    *
 *****************************************************************************************/

void AllMonochromeCallback(GtkWidget *widget, PAUL *p)
{
   long    f  = p->opt->f;
   
   p->opt->f |= MAKEGRAY;
   if ( p->opt->greps == 3 ) p->opt->greps = 255;
   ApplyPaulFunc(p, (void *)MakeGray, PAUL_FUNC_TYPE, ALL);
   p->opt->f  = f;
}

void MarkMonochromeCallback(GtkWidget *widget, PAUL *p)
{
   long    f  = p->opt->f;
   
   p->opt->f |= MAKEGRAY;
   if ( p->opt->greps == 3 ) p->opt->greps = 255;
   ApplyPaulFunc(p, (void *)MakeGray, PAUL_FUNC_TYPE, MARK);
   p->opt->f  = f;
}

void ThisMonochromeCallback(GtkWidget *widget, PAUL *p)
{
   long    f  = p->opt->f;
   
   p->opt->f |= MAKEGRAY;
   if ( p->opt->greps == 3 ) p->opt->greps = 255;
   ApplyPaulFunc(p, (void *)MakeGray, PAUL_FUNC_TYPE, THIS);
   p->opt->f  = f;
}

/*****************************************************************************************
 * Make negativ of image                                                                 *
 * related to: this/marked/all images                                                    *
 *****************************************************************************************/

void AllNegativCallback(GtkWidget *widget, PAUL *p)
{
   ApplyPaulFunc(p, (void *)MakeNegative, PICLIST_FUNC_TYPE, ALL);
}

void MarkNegativCallback(GtkWidget *widget, PAUL *p)
{
   ApplyPaulFunc(p, (void *)MakeNegative, PICLIST_FUNC_TYPE, MARK);
}

void ThisNegativCallback(GtkWidget *widget, PAUL *p)
{
   ApplyPaulFunc(p, (void *)MakeNegative, PICLIST_FUNC_TYPE, THIS);
}


/*****************************************************************************************
 * Mirror image                                                                          *
 * related to: this/all images                                                           *
 *****************************************************************************************/

void AllMirrorHorizontalCallback(GtkWidget *widget, PAUL *p)
/* mirror all images horizontally (at a vertical symmetry axis)
 */
{
   long   f  = p->opt->f;
   
   p->opt->f |= MIRROR_H;
   ApplyPaulFunc(p, (void *)MakeMirror, PAUL_FUNC_TYPE, ALL);
   p->opt->f  = f;
}

void AllMirrorVerticalCallback(GtkWidget *widget, PAUL *p)
/* mirror all images vertically (at a horizontal symmetry axis)
 */
{
   long   f  = p->opt->f;
   
   p->opt->f |= MIRROR_V;
   ApplyPaulFunc(p, (void *)MakeMirror, PAUL_FUNC_TYPE, ALL);
   p->opt->f  = f;
}

void MarkMirrorHorizontalCallback(GtkWidget *widget, PAUL *p)
/* mirror activ image horizontally (at a vertical symmetry axis)
 */
{
   long   f  = p->opt->f;
   
   p->opt->f |= MIRROR_H;
   ApplyPaulFunc(p, (void *)MakeMirror, PAUL_FUNC_TYPE, MARK);
   p->opt->f  = f;
}

void MarkMirrorVerticalCallback(GtkWidget *widget, PAUL *p)
/* mirror activ image vertically (at a horizontal symmetry axis)
 */
{
   long   f  = p->opt->f;
   
   p->opt->f |= MIRROR_V;
   ApplyPaulFunc(p, (void *)MakeMirror, PAUL_FUNC_TYPE, MARK);
   p->opt->f  = f;
}

void ThisMirrorHorizontalCallback(GtkWidget *widget, PAUL *p)
/* mirror activ image horizontally (at a vertical symmetry axis)
 */
{
   long   f  = p->opt->f;
   
   p->opt->f |= MIRROR_H;
   ApplyPaulFunc(p, (void *)MakeMirror, PAUL_FUNC_TYPE, THIS);
   p->opt->f  = f;
}

void ThisMirrorVerticalCallback(GtkWidget *widget, PAUL *p)
/* mirror activ image vertically (at a horizontal symmetry axis)
 */
{
   long   f  = p->opt->f;
   
   p->opt->f |= MIRROR_V;
   ApplyPaulFunc(p, (void *)MakeMirror, PAUL_FUNC_TYPE, THIS);
   p->opt->f  = f;
}


/*****************************************************************************************
 * Rotate image                                                                          *
 * related to: this/all images                                                           *
 *****************************************************************************************/

void AllRotate90Callback(GtkWidget *widget, PAUL *p)
{
   long   f  = p->opt->f;
   
   p->opt->f |= ROT_90;
   ApplyPaulFunc(p, (void *)MakeRotate, PAUL_FUNC_TYPE, ALL);
   p->opt->f  = f;
}

void AllRotate180Callback(GtkWidget *widget, PAUL *p)
{
   long   f  = p->opt->f;
   
   p->opt->f |= ROT_180;
   ApplyPaulFunc(p, (void *)MakeRotate, PAUL_FUNC_TYPE, ALL);
   p->opt->f  = f;
}

void AllRotate270Callback(GtkWidget *widget, PAUL *p)
{
   long   f  = p->opt->f;
   
   p->opt->f |= (ROT_90 | ROT_180);
   ApplyPaulFunc(p, (void *)MakeRotate, PAUL_FUNC_TYPE, ALL);
   p->opt->f  = f;
}

void MarkRotate90Callback(GtkWidget *widget, PAUL *p)
{
   long   f  = p->opt->f;
   
   p->opt->f |= ROT_90;
   ApplyPaulFunc(p, (void *)MakeRotate, PAUL_FUNC_TYPE, MARK);
   p->opt->f  = f;
}

void MarkRotate180Callback(GtkWidget *widget, PAUL *p)

{
   long   f  = p->opt->f;
   
   p->opt->f |= ROT_180;
   ApplyPaulFunc(p, (void *)MakeRotate, PAUL_FUNC_TYPE, MARK);
   p->opt->f  = f;
}

void MarkRotate270Callback(GtkWidget *widget, PAUL *p)
{
   long   f  = p->opt->f;
   
   p->opt->f |= (ROT_90 | ROT_180);
   ApplyPaulFunc(p, (void *)MakeRotate, PAUL_FUNC_TYPE, MARK);
   p->opt->f  = f;
}

void ThisRotate90Callback(GtkWidget *widget, PAUL *p)
{
   long   f  = p->opt->f;
   
   p->opt->f |= ROT_90;
   ApplyPaulFunc(p, (void *)MakeRotate, PAUL_FUNC_TYPE, THIS);
   p->opt->f  = f;
}

void ThisRotate180Callback(GtkWidget *widget, PAUL *p)

{
   long   f  = p->opt->f;
   
   p->opt->f |= ROT_180;
   ApplyPaulFunc(p, (void *)MakeRotate, PAUL_FUNC_TYPE, THIS);
   p->opt->f  = f;
}

void ThisRotate270Callback(GtkWidget *widget, PAUL *p)
{
   long   f  = p->opt->f;
   
   p->opt->f |= (ROT_90 | ROT_180);
   ApplyPaulFunc(p, (void *)MakeRotate, PAUL_FUNC_TYPE, THIS);
   p->opt->f  = f;
}

