/* GGlyph - a graphical utility for managing one's collection of Type
   1 fonts (and eventually, other sorts of fonts) under X11.

   Copyright (c) 1998 David Huggins-Daines
   <bn711@freenet.carleton.ca>.

   You are permitted to copy, distribute, and modify this file under the
   terms of the GNU General Public License, version 2, or any later
   version.  See the file COPYING for more details. */

/* fonts.h - methods for manipulating the database of fonts and font
   paths, as well as the X11 font path */

#ifndef FONTS_H
#define FONTS_H

#include <glib.h>

#define WHITESPACE " \t"
#define NOT_LOADED -1

typedef enum {
  NO_PROBLEMO = 0,
  NO_FONTSSCALE = 1 << 1,
  NO_FONTSDIR = 1 << 2,
  FONTS_NOT_INSTALLED = 1 <<3,
} FontDirProblems;

typedef enum {
  VIEW_SAMPLE,
  PRINT_SAMPLE
} SampleAction;

typedef struct _FontDirRec FontDirRec;
typedef struct _FontFileRec FontFileRec;

struct _FontDirRec
{
  gchar *path;
  GHashTable *fonts;

  /* has it been modified? */
  gint dirty;
  FontDirProblems problems;
};

struct _FontFileRec
{
  /* note that these two are the same string */
  gchar *pathname;
  gchar *basename;

  /* this being NULL indicates that it hasn't been entered into a
     fonts.dir/fonts.scale (yet) */
  gchar *xlfd;
  
  gint t1_fontid;
};

gint is_psfont (gchar *path);
FontFileRec *add_fontfile (FontDirRec *fontdir, gchar *pathname, gchar
			   *xlfd);
void copy_ffile_rec (FontDirRec *new_fdir, FontFileRec *ffile);
void rescan_fontdir (FontDirRec *fdir);
FontDirRec *add_fontdir (GSList **fdir_list, gchar *path);
char *get_xlfd_field (gchar *xlfd, gint field);
char *get_xlfd_slant (gchar *xlfd);
int is_xlfd_monospaced (gchar *xlfd);
void remove_from_XFontPath (gchar *dir);
void add_to_XFontPath (gchar *dir);
void flush_XFontPath (void);

/* for lack of a better place to put this... it will sorta fit once
   the appropriate stuff is moved to gdk_t1lib.[ch] from here */
void do_sample_sheet (FontFileRec *ffile, SampleAction act);

#endif /* FONTS_H */
