/*
 * XSOLDIER, a video-oriented game
 * Copyright (C) 1997, Yuusuke HASHIMOTO
 *                     s945750@educ.info.kanagawa-u.ac.jp
 *
 * ܥץˤ copyleft ŬѤƤޤCONDITION ե򻲾Ȥ
 * Ƥ
 */

#include <stdio.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/ioctl.h> /*** SystemV ioctl() ***/
#include <linux/joystick.h>

#include <X11/Xlib.h>

#include "image.h"
#include "xsoldier.h"
#include "key.h"
#include "extern.h"

static int fd;

void initJS(void)
{
    long tmpl;

    if ((fd=open("/dev/js0",O_RDONLY)) == -1)
    {
	perror("/dev/js0");
	if ((fd=open("/dev/js1",O_RDONLY)) == -1)
	{
	    perror("/dev/js1");
	    exit(1);
	}
    }

    tmpl = 1;
    if ((ioctl(fd,JS_SET_TIMELIMIT,&tmpl)) == -1)
    {
        perror ("js_set");
        exit (1);
    }
}

void readJS(void)
{
    static struct JS_DATA_TYPE js;
    static int scrsv = 0;
    static int psd2btn = False;
    /*** 2ܥ󤬲Ƥ? ***/

    if (scrsv > 200)
    {
	XResetScreenSaver(dpy);
	scrsv = 0;
    }
    else
	scrsv++;

    joymask = 0;
    if ((read(fd,&js,JS_RETURN)) == JS_RETURN)
    {
	if (js.buttons & 1) joymask |= Shot;

	if (js.buttons & 2)
	{
	    if (psd2btn == False)
	    {
		joymask |= SpeedUP;
		psd2btn = True;
	    }
	}
	else
	    psd2btn = False;
	/***  2ܥ꡼ʤȥԡɥ󥸽ʤ ***/
	/*** ʤȥܥ󲡤äѤʤǥԡɤѲ ***/

	if (js.x <  100) joymask |= Left;
	if (js.x > 1000) joymask |= Right;
	if (js.y <  100) joymask |= Up;
	if (js.y > 1000) joymask |= Down;
    }
}
