/*
    SABRE Fighter Plane Simulator 
    Copyright (c) 1997 Dan Hammer
    Portions Donated By Antti Barck

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/******************************************************
 * siminput.h                                         *
 ******************************************************/
#ifndef __siminput_h
#define __siminput_h

class InputFile
{
  void read();
  char message_buff[32];
public:
  FILE *input_file;
  REAL_TYPE elapsed_time;
  REAL_TYPE time_limit;
  int key;
  int rpt_count;
  int is_funct;
  int done;
  int get_key();
  char *get_message()
    { return message_buff; }
  void update();
  InputFile(char *);
  ~InputFile();
};

// Input routines
class Mouse;
class Joystick;


enum { kbd_ctrl, mouse_ctrl, joy_ctrl };
class FlightInput
{
public:
  int yoke_device;
  int rudder_device;
  int throttle_device;
  
  int m_throttle, m_rudder;
  Mouse *mouse;
  Joystick *y_joy;
  Joystick *r_joy;
  Joystick *t_joy;
  FlightInput(Mouse *ms, Joystick *yj, Joystick *tj, Joystick *rj, 
		       int mt, int mr);
  int update(Flight &,char key);
  int yoke_key(Flight &, char );
  void yoke_mouse(Flight &);
  void yoke_joystick(Flight &);
  void throttle_mouse(Flight &flt);
  void rudder_mouse(Flight &flt);
  void throttle_joy(Flight &flt);
  void rudder_joy(Flight &flt);
  void do_joystick_button(int bt, Flight &flt);
};


int flight_key(Flight_Node &, Flight_Manager &, FlightInput &, InputFile *);

#endif




