# $Id: xtend.pm,v 1.2 1998-04-02 01:34:43-05 dshaw Exp $

# This can be 'use'd by a perl script to parse the environment variables
# set by Xtend.
#
# Use them like: is_on(a1)
# which returns true if a1 is on.
#
# Note that is_appliance and is_light are only valid if one of the other
# bits are set as well.  This saves memory.

sub is_on
	{
	local($unit)=@_;
	$ENV{"X10_".uc($unit)} & 0x80;
	}

sub is_off
	{
	local($unit)=@_;
	!($ENV{"X10_".uc($unit)} & 0x80);
	}

sub is_addressed
	{
	local($unit)=@_;
	$ENV{"X10_".uc($unit)} & 0x40;
	}

sub is_notaddressed
	{
	local($unit)=@_;
	!($ENV{"X10_".uc($unit)} & 0x40);
	}

sub is_appliance
	{
	local($unit)=@_;
	$ENV{"X10_".uc($unit)} & 0x20;
	}

sub is_light
	{
	local($unit)=@_;
	!($ENV{"X10_".uc($unit)} & 0x20);
	}

# leave this alone
1;

