/*	$Id: tbl_funcs.h,v 1.17 1997/11/01 15:24:56 sandro Exp $	*/

/*
 * Copyright (c) 1997
 *	Sandro Sigala, Brescia, Italy.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * Add an entry to this list for declaring a new function.
 * X0 means no key binding, X1 means one key binding, etc.
 */

/* Motion functions. */
X2("backward-char", backward_char,			"\\C-b", "\\LEFT")
X2("forward-char", forward_char,			"\\C-f", "\\RIGHT")
X2("previous-line", previous_line,			"\\C-p", "\\UP")
X2("next-line", next_line,				"\\C-n", "\\DOWN")
X2("beginning-of-line", beginning_of_line,		"\\C-a", "\\HOME")
X2("end-of-line", end_of_line,				"\\C-e", "\\END")
X1("beginning-of-buffer", beginning_of_buffer,		"\\M-<")
X1("end-of-buffer", end_of_buffer,			"\\M->")
X2("scroll-down", scroll_down,				"\\M-v", "\\PGUP")
X2("scroll-up", scroll_up,				"\\C-v", "\\PGDN")

/* Editing functions. */
X0("self-insert-command", self_insert_command)
X1("backward-delete-char", backward_delete_char,	"\\BS")
X2("delete-char", delete_char,				"\\C-d", "\\DEL")
X1("kill-line", kill_line,				"\\C-k")
X1("kill-region", kill_region,				"\\C-w")
X1("yank", yank,					"\\C-y")
X2("undo", undo,					"\\C-xu", "\\C-_")
X1("copy-to-register", copy_to_register,		"\\C-xrs")
X1("insert-register", insert_register,			"\\C-xri")

/* Minor editing functions. */
X1("upcase-region", upcase_region,			"\\C-x\\C-u")
X1("downcase-region", downcase_region,			"\\C-x\\C-l")
X1("quoted-insert", quoted_insert,			"\\C-q")

/* Mark functions. */
X1("set-mark-command", set_mark_command,		"\\C-@")
X1("exchange-point-and-mark", exchange_point_and_mark,	"\\C-x\\C-x")
X1("mark-whole-buffer", mark_whole_buffer,		"\\C-xh")

/* File and buffers functions. */
X1("find-file", find_file,				"\\C-x\\C-f")
X1("find-alternate-file", find_alternate_file,		"\\C-x\\C-v")
X1("save-buffer", save_buffer,				"\\C-x\\C-s")
X1("write-file", write_file,				"\\C-x\\C-w")
X1("save-some-buffers", save_some_buffers,		"\\C-xs")
X1("save-buffers-kill-zile", save_buffers_kill_zile,	"\\C-x\\C-c")
X1("switch-to-buffer", switch_to_buffer,		"\\C-xb")
X1("list-buffers", list_buffers,			"\\C-x\\C-b")
X1("kill-buffer", kill_buffer,				"\\C-xk")
X0("insert-buffer", insert_buffer)
X1("insert-file", insert_file,				"\\C-xi")

/* Mode functions. */
X1("overwrite-mode", overwrite_mode,			"\\INS")
X1("toggle-read-only", toggle_read_only,		"\\C-x\\C-q")
X0("auto-fill-mode", auto_fill_mode)
X0("font-lock-mode", font_lock_mode)
X0("text-mode", text_mode)
X0("c-mode", c_mode)

/* Window functions. */
X1("split-window", split_window,			"\\C-x2")
X1("delete-other-windows", delete_other_windows,	"\\C-x1")
X1("delete-window", delete_window,			"\\C-x0")
X1("enlarge-window", enlarge_window,			"\\C-x^")
X1("other-window", other_window,			"\\C-xo")

/* Help functions. */
X1("toggle-minihelp-window", toggle_minihelp_window,	"\\M-h\\M-h")
X0("zile-version", zile_version)
X1("help-latest-version", help_latest_version,		"\\M-hd")
X1("help", help,					"\\M-hh")
X1("help-faq", help_faq,				"\\M-hF")
X1("help-tutorial", help_tutorial,			"\\M-ht")

/* Other functions. */
X0("cd", cd)
X1("recenter", recenter,				"\\C-l")
X2("suspend-zile", suspend_zile,			"\\C-x\\C-z", "\\C-z")
X1("keyboard-quit", keyboard_quit,			"\\C-g")
X1("universal-argument", universal_argument,		"\\C-u")
X1("search-forward", search_forward,			"\\C-s")
X1("search-backward", search_backward,			"\\C-r")
X0("set-variable", set_variable)
X1("list-variables", list_variables,			"\\M-hlv")
X1("execute-extended-command", execute_extended_command,"\\M-x")
X0("font-lock-refresh", font_lock_refresh)
X1("start-kbd-macro", start_kbd_macro,			"\\C-x(")
X1("end-kbd-macro", end_kbd_macro,			"\\C-x)")
X1("call-last-kbd-macro", call_last_kbd_macro,		"\\C-xe")
