/*
-- ANSI C code generated by :
-- SmallEiffel The GNU Eiffel Compiler -- Release (- 0.80)      --
-- Copyright (C), 1994-98 - LORIA - UHP - CRIN - INRIA - FRANCE --
-- Dominique COLNET and Suzanne COLLIN -    colnet@loria.fr     --
--                 http://www.loria.fr/SmallEiffel              --
*/

/*
-- This file is  free  software, which  comes  along  with  SmallEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT 
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of 
-- another product.
--          Copyright (C) 1994-98 LORIA - UHP - CRIN - INRIA - FRANCE
--            Dominique COLNET and Suzanne COLLIN - colnet@loria.fr 
--                       http://www.loria.fr/SmallEiffel
--
*/
/*
  This file (base.h) is automatically included in the header for all modes 
  of compilation : -boost, -no_check, -require_check, ...
  This file is also included in the header of any cecil file.
*/
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>
#include <signal.h>
#include <stddef.h>
#include <stdarg.h>
#include <limits.h>
#include <float.h>
#include <setjmp.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#ifndef O_RDONLY
#include <sys/file.h>
#endif
#ifndef O_RDONLY
#define O_RDONLY 0000
#endif

/* 
   On Linux glibc systems, we need to use sig.* versions of jmp_buf,
   setjmp and longjmp to preserve the signal handling context.
   Currently, the way I figured to detect this is if _SIGSET_H_types has
   been defined in /usr/include/setjmp.h.
*/
#ifdef _SIGSET_H_types
# define JMP_BUF    sigjmp_buf
# define SETJMP(x)  sigsetjmp( (x), 1)
# define LONGJMP    siglongjmp
#else
# define JMP_BUF    jmp_buf
# define SETJMP(x)  setjmp( (x) )
# define LONGJMP    longjmp
#endif

/* 
   Type to store reference objects Id :
 */
typedef int Tid;

typedef struct S0 T0;

struct S0{
  Tid id;
};

/* 
   The default channel used to print runtime error messages :
*/
#define SE_ERR stderr

/* 
   Eiffel type INTEGER is #2 :
*/
typedef int T2;
#define T2BITS (CHAR_BIT*sizeof(int))
#define T2MIN INT_MIN
#define T2MAX INT_MAX

/*
  Eiffel type CHARACTER is #3 :
*/
typedef char T3;
#define T3BITS CHAR_BIT
#define T3MIN (0)
#define T3MAX (255)

/*
  Eiffel type REAL is #4 :
*/
typedef float T4;
#define T4BITS (CHAR_BIT*sizeof(float))
#define T4MIN (-(FLT_MAX))
#define T4MAX FLT_MAX

/*
  Eiffel type DOUBLE is #5 :
*/
typedef double T5;
#define T5BITS (CHAR_BIT*sizeof(double))
#define T5MIN (-(DBL_MAX))
#define T5MAX DBL_MAX

/*
  Eiffel type BOOLEAN is #6 :
*/
typedef int T6;
#define T6BITS (CHAR_BIT*sizeof(int))

/* 
   Eiffel type POINTER is #8 :
*/
typedef void* T8;
#define T8BITS (CHAR_BIT*sizeof(void*))

/* --- Mangling Table Start ---
D 2  T1489 R BOOLEAN_CONSTANT 210,253
A 1  T945  R BIT_CONSTANT 945
A*1  T218  R TAG_NAME 218
A 1  T602  R TYPE_BIT_1 602
A*1  T1104 R ARRAY[CREATION_CLAUSE] 1104
A*1  T429  R E_ENSURE 429
A 1  T1545 R ARRAY[MANIFEST_STRING] 1545
A 1  T196  R E_DEBUG 196
A 1  T1190 R CST_ATT_INTEGER 1190
A 1  T16   R CALL_INFIX_PLUS 16
A 1  T1873 R CHARACTER_CONSTANT 1873
A 1  T653  R ASSIGNMENT 653
A*1  T847  R RUN_CONTROL 847
A*1  T32   R INDEX_LIST 32
A*1  T757  R EXPORT_ITEM 757
A*1  T425  R CLASS_NAME 425
A*1  T1540 R DICTIONARY[STRING,STRING] 1540
A 1  T1512 E NATIVE_ARRAY[E_REQUIRE] 1512
A 1  T1608 E NATIVE_ARRAY[RUN_CLASS] 1608
A 1  T9    E NATIVE_ARRAY[CHARACTER] 9
A 1  T1876 E NATIVE_ARRAY[ASSERTION] 1876
A 1  T1253 E NATIVE_ARRAY[E_FEATURE] 1253
A 1  T1421 E NATIVE_ARRAY[WHEN_ITEM] 1421
A 1  T29   R DECLARATION_GROUP 29
A*1  T499  R E_REQUIRE 499
A 1  T1734 E NATIVE_ARRAY[POSITION] 1734
A 1  T1093 R CREATION_CALL_2 1093
A 1  T1256 R CALL_INFIX_XOR 1256
A*1  T578  R METHOD_INFO 578
A 1  T1543 R INTEGER_CONSTANT 1543
A 1  T935  R TYPE_POINTER 935
A 1  T763  R TYPE_INTEGER 763
A 1  T612  R TYPE_BIT_2 612
A 1  T1683 R FIXED_ARRAY[TYPE_BIT_REF] 1683
A*1  T1467 R FIXED_ARRAY[FEATURE_NAME] 1467
A 1  T435  R INFIX_NAME 435
A 1  T25   R NATIVE_JVM_INVOKESTATIC 25
A 1  T1485 R TYPE_FORMAL_GENERIC 1485
A 1  T1379 R MANIFEST_STRING 1379
A 1  T1184 R FORMAL_ARG_LIST 1184
A*1  T13   R DICTIONARY[BASE_CLASS,STRING] 13
A 1  T1042 R RUN_FEATURE_2 1042
A*1  T1501 R FEATURE_NAME_LIST 1501
A*1  T1285 R CLASS_INVARIANT 1285
A*1  T1198 R CLASS_NAME_LIST 1198
D 8  T327  R ROUTINE 969,991,27,449,1657,1687,1564,1594
A*1  T269  R TMP_NAME 269
D 16 T890  R INSTRUCTION 1866,653,1123,1108,1093,1078,21,475,436,519,1324,196,140,584,573,441
A 1  T1210 R LOOP_VARIANT_1 1210
A*1  T898  R EIFFEL_PARSER 898
A 1  T1707 R CALL_INFIX_IMPLIES 1707
A 1  T441  R PROC_CALL_N 441
A 1  T23   R TYPE_EXPANDED 23
A 1  T1281 E NATIVE_ARRAY[BASE_CLASS] 1281
A 1  T1323 E NATIVE_ARRAY[EXPRESSION] 1323
A 1  T1282 E NATIVE_ARRAY[CLASS_NAME] 1282
A 1  T1231 R ARRAY[ARGUMENT_NAME1] 1231
A*1  T1926 R ARRAY[FEATURE_CLAUSE] 1926
D 2  T1085 R ARRAY[LOCAL_ARGUMENT] 1231,1388
A 1  T1348 R CALL_PREFIX_NOT 1348
A 1  T140  R E_CHECK 140
A 1  T1117 R LOCAL_VAR_LIST 1117
D 4  T1105 R LOCAL_ARGUMENT 1149,1163,636,625
A 1  T444  R TYPE_NONE 444
A 1  T1563 R CALL_INFIX_OR_ELSE 1563
A*1  T705  R ARRAY[TYPE] 705
A*1  T1567 R BINARY_FILE_WRITE 1567
A 1  T1657 R EXTERNAL_FUNCTION 1657
A 1  T1809 E NATIVE_ARRAY[BOOLEAN] 1809
D 7  T231  R NATIVE 1358,1584,1867,1243,24,1214,25
A 1  T2045 E NATIVE_ARRAY[INTEGER] 2045
A 1  T1840 E NATIVE_ARRAY[CP_INFO] 1840
D 2  T846  R LOOP_VARIANT 1224,1210
A 1  T1888 E NATIVE_ARRAY[RUN_FEATURE_6] 1888
A 1  T1862 E NATIVE_ARRAY[RUN_FEATURE_5] 1862
A 1  T1784 E NATIVE_ARRAY[RUN_FEATURE_2] 1784
A*1  T504  R SMALL_EIFFEL 504
A 1  T1108 R CREATION_CALL_3 1108
A 1  T1492 E SWITCH_COLLECTION 1492
A*1  T1806 R FIXED_ARRAY[INTEGER] 1806
A*1  T1615 R FIXED_ARRAY[CP_INFO] 1615
A 1  T1513 R CALL_INFIX_AND_THEN 1513
A 1  T1055 R RUN_FEATURE_3 1055
A 1  T1214 R NATIVE_WITHOUT_CURRENT 1214
A 1  T1511 R SIMPLE_FEATURE_NAME 1511
A 1  T559  R TYPE_CLASS 559
A 1  T527  R PREFIX_NAME 527
A 1  T181  R E_VOID 181
A*1  T535  R RENAME_PAIR 535
A*1  T878  R STD_OUTPUT 878
A 1  T6    E BOOLEAN 6
A 1  T1224 R LOOP_VARIANT_2 1224
A 1  T15   R CALL_INFIX_EQ 15
A*1  T474  R BOOLEAN_REF 474
A 1  T771  R CALL_INFIX_AND 771
A 2  T1610 R ARRAY[RUN_FEATURE] 1610,1124
A*1  T876  R BINARY_FILE_READ 876
A 1  T1388 R ARRAY[LOCAL_NAME1] 1388
A*1  T1280 R ARRAY[RENAME_PAIR] 1280
A*1  T1772 R ARRAY[EXPORT_ITEM] 1772
A*1  T28   R ARRAY[DECLARATION] 28
A*1  T2001 R ARRAY[INSTRUCTION] 2001
A 1  T214  E SWITCH 214
A*1  T7    R STRING 7
D 30 T14   R CALL_PROC_CALL 1787,1408,1578,1635,992,744,684,1647,584,245,251,573,1562,1653,939,879,994,1633,1436,157,949,771,15,1513,1563,1348,441,1707,1256,16
A 1  T253  R E_TRUE 253
A*1  T528  R INTEGER_REF 528
A 1  T105  R E_OLD 105
A 1  T31   R WRITABLE_ATTRIBUTE 31
A 1  T1776 E NATIVE_ARRAY[TYPE] 1776
A 1  T1068 R RUN_FEATURE_4 1068
A*1  T1211 R ARRAY[FORMAL_GENERIC_ARG] 1211
A 1  T667  R CST_ATT_REAL 667
A 1  T1687 R EXTERNAL_PROCEDURE 1687
A*1  T201  R IFTHEN 201
A 1  T1585 E NATIVE_ARRAY[INTEGER_CONSTANT] 1585
A*1  T792  R CLIENT_LIST 792
A 1  T27   R FUNCTION 27
A*1  T556  R CECIL_POOL 556
A*1  T1065 R UNIQUE_STRING 1065
A*1  T977  R FEATURE_CLAUSE 977
A 1  T1123 R CREATION_CALL_4 1123
A 1  T1460 E NATIVE_ARRAY[EFFECTIVE_ARG_LIST] 1460
A 1  T1801 E NATIVE_ARRAY[FORMAL_GENERIC_ARG] 1801
A*1  T822  R PARSER_BUFFER 822
A 1  T949  R CALL_INFIX_OR 949
A 1  T157  R CALL_N 157
A 1  T1356 E NATIVE_ARRAY[EXPORT_ITEM] 1356
A 1  T1082 E NATIVE_ARRAY[RUN_FEATURE] 1082
A 1  T1677 E NATIVE_ARRAY[LOCAL_NAME1] 1677
A 1  T1548 E NATIVE_ARRAY[RENAME_PAIR] 1548
A 1  T1696 E NATIVE_ARRAY[DECLARATION] 1696
A 1  T1697 E NATIVE_ARRAY[INSTRUCTION] 1697
A*1  T257  R CP_INFO 257
A*1  T697  R RENAME_LIST 697
D 2  T1463 R DEFERRED_ROUTINE 1594,1564
A*1  T1127 R CODE_ATTRIBUTE 1127
A*1  T1120 R COMPILE_TO_JVM 1120
A 1  T2    E INTEGER 2
A*1  T1220 R DICTIONARY[RUN_CLASS,STRING] 1220
A*1  T1916 R DICTIONARY[E_FEATURE,STRING] 1916
A 1  T1124 R ARRAY[RUN_FEATURE_2] 1124
A 1  T882  R TYPE_CHARACTER 882
A*1  T810  R PARENT_LIST 810
A*1  T1175 R DICTIONARY[TYPE_REF_TO_EXP,STRING] 1175
A*1  T12   R POSITION 12
A 1  T1570 R FIXED_ARRAY[RUN_FEATURE_6] 1570
A 1  T41   R FIXED_ARRAY[RUN_FEATURE_5] 41
A 1  T1436 R CALL_INFIX_FREEOP 1436
A*1  T708  R ID_PROVIDER 708
A*1  T18   R E_WHEN 18
A 1  T1024 R CST_ATT_BOOLEAN 1024
A 1  T1081 R RUN_FEATURE_5 1081
A*1  T345  R COMMENT 345
A 1  T1008 R DECLARATION_1 1008
A*1  T590  R ASSERTION 590
A 1  T1136 E NATIVE_ARRAY[STRING] 1136
A 1  T1987 E NATIVE_ARRAY[PARENT] 1987
A 1  T1688 E NATIVE_ARRAY[E_WHEN] 1688
A 1  T1771 E NATIVE_ARRAY[IFTHEN] 1771
A 1  T1866 R REVERSE_ASSIGNMENT 1866
A 1  T45   R FIXED_ARRAY[TYPE_REF_TO_EXP] 45
A 1  T1975 R FIXED_ARRAY[MANIFEST_STRING] 1975
A*1  T683  R TMP_FEATURE 683
D 3  T298  R PROC_CALL 584,573,441
A 1  T3    E CHARACTER 3
A*1  T87   R JVM 87
A*1  T380  R COUNTER 380
A 1  T991  R ONCE_PROCEDURE 991
D 9  T691  R RUN_FEATURE 1042,40,1081,1068,43,1107,1133,1029,1055
A 1  T8    E POINTER 8
A*1  T816  R ERROR_HANDLER 816
A*1  T261  R PARENT 261
A 1  T21   R E_LOOP 21
A 1  T1205 E NATIVE_ARRAY[TYPE_REF_TO_EXP] 1205
A 1  T1666 E NATIVE_ARRAY[CREATION_CLAUSE] 1666
A 1  T1304 E NATIVE_ARRAY[MANIFEST_STRING] 1304
A 1  T1633 R CALL_PREFIX_FREEOP 1633
A*1  T46   R ARRAY[BOOLEAN] 46
A*1  T911  R ARRAY[INTEGER] 911
A*1  T37   R DICTIONARY[DICTIONARY[RUN_FEATURE,STRING],STRING] 37
D 2  T421  R WHEN_ITEM 718,707
D 3  T616  R FEATURE_NAME 1511,435,527
A 1  T372  R E_STRIP 372
A*1  T1333 R ARRAY[POSITION] 1333
A*1  T722  R INDEX_CLAUSE 722
A*1  T1189 R FORMAL_GENERIC_ARG 1189
A 1  T22   R TYPE_NATIVE_ARRAY 22
A 1  T567  R TYPE_DOUBLE 567
A 1  T940  R CST_ATT_DOUBLE 940
A 1  T1248 R CST_ATT_UNIQUE 1248
A 1  T40   R RUN_FEATURE_6 40
A 1  T357  R TYPE_REAL 357
A*1  T1974 R FEATURE_CLAUSE_LIST 1974
A*1  T1789 R FORMAL_GENERIC_LIST 1789
D 8  T17   R CST_ATT 1300,1230,640,1248,940,1024,667,1190
A 1  T640  R CST_ATT_BIT 640
A*1  T11   R FIELD_INFO 11
A 1  T24   R NATIVE_INLINE_WITHOUT_CURRENT 24
A*1  T42   R RUN_REQUIRE 42
A 1  T994  R CALL_INFIX_DIV 994
A 1  T625  R LOCAL_NAME1 625
A*1  T899  R EXPORT_LIST 899
A 1  T879  R CALL_INFIX_GT 879
A 1  T939  R CALL_INFIX_LT 939
A*1  T1141 R LOOP_INVARIANT 1141
A 1  T1678 R TYPE_LIKE_CURRENT 1678
A*1  T1751 R FIXED_ARRAY[PARENT] 1751
A*1  T1886 R FIXED_ARRAY[STRING] 1886
A*1  T931  R ARRAY[STRING] 931
A*1  T874  R ARRAY[PARENT] 874
A*1  T701  R ARRAY[E_WHEN] 701
A*1  T742  R ARRAY[IFTHEN] 742
A 1  T623  R TYPE_ARRAY 623
D 2  T864  R ONCE_ROUTINE 969,991
A 1  T1038 R REAL_CONSTANT 1038
A*1  T1244 R ARRAY[E_REQUIRE] 1244
A*1  T1277 R ARRAY[RUN_CLASS] 1277
A*1  T36   R ARRAY[E_FEATURE] 36
A 1  T636  R LOCAL_NAME2 636
A*1  T1461 R ARRAY[ASSERTION] 1461
A*1  T20   R ARRAY[WHEN_ITEM] 20
A 1  T1107 R RUN_FEATURE_7 1107
A 1  T510  R E_RESULT 510
A 1  T614  R TYPE_GENERIC 614
D 5  T229  R CALL_0 1787,1635,245,1633,1348
A*1  T38   R FIXED_ARRAY[DICTIONARY[RUN_FEATURE,STRING]] 38
A*1  T837  R MEMO[COMMENT] 837
A 1  T773  R TYPE_STRING 773
A 1  T639  R TYPE_BOOLEAN 639
D 47 T737  R EXPRESSION 1149,625,2038,1707,1256,949,1563,771,1513,879,939,684,744,992,15,1578,16,994,1647,1653,1408,1562,1436,105,1163,636,1543,1038,945,1379,1873,210,253,157,251,245,513,580,181,510,1511,372,1633,1787,1635,1348,1137
A 1  T1243 R NATIVE_WITH_CURRENT 1243
A 1  T39   E NATIVE_ARRAY[DICTIONARY[RUN_FEATURE,STRING]] 39
A*1  T1373 R MANIFEST_STRING_POOL 1373
A 1  T1967 E NATIVE_ARRAY[TYPE_BIT_REF] 1967
A 1  T1943 E NATIVE_ARRAY[INDEX_CLAUSE] 1943
A 1  T1733 E NATIVE_ARRAY[FEATURE_NAME] 1733
D 2  T670  R DECLARATION 1008,29
A 1  T436  R E_RETRY 436
A 3  T1546 R FIXED_ARRAY[TYPE] 45,1683,1546
D 2  T1556 R EXTERNAL_ROUTINE 1687,1657
D 2  T1499 R DECLARATION_LIST 1117,1184
A*1  T10   R STD_ERROR 10
D 2  T342  R TYPE_BIT 612,602
A 1  T1867 R NATIVE_INLINE_WITH_CURRENT 1867
A 1  T1653 R CALL_INFIX_INT_DIV 1653
A 1  T43   R RUN_FEATURE_8 43
A*1  T1695 R ONCE_ROUTINE_POOL 1695
A 1  T1375 R TYPE_LIKE_FEATURE 1375
A 2  T2020 R FIXED_ARRAY[EXPRESSION] 1975,2020
A*1  T2040 R FIXED_ARRAY[BASE_CLASS] 2040
D 27 T79   R CALL 1787,1408,1578,1635,992,744,684,1647,245,251,1562,1653,939,879,994,1633,1436,157,949,771,15,1513,1563,1348,1707,1256,16
A 1  T1584 R NATIVE_JVM_INVOKEVIRTUAL 1584
A 1  T1562 R CALL_INFIX_POWER 1562
A*1  T85   R ECHO 85
A 1  T573  R PROC_CALL_0 573
A 1  T1828 E NATIVE_ARRAY[CALL_PROC_CALL] 1828
A 1  T1891 E NATIVE_ARRAY[ARGUMENT_NAME1] 1891
A 1  T1433 E NATIVE_ARRAY[FEATURE_CLAUSE] 1433
A 1  T30   E NATIVE_ARRAY[LOCAL_ARGUMENT] 30
A*1  T33   R ARRAY[INDEX_CLAUSE] 33
A*1  T1409 R ARRAY[FEATURE_NAME] 1409
A 1  T1735 R TYPE_LIKE_ARGUMENT 1735
A 1  T1230 R CST_ATT_STRING 1230
A*1  T1341 R FIXED_ARRAY[RUN_CLASS] 1341
A*1  T2011 R FIXED_ARRAY[E_FEATURE] 2011
A*1  T1094 R CONSTANT_POOL 1094
A 1  T1137 R MANIFEST_ARRAY 1137
A 1  T1564 R DEFERRED_FUNCTION 1564
A 1  T1358 R NATIVE_SMALL_EIFFEL 1358
A*1  T1106 R CREATION_CLAUSE 1106
A 1  T707  R WHEN_ITEM_1 707
A*1  T1587 R EXCEPTIONS_HANDLER 1587
A 1  T251  R CALL_1_C 251
A 1  T245  R CALL_0_C 245
A*1  T1160 R CREATION_CLAUSE_LIST 1160
A*1  T478  R RUN_CLASS 478
A 1  T580  R E_CURRENT 580
A 1  T475  R E_INSPECT 475
A 1  T1149 R ARGUMENT_NAME1 1149
A 1  T584  R PROC_CALL_1 584
A 3  T1794 R FIXED_ARRAY[RUN_FEATURE] 1570,41,1794
A 1  T1647 R CALL_INFIX_INT_REM 1647
D 22 T128  R TYPE 44,1241,1485,612,602,23,614,559,773,357,935,444,763,567,882,639,22,623,411,1375,1735,1678
A*1  T19   R WHEN_LIST 19
A 1  T1133 R RUN_FEATURE_9 1133
A*1  T1185 R CHECK_INVARIANT 1185
A*1  T34   R FIXED_ARRAY[CALL_PROC_CALL] 34
D 17 T461  R E_FEATURE 31,969,991,27,449,1657,1687,1564,1594,1190,940,667,640,1230,1300,1024,1248
A*1  T982  R EXCEPTION_TABLE 982
A*1  T431  R COMPOUND 431
A*1  T1139 R ARRAY[BASE_CLASS] 1139
A 5  T1746 R ARRAY[EXPRESSION] 1231,1388,1545,1763,1746
A*1  T1098 R ARRAY[CLASS_NAME] 1098
A 1  T1078 R CREATION_CALL_1 1078
A*1  T1815 R DICTIONARY[RUN_FEATURE,STRING] 1815
A*1  T35   R FIXED_ARRAY[EFFECTIVE_ARG_LIST] 35
A 1  T718  R WHEN_ITEM_2 718
A 1  T1594 R DEFERRED_PROCEDURE 1594
A 1  T684  R CALL_INFIX_GE 684
A 1  T744  R CALL_INFIX_LE 744
A 1  T992  R CALL_INFIX_NEQ 992
A 1  T449  R PROCEDURE 449
A*1  T1457 R FIXED_ARRAY[POSITION] 1457
A 1  T1241 R TYPE_REF_TO_EXP 1241
A 1  T44   R TYPE_BIT_REF 44
A*1  T1652 R EFFECTIVE_ARG_LIST 1652
A 1  T1635 R CALL_PREFIX_PLUS 1635
A 1  T1578 R CALL_INFIX_MINUS 1578
A 1  T1408 R CALL_INFIX_TIMES 1408
A 1  T513  R ADDRESS_OF 513
A 1  T1300 R CST_ATT_CHARACTER 1300
A 1  T411  R TYPE_ANY 411
A*1  T502  R BASE_CLASS 502
A*1  T694  R IFTHENLIST 694
A 1  T2038 R EXPRESSION_WITH_COMMENT 2038
D 4  T1706 R EFFECTIVE_ROUTINE 969,449,991,27
A 1  T1787 R CALL_PREFIX_MINUS 1787
A 1  T210  R E_FALSE 210
A 1  T1163 R ARGUMENT_NAME2 1163
A 1  T1324 R INSTRUCTION_WITH_COMMENT 1324
A 1  T519  R IFTHENELSE 519
A 1  T1029 R RUN_FEATURE_1 1029
A 1  T1763 R ARRAY[INTEGER_CONSTANT] 1763
A 1  T969  R ONCE_FUNCTION 969
A*1  T500  R STD_FILE_READ 500
A 1  T673  E FILE_TOOLS 673
 --- Mangling Table End --- */

/*C Header Pass 1 :*/
typedef struct S945 T945;
typedef struct S218 T218;
typedef struct S602 T602;
typedef struct S1104 T1104;
typedef struct S429 T429;
typedef struct S1545 T1545;
typedef struct S196 T196;
typedef struct S1190 T1190;
typedef struct S16 T16;
typedef struct S1873 T1873;
typedef struct S653 T653;
typedef struct S847 T847;
typedef struct S32 T32;
typedef struct S757 T757;
typedef struct S425 T425;
typedef struct S1540 T1540;
typedef struct S29 T29;
typedef struct S499 T499;
typedef struct S1093 T1093;
typedef struct S1256 T1256;
typedef struct S578 T578;
typedef struct S1543 T1543;
typedef struct S935 T935;
typedef struct S763 T763;
typedef struct S612 T612;
typedef struct S1683 T1683;
typedef struct S1467 T1467;
typedef struct S435 T435;
typedef struct S25 T25;
typedef struct S1485 T1485;
typedef struct S1379 T1379;
typedef struct S1184 T1184;
typedef struct S13 T13;
typedef struct S1042 T1042;
typedef struct S1501 T1501;
typedef struct S1285 T1285;
typedef struct S1198 T1198;
typedef struct S269 T269;
typedef struct S1210 T1210;
typedef struct S898 T898;
typedef struct S1707 T1707;
typedef struct S441 T441;
typedef struct S23 T23;
typedef struct S1231 T1231;
typedef struct S1926 T1926;
typedef struct S1348 T1348;
typedef struct S140 T140;
typedef struct S1117 T1117;
typedef struct S444 T444;
typedef struct S1563 T1563;
typedef struct S705 T705;
typedef struct S1567 T1567;
typedef struct S1657 T1657;
typedef struct S504 T504;
typedef struct S1108 T1108;
typedef int T1492;
typedef struct S1806 T1806;
typedef struct S1615 T1615;
typedef struct S1513 T1513;
typedef struct S1055 T1055;
typedef struct S1214 T1214;
typedef struct S1511 T1511;
typedef struct S559 T559;
typedef struct S527 T527;
typedef struct S181 T181;
typedef struct S535 T535;
typedef void*T878;
typedef struct S1224 T1224;
typedef struct S15 T15;
typedef struct S474 T474;
typedef struct S771 T771;
typedef struct S1610 T1610;
typedef struct S876 T876;
typedef struct S1388 T1388;
typedef struct S1280 T1280;
typedef struct S1772 T1772;
typedef struct S28 T28;
typedef struct S2001 T2001;
typedef int T214;
typedef struct S7 T7;
typedef struct S253 T253;
typedef struct S528 T528;
typedef struct S105 T105;
typedef struct S31 T31;
typedef struct S1068 T1068;
typedef struct S1211 T1211;
typedef struct S667 T667;
typedef struct S1687 T1687;
typedef struct S201 T201;
typedef struct S792 T792;
typedef struct S27 T27;
typedef struct S556 T556;
typedef void*T1065;
typedef struct S977 T977;
typedef struct S1123 T1123;
typedef struct S822 T822;
typedef struct S949 T949;
typedef struct S157 T157;
typedef struct S257 T257;
typedef struct S697 T697;
typedef struct S1127 T1127;
typedef struct S1120 T1120;
typedef struct S1220 T1220;
typedef struct S1916 T1916;
typedef struct S1124 T1124;
typedef struct S882 T882;
typedef struct S810 T810;
typedef struct S1175 T1175;
typedef struct S12 T12;
typedef struct S1570 T1570;
typedef struct S41 T41;
typedef struct S1436 T1436;
typedef struct S708 T708;
typedef struct S18 T18;
typedef struct S1024 T1024;
typedef struct S1081 T1081;
typedef struct S345 T345;
typedef struct S1008 T1008;
typedef struct S590 T590;
typedef struct S1866 T1866;
typedef struct S45 T45;
typedef struct S1975 T1975;
typedef struct S683 T683;
typedef struct S87 T87;
typedef struct S380 T380;
typedef struct S991 T991;
typedef struct S816 T816;
typedef struct S261 T261;
typedef struct S21 T21;
typedef struct S1633 T1633;
typedef struct S46 T46;
typedef struct S911 T911;
typedef struct S37 T37;
typedef struct S372 T372;
typedef struct S1333 T1333;
typedef struct S722 T722;
typedef struct S1189 T1189;
typedef struct S22 T22;
typedef struct S567 T567;
typedef struct S940 T940;
typedef struct S1248 T1248;
typedef struct S40 T40;
typedef struct S357 T357;
typedef struct S1974 T1974;
typedef struct S1789 T1789;
typedef struct S640 T640;
typedef struct S11 T11;
typedef struct S24 T24;
typedef struct S42 T42;
typedef struct S994 T994;
typedef struct S625 T625;
typedef struct S899 T899;
typedef struct S879 T879;
typedef struct S939 T939;
typedef struct S1141 T1141;
typedef struct S1678 T1678;
typedef struct S1751 T1751;
typedef struct S1886 T1886;
typedef struct S931 T931;
typedef struct S874 T874;
typedef struct S701 T701;
typedef struct S742 T742;
typedef struct S623 T623;
typedef struct S1038 T1038;
typedef struct S1244 T1244;
typedef struct S1277 T1277;
typedef struct S36 T36;
typedef struct S636 T636;
typedef struct S1461 T1461;
typedef struct S20 T20;
typedef struct S1107 T1107;
typedef struct S510 T510;
typedef struct S614 T614;
typedef struct S38 T38;
typedef struct S837 T837;
typedef struct S773 T773;
typedef struct S639 T639;
typedef struct S1243 T1243;
typedef void*T1373;
typedef struct S436 T436;
typedef struct S1546 T1546;
typedef void*T10;
typedef struct S1867 T1867;
typedef struct S1653 T1653;
typedef struct S43 T43;
typedef struct S1695 T1695;
typedef struct S1375 T1375;
typedef struct S2020 T2020;
typedef struct S2040 T2040;
typedef struct S1584 T1584;
typedef struct S1562 T1562;
typedef struct S85 T85;
typedef struct S573 T573;
typedef struct S33 T33;
typedef struct S1409 T1409;
typedef struct S1735 T1735;
typedef struct S1230 T1230;
typedef struct S1341 T1341;
typedef struct S2011 T2011;
typedef struct S1094 T1094;
typedef struct S1137 T1137;
typedef struct S1564 T1564;
typedef struct S1358 T1358;
typedef struct S1106 T1106;
typedef struct S707 T707;
typedef struct S1587 T1587;
typedef struct S251 T251;
typedef struct S245 T245;
typedef struct S1160 T1160;
typedef struct S478 T478;
typedef struct S580 T580;
typedef struct S475 T475;
typedef struct S1149 T1149;
typedef struct S584 T584;
typedef struct S1794 T1794;
typedef struct S1647 T1647;
typedef struct S19 T19;
typedef struct S1133 T1133;
typedef struct S1185 T1185;
typedef struct S34 T34;
typedef void*T982;
typedef struct S431 T431;
typedef struct S1139 T1139;
typedef struct S1746 T1746;
typedef struct S1098 T1098;
typedef struct S1078 T1078;
typedef struct S1815 T1815;
typedef struct S35 T35;
typedef struct S718 T718;
typedef struct S1594 T1594;
typedef struct S684 T684;
typedef struct S744 T744;
typedef struct S992 T992;
typedef struct S449 T449;
typedef struct S1457 T1457;
typedef struct S1241 T1241;
typedef struct S44 T44;
typedef struct S1652 T1652;
typedef struct S1635 T1635;
typedef struct S1578 T1578;
typedef struct S1408 T1408;
typedef struct S513 T513;
typedef struct S1300 T1300;
typedef struct S411 T411;
typedef struct S502 T502;
typedef struct S694 T694;
typedef struct S2038 T2038;
typedef struct S1787 T1787;
typedef struct S210 T210;
typedef struct S1163 T1163;
typedef struct S1324 T1324;
typedef struct S519 T519;
typedef struct S1029 T1029;
typedef struct S1763 T1763;
typedef struct S969 T969;
typedef struct S500 T500;
typedef int T673;

/*C Header Pass 2 :*/
typedef T0**T1512;
typedef T0**T1608;
typedef T3*T9;
typedef T0**T1876;
typedef T0**T1253;
typedef T0**T1421;
typedef T0**T1734;
typedef T0**T1281;
typedef T0**T1323;
typedef T0**T1282;
typedef T6*T1809;
typedef T2*T2045;
typedef T0**T1840;
typedef T0**T1888;
typedef T0**T1862;
typedef T0**T1784;
typedef T0**T1776;
typedef T0**T1585;
typedef T0**T1460;
typedef T0**T1801;
typedef T0**T1356;
typedef T0**T1082;
typedef T0**T1677;
typedef T0**T1548;
typedef T0**T1696;
typedef T0**T1697;
typedef T0**T1136;
typedef T0**T1987;
typedef T0**T1688;
typedef T0**T1771;
typedef T0**T1205;
typedef T0**T1666;
typedef T0**T1304;
typedef T0**T39;
typedef T0**T1967;
typedef T0**T1943;
typedef T0**T1733;
typedef T0**T1828;
typedef T0**T1891;
typedef T0**T1433;
typedef T0**T30;

/*C Header Pass 3 :*/

/*C Header Pass 4 :*/
struct S945{int id;T2 _static_value_mem;T0* _current_type;T0* _start_position;T0* _value;T0* _result_type;};
extern T945 M945;
struct S218{T0* _to_string;T0* _start_position;};
extern T218 M218;
struct S602{int id;T0* _start_position;T0* _written_mark;T0* _run_time_mark;T0* _n;};
extern T602 M602;
struct S1104{T1666 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T1104 M1104;
struct S429{T0* _start_position;T0* _header_comment;T0* _list;T0* _current_type;T6 _is_ensure_then;};
extern T429 M429;
struct S1545{int id;T1304 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T1545 M1545;
struct S196{int id;T0* _run_compound;T0* _start_position;T0* _list;T0* _compound;};
extern T196 M196;
struct S1190{int id;T0* _base_class;T0* _names;T0* _result_type;T0* _header_comment;T0* _clients;T0* _value_mem;};
extern T1190 M1190;
struct S16{int id;T0* _target;T0* _current_type;T0* _run_feature;T2 _static_value_mem;T0* _result_type;T0* _arguments;T0* _feature_name;};
extern T16 M16;
struct S1873{int id;T2 _static_value_mem;T0* _current_type;T0* _start_position;T3 _value;T2 _pretty_print_mode;};
extern T1873 M1873;
struct S653{int id;T0* _run_compound;T0* _left_side;T0* _right_side;};
extern T653 M653;
struct S847{T2 _level;T6 _trace;T0* _root_class;T0* _cecil_path;};
extern T847 M847;
struct S32{T0* _list;};
extern T32 M32;
struct S757{T0* _clients;T0* _list;};
extern T757 M757;
struct S425{T0* _to_string;T0* _start_position;};
extern T425 M425;
struct S1540{T0* _keys;T0* _store;T2 _modulus;T0* _buckets;T0* _chain;T2 _first_free_slot;T2 _cache_keys_idx;T2 _cache_user_idx;T2 _count;};
extern T1540 M1540;
struct S29{int id;T0* _name_list;};
extern T29 M29;
struct S499{T0* _start_position;T0* _header_comment;T0* _list;T0* _current_type;T6 _is_require_else;};
extern T499 M499;
struct S1093{int id;T0* _run_compound;T0* _start_position;T0* _writable;T0* _type;};
extern T1093 M1093;
struct S1256{int id;T0* _target;T0* _current_type;T0* _run_feature;T2 _static_value_mem;T0* _result_type;T0* _arguments;T0* _feature_name;};
extern T1256 M1256;
struct S578{T2 _count;T2 _access_flags;T2 _name_index;T2 _descriptor_index;};
extern T578 M578;
struct S1543{int id;T2 _static_value_mem;T0* _current_type;T0* _start_position;T2 _value;};
extern T1543 M1543;
struct S935{int id;T0* _base_class_name;};
extern T935 M935;
struct S763{int id;T0* _base_class_name;};
extern T763 M763;
struct S612{int id;T0* _start_position;T0* _written_mark;T0* _run_time_mark;T0* _n;T2 _nb;};
extern T612 M612;
struct S1683{int id;T1967 _storage;T2 _capacity;T2 _upper;};
extern T1683 M1683;
struct S1467{T1733 _storage;T2 _capacity;T2 _upper;};
extern T1467 M1467;
struct S435{int id;T0* _to_string;T0* _start_position;T6 _is_frozen;T0* _to_key;};
extern T435 M435;
struct S25{int id;};
extern T25 M25;
struct S1485{int id;T0* _formal_name;T2 _rank;T0* _run_type;};
extern T1485 M1485;
struct S1379{int id;T2 _static_value_mem;T0* _current_type;T0* _start_position;T0* _to_string;T0* _break;T0* _ascii;T0* _percent;T0* _mapping_c;};
extern T1379 M1379;
struct S1184{int id;T0* _start_position;T0* _list;T0* _flat_list;T0* _current_type;};
extern T1184 M1184;
struct S13{T0* _keys;T0* _store;T2 _modulus;T0* _buckets;T0* _chain;T2 _first_free_slot;T2 _cache_keys_idx;T2 _cache_user_idx;T2 _count;};
extern T13 M13;
struct S1042{int id;T0* _current_type;T0* _clients_memory;T0* _actuals_clients;T0* _name;T0* _arguments;T0* _result_type;T2 _use_current_state;T0* _base_feature;};
extern T1042 M1042;
struct S1501{T0* _list;};
extern T1501 M1501;
struct S1285{T0* _start_position;T0* _header_comment;T0* _list;T0* _current_type;};
extern T1285 M1285;
struct S1198{T0* _list;};
extern T1198 M1198;
struct S269{T0* _unique_string_memory;T2 _li;T2 _co;};
extern T269 M269;
struct S1210{int id;T0* _comment;T0* _expression;T0* _current_type;};
extern T1210 M1210;
struct S898{T6 _case_insensitive;T6 _drop_comments;T6 _is_running;T2 _column;T2 _line;T0* _current_line;T3 _cc;T0* _last_comments;T0* _function_type;T0* _formal_generic_list;T6 _in_ensure;T6 _in_rescue;T0* _arguments;T0* _local_vars;T6 _ok;T2 _ms_numbering;T2 _last_ascii_code;T0* _last_base_class;T0* _last_base_type;T0* _last_binary;T0* _last_bit_constant;T0* _last_boolean_constant;T0* _last_character_constant;T0* _last_class_name;T0* _last_class_type;T0* _last_expression;T0* _last_feature_declaration;T0* _last_feature_list;T0* _last_feature_name;T0* _last_keyword;T0* _last_type_formal_generic;T0* _last_infix;T0* _last_prefix;T0* _last_integer_constant;T0* _last_instruction;T0* _last_index_value;T0* _last_manifest_constant;T0* _last_manifest_string;T0* _last_parent;T0* _last_real_constant;T0* _last_type;T0* _last_tag_mark;T2 _start_column;T2 _start_line;};
extern T898 M898;
struct S1707{int id;T0* _target;T0* _current_type;T0* _run_feature;T2 _static_value_mem;T0* _result_type;T0* _arguments;T0* _feature_name;};
extern T1707 M1707;
struct S441{int id;T0* _run_compound;T0* _target;T0* _feature_name;T0* _run_feature;T0* _arguments;};
extern T441 M441;
struct S23{int id;T0* _start_position;T0* _written_mark;T0* _mapped;T0* _run_time_mark;T0* _run_type;};
extern T23 M23;
struct S1231{int id;T1891 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T1231 M1231;
struct S1926{T1433 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T1926 M1926;
struct S1348{int id;T0* _target;T0* _current_type;T0* _run_feature;T2 _static_value_mem;T0* _result_type;T0* _feature_name;};
extern T1348 M1348;
struct S140{int id;T0* _run_compound;T0* _check_invariant;};
extern T140 M140;
struct S1117{int id;T0* _start_position;T0* _list;T0* _flat_list;T0* _current_type;};
extern T1117 M1117;
struct S444{int id;T0* _base_class_name;};
extern T444 M444;
struct S1563{int id;T0* _target;T0* _current_type;T0* _run_feature;T2 _static_value_mem;T0* _result_type;T0* _arguments;T0* _feature_name;};
extern T1563 M1563;
struct S705{T1776 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T705 M705;
struct S1567{T0* _path;T8 _output_stream;};
extern T1567 M1567;
struct S1657{int id;T0* _base_class;T0* _names;T0* _result_type;T0* _header_comment;T0* _clients;T0* _arguments;T0* _obsolete_mark;T0* _require_assertion;T0* _ensure_assertion;T0* _end_comment;T0* _native;T0* _alias_string;};
extern T1657 M1657;
struct S504{T0* _root_procedure;T6 _is_ready;T6 _short_flag;T2 _magic_count;T2 _top;};
extern T504 M504;
struct S1108{int id;T0* _run_compound;T0* _start_position;T0* _writable;T0* _run_feature;T0* _call;};
extern T1108 M1108;
extern T1492 M1492;
struct S1806{T2045 _storage;T2 _capacity;T2 _upper;};
extern T1806 M1806;
struct S1615{T1840 _storage;T2 _capacity;T2 _upper;};
extern T1615 M1615;
struct S1513{int id;T0* _target;T0* _current_type;T0* _run_feature;T2 _static_value_mem;T0* _result_type;T0* _arguments;T0* _feature_name;};
extern T1513 M1513;
struct S1055{int id;T0* _current_type;T0* _clients_memory;T0* _actuals_clients;T0* _name;T0* _arguments;T0* _result_type;T0* _require_assertion;T0* _routine_body;T0* _ensure_assertion;T0* _rescue_compound;T2 _use_current_state;T0* _base_feature;T0* _local_vars;T2 _in_line_status;};
extern T1055 M1055;
struct S1214{int id;};
extern T1214 M1214;
struct S1511{int id;T2 _static_value_mem;T0* _current_type;T0* _to_string;T0* _start_position;T6 _is_frozen;T0* _run_feature_2;};
extern T1511 M1511;
struct S559{int id;T0* _base_class_name;};
extern T559 M559;
struct S527{int id;T0* _to_string;T0* _start_position;T6 _is_frozen;T0* _to_key;};
extern T527 M527;
struct S181{int id;T2 _static_value_mem;T0* _current_type;T0* _to_string;T0* _start_position;};
extern T181 M181;
struct S535{T0* _old_name;T0* _new_name;};
extern T535 M535;
extern T878 M878;
struct S1224{int id;T0* _comment;T0* _expression;T0* _current_type;T0* _tag;};
extern T1224 M1224;
struct S15{int id;T0* _target;T0* _current_type;T0* _run_feature;T2 _static_value_mem;T0* _result_type;T0* _arguments;T0* _feature_name;};
extern T15 M15;
struct S474{T6 _item;};
extern T474 M474;
struct S771{int id;T0* _target;T0* _current_type;T0* _run_feature;T2 _static_value_mem;T0* _result_type;T0* _arguments;T0* _feature_name;};
extern T771 M771;
struct S1610{int id;T1082 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T1610 M1610;
struct S876{T0* _path;T2 _last_byte;T8 _output_stream;};
extern T876 M876;
struct S1388{int id;T1677 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T1388 M1388;
struct S1280{T1548 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T1280 M1280;
struct S1772{T1356 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T1772 M1772;
struct S28{T1696 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T28 M28;
struct S2001{T1697 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T2001 M2001;
extern T214 M214;
struct S7{T9 _storage;T2 _count;T2 _capacity;};
extern T7 M7;
struct S253{int id;T2 _static_value_mem;T0* _current_type;T0* _start_position;};
extern T253 M253;
struct S528{T2 _item;};
extern T528 M528;
struct S105{int id;T2 _static_value_mem;T0* _current_type;T0* _expression;T2 _id;};
extern T105 M105;
struct S31{int id;T0* _base_class;T0* _names;T0* _result_type;T0* _header_comment;T0* _clients;};
extern T31 M31;
struct S1068{int id;T0* _current_type;T0* _clients_memory;T0* _actuals_clients;T0* _name;T0* _arguments;T0* _result_type;T0* _require_assertion;T0* _routine_body;T0* _ensure_assertion;T0* _rescue_compound;T2 _use_current_state;T0* _base_feature;T0* _local_vars;T2 _static_value_mem;T2 _in_line_status;T6 _is_static_flag;};
extern T1068 M1068;
struct S1211{T1801 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T1211 M1211;
struct S667{int id;T0* _base_class;T0* _names;T0* _result_type;T0* _header_comment;T0* _clients;T0* _value_mem;};
extern T667 M667;
struct S1687{int id;T0* _base_class;T0* _names;T0* _result_type;T0* _header_comment;T0* _clients;T0* _arguments;T0* _obsolete_mark;T0* _require_assertion;T0* _ensure_assertion;T0* _end_comment;T0* _native;T0* _alias_string;};
extern T1687 M1687;
struct S201{T0* _expression;T0* _then_compound;T0* _run_compound;T2 _point2;};
extern T201 M201;
struct S792{T0* _start_position;T0* _list;};
extern T792 M792;
struct S27{int id;T0* _base_class;T0* _names;T0* _result_type;T0* _header_comment;T0* _local_vars;T0* _clients;T0* _arguments;T0* _obsolete_mark;T0* _require_assertion;T0* _ensure_assertion;T0* _end_comment;T0* _routine_body;T0* _rescue_compound;T2 _use_current_state;};
extern T27 M27;
struct S556{T0* _user_cecil_list;T0* _user_cecil_name;T0* _user_path_h;};
extern T556 M556;
extern T1065 M1065;
struct S977{T0* _clients;T0* _comment;T0* _list;};
extern T977 M977;
struct S1123{int id;T0* _run_compound;T0* _start_position;T0* _writable;T0* _run_feature;T0* _call;T0* _type;};
extern T1123 M1123;
struct S822{T0* _path;T2 _count;};
extern T822 M822;
struct S949{int id;T0* _target;T0* _current_type;T0* _run_feature;T2 _static_value_mem;T0* _result_type;T0* _arguments;T0* _feature_name;};
extern T949 M949;
struct S157{int id;T0* _target;T0* _current_type;T0* _run_feature;T2 _static_value_mem;T0* _feature_name;T0* _result_type;T0* _arguments;};
extern T157 M157;
struct S257{T3 _tag;T0* _info;};
extern T257 M257;
struct S697{T0* _list;};
extern T697 M697;
struct S1127{T2 _max_stack;T2 _current_stack_level;T2 _max_locals;T2 _check_flag_idx;T2 _skip_check;};
extern T1127 M1127;
struct S1120{T2 _state;T0* _level;T0* _root_class;T0* _start_proc;};
extern T1120 M1120;
struct S1220{T0* _keys;T0* _store;T2 _modulus;T0* _buckets;T0* _chain;T2 _first_free_slot;T2 _cache_keys_idx;T2 _cache_user_idx;T2 _cache_buckets_idx;T2 _count;};
extern T1220 M1220;
struct S1916{T0* _keys;T0* _store;T2 _modulus;T0* _buckets;T0* _chain;T2 _first_free_slot;T2 _cache_keys_idx;T2 _cache_user_idx;T2 _count;};
extern T1916 M1916;
struct S1124{int id;T1784 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T1124 M1124;
struct S882{int id;T0* _base_class_name;};
extern T882 M882;
struct S810{T0* _base_class;T0* _start_position;T0* _heading_comment;T0* _list;};
extern T810 M810;
struct S1175{T0* _keys;T0* _store;T2 _modulus;T0* _buckets;T0* _chain;T2 _first_free_slot;T2 _cache_keys_idx;T2 _cache_user_idx;T2 _count;};
extern T1175 M1175;
struct S12{T0* _base_class_name;T2 _mem_line_column;};
extern T12 M12;
struct S1570{int id;T1888 _storage;T2 _capacity;T2 _upper;};
extern T1570 M1570;
struct S41{int id;T1862 _storage;T2 _capacity;T2 _upper;};
extern T41 M41;
struct S1436{int id;T0* _target;T0* _current_type;T0* _run_feature;T2 _static_value_mem;T0* _result_type;T0* _arguments;T0* _feature_name;};
extern T1436 M1436;
struct S708{T0* _mem_id;T0* _mem_str;};
extern T708 M708;
struct S18{T0* _start_position;T0* _list;T0* _header_comment;T0* _compound;T0* _when_list;T0* _values;T2 _point2;};
extern T18 M18;
struct S1024{int id;T0* _base_class;T0* _names;T0* _result_type;T0* _header_comment;T0* _clients;T0* _value_mem;};
extern T1024 M1024;
struct S1081{int id;T0* _current_type;T0* _clients_memory;T0* _actuals_clients;T0* _name;T0* _arguments;T0* _result_type;T0* _require_assertion;T0* _routine_body;T0* _ensure_assertion;T0* _rescue_compound;T2 _use_current_state;T0* _base_feature;T0* _local_vars;};
extern T1081 M1081;
struct S345{T0* _start_position;T0* _list;};
extern T345 M345;
struct S1008{int id;T0* _name;};
extern T1008 M1008;
struct S590{T0* _tag;T0* _expression;T0* _comment;T0* _current_type;};
extern T590 M590;
struct S1866{int id;T0* _run_compound;T0* _left_side;T0* _right_side;};
extern T1866 M1866;
struct S45{int id;T1205 _storage;T2 _capacity;T2 _upper;};
extern T45 M45;
struct S1975{int id;T1304 _storage;T2 _capacity;T2 _upper;};
extern T1975 M1975;
struct S683{T0* _arguments;T0* _type;T0* _header_comment;T0* _obsolete_mark;T0* _require_assertion;T0* _local_vars;T0* _routine_body;};
extern T683 M683;
struct S87{T0* _output_name;T2 _static_expression_count;T2 _top;T2 _direct_call_count;T2 _switch_count;T2 _b_put_u1_count;T2 _access_flags;T2 _this_class_idx;T2 _super_class_idx;T0* _current_frame;};
extern T87 M87;
struct S380{T2 _value;};
extern T380 M380;
struct S991{int id;T0* _base_class;T0* _names;T0* _result_type;T0* _header_comment;T0* _local_vars;T0* _clients;T0* _arguments;T0* _obsolete_mark;T0* _require_assertion;T0* _ensure_assertion;T0* _end_comment;T0* _routine_body;T0* _rescue_compound;T2 _use_current_state;};
extern T991 M991;
struct S816{T2 _nb_warnings;T2 _nb_errors;T6 _no_warning;};
extern T816 M816;
struct S261{T0* _parent_list;T0* _type;T0* _comment;T0* _rename_list;T0* _export_list;T0* _undefine_list;T0* _redefine_list;T0* _select_list;T0* _undefine_memory1;T0* _undefine_memory2;};
extern T261 M261;
struct S21{int id;T0* _run_compound;T0* _start_position;T0* _initialize;T0* _invariant_clause;T0* _variant_clause;T0* _until_expression;T0* _loop_body;};
extern T21 M21;
struct S1633{int id;T0* _target;T0* _current_type;T0* _run_feature;T2 _static_value_mem;T0* _result_type;T0* _feature_name;};
extern T1633 M1633;
struct S46{T1809 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T46 M46;
struct S911{T2045 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T911 M911;
struct S37{T0* _keys;T0* _store;T2 _modulus;T0* _buckets;T0* _chain;T2 _first_free_slot;T2 _cache_keys_idx;T2 _cache_user_idx;T2 _cache_buckets_idx;T2 _count;};
extern T37 M37;
struct S372{int id;T2 _static_value_mem;T0* _current_type;T0* _list;};
extern T372 M372;
struct S1333{T1734 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T1333 M1333;
struct S722{T0* _index;T0* _list;};
extern T722 M722;
struct S1189{T0* _name;T0* _constraint;};
extern T1189 M1189;
struct S22{int id;T0* _base_class_name;T0* _generic_list;T0* _written_mark;T0* _run_type;};
extern T22 M22;
struct S567{int id;T0* _base_class_name;};
extern T567 M567;
struct S940{int id;T0* _base_class;T0* _names;T0* _result_type;T0* _header_comment;T0* _clients;T0* _value_mem;};
extern T940 M940;
struct S1248{int id;T0* _base_class;T0* _names;T0* _result_type;T0* _header_comment;T0* _clients;T0* _values;};
extern T1248 M1248;
struct S40{int id;T0* _current_type;T0* _clients_memory;T0* _actuals_clients;T0* _name;T0* _arguments;T0* _result_type;T0* _require_assertion;T0* _routine_body;T0* _ensure_assertion;T0* _rescue_compound;T2 _use_current_state;T0* _base_feature;T0* _local_vars;};
extern T40 M40;
struct S357{int id;T0* _base_class_name;};
extern T357 M357;
struct S1974{T0* _list;};
extern T1974 M1974;
struct S1789{T0* _start_position;T0* _list;};
extern T1789 M1789;
struct S640{int id;T0* _base_class;T0* _names;T0* _result_type;T0* _header_comment;T0* _clients;T0* _value_mem;};
extern T640 M640;
struct S11{T2 _count;};
extern T11 M11;
struct S24{int id;};
extern T24 M24;
struct S42{T0* _list;};
extern T42 M42;
struct S994{int id;T0* _target;T0* _current_type;T0* _run_feature;T2 _static_value_mem;T0* _result_type;T0* _arguments;T0* _feature_name;};
extern T994 M994;
struct S625{int id;T2 _static_value_mem;T0* _current_type;T0* _to_string;T0* _start_position;T2 _rank;T0* _result_type;T6 _is_used;};
extern T625 M625;
struct S899{T0* _start_position;T0* _items;};
extern T899 M899;
struct S879{int id;T0* _target;T0* _current_type;T0* _run_feature;T2 _static_value_mem;T0* _result_type;T0* _arguments;T0* _feature_name;};
extern T879 M879;
struct S939{int id;T0* _target;T0* _current_type;T0* _run_feature;T2 _static_value_mem;T0* _result_type;T0* _arguments;T0* _feature_name;};
extern T939 M939;
struct S1141{T0* _start_position;T0* _header_comment;T0* _list;T0* _current_type;};
extern T1141 M1141;
struct S1678{int id;T0* _start_position;T0* _run_type;T0* _like_what;};
extern T1678 M1678;
struct S1751{T1987 _storage;T2 _capacity;T2 _upper;};
extern T1751 M1751;
struct S1886{T1136 _storage;T2 _capacity;T2 _upper;};
extern T1886 M1886;
struct S931{T1136 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T931 M931;
struct S874{T1987 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T874 M874;
struct S701{T1688 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T701 M701;
struct S742{T1771 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T742 M742;
struct S623{int id;T0* _base_class_name;T0* _generic_list;T0* _written_mark;T0* _run_type;};
extern T623 M623;
struct S1038{int id;T2 _static_value_mem;T0* _current_type;T0* _start_position;T0* _to_string;};
extern T1038 M1038;
struct S1244{T1512 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T1244 M1244;
struct S1277{T1608 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T1277 M1277;
struct S36{T1253 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T36 M36;
struct S636{int id;T2 _static_value_mem;T0* _current_type;T0* _to_string;T0* _start_position;T2 _rank;T0* _result_type;};
extern T636 M636;
struct S1461{T1876 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T1461 M1461;
struct S20{T1421 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T20 M20;
struct S1107{int id;T0* _current_type;T0* _clients_memory;T0* _actuals_clients;T0* _name;T0* _arguments;T0* _result_type;T0* _require_assertion;T0* _routine_body;T0* _ensure_assertion;T0* _rescue_compound;T2 _use_current_state;T0* _base_feature;};
extern T1107 M1107;
struct S510{int id;T2 _static_value_mem;T0* _current_type;T0* _to_string;T0* _start_position;T0* _result_type;};
extern T510 M510;
struct S614{int id;T0* _base_class_name;T0* _generic_list;T0* _written_mark;T0* _run_type_memory;};
extern T614 M614;
struct S38{T39 _storage;T2 _capacity;T2 _upper;};
extern T38 M38;
struct S837{T0* _item;};
extern T837 M837;
struct S773{int id;T0* _base_class_name;};
extern T773 M773;
struct S639{int id;T0* _base_class_name;};
extern T639 M639;
struct S1243{int id;};
extern T1243 M1243;
extern T1373 M1373;
struct S436{int id;T0* _run_compound;T0* _start_position;};
extern T436 M436;
struct S1546{int id;T1776 _storage;T2 _capacity;T2 _upper;};
extern T1546 M1546;
extern T10 M10;
struct S1867{int id;};
extern T1867 M1867;
struct S1653{int id;T0* _target;T0* _current_type;T0* _run_feature;T2 _static_value_mem;T0* _result_type;T0* _arguments;T0* _feature_name;};
extern T1653 M1653;
struct S43{int id;T0* _current_type;T0* _clients_memory;T0* _actuals_clients;T0* _name;T0* _arguments;T0* _result_type;T0* _require_assertion;T0* _routine_body;T0* _ensure_assertion;T0* _rescue_compound;T2 _use_current_state;T2 _static_value_mem;T0* _base_feature;};
extern T43 M43;
struct S1695{T2 _fields_count;};
extern T1695 M1695;
struct S1375{int id;T0* _start_position;T0* _run_type;T0* _like_what;T0* _written_mark;};
extern T1375 M1375;
struct S2020{int id;T1323 _storage;T2 _capacity;T2 _upper;};
extern T2020 M2020;
struct S2040{T1281 _storage;T2 _capacity;T2 _upper;};
extern T2040 M2040;
struct S1584{int id;};
extern T1584 M1584;
struct S1562{int id;T0* _target;T0* _current_type;T0* _run_feature;T2 _static_value_mem;T0* _result_type;T0* _arguments;T0* _feature_name;};
extern T1562 M1562;
struct S85{T6 _verbose;};
extern T85 M85;
struct S573{int id;T0* _run_compound;T0* _target;T0* _feature_name;T0* _run_feature;};
extern T573 M573;
struct S33{T1943 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T33 M33;
struct S1409{T1733 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T1409 M1409;
struct S1735{int id;T0* _start_position;T0* _run_type;T0* _like_what;T0* _written_mark;};
extern T1735 M1735;
struct S1230{int id;T0* _base_class;T0* _names;T0* _result_type;T0* _header_comment;T0* _clients;T0* _values;};
extern T1230 M1230;
struct S1341{T1608 _storage;T2 _capacity;T2 _upper;};
extern T1341 M1341;
struct S2011{T1253 _storage;T2 _capacity;T2 _upper;};
extern T2011 M2011;
struct S1094{T2 _cp_up;T2 _idx_uft8_code;T2 _idx_java_lang_object;T2 _idx_jvm_root_class;};
extern T1094 M1094;
struct S1137{int id;T2 _static_value_mem;T0* _current_type;T0* _start_position;T0* _list;T0* _result_type;};
extern T1137 M1137;
struct S1564{int id;T0* _base_class;T0* _names;T0* _result_type;T0* _header_comment;T0* _clients;T0* _arguments;T0* _obsolete_mark;T0* _require_assertion;T0* _ensure_assertion;T0* _end_comment;};
extern T1564 M1564;
struct S1358{int id;};
extern T1358 M1358;
struct S1106{T0* _start_position;T0* _clients;T0* _comment;T0* _procedure_list;};
extern T1106 M1106;
struct S707{int id;T0* _e_when;T0* _expression;T2 _expression_value;};
extern T707 M707;
struct S1587{T6 _used;};
extern T1587 M1587;
struct S251{int id;T0* _target;T0* _current_type;T0* _run_feature;T2 _static_value_mem;T0* _feature_name;T0* _result_type;T0* _arguments;};
extern T251 M251;
struct S245{int id;T0* _target;T0* _current_type;T0* _run_feature;T2 _static_value_mem;T0* _feature_name;T0* _result_type;};
extern T245 M245;
struct S1160{T0* _list;};
extern T1160 M1160;
struct S478{T0* _current_type;T2 _id;T6 _at_run_time;T0* _running;T0* _class_invariant;T6 _compile_to_c_done;T0* _feature_dictionary;T6 _runnable_class_invariant_done;T0* _actuals_clients;T0* _writable_attributes_mem;};
extern T478 M478;
struct S580{int id;T2 _static_value_mem;T0* _current_type;T0* _to_string;T6 _is_written;T0* _start_position;};
extern T580 M580;
struct S475{int id;T0* _run_compound;T0* _start_position;T0* _expression;T0* _when_list;T0* _else_position;T0* _else_compound;};
extern T475 M475;
struct S1149{int id;T2 _static_value_mem;T0* _current_type;T0* _to_string;T0* _start_position;T2 _rank;T0* _result_type;};
extern T1149 M1149;
struct S584{int id;T0* _target;T0* _run_compound;T0* _feature_name;T0* _run_feature;T0* _arguments;};
extern T584 M584;
struct S1794{int id;T1082 _storage;T2 _capacity;T2 _upper;};
extern T1794 M1794;
struct S1647{int id;T0* _target;T0* _current_type;T0* _run_feature;T2 _static_value_mem;T0* _result_type;T0* _arguments;T0* _feature_name;};
extern T1647 M1647;
struct S19{T0* _e_inspect;T0* _list;};
extern T19 M19;
struct S1133{int id;T0* _current_type;T0* _clients_memory;T0* _actuals_clients;T0* _name;T0* _arguments;T0* _result_type;T0* _require_assertion;T0* _routine_body;T0* _ensure_assertion;T0* _rescue_compound;T2 _use_current_state;T0* _base_feature;};
extern T1133 M1133;
struct S1185{T0* _start_position;T0* _header_comment;T0* _list;T0* _current_type;};
extern T1185 M1185;
struct S34{T1828 _storage;T2 _capacity;T2 _upper;};
extern T34 M34;
extern T982 M982;
struct S431{T0* _header_comment;T0* _current_type;T0* _list;};
extern T431 M431;
struct S1139{T1281 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T1139 M1139;
struct S1746{int id;T1323 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T1746 M1746;
struct S1098{T1282 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T1098 M1098;
struct S1078{int id;T0* _run_compound;T0* _start_position;T0* _writable;};
extern T1078 M1078;
struct S1815{T0* _keys;T0* _store;T2 _modulus;T0* _buckets;T0* _chain;T2 _first_free_slot;T2 _cache_keys_idx;T2 _cache_user_idx;T2 _cache_buckets_idx;T2 _count;};
extern T1815 M1815;
struct S35{T1460 _storage;T2 _capacity;T2 _upper;};
extern T35 M35;
struct S718{int id;T0* _e_when;T0* _upper;T0* _lower;T2 _upper_value;T2 _lower_value;};
extern T718 M718;
struct S1594{int id;T0* _base_class;T0* _names;T0* _result_type;T0* _header_comment;T0* _clients;T0* _arguments;T0* _obsolete_mark;T0* _require_assertion;T0* _ensure_assertion;T0* _end_comment;};
extern T1594 M1594;
struct S684{int id;T0* _target;T0* _current_type;T0* _run_feature;T2 _static_value_mem;T0* _result_type;T0* _arguments;T0* _feature_name;};
extern T684 M684;
struct S744{int id;T0* _target;T0* _current_type;T0* _run_feature;T2 _static_value_mem;T0* _result_type;T0* _arguments;T0* _feature_name;};
extern T744 M744;
struct S992{int id;T0* _target;T0* _current_type;T0* _run_feature;T2 _static_value_mem;T0* _result_type;T0* _arguments;T0* _feature_name;};
extern T992 M992;
struct S449{int id;T0* _base_class;T0* _names;T0* _result_type;T0* _header_comment;T0* _local_vars;T0* _clients;T0* _arguments;T0* _obsolete_mark;T0* _require_assertion;T0* _ensure_assertion;T0* _end_comment;T0* _routine_body;T0* _rescue_compound;T2 _use_current_state;};
extern T449 M449;
struct S1457{T1734 _storage;T2 _capacity;T2 _upper;};
extern T1457 M1457;
struct S1241{int id;T0* _run_class;T0* _written_mark;T0* _expanded_type;};
extern T1241 M1241;
struct S44{int id;T0* _type_bit;T0* _written_mark;T0* _run_time_mark;};
extern T44 M44;
struct S1652{T0* _list;T0* _current_type;};
extern T1652 M1652;
struct S1635{int id;T0* _target;T0* _current_type;T0* _run_feature;T2 _static_value_mem;T0* _result_type;T0* _feature_name;};
extern T1635 M1635;
struct S1578{int id;T0* _target;T0* _current_type;T0* _run_feature;T2 _static_value_mem;T0* _result_type;T0* _arguments;T0* _feature_name;};
extern T1578 M1578;
struct S1408{int id;T0* _target;T0* _current_type;T0* _run_feature;T2 _static_value_mem;T0* _result_type;T0* _arguments;T0* _feature_name;};
extern T1408 M1408;
struct S513{int id;T2 _static_value_mem;T0* _current_type;T0* _feature_name;T0* _rf;};
extern T513 M513;
struct S1300{int id;T0* _base_class;T0* _names;T0* _result_type;T0* _header_comment;T0* _clients;T0* _value_mem;};
extern T1300 M1300;
struct S411{int id;T0* _base_class_name;};
extern T411 M411;
struct S502{T2 _id;T0* _path;T0* _index_list;T0* _heading_comment1;T6 _is_deferred;T6 _is_expanded;T0* _base_class_name;T0* _formal_generic_list;T0* _heading_comment2;T0* _obsolete_type_string;T0* _parent_list;T0* _creation_clause_list;T0* _feature_clause_list;T0* _class_invariant;T0* _end_comment;T0* _feature_dictionary;T0* _isom;};
extern T502 M502;
struct S694{T0* _list;T0* _run_compound;};
extern T694 M694;
struct S2038{int id;T2 _static_value_mem;T0* _current_type;T0* _expression;T0* _comment;};
extern T2038 M2038;
struct S1787{int id;T0* _target;T0* _current_type;T0* _run_feature;T2 _static_value_mem;T0* _result_type;T0* _feature_name;};
extern T1787 M1787;
struct S210{int id;T2 _static_value_mem;T0* _current_type;T0* _start_position;};
extern T210 M210;
struct S1163{int id;T2 _static_value_mem;T0* _current_type;T0* _to_string;T0* _start_position;T2 _rank;T0* _result_type;};
extern T1163 M1163;
struct S1324{int id;T0* _run_compound;T0* _instruction;T0* _comment;};
extern T1324 M1324;
struct S519{int id;T0* _run_compound;T0* _start_position;T0* _ifthenlist;T0* _else_compound;};
extern T519 M519;
struct S1029{int id;T0* _current_type;T0* _clients_memory;T0* _actuals_clients;T0* _name;T0* _arguments;T0* _result_type;T0* _require_assertion;T0* _routine_body;T0* _ensure_assertion;T0* _rescue_compound;T2 _use_current_state;T0* _base_feature;T0* _value;};
extern T1029 M1029;
struct S1763{int id;T1585 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T1763 M1763;
struct S969{int id;T0* _base_class;T0* _names;T0* _result_type;T0* _header_comment;T0* _local_vars;T0* _clients;T0* _arguments;T0* _obsolete_mark;T0* _require_assertion;T0* _ensure_assertion;T0* _end_comment;T0* _routine_body;T0* _rescue_compound;T2 _use_current_state;};
extern T969 M969;
struct S500{T6 _push_back_flag;T0* _path;T8 _input_stream;T2 _memory;};
extern T500 M500;
extern T673 M673;
T7*se_ms(int c,char*e);
T7*e2s(char*e);
char*s2e(T7*s);
/*
-- This file is  free  software, which  comes  along  with  SmallEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT 
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of 
-- another product.
--          Copyright (C) 1994-98 LORIA - UHP - CRIN - INRIA - FRANCE
--            Dominique COLNET and Suzanne COLLIN - colnet@loria.fr 
--                       http://www.loria.fr/SmallEiffel
--
*/

/*
  This file (boost.h) is automatically included when `run_control.boost' is
  true (ie. only for mode -boost).
*/
#define SE_BOOST 1
void se_print_run_time_stack (void);
void sigrsp(int sig);
T6 r6_ix_not(T6 C);
void r2append_in(T2 C,T0* a1);
T0* r2to_string(T2 C);
T2 r2min(T2 C,T2 a1);
T3 r2digit(T2 C);
T2 r2_px_94(T2 C,T2 a1);
T2 r2max(T2 C,T2 a1);
T3 r3to_upper(T3 C);
T6 r3is_separator(T3 C);
T3 r3to_lower(T3 C);
T6 r3same_as(T3 C,T3 a1);
T6 r3_px_6261(T3 C,T3 a1);
T6 r3_px_60(T3 C,T3 a1);
T6 r3is_letter(T3 C);
T6 r3is_digit(T3 C);
T2 r3value(T3 C);
T1512 r1512realloc(T1512 C,T2 a1,T2 a2);
void r1512set_all_with(T1512 C,T0* a1,T2 a2);
T2 r1512fast_index_of(T1512 C,T0* a1,T2 a2);
void r1512copy_from(T1512 C,T1512 a1,T2 a2);
T1608 r1608realloc(T1608 C,T2 a1,T2 a2);
void r1608set_all_with(T1608 C,T0* a1,T2 a2);
T2 r1608fast_index_of(T1608 C,T0* a1,T2 a2);
void r1608copy_from(T1608 C,T1608 a1,T2 a2);
T6 r9fast_memcmp(T9 C,T9 a1,T2 a2);
T9 r9realloc(T9 C,T2 a1,T2 a2);
T2 r9fast_index_of(T9 C,T3 a1,T2 a2);
void r9copy_from(T9 C,T9 a1,T2 a2);
T1876 r1876realloc(T1876 C,T2 a1,T2 a2);
void r1876set_all_with(T1876 C,T0* a1,T2 a2);
T2 r1876fast_index_of(T1876 C,T0* a1,T2 a2);
void r1876copy_from(T1876 C,T1876 a1,T2 a2);
T1253 r1253realloc(T1253 C,T2 a1,T2 a2);
void r1253clear_all(T1253 C,T2 a1);
void r1253set_all_with(T1253 C,T0* a1,T2 a2);
void r1253copy_from(T1253 C,T1253 a1,T2 a2);
T1421 r1421realloc(T1421 C,T2 a1,T2 a2);
void r1421copy_from(T1421 C,T1421 a1,T2 a2);
T1734 r1734realloc(T1734 C,T2 a1,T2 a2);
T6 r1734equal_like(T0* a1,T0* a2);
T2 r1734fast_index_of(T1734 C,T0* a1,T2 a2);
void r1734copy_from(T1734 C,T1734 a1,T2 a2);
T2 r1734index_of(T1734 C,T0* a1,T2 a2);
T1281 r1281realloc(T1281 C,T2 a1,T2 a2);
void r1281set_all_with(T1281 C,T0* a1,T2 a2);
T2 r1281fast_index_of(T1281 C,T0* a1,T2 a2);
void r1281copy_from(T1281 C,T1281 a1,T2 a2);
T1323 r1323realloc(T1323 C,T2 a1,T2 a2);
void r1323set_all_with(T1323 C,T0* a1,T2 a2);
void r1323copy_from(T1323 C,T1323 a1,T2 a2);
T1282 r1282realloc(T1282 C,T2 a1,T2 a2);
void r1282copy_from(T1282 C,T1282 a1,T2 a2);
T1809 r1809realloc(T1809 C,T2 a1,T2 a2);
void r1809set_all_with(T1809 C,T6 a1,T2 a2);
void r1809move(T1809 C,T2 a1,T2 a2,T2 a3);
void r1809copy_from(T1809 C,T1809 a1,T2 a2);
void r1809clear(T1809 C,T2 a1,T2 a2);
T2045 r2045realloc(T2045 C,T2 a1,T2 a2);
void r2045set_all_with(T2045 C,T2 a1,T2 a2);
T2 r2045fast_index_of(T2045 C,T2 a1,T2 a2);
void r2045copy_from(T2045 C,T2045 a1,T2 a2);
T1840 r1840realloc(T1840 C,T2 a1,T2 a2);
void r1840set_all_with(T1840 C,T0* a1,T2 a2);
void r1840copy_from(T1840 C,T1840 a1,T2 a2);
T1888 r1888realloc(T1888 C,T2 a1,T2 a2);
void r1888set_all_with(T1888 C,T0* a1,T2 a2);
T2 r1888fast_index_of(T1888 C,T0* a1,T2 a2);
void r1888copy_from(T1888 C,T1888 a1,T2 a2);
T1862 r1862realloc(T1862 C,T2 a1,T2 a2);
void r1862set_all_with(T1862 C,T0* a1,T2 a2);
T2 r1862fast_index_of(T1862 C,T0* a1,T2 a2);
void r1862copy_from(T1862 C,T1862 a1,T2 a2);
T1784 r1784realloc(T1784 C,T2 a1,T2 a2);
void r1784set_all_with(T1784 C,T0* a1,T2 a2);
void r1784move(T1784 C,T2 a1,T2 a2,T2 a3);
void r1784clear(T1784 C,T2 a1,T2 a2);
void r1784copy_from(T1784 C,T1784 a1,T2 a2);
T1776 r1776realloc(T1776 C,T2 a1,T2 a2);
void r1776copy_from(T1776 C,T1776 a1,T2 a2);
T1585 r1585realloc(T1585 C,T2 a1,T2 a2);
void r1585set_all_with(T1585 C,T0* a1,T2 a2);
void r1585copy_from(T1585 C,T1585 a1,T2 a2);
T1460 r1460realloc(T1460 C,T2 a1,T2 a2);
void r1460set_all_with(T1460 C,T0* a1,T2 a2);
void r1460copy_from(T1460 C,T1460 a1,T2 a2);
T1801 r1801realloc(T1801 C,T2 a1,T2 a2);
void r1801copy_from(T1801 C,T1801 a1,T2 a2);
T1356 r1356realloc(T1356 C,T2 a1,T2 a2);
void r1356copy_from(T1356 C,T1356 a1,T2 a2);
T1082 r1082realloc(T1082 C,T2 a1,T2 a2);
void r1082set_all_with(T1082 C,T0* a1,T2 a2);
T2 r1082fast_index_of(T1082 C,T0* a1,T2 a2);
void r1082move(T1082 C,T2 a1,T2 a2,T2 a3);
void r1082clear(T1082 C,T2 a1,T2 a2);
void r1082copy_from(T1082 C,T1082 a1,T2 a2);
T1677 r1677realloc(T1677 C,T2 a1,T2 a2);
void r1677set_all_with(T1677 C,T0* a1,T2 a2);
void r1677copy_from(T1677 C,T1677 a1,T2 a2);
T1548 r1548realloc(T1548 C,T2 a1,T2 a2);
void r1548copy_from(T1548 C,T1548 a1,T2 a2);
T1696 r1696realloc(T1696 C,T2 a1,T2 a2);
void r1696copy_from(T1696 C,T1696 a1,T2 a2);
T1697 r1697realloc(T1697 C,T2 a1,T2 a2);
void r1697copy_from(T1697 C,T1697 a1,T2 a2);
T1136 r1136realloc(T1136 C,T2 a1,T2 a2);
void r1136set_all_with(T1136 C,T0* a1,T2 a2);
T6 r1136equal_like(T0* a1,T0* a2);
T2 r1136fast_index_of(T1136 C,T0* a1,T2 a2);
void r1136copy_from(T1136 C,T1136 a1,T2 a2);
T2 r1136index_of(T1136 C,T0* a1,T2 a2);
T1987 r1987realloc(T1987 C,T2 a1,T2 a2);
void r1987copy_from(T1987 C,T1987 a1,T2 a2);
T1688 r1688realloc(T1688 C,T2 a1,T2 a2);
void r1688copy_from(T1688 C,T1688 a1,T2 a2);
T1771 r1771realloc(T1771 C,T2 a1,T2 a2);
void r1771copy_from(T1771 C,T1771 a1,T2 a2);
T1205 r1205realloc(T1205 C,T2 a1,T2 a2);
void r1205set_all_with(T1205 C,T0* a1,T2 a2);
void r1205copy_from(T1205 C,T1205 a1,T2 a2);
T1666 r1666realloc(T1666 C,T2 a1,T2 a2);
void r1666copy_from(T1666 C,T1666 a1,T2 a2);
T1304 r1304realloc(T1304 C,T2 a1,T2 a2);
void r1304set_all_with(T1304 C,T0* a1,T2 a2);
T2 r1304fast_index_of(T1304 C,T0* a1,T2 a2);
void r1304copy_from(T1304 C,T1304 a1,T2 a2);
T39 r39realloc(T39 C,T2 a1,T2 a2);
void r39set_all_with(T39 C,T0* a1,T2 a2);
void r39copy_from(T39 C,T39 a1,T2 a2);
T1967 r1967realloc(T1967 C,T2 a1,T2 a2);
void r1967copy_from(T1967 C,T1967 a1,T2 a2);
T1943 r1943realloc(T1943 C,T2 a1,T2 a2);
void r1943copy_from(T1943 C,T1943 a1,T2 a2);
T1733 r1733realloc(T1733 C,T2 a1,T2 a2);
void r1733set_all_with(T1733 C,T0* a1,T2 a2);
void r1733copy_from(T1733 C,T1733 a1,T2 a2);
T1828 r1828realloc(T1828 C,T2 a1,T2 a2);
void r1828set_all_with(T1828 C,T0* a1,T2 a2);
void r1828copy_from(T1828 C,T1828 a1,T2 a2);
T1891 r1891realloc(T1891 C,T2 a1,T2 a2);
void r1891set_all_with(T1891 C,T0* a1,T2 a2);
void r1891copy_from(T1891 C,T1891 a1,T2 a2);
T1433 r1433realloc(T1433 C,T2 a1,T2 a2);
void r1433copy_from(T1433 C,T1433 a1,T2 a2);
T6 r7has(T7* C,T3 a1);
T8 r7to_external(T7* C);
void r7to_lower(T7* C);
T3 r7last(T7* C);
T6 r7_px_60(T7* C,T0* a1);
void r7extend(T7* C,T3 a1);
void r7swap(T7* C,T2 a1,T2 a2);
void r7copy(T7* C,T0* a1);
T2 r7hash_code(T7* C);
void r7set_last(T7* C,T3 a1);
T0* r7twin(T7* C);
void r7to_upper(T7* C);
void r7remove_last(T7* C,T2 a1);
T6 r7is_equal(T7* C,T0* a1);
T6 r7has_suffix(T7* C,T0* a1);
T6 r7same_as(T7* C,T0* a1);
T2 r7index_of_string(T7* C,T0* a1);
void r7prepend(T7* C,T0* a1);
void r7add_first(T7* C,T3 a1);
T6 r7has_string(T7* C,T0* a1);
void r7make(T7* C,T2 a1);
void r7append(T7* C,T0* a1);
T2 r7index_of(T7* C,T3 a1);
void r1104add_last(T1104* C,T0* a1);
T0* r1104item(T1104* C,T2 a1);
T0* r1104first(T1104* C);
T2 r1104count(T1104* C);
T0* r1545twin(T1545* C);
void r1545add_last(T1545* C,T0* a1);
T0* r1545item(T1545* C,T2 a1);
T0* r1545first(T1545* C);
T2 r1545count(T1545* C);
void r1545make(T1545* C,T2 a1,T2 a2);
void r1545copy(T1545* C,T0* a1);
void r1683with_capacity(T1683* C,T2 a1);
void r1683add_last(T1683* C,T0* a1);
void r1467with_capacity(T1467* C,T2 a1);
void r1467add_last(T1467* C,T0* a1);
T0* r1231twin(T1231* C);
void r1231add_last(T1231* C,T0* a1);
T0* r1231item(T1231* C,T2 a1);
T0* r1231first(T1231* C);
T2 r1231count(T1231* C);
void r1231make(T1231* C,T2 a1,T2 a2);
void r1231copy(T1231* C,T0* a1);
void r1926add_last(T1926* C,T0* a1);
T0* r1926item(T1926* C,T2 a1);
T2 r1926count(T1926* C);
T0* r705twin(T705* C);
void r705add_last(T705* C,T0* a1);
T0* r705item(T705* C,T2 a1);
T2 r705count(T705* C);
void r705copy(T705* C,T0* a1);
void r1806with_capacity(T1806* C,T2 a1);
void r1806add_last(T1806* C,T2 a1);
void r1806resize(T1806* C,T2 a1);
T6 r1806fast_has(T1806* C,T2 a1);
void r1806make(T1806* C,T2 a1);
T2 r1806fast_index_of(T1806* C,T2 a1);
void r1615add_last(T1615* C,T0* a1);
void r1615make(T1615* C,T2 a1);
void r1610clear_all(T1610* C);
void r1610force(T1610* C,T0* a1,T2 a2);
T0* r1610item(T1610* C,T2 a1);
void r1610resize(T1610* C,T2 a1,T2 a2);
void r1610make(T1610* C,T2 a1,T2 a2);
T0* r1388twin(T1388* C);
void r1388add_last(T1388* C,T0* a1);
T0* r1388item(T1388* C,T2 a1);
T0* r1388first(T1388* C);
T2 r1388count(T1388* C);
void r1388make(T1388* C,T2 a1,T2 a2);
void r1388copy(T1388* C,T0* a1);
void r1280add_last(T1280* C,T0* a1);
T0* r1280item(T1280* C,T2 a1);
T2 r1280count(T1280* C);
void r1772add_last(T1772* C,T0* a1);
T0* r1772item(T1772* C,T2 a1);
T2 r1772count(T1772* C);
void r28add_last(T28* C,T0* a1);
T0* r28item(T28* C,T2 a1);
T2 r28count(T28* C);
T0* r2001twin(T2001* C);
void r2001add_last(T2001* C,T0* a1);
T0* r2001item(T2001* C,T2 a1);
T0* r2001first(T2001* C);
T2 r2001count(T2001* C);
void r2001copy(T2001* C,T0* a1);
void r1211add_last(T1211* C,T0* a1);
T0* r1211item(T1211* C,T2 a1);
T2 r1211count(T1211* C);
void r1124force(T1124* C,T0* a1,T2 a2);
void r1124add_last(T1124* C,T0* a1);
T0* r1124item(T1124* C,T2 a1);
T2 r1124count(T1124* C);
void r1124resize(T1124* C,T2 a1,T2 a2);
void r1124make(T1124* C,T2 a1,T2 a2);
void r1124swap(T1124* C,T2 a1,T2 a2);
void r1570with_capacity(T1570* C,T2 a1);
void r1570add_last(T1570* C,T0* a1);
void r1570resize(T1570* C,T2 a1);
void r1570make(T1570* C,T2 a1);
T6 r1570fast_has(T1570* C,T0* a1);
T2 r1570fast_index_of(T1570* C,T0* a1);
void r41with_capacity(T41* C,T2 a1);
void r41add_last(T41* C,T0* a1);
void r41resize(T41* C,T2 a1);
void r41make(T41* C,T2 a1);
T6 r41fast_has(T41* C,T0* a1);
T2 r41fast_index_of(T41* C,T0* a1);
void r45with_capacity(T45* C,T2 a1);
void r45add_last(T45* C,T0* a1);
void r45resize(T45* C,T2 a1);
void r45make(T45* C,T2 a1);
void r1975with_capacity(T1975* C,T2 a1);
void r1975add_last(T1975* C,T0* a1);
void r1975resize(T1975* C,T2 a1);
void r1975make(T1975* C,T2 a1);
T6 r1975fast_has(T1975* C,T0* a1);
T2 r1975fast_index_of(T1975* C,T0* a1);
T6 r1975empty(T1975* C);
void r46force(T46* C,T6 a1,T2 a2);
T6 r46item(T46* C,T2 a1);
T6 r46valid_index(T46* C,T2 a1);
void r46set_slice_with(T46* C,T6 a1,T2 a2,T2 a3);
void r46resize(T46* C,T2 a1,T2 a2);
void r46make(T46* C,T2 a1,T2 a2);
void r911add_last(T911* C,T2 a1);
T2 r911count(T911* C);
void r1333with_capacity(T1333* C,T2 a1,T2 a2);
T6 r1333has(T1333* C,T0* a1);
void r1333add_last(T1333* C,T0* a1);
T0* r1333item(T1333* C,T2 a1);
T2 r1333count(T1333* C);
void r1333clear(T1333* C);
T6 r1333empty(T1333* C);
T2 r1333index_of(T1333* C,T0* a1);
void r1751with_capacity(T1751* C,T2 a1);
void r1751add_last(T1751* C,T0* a1);
void r1751remove_last(T1751* C);
T0* r1751last(T1751* C);
T6 r1751empty(T1751* C);
void r1886with_capacity(T1886* C,T2 a1);
void r1886add_last(T1886* C,T0* a1);
void r1886resize(T1886* C,T2 a1);
T6 r1886fast_has(T1886* C,T0* a1);
void r1886make(T1886* C,T2 a1);
T2 r1886fast_index_of(T1886* C,T0* a1);
T6 r931has(T931* C,T0* a1);
void r931add_last(T931* C,T0* a1);
T0* r931item(T931* C,T2 a1);
T2 r931count(T931* C);
T6 r931fast_has(T931* C,T0* a1);
void r931make(T931* C,T2 a1,T2 a2);
T2 r931fast_index_of(T931* C,T0* a1);
void r931clear(T931* C);
T2 r931index_of(T931* C,T0* a1);
void r874add_last(T874* C,T0* a1);
T0* r874item(T874* C,T2 a1);
T0* r874first(T874* C);
T2 r874count(T874* C);
T0* r701twin(T701* C);
void r701add_last(T701* C,T0* a1);
T0* r701item(T701* C,T2 a1);
T2 r701count(T701* C);
void r701copy(T701* C,T0* a1);
T0* r742twin(T742* C);
void r742add_last(T742* C,T0* a1);
T0* r742item(T742* C,T2 a1);
T2 r742count(T742* C);
void r742copy(T742* C,T0* a1);
void r1244add_last(T1244* C,T0* a1);
T0* r1244item(T1244* C,T2 a1);
T0* r1244first(T1244* C);
T2 r1244count(T1244* C);
T6 r1244fast_has(T1244* C,T0* a1);
void r1244make(T1244* C,T2 a1,T2 a2);
T2 r1244fast_index_of(T1244* C,T0* a1);
void r1244clear(T1244* C);
T6 r1244empty(T1244* C);
void r1277with_capacity(T1277* C,T2 a1,T2 a2);
void r1277add_last(T1277* C,T0* a1);
T0* r1277item(T1277* C,T2 a1);
T0* r1277first(T1277* C);
T2 r1277count(T1277* C);
T6 r1277fast_has(T1277* C,T0* a1);
T2 r1277fast_index_of(T1277* C,T0* a1);
void r1277copy(T1277* C,T0* a1);
T6 r1277empty(T1277* C);
void r36add_last(T36* C,T0* a1);
T0* r36item(T36* C,T2 a1);
T2 r36count(T36* C);
T0* r1461twin(T1461* C);
void r1461add_last(T1461* C,T0* a1);
T0* r1461item(T1461* C,T2 a1);
T2 r1461count(T1461* C);
T6 r1461fast_has(T1461* C,T0* a1);
void r1461make(T1461* C,T2 a1,T2 a2);
T2 r1461fast_index_of(T1461* C,T0* a1);
void r1461clear(T1461* C);
void r1461copy(T1461* C,T0* a1);
T6 r1461empty(T1461* C);
T0* r20twin(T20* C);
void r20add_last(T20* C,T0* a1);
T0* r20item(T20* C,T2 a1);
T2 r20count(T20* C);
void r20copy(T20* C,T0* a1);
void r38resize(T38* C,T2 a1);
void r38make(T38* C,T2 a1);
void r1546with_capacity(T1546* C,T2 a1);
void r1546add_last(T1546* C,T0* a1);
T0* r1546item(T1546* C,T2 a1);
void r2020clear_all(T2020* C);
T2 r2020count(T2020* C);
void r2020resize(T2020* C,T2 a1);
void r2020make(T2020* C,T2 a1);
void r2040resize(T2040* C,T2 a1);
void r2040make(T2040* C,T2 a1);
void r33add_last(T33* C,T0* a1);
T2 r33count(T33* C);
T0* r1409twin(T1409* C);
void r1409add_last(T1409* C,T0* a1);
T0* r1409item(T1409* C,T2 a1);
T0* r1409first(T1409* C);
T2 r1409count(T1409* C);
void r1409make(T1409* C,T2 a1,T2 a2);
void r1409clear(T1409* C);
void r1409copy(T1409* C,T0* a1);
void r1341with_capacity(T1341* C,T2 a1);
void r1341add_last(T1341* C,T0* a1);
void r1341resize(T1341* C,T2 a1);
void r1341make(T1341* C,T2 a1);
T2 r1341fast_index_of(T1341* C,T0* a1);
void r2011with_capacity(T2011* C,T2 a1);
T0* r2011twin(T2011* C);
void r2011add_last(T2011* C,T0* a1);
void r2011resize(T2011* C,T2 a1);
void r2011make(T2011* C,T2 a1);
void r2011copy(T2011* C,T0* a1);
T6 r2011empty(T2011* C);
void r1794with_capacity(T1794* C,T2 a1);
void r1794clear_all(T1794* C);
void r1794add_last(T1794* C,T0* a1);
T0* r1794item(T1794* C,T2 a1);
T2 r1794count(T1794* C);
void r1794resize(T1794* C,T2 a1);
T6 r1794fast_has(T1794* C,T0* a1);
void r1794make(T1794* C,T2 a1);
T2 r1794fast_index_of(T1794* C,T0* a1);
void r34resize(T34* C,T2 a1);
void r34make(T34* C,T2 a1);
void r1139with_capacity(T1139* C,T2 a1,T2 a2);
void r1139add_last(T1139* C,T0* a1);
T0* r1139item(T1139* C,T2 a1);
T0* r1139first(T1139* C);
T2 r1139count(T1139* C);
T6 r1139fast_has(T1139* C,T0* a1);
void r1139make(T1139* C,T2 a1,T2 a2);
T2 r1139fast_index_of(T1139* C,T0* a1);
void r1139clear(T1139* C);
T0* r1746twin(T1746* C);
void r1746add_last(T1746* C,T0* a1);
T0* r1746item(T1746* C,T2 a1);
T0* r1746first(T1746* C);
T2 r1746count(T1746* C);
void r1746copy(T1746* C,T0* a1);
T0* r1098twin(T1098* C);
void r1098add_last(T1098* C,T0* a1);
T0* r1098item(T1098* C,T2 a1);
T2 r1098count(T1098* C);
void r1098copy(T1098* C,T0* a1);
void r35resize(T35* C,T2 a1);
void r35make(T35* C,T2 a1);
void r1457with_capacity(T1457* C,T2 a1);
void r1457add_last(T1457* C,T0* a1);
T6 r1457fast_has(T1457* C,T0* a1);
T2 r1457fast_index_of(T1457* C,T0* a1);
T0* r1763twin(T1763* C);
void r1763add_last(T1763* C,T0* a1);
T0* r1763item(T1763* C,T2 a1);
T0* r1763first(T1763* C);
T2 r1763count(T1763* C);
void r1763make(T1763* C,T2 a1,T2 a2);
void r1763copy(T1763* C,T0* a1);
void r1540with_capacity(T1540* C,T2 a1);
T6 r1540has(T1540* C,T0* a1);
void r1540expand(T1540* C);
void r1540resize_buckets(T1540* C,T2 a1);
T0* r1540at(T1540* C,T0* a1);
void r1540put(T1540* C,T0* a1,T0* a2);
void r13with_capacity(T13* C,T2 a1);
T6 r13has(T13* C,T0* a1);
void r13expand(T13* C);
void r13resize_buckets(T13* C,T2 a1);
T0* r13at(T13* C,T0* a1);
void r13put(T13* C,T0* a1,T0* a2);
void r1220with_capacity(T1220* C,T2 a1);
T6 r1220has(T1220* C,T0* a1);
void r1220expand(T1220* C);
void r1220resize_buckets(T1220* C,T2 a1);
T0* r1220item(T1220* C,T2 a1);
void r1220set_cache_user_idx(T1220* C,T2 a1);
T0* r1220at(T1220* C,T0* a1);
void r1220put(T1220* C,T0* a1,T0* a2);
void r1916with_capacity(T1916* C,T2 a1);
T6 r1916has(T1916* C,T0* a1);
void r1916expand(T1916* C);
void r1916resize_buckets(T1916* C,T2 a1);
T0* r1916at(T1916* C,T0* a1);
void r1916put(T1916* C,T0* a1,T0* a2);
void r1175with_capacity(T1175* C,T2 a1);
T6 r1175has(T1175* C,T0* a1);
void r1175expand(T1175* C);
void r1175resize_buckets(T1175* C,T2 a1);
void r1175put(T1175* C,T0* a1,T0* a2);
void r37with_capacity(T37* C,T2 a1);
T6 r37has(T37* C,T0* a1);
void r37expand(T37* C);
void r37resize_buckets(T37* C,T2 a1);
T0* r37item(T37* C,T2 a1);
void r37set_cache_user_idx(T37* C,T2 a1);
T0* r37at(T37* C,T0* a1);
void r37put(T37* C,T0* a1,T0* a2);
void r1815with_capacity(T1815* C,T2 a1);
T6 r1815has(T1815* C,T0* a1);
void r1815expand(T1815* C);
void r1815resize_buckets(T1815* C,T2 a1);
T0* r1815item(T1815* C,T2 a1);
void r1815set_cache_user_idx(T1815* C,T2 a1);
T0* r1815at(T1815* C,T0* a1);
void r1815put(T1815* C,T0* a1,T0* a2);
extern T0*oBC266code_attribute;
T0* r945add_comment(T945* C,T0* a1);
T2 r945to_integer(T945* C);
extern T0*oBC266eh;
T0* r945to_runnable(T945* C,T0* a1);
T2 r945compile_to_jvm_into(T945* C,T0* a1);
extern T0*oBC266constant_pool;
void r945compile_to_jvm(T945* C);
T0* r945twin(T945* C);
void r945compile_target_to_jvm(T945* C);
T6 r945is_a(T945* C,T0* a1);
void r945error(T0* a1,T0* a2);
void r945make(T945* C,T0* a1,T0* a2);
T2 r945standard_compile_to_jvm_into(T945* C,T0* a1);
extern T0*oBC266unique_string;
void r218make(T218* C,T0* a1,T0* a2);
void r435undefine_in(T435* C,T0* a1);
T0* r435origin_base_class(T435* C);
void r435error(T0* a1,T0* a2);
void r435make(T435* C,T0* a1,T0* a2);
T6 r429use_current(T429* C);
extern T0*oBC1307points_false;
void r429add_into(T429* C,T0* a1);
void r429make(T429* C,T0* a1,T0* a2,T0* a3);
void r429from_runnable(T429* C,T0* a1);
void r429compile_to_jvm_old(T429* C);
void r429compile_to_jvm(T429* C,T6 a1);
void r429afd_check(T429* C);
extern T0*oBC266run_control;
T0* r196add_comment(T196* C,T0* a1);
T6 r196use_current(T196* C);
T0* r196to_runnable(T196* C,T0* a1);
T0* r196current_type(T196* C);
void r196make(T196* C,T0* a1,T0* a2,T0* a3);
void r196compile_to_jvm(T196* C);
void r196afd_check(T196* C);
T0* r1190start_position(T1190* C);
T6 r1190is_merge_with(T1190* C,T0* a1,T0* a2);
void r1190make_e_feature(T1190* C,T0* a1,T0* a2);
void r1190add_into(T1190* C,T0* a1);
T6 r1190can_hide(T1190* C,T0* a1,T0* a2);
T0* r1190try_to_undefine(T1190* C,T0* a1,T0* a2);
extern T0*oBC461assertion_collector;
T0* r1190to_run_feature(T1190* C,T0* a1,T0* a2);
extern T0*oBC461header_comment_memory;
extern T0*oBC461require_collector;
T0* r1190try_to_undefine_aux(T1190* C,T0* a1,T0* a2);
void r1190error(T0* a1,T0* a2);
void r1190make(T1190* C,T0* a1,T0* a2,T0* a3);
void r1190collect_for(T2 a1);
T0* r1065for_infix(T0* a1);
extern T0*oBC1065memory;
T0* r1065read(T0* a1);
T0* r1065item(T0* a1);
extern int fBC1065initialize;
void r1065initialize(void);
extern T0*oBC1065pfx_ifx;
T0* r1065for_prefix(T0* a1);
void r1065key_pfx_ifx(T0* a1);
void r1065add2(T0* a1);
extern T0*oBC266eiffel_parser;
T0* r898a_alias(T898* C);
T6 r898a_type_formal_generic(T898* C);
T6 r898end_of_input(T898* C);
void r898err_exp(T0* a1,T0* a2);
T6 r898a_rename_pair(T898* C);
void r898a_function_call(T898* C);
T6 r898a_real_constant(T898* C);
T6 r898a_assignment_or_call(T898* C);
T6 r898a_strip(T898* C);
void r898a_redefine_list(T898* C);
extern T0*oBC898faof;
void r898disconnect(T898* C);
void r898a_indexing(T898* C);
T0* r898a_actuals(T898* C);
T0* r898a_clients(T898* C);
extern T0*oBC266echo;
extern T0*oBC898tmp_name;
void r898a_feature_clause(T898* C);
T6 r898a_integer(T898* C);
T0* r898current_position(T898* C);
extern T0*oBC898forbidden_class;
T6 r898a_manifest_string(T898* C);
void r898a_class_declaration(T898* C);
void r898a_after_a_dot(T898* C,T6 a1,T0* a2);
T6 r898a_actual(T898* C);
void r898a_undefine_list(T898* C);
T6 r898a_infix(T898* C);
extern T0*oBC266parser_buffer;
void r898a_parent_list(T898* C,T0* a1,T0* a2);
void r898a_select_list(T898* C);
void r898prev_char(T898* C);
T6 r898a_current(T898* C);
T6 r898a_inspect(T898* C);
void r898a_rename_list(T898* C);
void r898next_char(T898* C);
T6 r898a_unary(T898* C);
T0* r898analyse_class(T898* C,T0* a1);
void r898skip_comments(T898* C);
T6 r898a_local_variable(T898* C);
T6 r898a_retry(T898* C);
T6 r898a_e10(T898* C);
T6 r898a_conditional(T898* C);
void r898a_r10(T898* C,T6 a1,T0* a2,T0* a3,T0* a4);
extern T0*oBC898tmp_string;
T6 r898a_tag_mark(T898* C);
void r898a_base_class_name1(T898* C);
T6 r898a_keyword(T898* C,T0* a1);
T6 r898a_feature_list(T898* C);
extern T0*oBC266small_eiffel;
T0* r898a_routine_body(T898* C);
T6 r898a_void(T898* C);
T6 r898a_class_type(T898* C);
T0* r898a_assertion(T898* C);
T6 r898a_feature_name(T898* C);
T6 r898a_feature_declaration(T898* C);
void r898a_ascii_code(T898* C);
T0* r898to_proc_call(T898* C,T0* a1,T0* a2,T0* a3);
T6 r898a_index_value(T898* C);
T6 r898a_expression(T898* C);
T6 r898a_type(T898* C);
T0* r898a_routine(T898* C);
T6 r898a_creation(T898* C);
T6 r898a_real(T898* C);
void r898a_assignment_aux(T898* C,T6 a1);
T0* r898a_external(T898* C);
T6 r898a_debug(T898* C);
T6 r898a_parent(T898* C);
T6 r898a_bit_constant(T898* C);
void r898a_formal_generic_list(T898* C);
T6 r898skip1unless2(T898* C,T3 a1,T3 a2);
void r898fcp(T898* C,T0* a1);
T0* r898a_compound1(T898* C);
T6 r898a_result(T898* C);
T6 r898skip1(T898* C,T3 a1);
extern T0*oBC898lcs;
T6 r898skip2(T898* C,T3 a1,T3 a2);
T6 r898a_boolean_constant(T898* C);
T6 r898a_index_clause(T898* C);
T6 r898a_instruction(T898* C);
void r898wcpefnc(T898* C,T0* a1,T0* a2);
T6 r898a_base_type(T898* C);
void r898a_procedure_call(T898* C);
T0* r898pos(T2 a1,T2 a2);
void r898show_nb(T2 a1,T0* a2);
T0* r898connect_to_cecil(T898* C);
T6 r898a_identifier(T898* C);
T0* r898a_compound2(T898* C,T0* a1,T0* a2);
T6 r898a_loop(T898* C);
T6 r898a_base_class_name(T898* C);
T6 r898a_manifest_constant(T898* C);
T6 r898a_identifier1(T898* C);
void r898a_formal_arg_list(T898* C);
T6 r898a_check(T898* C);
T6 r898a_binary(T898* C,T0* a1);
void r898a_new_export_list(T898* C);
void r898a_creation_clause(T898* C,T0* a1);
T6 r898a_integer_constant(T898* C);
T6 r898a_prefix(T898* C);
T0* r898parse_c_name(T898* C);
T0* r898parse_feature_name(T898* C);
void r898a_local_var_list(T898* C,T0* a1);
T6 r898a_character_constant(T898* C);
T6 r898a_free_operator(T898* C);
void r898a_then_part_list(T898* C,T0* a1);
void r898warning(T0* a1,T0* a2);
T6 r898a_identifier2(T898* C);
void r898error(T0* a1,T0* a2);
T0* r898to_call(T0* a1,T0* a2,T0* a3);
extern T0*oBC898tmp_feature;
T6 r898a_e0(T898* C);
T0* r898get_comments(T898* C);
T6 r898a_e1(T898* C);
T6 r898a_e2(T898* C);
T6 r898a_then_part(T898* C,T0* a1);
T6 r898a_e3(T898* C);
T6 r898a_e4(T898* C);
T6 r898a_e5(T898* C);
T6 r898a_e6(T898* C);
void r898go_back_at(T898* C,T2 a1,T2 a2);
T6 r898a_e7(T898* C);
T6 r898a_e8(T898* C);
T0* r898parse_run_type(T898* C);
T6 r898a_e9(T898* C);
T6 r898a_when_part(T898* C,T0* a1);
T6 r898a_argument(T898* C);
void r898a_r1(T898* C,T0* a1);
void r898a_index_list(T898* C);
void r898a_r2(T898* C,T0* a1);
void r898a_r3(T898* C,T0* a1);
void r898a_r4(T898* C,T0* a1);
void r898a_r5(T898* C,T0* a1);
void r898a_r6(T898* C,T0* a1);
void r898a_r7(T898* C,T0* a1);
void r898a_r8(T898* C,T0* a1);
T6 r898a_constant(T898* C);
T0* r653start_position(T653* C);
T0* r653add_comment(T653* C,T0* a1);
T0* r653right_type(T653* C);
T6 r653use_current(T653* C);
T0* r653to_runnable(T653* C,T0* a1);
void r653warning(T0* a1,T0* a2);
T0* r653current_type(T653* C);
T6 r653is_pre_computable(T653* C);
T0* r653left_type(T653* C);
void r653error(T0* a1,T0* a2);
void r653make(T653* C,T0* a1,T0* a2);
void r653compile_to_jvm(T653* C);
void r653afd_check(T653* C);
void r87b_put_byte_string(T87* C,T0* a1);
T2 r87push_ith_argument(T87* C,T2 a1);
void r87incr_static_expression_count(T87* C);
T2 r87argument_offset_of(T87* C,T0* a1);
T2 r87max_locals(T87* C);
extern int fBC266small_eiffel_directory;
extern T0*oBC266small_eiffel_directory;
T0* r87small_eiffel_directory(T87* C);
void r87drop_target(T87* C);
extern T0*oBC883stack_args;
void r87opcode_check_id_for(T0* a1);
T2 r87result_offset(T87* C);
void r87push_expanded_initialize(T87* C,T0* a1);
void r87finish_class(T87* C);
void r87add_runtime_copy(T87* C);
void r87push_check(T87* C,T0* a1);
void r87inside_twin(T87* C,T0* a1);
extern T0*oBC87out_file;
void r87write_main_class(T87* C,T0* a1);
void r87add_directory(T87* C,T0* a1,T0* a2);
extern T0*oBC883stack_rf;
extern T0*oBC266manifest_string_pool;
extern int fBC266system_name;
extern T0*oBC266system_name;
T0* r87system_name(T87* C);
void r87push_target(T87* C);
void r87push_direct(T87* C,T0* a1);
extern T0*oBC87out_file_path;
extern T0*oBC266tmp_file_read;
extern T0*oBC883stack_code;
T2 r87idx_bad_target(T0* a1);
extern T0*oBC266jvm;
extern T0*oBC883stack_target;
void r87pop(T87* C);
T0* r87get_environment_variable(T87* C,T0* a1);
extern T0*oBC266field_info;
void r87stack_overflow(T87* C);
void r87push_switch(T87* C,T0* a1,T0* a2);
T2 r87local_offset_of(T87* C,T0* a1);
void r87set_output_name(T87* C,T0* a1);
extern T0*oBC266once_routine_pool;
extern T0*oBC87methods;
T2 r87args_field_idx(void);
extern T0*oBC266method_info;
void r87prepare_methods(T87* C);
extern T0*oBC266tmp_path;
extern int fBC266jvm_root_class;
extern T0*oBC266jvm_root_class;
T0* r87jvm_root_class(void);
void r87add_field(T0* a1);
T2 r87push_arguments(T87* C);
extern T0*oBC87fields;
void r87mkdir(T87* C,T0* a1);
extern T0*oBC883stack_static_rf;
extern T0*oBC266system_list;
void r87define_class_invariant_method(T87* C,T0* a1);
void r87start_directory(T87* C,T0* a1,T0* a2);
void r87inside_new(T87* C,T0* a1,T0* a2);
void r87stack_push(T87* C,T2 a1);
extern T0*oBC87tmp_string;
void r87add_method(T0* a1);
void r87write_jvm_root_class(T87* C);
void r87drop_ith_argument(T87* C,T2 a1);
T2 r87idx_void_target(T0* a1);
void r87start_basic(T87* C);
extern T673 oBC1file_tools;
void r87bfw_connect(T87* C,T0* a1,T0* a2);
void r87b_put_u1(T87* C,T3 a1);
void r87push_se_argv(T87* C);
void r87push_target_as_target(T87* C);
extern T0*oBC883stack_cpc;
void r87start_new_class(T87* C,T0* a1);
T0* r87target_position(T87* C);
void r87b_put_cpc(T87* C,T0* a1);
void r87b_put_u2(T87* C,T2 a1);
extern T1492 oBC266switch_collection;
void r757make(T757* C,T0* a1,T0* a2);
void r757make_all(T757* C,T0* a1);
T6 r757affect(T757* C,T0* a1);
T6 r504is_used(T0* a1);
void r504add_class(T504* C,T0* a1);
void r504get_started(T504* C,T0* a1,T0* a2);
T0* r504small_eiffel_directory(T504* C);
T0* r504run_class(T0* a1);
void r504afd_check_deferred(T0* a1);
extern int fBC504rename_dictionary;
extern T0*oBC504rename_dictionary;
T0* r504rename_dictionary(T504* C);
T6 r504parser_buffer_for(T504* C,T0* a1);
extern T0*oBC504rf9_memory;
void r504warning(T0* a1,T0* a2);
T0* r504top_rf(T504* C);
void r504add_directory(T504* C,T0* a1,T0* a2);
extern T0*oBC504stack_rf;
extern T0*oBC504base_class_dictionary;
extern int fBC504tmp_class_name;
extern T0*oBC504tmp_class_name;
T0* r504tmp_class_name(void);
T0* r504base_class(T504* C,T0* a1);
T0* r504system_name(T504* C);
T0* r504load_class(T504* C,T0* a1);
T0* r504get_class(T0* a1);
void r504pop(T504* C);
T0* r504get_environment_variable(T504* C,T0* a1);
extern T0*oBC504run_class_dictionary;
extern T0*oBC504parser_buffer_path;
void r504compile_to_jvm(T504* C,T0* a1,T0* a2);
extern T0*oBC504tmp_tail;
extern int fBC504loading_path;
extern T0*oBC504loading_path;
T0* r504loading_path(T504* C);
void r504incr_magic_count(T504* C);
void r504push(T504* C,T0* a1);
extern T0*oBC266cecil_pool;
void r504append_loading_path_in(T504* C,T0* a1);
void r29append_in(T29* C,T0* a1);
T2 r29count(T29* C);
void r29make(T29* C,T0* a1,T0* a2);
T6 r499use_current(T499* C);
void r499make(T499* C,T0* a1,T0* a2,T0* a3);
void r499from_runnable(T499* C,T0* a1);
void r499compile_to_jvm(T499* C,T6 a1);
void r499afd_check(T499* C);
T0* r1093add_comment(T1093* C,T0* a1);
T6 r1093use_current(T1093* C);
void r1093check_created_type(T1093* C,T0* a1);
T0* r1093to_runnable(T1093* C,T0* a1);
void r1093warning(T0* a1,T0* a2);
T0* r1093current_type(T1093* C);
T6 r1093is_pre_computable(T1093* C);
void r1093error(T0* a1,T0* a2);
void r1093make(T1093* C,T0* a1,T0* a2,T0* a3);
void r1093check_explicit_type(T1093* C);
void r1093check_writable(T1093* C,T0* a1);
void r1093check_creation_clause(T1093* C,T0* a1);
void r1093compile_to_jvm(T1093* C);
T6 r1256is_static(T1256* C);
T0* r1256add_comment(T1256* C,T0* a1);
T2 r1256to_integer(T1256* C);
T6 r1256use_current(T1256* C);
T0* r1256to_runnable(T1256* C,T0* a1);
T2 r1256compile_to_jvm_into(T1256* C,T0* a1);
void r1256cpc_to_runnable(T1256* C,T0* a1);
void r1256standard_compile_target_to_jvm(T1256* C);
void r1256compile_to_jvm_old(T1256* C);
T0* r1256twin(T1256* C);
void r1256to_runnable_0(T1256* C,T0* a1);
T2 r1256jvm_standard_branch_if_false(T1256* C);
T6 r1256is_a(T1256* C,T0* a1);
void r1256error(T0* a1,T0* a2);
void r1256make(T1256* C,T0* a1,T0* a2,T0* a3);
T2 r1256standard_compile_to_jvm_into(T1256* C,T0* a1);
void r1256make_call_1(T1256* C,T0* a1,T0* a2,T0* a3);
T0* r1256operator(void);
T2 r1256jvm_standard_branch_if_true(T1256* C);
void r1256afd_check(T1256* C);
void r578add_init(T578* C,T0* a1);
void r578write_bytes(T578* C);
void r578append_u2(T0* a1,T2 a2);
void r578finish(T578* C);
void r578clear(T578* C);
void r578start(T578* C,T2 a1,T0* a2,T0* a3);
extern T0*oBC578storage;
T6 r1543is_static(T1543* C);
T0* r1543add_comment(T1543* C,T0* a1);
T0* r1543to_runnable(T1543* C,T0* a1);
T2 r1543compile_to_jvm_into(T1543* C,T0* a1);
extern int fBC1543result_type;
extern T0*oBC1543result_type;
T0* r1543result_type(void);
void r1543unary_minus(T1543* C);
T0* r1543twin(T1543* C);
T0* r1543to_real_constant(T1543* C);
T2 r1543isa_dca_inline_argument(T1543* C);
T6 r1543is_a(T1543* C,T0* a1);
void r1543error(T0* a1,T0* a2);
void r1543make(T1543* C,T2 a1,T0* a2);
T2 r1543standard_compile_to_jvm_into(T1543* C,T0* a1);
void r935jvm_initialize_local(T2 a1);
extern int fBC935used_as_reference;
void r935used_as_reference(void);
T0* r935to_runnable(T935* C,T0* a1);
T0* r935run_class(T935* C);
T0* r935smallest_ancestor(T935* C,T0* a1);
T0* r935run_time_mark(void);
extern int fBC266type_pointer_ref;
extern T0*oBC266type_pointer_ref;
T0* r935type_pointer_ref(void);
T6 r935is_a(T935* C,T0* a1);
T0* r935written_mark(void);
void r935error(T0* a1,T0* a2);
void r935make(T935* C,T0* a1);
T2 r935jvm_convert_to(T0* a1);
void r935fatal_error_generic_list(T935* C);
T2 r935jvm_push_default(void);
T0* r935generic_list(T935* C);
T0* r935base_class(T935* C);
T6 r935is_a_in(T935* C,T0* a1,T0* a2);
T0* r935look_up_for(T935* C,T0* a1,T0* a2);
T6 r935has_creation(T935* C,T0* a1);
void r935load_ref(T0* a1);
extern int fBC935check_type;
void r935check_type(T935* C);
T2 r935jvm_stack_space(void);
void r763jvm_initialize_local(T2 a1);
extern int fBC763used_as_reference;
void r763used_as_reference(void);
T0* r763to_runnable(T763* C,T0* a1);
T0* r763run_class(T763* C);
T0* r763smallest_ancestor(T763* C,T0* a1);
T0* r763run_time_mark(void);
extern int fBC266type_integer_ref;
extern T0*oBC266type_integer_ref;
T0* r763type_integer_ref(void);
T6 r763is_a(T763* C,T0* a1);
T0* r763written_mark(void);
void r763error(T0* a1,T0* a2);
void r763make(T763* C,T0* a1);
T2 r763jvm_convert_to(T0* a1);
void r763fatal_error_generic_list(T763* C);
T2 r763jvm_push_default(void);
T0* r763generic_list(T763* C);
T0* r763base_class(T763* C);
T6 r763is_a_in(T763* C,T0* a1,T0* a2);
T0* r763look_up_for(T763* C,T0* a1,T0* a2);
T6 r763has_creation(T763* C,T0* a1);
void r763load_ref(T0* a1);
extern int fBC763check_type;
void r763check_type(T763* C);
T2 r763jvm_stack_space(void);
void r612jvm_initialize_local(T612* C,T2 a1);
void r612used_as_reference(T612* C);
T2 r612id(T612* C);
T0* r612to_runnable(T612* C,T0* a1);
void r612set_run_time_mark(T612* C);
T0* r612run_class(T612* C);
void r612jvm_write_local(T2 a1);
T0* r612smallest_ancestor(T612* C,T0* a1);
T2 r612jvm_if_x_eq(void);
T6 r612is_a(T612* C,T0* a1);
T2 r612jvm_convert_to(T612* C,T0* a1);
void r612make(T612* C,T0* a1,T0* a2);
void r612fatal_error_generic_list(T612* C);
T2 r612jvm_push_default(T612* C);
extern T0*oBC128tmp_string;
void r612to_runnable_1_2(T612* C);
T0* r612generic_list(T612* C);
T0* r612base_class(T612* C);
T2 r612jvm_if_x_ne(void);
extern int fBC342base_class_name;
extern T0*oBC342base_class_name;
T0* r612base_class_name(void);
T6 r612is_a_in(T612* C,T0* a1,T0* a2);
T0* r612look_up_for(T612* C,T0* a1,T0* a2);
void r612jvm_to_reference(T612* C);
extern T0*oBC342mem_ref_nb;
extern T0*oBC342mem_type_bit_ref;
T2 r612jvm_stack_space(void);
extern T0*oBC26tmp_class;
T2 r25idx_methodref(T0* a1);
void r25jvm_mapping_function(T0* a1,T0* a2,T0* a3);
extern T0*oBC26tmp_descriptor;
extern T0*oBC26tmp_name;
void r1485jvm_initialize_local(T1485* C,T2 a1);
void r1485used_as_reference(T1485* C);
T6 r1485is_user_expanded(T1485* C);
T2 r1485id(T1485* C);
void r1485jvm_check_class_invariant(T1485* C);
T6 r1485is_pointer(T1485* C);
T0* r1485formal_arg(T1485* C);
T0* r1485to_runnable(T1485* C,T0* a1);
T0* r1485run_class(T1485* C);
T0* r1485formal_generic_list(T1485* C);
T0* r1485make_runnable(T1485* C,T0* a1);
T6 r1485is_bit(T1485* C);
void r1485jvm_write_local(T1485* C,T2 a1);
T0* r1485smallest_ancestor(T1485* C,T0* a1);
T0* r1485run_time_mark(T1485* C);
T6 r1485is_expanded(T1485* C);
T2 r1485jvm_if_x_eq(T1485* C);
void r1485jvm_xnewarray(T1485* C);
void r1485warning(T0* a1,T0* a2);
void r1485jvm_push_local(T1485* C,T2 a1);
T6 r1485is_a(T1485* C,T0* a1);
T6 r1485is_character(T1485* C);
void r1485error(T0* a1,T0* a2);
void r1485make(T1485* C,T0* a1,T2 a2);
T2 r1485jvm_convert_to(T1485* C,T0* a1);
void r1485fatal_error_generic_list(T1485* C);
T6 r1485is_array(T1485* C);
T2 r1485jvm_push_default(T1485* C);
T6 r1485is_dummy_expanded(T1485* C);
T0* r1485generic_list(T1485* C);
T0* r1485base_class(T1485* C);
T2 r1485jvm_if_x_ne(T1485* C);
T0* r1485base_class_name(T1485* C);
T6 r1485is_a_in(T1485* C,T0* a1,T0* a2);
T0* r1485look_up_for(T1485* C,T0* a1,T0* a2);
void r1485jvm_to_reference(T1485* C);
T6 r1485has_creation(T1485* C,T0* a1);
T0* r1485expanded_initializer(T1485* C);
T2 r1485jvm_method_flags(T1485* C);
T6 r1485is_boolean(T1485* C);
T6 r1485is_generic(T1485* C);
void r1485jvm_xaload(T1485* C);
T6 r1485is_real(T1485* C);
T6 r1485is_any(T1485* C);
T0* r1485twin(T1485* C);
T6 r1485is_basic_eiffel_expanded(T1485* C);
void r1485jvm_descriptor_in(T1485* C,T0* a1);
T6 r1485is_string(T1485* C);
T6 r1485is_integer(T1485* C);
T6 r1485is_reference(T1485* C);
T6 r1485is_none(T1485* C);
void r1485jvm_target_descriptor_in(T1485* C,T0* a1);
void r1485jvm_return_code(T1485* C);
T0* r1485constraint(T1485* C);
void r1485jvm_xastore(T1485* C);
T2 r1485jvm_stack_space(T1485* C);
T6 r1485is_double(T1485* C);
T0* r1379add_comment(T1379* C,T0* a1);
T2 r1379to_integer(T1379* C);
T2 r1379fieldref_idx(T1379* C);
T0* r1379to_runnable(T1379* C,T0* a1);
T2 r1379compile_to_jvm_into(T1379* C,T0* a1);
void r1379break_line(T1379* C);
void r1379compile_to_jvm(T1379* C);
void r1379from_manifest_string(T1379* C,T0* a1,T2 a2);
T0* r1379twin(T1379* C);
void r1379compile_target_to_jvm(T1379* C);
T6 r1379is_a(T1379* C,T0* a1);
void r1379error(T0* a1,T0* a2);
void r1379make(T1379* C,T0* a1,T2 a2);
void r1379add_percent(T1379* C,T3 a1);
void r1379add_ascii(T1379* C,T3 a1);
extern int fBC266type_string;
extern T0*oBC266type_string;
T0* r1379type_string(void);
T0* r1184jvm_root_class(void);
void r1184runnable_from_current(T1184* C,T0* a1,T0* a2);
T0* r1184type(T1184* C,T2 a1);
T6 r1184is_a_in(T1184* C,T0* a1,T0* a2);
void r1184add_last(T1184* C,T0* a1);
T2 r1184rank_of(T1184* C,T0* a1);
void r1184jvm_descriptor_in(T1184* C,T0* a1);
T0* r1184to_runnable(T1184* C,T0* a1);
T2 r1184jvm_switch_push_ith(T1184* C,T0* a1,T2 a2);
T2 r1184jvm_offset_of(T1184* C,T0* a1);
void r1184error(T0* a1,T0* a2);
void r1184make(T1184* C,T0* a1,T0* a2);
void r1184standard_make(T1184* C,T0* a1,T0* a2);
T2 r1184jvm_stack_space(T1184* C);
extern int fBC266jvm_root_descriptor;
extern T0*oBC266jvm_root_descriptor;
T0* r1184jvm_root_descriptor(void);
T2 r1184jvm_switch_push(T1184* C,T0* a1);
T0* r1042jvm_root_class(void);
void r1042fall_down(T1042* C);
T6 r1042use_current(T1042* C);
void r1042mapping_jvm(T1042* C);
extern T0*oBC691tmp_jvm_descriptor;
T0* r1042run_class(T1042* C);
T2 r1042jvm_local_variable_offset(T1042* C,T0* a1);
T2 r1042arg_count(T1042* C);
T0* r1042jvm_root_descriptor(void);
T6 r1042is_exported_in(T1042* C,T0* a1);
T2 r1042jvm_argument_offset(T1042* C,T0* a1);
void r1042initialize(T1042* C);
void r1042update_tmp_jvm_descriptor(T1042* C);
T2 r1042jvm_max_locals(T1042* C);
void r1042add_client(T1042* C,T0* a1);
void r1042make(T1042* C,T0* a1,T0* a2,T0* a3);
void r1042jvm_define(T1042* C);
T2 r1042jvm_result_offset(T1042* C);
void r1042afd_check(T1042* C);
T0* r1042clients(T1042* C);
T0* r1042jvm_descriptor(T1042* C);
T0* r1501feature_name(T1501* C,T0* a1);
T6 r1501has(T1501* C,T0* a1);
void r1501make(T1501* C,T0* a1);
T2 r1501index_of(T1501* C,T0* a1);
void r1285add_into(T1285* C,T0* a1);
void r1285make(T1285* C,T0* a1,T0* a2,T0* a3);
void r1285from_runnable(T1285* C,T0* a1);
void r1285compile_to_jvm(T1285* C,T6 a1);
void r1285afd_check(T1285* C);
T6 r1198gives_permission_to_any(T1198* C);
void r1198merge(T1198* C,T0* a1,T0* a2);
void r1198warning(T0* a1,T0* a2);
T6 r1198gives_permission_to(T1198* C,T0* a1);
void r1198make(T1198* C,T0* a1);
T2 r1198index_of(T1198* C,T0* a1);
T6 r269look_in(T0* a1);
T0* r269start_position(T269* C);
T0* r269to_string(T269* C);
T0* r269to_prefix_name(T269* C);
extern T0*oBC269keyword_u;
T0* r269to_argument_name1(T269* C);
T0* r269to_infix_name(T0* a1);
T0* r269to_e_current(T269* C);
T0* r269to_simple_feature_name(T269* C);
extern T0*oBC269keyword_l;
T6 r269is_result(void);
T0* r269to_local_name1(T269* C);
extern T0*oBC269keyword_c;
T6 r269is_current(void);
T0* r269to_infix_name_use(T269* C);
extern T0*oBC269tmp_string;
extern T0*oBC269keyword_r;
extern T0*oBC269keyword_d;
T0* r269to_tag_name(T269* C);
T0* r269to_e_void(T269* C);
extern T0*oBC269keyword_i;
T0* r269pos(T2 a1,T2 a2);
extern T0*oBC269keyword_s;
extern T0*oBC269keyword_e;
void r269initialize(T269* C,T2 a1,T2 a2);
T0* r269to_local_name2(T269* C,T0* a1,T2 a2);
T6 r269isa_keyword(void);
T0* r269to_e_result(T269* C);
T0* r269to_class_name(T269* C);
extern T0*oBC269keyword_o;
T0* r269to_argument_name2(T269* C,T0* a1,T2 a2);
extern T0*oBC269keyword_a;
extern T0*oBC269keyword_t;
T6 r269is_void(void);
extern T0*oBC269keyword_f;
T0* r1210start_position(T1210* C);
T0* r1210twin(T1210* C);
T6 r1210use_current(T1210* C);
T0* r1210to_runnable(T1210* C,T0* a1);
void r1210error(T0* a1,T0* a2);
void r1210make(T1210* C,T0* a1,T0* a2);
void r1210afd_check(T1210* C);
T6 r1707is_static(T1707* C);
T0* r1707add_comment(T1707* C,T0* a1);
T2 r1707to_integer(T1707* C);
T6 r1707use_current(T1707* C);
T0* r1707to_runnable(T1707* C,T0* a1);
T2 r1707compile_to_jvm_into(T1707* C,T0* a1);
void r1707cpc_to_runnable(T1707* C,T0* a1);
void r1707standard_compile_target_to_jvm(T1707* C);
void r1707compile_to_jvm_old(T1707* C);
T0* r1707twin(T1707* C);
void r1707to_runnable_0(T1707* C,T0* a1);
T2 r1707jvm_standard_branch_if_false(T1707* C);
T6 r1707is_a(T1707* C,T0* a1);
void r1707error(T0* a1,T0* a2);
void r1707make(T1707* C,T0* a1,T0* a2,T0* a3);
T2 r1707standard_compile_to_jvm_into(T1707* C,T0* a1);
void r1707make_call_1(T1707* C,T0* a1,T0* a2,T0* a3);
T0* r1707operator(void);
T2 r1707jvm_standard_branch_if_true(T1707* C);
void r1707afd_check(T1707* C);
T0* r441start_position(T441* C);
T0* r441add_comment(T441* C,T0* a1);
T6 r441use_current(T441* C);
T0* r441to_runnable(T441* C,T0* a1);
void r441to_runnable_0(T441* C,T0* a1);
void r441cpc_to_runnable(T441* C,T0* a1);
T0* r441current_type(T441* C);
void r441error(T0* a1,T0* a2);
void r441make(T441* C,T0* a1,T0* a2,T0* a3);
T0* r441make_runnable(T441* C,T0* a1,T0* a2,T0* a3,T0* a4);
void r441afd_check(T441* C);
T0* r23jvm_root_class(void);
void r23jvm_initialize_local(T23* C,T2 a1);
T6 r23is_user_expanded(T23* C);
T2 r23id(T23* C);
T6 r23is_pointer(T23* C);
T0* r23to_runnable(T23* C,T0* a1);
T0* r23run_class(T23* C);
void r23standard_jvm_check_class_invariant(T23* C);
T6 r23is_bit(T23* C);
void r23jvm_write_local(T23* C,T2 a1);
T0* r23smallest_ancestor(T23* C,T0* a1);
T6 r23is_a(T23* C,T0* a1);
T6 r23is_character(T23* C);
void r23make(T23* C,T0* a1,T0* a2);
T2 r23jvm_convert_to(T23* C,T0* a1);
T2 r23jvm_push_default(T23* C);
T6 r23is_dummy_expanded(T23* C);
T0* r23generic_list(T23* C);
T0* r23base_class(T23* C);
T0* r23base_class_name(T23* C);
T6 r23is_a_in(T23* C,T0* a1,T0* a2);
T0* r23look_up_for(T23* C,T0* a1,T0* a2);
void r23jvm_to_reference(T23* C);
T6 r23has_creation(T23* C,T0* a1);
T0* r23expanded_initializer(T23* C);
T2 r23jvm_method_flags(T23* C);
T6 r23is_boolean(T23* C);
T6 r23is_generic(T23* C);
T6 r23is_real(T23* C);
T0* r23compute_mark(T0* a1);
T0* r23jvm_root_descriptor(void);
T6 r23is_basic_eiffel_expanded(T23* C);
T6 r23is_integer(T23* C);
void r23from_other(T23* C,T0* a1,T0* a2);
extern T0*oBC23tmp_written_mark;
void r23jvm_target_descriptor_in(T23* C,T0* a1);
T2 r23jvm_stack_space(T23* C);
T6 r23is_double(T23* C);
T6 r1348is_static(T1348* C);
T0* r1348add_comment(T1348* C,T0* a1);
T2 r1348to_integer(T1348* C);
T6 r1348use_current(T1348* C);
T2 r1348jvm_branch_if_true(T1348* C);
T0* r1348to_runnable(T1348* C,T0* a1);
T2 r1348compile_to_jvm_into(T1348* C,T0* a1);
void r1348cpc_to_runnable(T1348* C,T0* a1);
void r1348make_call0(T1348* C,T0* a1,T0* a2);
void r1348standard_compile_target_to_jvm(T1348* C);
void r1348compile_to_jvm_old(T1348* C);
T2 r1348jvm_branch_if_false(T1348* C);
T6 r1348can_be_dropped(T1348* C);
T0* r1348twin(T1348* C);
void r1348to_runnable_0(T1348* C,T0* a1);
T2 r1348jvm_standard_branch_if_false(T1348* C);
T6 r1348is_a(T1348* C,T0* a1);
void r1348error(T0* a1,T0* a2);
void r1348make(T1348* C,T0* a1,T0* a2);
T2 r1348standard_compile_to_jvm_into(T1348* C,T0* a1);
T0* r1348operator(void);
T2 r1348jvm_standard_branch_if_true(T1348* C);
void r1348afd_check(T1348* C);
T0* r140add_comment(T140* C,T0* a1);
T6 r140use_current(T140* C);
T0* r140to_runnable(T140* C,T0* a1);
T6 r140is_pre_computable(T140* C);
void r140error(T0* a1,T0* a2);
void r140make(T140* C,T0* a1,T0* a2,T0* a3);
void r140compile_to_jvm(T140* C);
void r140afd_check(T140* C);
void r1117runnable_from_current(T1117* C,T0* a1,T0* a2);
void r1117jvm_initialize(T1117* C);
T0* r1117type(T1117* C,T2 a1);
void r1117add_last(T1117* C,T0* a1);
T2 r1117rank_of(T1117* C,T0* a1);
T0* r1117to_runnable(T1117* C,T0* a1);
T2 r1117jvm_offset_of(T1117* C,T0* a1);
void r1117error(T0* a1,T0* a2);
void r1117make(T1117* C,T0* a1,T0* a2);
T2 r1117jvm_stack_space(T1117* C);
T0* r444jvm_root_class(void);
void r444jvm_initialize_local(T2 a1);
T0* r444smallest_ancestor(T0* a1);
T0* r444run_time_mark(void);
T0* r444written_mark(void);
void r444error(T0* a1,T0* a2);
void r444make(T444* C,T0* a1);
void r444fatal_error_generic_list(T444* C);
T2 r444jvm_push_default(void);
T0* r444generic_list(T444* C);
T0* r444base_class(T444* C);
T6 r444is_a_in(T444* C,T0* a1,T0* a2);
T0* r444look_up_for(T444* C,T0* a1,T0* a2);
T6 r444has_creation(T444* C,T0* a1);
T0* r444jvm_root_descriptor(void);
T2 r444jvm_stack_space(void);
T6 r1563is_static(T1563* C);
T0* r1563add_comment(T1563* C,T0* a1);
T2 r1563to_integer(T1563* C);
T6 r1563use_current(T1563* C);
T0* r1563to_runnable(T1563* C,T0* a1);
T2 r1563compile_to_jvm_into(T1563* C,T0* a1);
void r1563cpc_to_runnable(T1563* C,T0* a1);
void r1563standard_compile_target_to_jvm(T1563* C);
void r1563compile_to_jvm_old(T1563* C);
void r1563compile_to_jvm(T1563* C);
T0* r1563twin(T1563* C);
void r1563to_runnable_0(T1563* C,T0* a1);
T2 r1563jvm_standard_branch_if_false(T1563* C);
T6 r1563is_a(T1563* C,T0* a1);
void r1563error(T0* a1,T0* a2);
void r1563make(T1563* C,T0* a1,T0* a2,T0* a3);
T2 r1563standard_compile_to_jvm_into(T1563* C,T0* a1);
void r1563make_call_1(T1563* C,T0* a1,T0* a2,T0* a3);
T0* r1563operator(void);
T2 r1563jvm_standard_branch_if_true(T1563* C);
void r1563afd_check(T1563* C);
void r1567put_byte2(T1567* C,T2 a1);
T8 r1567bfw_open(T2 a1,T8 a2);
void r1567put_byte(T1567* C,T3 a1);
void r1567connect_to(T1567* C,T0* a1);
void r1567disconnect(T1567* C);
T0* r1657run_require(T0* a1);
void r1657set_rescue_compound(T1657* C,T0* a1);
T0* r1657start_position(T1657* C);
T6 r1657is_merge_with(T1657* C,T0* a1,T0* a2);
T0* r1657runnable(T0* a1,T0* a2,T0* a3);
T6 r1657use_current(T1657* C);
void r1657make_external_routine(T1657* C,T0* a1,T0* a2);
void r1657make_e_feature(T1657* C,T0* a1,T0* a2);
void r1657add_into(T1657* C,T0* a1);
T6 r1657can_hide(T1657* C,T0* a1,T0* a2);
T0* r1657run_ensure(T0* a1);
void r1657check_obsolete(T1657* C);
T0* r1657try_to_undefine(T1657* C,T0* a1,T0* a2);
void r1657make_routine(T1657* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T0* r1657to_run_feature(T1657* C,T0* a1,T0* a2);
void r1657warning(T0* a1,T0* a2);
T0* r1657try_to_undefine_aux(T1657* C,T0* a1,T0* a2);
void r1657error(T0* a1,T0* a2);
void r1657make(T1657* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7,T0* a8);
void r1657collect_for(T1657* C,T2 a1);
void r1657set_header_comment(T1657* C,T0* a1);
T0* r1108add_comment(T1108* C,T0* a1);
T6 r1108use_current(T1108* C);
T0* r1108run_args(T1108* C);
T0* r1108to_runnable(T1108* C,T0* a1);
T6 r1108is_pre_computable(T1108* C);
void r1108check_writable(T1108* C,T0* a1);
void r1108check_creation_clause(T1108* C,T0* a1);
void r1108compile_to_jvm(T1108* C);
T2 r1108arg_count(T1108* C);
extern T0*oBC1601make_precomputable;
void r1108check_created_type(T1108* C,T0* a1);
void r1108warning(T0* a1,T0* a2);
T0* r1108current_type(T1108* C);
void r1108error(T0* a1,T0* a2);
void r1108make(T1108* C,T0* a1,T0* a2,T0* a3);
void r1108cp_not_found(T1108* C,T0* a1);
void r1108afd_check(T1108* C);
extern T0*oBC1492dictionary;
void r1492update(T0* a1,T0* a2);
void r1492update_with(T0* a1);
T6 r1513is_static(T1513* C);
T0* r1513add_comment(T1513* C,T0* a1);
T2 r1513to_integer(T1513* C);
T6 r1513use_current(T1513* C);
T0* r1513to_runnable(T1513* C,T0* a1);
T2 r1513compile_to_jvm_into(T1513* C,T0* a1);
void r1513cpc_to_runnable(T1513* C,T0* a1);
void r1513standard_compile_target_to_jvm(T1513* C);
void r1513compile_to_jvm_old(T1513* C);
void r1513compile_to_jvm(T1513* C);
T0* r1513twin(T1513* C);
void r1513to_runnable_0(T1513* C,T0* a1);
T2 r1513jvm_standard_branch_if_false(T1513* C);
T6 r1513is_a(T1513* C,T0* a1);
void r1513error(T0* a1,T0* a2);
void r1513make(T1513* C,T0* a1,T0* a2,T0* a3);
T2 r1513standard_compile_to_jvm_into(T1513* C,T0* a1);
void r1513make_call_1(T1513* C,T0* a1,T0* a2,T0* a3);
T0* r1513operator(void);
T2 r1513jvm_standard_branch_if_true(T1513* C);
void r1513afd_check(T1513* C);
void r1055fall_down(T1055* C);
void r1055routine_mapping_jvm(T1055* C);
T6 r1055use_current(T1055* C);
void r1055routine_afd_check(T1055* C);
T6 r1055is_pre_computable(T1055* C);
void r1055std_compute_use_current(T1055* C);
T0* r1055run_class(T1055* C);
T2 r1055jvm_local_variable_offset(T1055* C,T0* a1);
T2 r1055arg_count(T1055* C);
T6 r1055is_exported_in(T1055* C,T0* a1);
T2 r1055jvm_argument_offset(T1055* C,T0* a1);
void r1055initialize(T1055* C);
T2 r1055jvm_max_locals(T1055* C);
void r1055jvm_define_opening(T1055* C);
void r1055jvm_define_closing(T1055* C);
extern T0*oBC266exceptions_handler;
void r1055add_client(T1055* C,T0* a1);
void r1055compute_use_current(T1055* C);
void r1055method_info_start(T1055* C);
void r1055make(T1055* C,T0* a1,T0* a2,T0* a3);
void r1055jvm_define(T1055* C);
T2 r1055jvm_result_offset(T1055* C);
void r1055routine_update_tmp_jvm_descriptor(T1055* C);
T0* r1055clients(T1055* C);
T0* r1055jvm_descriptor(T1055* C);
void r1214fe_c2jvm(T0* a1);
T0* r1511origin_base_class(T1511* C);
T0* r1511add_comment(T1511* C,T0* a1);
T2 r1511to_integer(T1511* C);
T2 r1511jvm_branch_if_true(T1511* C);
T0* r1511to_runnable(T1511* C,T0* a1);
T2 r1511compile_to_jvm_into(T1511* C,T0* a1);
T0* r1511run_feature(T1511* C,T0* a1);
void r1511compile_to_jvm_assignment(T1511* C,T0* a1);
void r1511jvm_assign(T1511* C);
T2 r1511jvm_branch_if_false(T1511* C);
void r1511compile_to_jvm(T1511* C);
void r1511undefine_in(T1511* C,T0* a1);
T6 r1511can_be_dropped(T1511* C);
void r1511compile_target_to_jvm(T1511* C);
T6 r1511is_a(T1511* C,T0* a1);
void r1511error(T0* a1,T0* a2);
void r1511make(T1511* C,T0* a1,T0* a2);
T2 r1511standard_compile_to_jvm_into(T1511* C,T0* a1);
T0* r559jvm_root_class(void);
void r559jvm_initialize_local(T559* C,T2 a1);
void r559used_as_reference(T559* C);
T2 r559id(T559* C);
T0* r559to_runnable(T559* C,T0* a1);
T0* r559run_class(T559* C);
void r559standard_jvm_check_class_invariant(T559* C);
void r559jvm_write_local(T559* C,T2 a1);
T0* r559smallest_ancestor(T559* C,T0* a1);
T6 r559is_expanded(T559* C);
T2 r559jvm_if_x_eq(T559* C);
void r559jvm_push_local(T559* C,T2 a1);
T6 r559is_a(T559* C,T0* a1);
void r559fatal_error_generic_list(T559* C);
T2 r559jvm_push_default(T559* C);
T6 r559is_dummy_expanded(T559* C);
T0* r559generic_list(T559* C);
T0* r559base_class(T559* C);
T2 r559jvm_if_x_ne(T559* C);
T6 r559is_a_in(T559* C,T0* a1,T0* a2);
T0* r559look_up_for(T559* C,T0* a1,T0* a2);
T0* r559expanded_initializer(T559* C);
T6 r559has_creation(T559* C,T0* a1);
T2 r559jvm_method_flags(T559* C);
void r559jvm_xaload(T559* C);
T0* r559jvm_root_descriptor(void);
extern T0*oBC559check_memory;
void r559jvm_descriptor_in(T559* C,T0* a1);
extern int fBC266type_any;
extern T0*oBC266type_any;
T0* r559type_any(void);
T6 r559is_reference(T559* C);
void r559jvm_target_descriptor_in(T559* C,T0* a1);
void r559jvm_return_code(T559* C);
void r559jvm_xastore(T559* C);
T2 r559jvm_stack_space(void);
void r527undefine_in(T527* C,T0* a1);
T0* r527origin_base_class(T527* C);
void r527error(T0* a1,T0* a2);
void r527make(T527* C,T0* a1,T0* a2);
T0* r181add_comment(T181* C,T0* a1);
T2 r181to_integer(T181* C);
T0* r181to_runnable(T181* C,T0* a1);
T2 r181compile_to_jvm_into(T0* a1);
extern int fBC181result_type;
extern T0*oBC181result_type;
T0* r181result_type(void);
T0* r181twin(T181* C);
T6 r181is_a(T181* C,T0* a1);
void r181error(T0* a1,T0* a2);
void r181make(T181* C,T0* a1);
void r535make(T535* C,T0* a1,T0* a2);
extern T0*oBC1std_error;
void r85sfr_connect(T85* C,T0* a1,T0* a2);
void r85put_new_line(T85* C);
void r85w_put_string(T0* a1);
extern T0*oBC1std_output;
void r85w_put_integer(T2 a1);
void r85put_string(T85* C,T0* a1);
void r85put_character(T85* C,T3 a1);
void r85print_count(T85* C,T0* a1,T2 a2);
void r85put_integer(T85* C,T2 a1);
void r85w_put_character(T3 a1);
T0* r1224start_position(T1224* C);
T0* r1224twin(T1224* C);
T6 r1224use_current(T1224* C);
T0* r1224to_runnable(T1224* C,T0* a1);
void r1224error(T0* a1,T0* a2);
void r1224make(T1224* C,T0* a1,T0* a2,T0* a3);
void r1224afd_check(T1224* C);
T6 r15is_static(T15* C);
void r15jvm_void_cmp(T0* a1);
void r15error_comparison(T15* C,T0* a1);
T0* r15add_comment(T15* C,T0* a1);
T2 r15to_integer(T15* C);
T6 r15use_current(T15* C);
T6 r15is_static_eq_void(T15* C,T0* a1);
T0* r15to_runnable(T15* C,T0* a1);
T2 r15compile_to_jvm_into(T15* C,T0* a1);
void r15jvm_standard_is_equal_aux(T0* a1,T0* a2);
void r15standard_compile_target_to_jvm(T15* C);
void r15compile_to_jvm_old(T15* C);
void r15compile_to_jvm(T15* C);
void r15bit_limitation(T15* C,T0* a1,T0* a2);
extern int fBC266type_boolean;
extern T0*oBC266type_boolean;
T0* r15type_boolean(void);
T6 r15is_manifest_array(T0* a1);
T2 r15jvm_standard_branch_if_false(T15* C);
T6 r15is_a(T15* C,T0* a1);
void r15error(T0* a1,T0* a2);
void r15make(T15* C,T0* a1,T0* a2,T0* a3);
T2 r15standard_compile_to_jvm_into(T15* C,T0* a1);
void r15make_call_1(T15* C,T0* a1,T0* a2,T0* a3);
T0* r15operator(void);
void r15to_runnable_equal_not_equal(T15* C,T0* a1);
T2 r15jvm_standard_branch_if_true(T15* C);
void r15afd_check(T15* C);
T6 r771is_static(T771* C);
T0* r771add_comment(T771* C,T0* a1);
T2 r771to_integer(T771* C);
T6 r771use_current(T771* C);
T0* r771to_runnable(T771* C,T0* a1);
T2 r771compile_to_jvm_into(T771* C,T0* a1);
void r771cpc_to_runnable(T771* C,T0* a1);
void r771standard_compile_target_to_jvm(T771* C);
void r771compile_to_jvm_old(T771* C);
T0* r771twin(T771* C);
void r771to_runnable_0(T771* C,T0* a1);
T2 r771jvm_standard_branch_if_false(T771* C);
T6 r771is_a(T771* C,T0* a1);
void r771error(T0* a1,T0* a2);
void r771make(T771* C,T0* a1,T0* a2,T0* a3);
T2 r771standard_compile_to_jvm_into(T771* C,T0* a1);
void r771make_call_1(T771* C,T0* a1,T0* a2,T0* a3);
T0* r771operator(void);
T2 r771jvm_standard_branch_if_true(T771* C);
void r771afd_check(T771* C);
void r876read_byte(T876* C);
T6 r876end_of_input(T876* C);
void r876connect_to(T876* C,T0* a1);
void r876disconnect(T876* C);
T8 r876bfr_open(T2 a1,T8 a2);
T0* r214jvm_root_class(void);
void r214jvm_mapping(T0* a1);
T2 r214idx_error01(void);
extern T0*oBC214running;
T2 r214idx_methodref(T0* a1);
extern T0*oBC214c_code;
void r214jvm_switch(T0* a1,T0* a2);
extern T0*oBC214tmp_jvmd;
void r214jvm_define(T0* a1);
T0* r214name(T0* a1);
T0* r214jvm_root_descriptor(void);
T0* r214jvm_descriptor(T0* a1);
T6 r253is_static(T253* C);
T0* r253add_comment(T253* C,T0* a1);
T0* r253to_runnable(T253* C,T0* a1);
T2 r253compile_to_jvm_into(T0* a1);
T2 r253jvm_branch_if_false(void);
T0* r253type_boolean(void);
T0* r253twin(T253* C);
T2 r253isa_dca_inline_argument(T253* C);
T6 r253is_a(T253* C,T0* a1);
void r253error(T0* a1,T0* a2);
T2 r253standard_compile_to_jvm_into(T0* a1);
T0* r105start_position(T105* C);
T0* r105add_comment(T105* C,T0* a1);
T2 r105to_integer(T105* C);
T6 r105use_current(T105* C);
T0* r105to_runnable(T105* C,T0* a1);
T2 r105compile_to_jvm_into(T105* C,T0* a1);
T0* r105result_type(T105* C);
void r105standard_compile_target_to_jvm(T105* C);
void r105compile_to_jvm_old(T105* C);
void r105compile_to_jvm(T105* C);
T2 r105jvm_standard_branch_if_false(T105* C);
T6 r105is_a(T105* C,T0* a1);
void r105error(T0* a1,T0* a2);
T2 r105standard_compile_to_jvm_into(T105* C,T0* a1);
T2 r105jvm_standard_branch_if_true(T105* C);
void r105afd_check(T105* C);
T0* r31to_run_feature(T31* C,T0* a1,T0* a2);
T0* r31start_position(T31* C);
T6 r31is_merge_with(T31* C,T0* a1,T0* a2);
T0* r31try_to_undefine_aux(T31* C,T0* a1,T0* a2);
void r31error(T0* a1,T0* a2);
void r31add_into(T31* C,T0* a1);
T6 r31can_hide(T31* C,T0* a1,T0* a2);
void r31make(T31* C,T0* a1,T0* a2);
void r31collect_for(T2 a1);
T0* r31try_to_undefine(T31* C,T0* a1,T0* a2);
T6 r1068empty_or_null_body(T1068* C);
T6 r1068is_static(T1068* C);
T0* r1068body_one_result(T1068* C);
T6 r1068isa_in_line(T1068* C);
void r1068routine_mapping_jvm(T1068* C);
T6 r1068use_current(T1068* C);
void r1068routine_afd_check(T1068* C);
T6 r1068value_reader(T1068* C);
T0* r1068body_one_dc_pco(T1068* C);
T6 r1068direct_cse_call(T1068* C);
void r1068std_compute_use_current(T1068* C);
T0* r1068run_class(T1068* C);
T6 r1068is_exported_in(T1068* C,T0* a1);
T6 r1068direct_call(T1068* C);
T6 r1068dca(T1068* C);
void r1068jvm_define_opening(T1068* C);
void r1068jvm_define_closing(T1068* C);
void r1068add_client(T1068* C,T0* a1);
void r1068make(T1068* C,T0* a1,T0* a2,T0* a3);
void r1068jvm_define(T1068* C);
T6 r1068attribute_reader(T1068* C);
T0* r1068clients(T1068* C);
void r1068fall_down(T1068* C);
T6 r1068result_is_current(T1068* C);
T6 r1068a_eq_neq(T1068* C);
T2 r1068jvm_local_variable_offset(T1068* C,T0* a1);
T2 r1068arg_count(T1068* C);
T6 r1068dc_pco1(T1068* C);
T2 r1068jvm_argument_offset(T1068* C,T0* a1);
void r1068initialize(T1068* C);
T6 r1068can_be_dropped(T1068* C);
T2 r1068jvm_max_locals(T1068* C);
T6 r1068dc_pco2(T1068* C);
T0* r1068body_one_result_dca(T1068* C);
void r1068compute_use_current(T1068* C);
void r1068method_info_start(T1068* C);
T2 r1068jvm_result_offset(T1068* C);
void r1068routine_update_tmp_jvm_descriptor(T1068* C);
T0* r1068jvm_descriptor(T1068* C);
T0* r667start_position(T667* C);
T6 r667is_merge_with(T667* C,T0* a1,T0* a2);
void r667make_e_feature(T667* C,T0* a1,T0* a2);
void r667add_into(T667* C,T0* a1);
T6 r667can_hide(T667* C,T0* a1,T0* a2);
T0* r667try_to_undefine(T667* C,T0* a1,T0* a2);
T0* r667to_run_feature(T667* C,T0* a1,T0* a2);
T0* r667try_to_undefine_aux(T667* C,T0* a1,T0* a2);
void r667error(T0* a1,T0* a2);
void r667make(T667* C,T0* a1,T0* a2,T0* a3);
void r667collect_for(T2 a1);
T0* r1687run_require(T0* a1);
void r1687set_rescue_compound(T1687* C,T0* a1);
T0* r1687start_position(T1687* C);
T6 r1687is_merge_with(T1687* C,T0* a1,T0* a2);
T0* r1687runnable(T0* a1,T0* a2,T0* a3);
T6 r1687use_current(T1687* C);
void r1687make_external_routine(T1687* C,T0* a1,T0* a2);
void r1687make_e_feature(T1687* C,T0* a1,T0* a2);
void r1687add_into(T1687* C,T0* a1);
T6 r1687can_hide(T1687* C,T0* a1,T0* a2);
T0* r1687run_ensure(T0* a1);
void r1687check_obsolete(T1687* C);
T0* r1687try_to_undefine(T1687* C,T0* a1,T0* a2);
void r1687make_routine(T1687* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T0* r1687to_run_feature(T1687* C,T0* a1,T0* a2);
void r1687warning(T0* a1,T0* a2);
T0* r1687try_to_undefine_aux(T1687* C,T0* a1,T0* a2);
void r1687error(T0* a1,T0* a2);
void r1687make(T1687* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7);
void r1687collect_for(T1687* C,T2 a1);
void r1687set_header_comment(T1687* C,T0* a1);
T6 r201use_current(T201* C);
T0* r201to_runnable(T201* C,T0* a1);
T2 r201compile_to_jvm_resolve_branch(T201* C);
void r201error(T0* a1,T0* a2);
void r201make(T201* C,T0* a1,T0* a2);
T2 r201compile_to_jvm(T201* C);
void r201afd_check(T201* C);
T6 r792gives_permission_to_any(T792* C);
void r792merge(T792* C,T0* a1,T0* a2,T0* a3);
T6 r792gives_permission_to(T792* C,T0* a1);
void r792make(T792* C,T0* a1,T0* a2);
T0* r792append(T792* C,T0* a1);
T0* r792merge_with(T792* C,T0* a1);
T0* r27run_require(T0* a1);
T0* r27start_position(T27* C);
T6 r27is_merge_with(T27* C,T0* a1,T0* a2);
T0* r27runnable(T0* a1,T0* a2,T0* a3);
void r27make_e_feature(T27* C,T0* a1,T0* a2);
void r27add_into(T27* C,T0* a1);
T6 r27can_hide(T27* C,T0* a1,T0* a2);
T0* r27run_ensure(T0* a1);
void r27check_obsolete(T27* C);
T0* r27try_to_undefine(T27* C,T0* a1,T0* a2);
void r27make_routine(T27* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T0* r27to_run_feature(T27* C,T0* a1,T0* a2);
void r27make_effective_routine(T27* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7);
void r27warning(T0* a1,T0* a2);
T0* r27try_to_undefine_aux(T27* C,T0* a1,T0* a2);
void r27error(T0* a1,T0* a2);
void r27make(T27* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7,T0* a8);
void r27collect_for(T27* C,T2 a1);
void r27set_header_comment(T27* C,T0* a1);
void r556fill_up(T556* C);
T0* r556type_any(void);
void r977make(T977* C,T0* a1,T0* a2,T0* a3);
void r977add_into(T977* C,T0* a1);
T0* r1123add_comment(T1123* C,T0* a1);
T6 r1123use_current(T1123* C);
T0* r1123run_args(T1123* C);
T0* r1123to_runnable(T1123* C,T0* a1);
T6 r1123is_pre_computable(T1123* C);
void r1123check_writable(T1123* C,T0* a1);
void r1123check_creation_clause(T1123* C,T0* a1);
void r1123compile_to_jvm(T1123* C);
T2 r1123arg_count(T1123* C);
void r1123check_created_type(T1123* C,T0* a1);
void r1123warning(T0* a1,T0* a2);
T0* r1123current_type(T1123* C);
void r1123error(T0* a1,T0* a2);
void r1123make(T1123* C,T0* a1,T0* a2,T0* a3,T0* a4);
void r1123check_explicit_type(T1123* C);
void r1123cp_not_found(T1123* C,T0* a1);
void r1123afd_check(T1123* C);
T2 r822read_file(T0* a1);
extern int fBC822buffer;
extern T9 oBC822buffer;
T9 r822buffer(void);
extern T0*oBC822text;
T0* r822item(T2 a1);
T0* r822next_line(T2 a1);
void r822load_file(T822* C,T0* a1);
T6 r949is_static(T949* C);
T0* r949add_comment(T949* C,T0* a1);
T2 r949to_integer(T949* C);
T6 r949use_current(T949* C);
T0* r949to_runnable(T949* C,T0* a1);
T2 r949compile_to_jvm_into(T949* C,T0* a1);
void r949cpc_to_runnable(T949* C,T0* a1);
void r949standard_compile_target_to_jvm(T949* C);
void r949compile_to_jvm_old(T949* C);
T0* r949twin(T949* C);
void r949to_runnable_0(T949* C,T0* a1);
T2 r949jvm_standard_branch_if_false(T949* C);
T6 r949is_a(T949* C,T0* a1);
void r949error(T0* a1,T0* a2);
void r949make(T949* C,T0* a1,T0* a2,T0* a3);
T2 r949standard_compile_to_jvm_into(T949* C,T0* a1);
void r949make_call_1(T949* C,T0* a1,T0* a2,T0* a3);
T0* r949operator(void);
T2 r949jvm_standard_branch_if_true(T949* C);
void r949afd_check(T949* C);
T0* r157start_position(T157* C);
T0* r157add_comment(T157* C,T0* a1);
T6 r157call_is_static(T157* C);
T2 r157to_integer(T157* C);
T6 r157use_current(T157* C);
T0* r157to_runnable(T157* C,T0* a1);
T2 r157compile_to_jvm_into(T157* C,T0* a1);
void r157cpc_to_runnable(T157* C,T0* a1);
void r157standard_compile_target_to_jvm(T157* C);
void r157compile_to_jvm_old(T157* C);
T0* r157twin(T157* C);
void r157to_runnable_0(T157* C,T0* a1);
T2 r157jvm_standard_branch_if_false(T157* C);
T6 r157is_a(T157* C,T0* a1);
void r157error(T0* a1,T0* a2);
void r157make(T157* C,T0* a1,T0* a2,T0* a3);
T2 r157standard_compile_to_jvm_into(T157* C,T0* a1);
T2 r157jvm_standard_branch_if_true(T157* C);
void r157afd_check(T157* C);
void r257set_fieldref(T257* C,T0* a1);
T6 r257is_methodref_idx(T257* C,T2 a1,T2 a2);
T6 r257is_class_idx(T257* C,T2 a1);
T6 r257is_fieldref_idx(T257* C,T2 a1,T2 a2);
T6 r257is_uft8_idx(T257* C,T0* a1);
void r257set_methodref(T257* C,T0* a1);
T6 r257is_string_idx(T257* C,T2 a1);
void r257set_string(T257* C,T0* a1);
void r257set_class(T257* C,T0* a1);
void r257set_name_and_type(T257* C,T0* a1);
void r257b_put(T257* C);
void r257clear(T257* C);
T6 r257is_name_and_type_idx(T257* C,T2 a1,T2 a2);
void r257set_uft8(T257* C,T0* a1);
T2 r257u2_to_integer(T257* C,T2 a1);
T0* r697to_old_name(T697* C,T0* a1);
T0* r697to_new_name(T697* C,T0* a1);
void r697get_started(T697* C,T0* a1);
T6 r697affect(T697* C,T0* a1);
void r1127opcode_putfield(T1127* C,T2 a1,T2 a2);
void r1127opcode_getfield(T1127* C,T2 a1,T2 a2);
void r1127opcode(T1127* C,T2 a1,T2 a2);
void r1127opcode_ldc(T1127* C,T2 a1);
void r1127opcode_system_err(T1127* C);
void r1127opcode_push_manifest_string(T1127* C,T0* a1);
T2 r1127opcode_ifnull(T1127* C);
void r1127opcode_println(T1127* C,T2 a1);
T2 r1127extra_local(T1127* C,T0* a1);
T2 r1127opcode_if_icmpge(T1127* C);
T2 r1127opcode_if_icmple(T1127* C);
T2 r1127opcode_if_icmplt(T1127* C);
T2 r1127opcode_if_icmpgt(T1127* C);
void r1127opcode_system_in(T1127* C);
T2 r1127opcode_if_icmpeq(T1127* C);
T2 r1127opcode_if_acmpeq(T1127* C);
T2 r1127opcode_if_icmpne(T1127* C);
T2 r1127opcode_if_acmpne(T1127* C);
void r1127opcode_string2float(T1127* C,T0* a1);
void r1127opcode_invokestatic(T1127* C,T2 a1,T2 a2);
T2 r1127opcode_iflt(T1127* C);
T2 r1127opcode_ifgt(T1127* C);
void r1127store_in(T1127* C,T0* a1);
extern T0*oBC1127branches;
T2 r1127skip_2_bytes(void);
void r1127opcode_push_integer(T1127* C,T2 a1);
void r1127opcode_newarray(T1127* C,T2 a1);
void r1127opcode_bipush(T1127* C,T2 a1);
void r1127opcode_sipush(T1127* C,T2 a1);
void r1127opcode_bytes_array2eiffel_string(T1127* C);
void r1127opcode_java_string2eiffel_string(T1127* C);
extern T0*oBC1127code;
void r1127opcode_java_string2bytes_array(T1127* C);
extern T0*oBC1127exception_table;
void r1127resolve_with(T0* a1);
void r1127opcode_aload(T1127* C,T2 a1);
void r1127opcode_fload(T1127* C,T2 a1);
void r1127opcode_dload(T1127* C,T2 a1);
void r1127opcode_iload(T1127* C,T2 a1);
T2 r1127opcode_goto(T1127* C);
void r1127opcode_goto_backward(T1127* C,T2 a1);
void r1127opcode_system_err_println(T1127* C,T2 a1);
void r1127opcode_putstatic(T1127* C,T2 a1,T2 a2);
void r1127opcode_getstatic(T1127* C,T2 a1,T2 a2);
T2 r1127opcode_ifnonnull(T1127* C);
void r1127add_u2(T2 a1);
void r1127runtime_internal_exception_number(T1127* C);
void r1127opcode_iinc(T1127* C,T2 a1,T2 a2);
void r1127opcode_runtime_get_runtime(T1127* C);
void r1127clear(T1127* C);
void r1127opcode_fstore(T1127* C,T2 a1);
void r1127opcode_dstore(T1127* C,T2 a1);
void r1127opcode_astore(T1127* C,T2 a1);
void r1127opcode_istore(T1127* C,T2 a1);
T0* r1127jvm_root_class(void);
void r1127opcode_instanceof(T1127* C,T2 a1);
void r1127opcode_invokespecial(T1127* C,T2 a1,T2 a2);
void r1127opcode_invokevirtual(T1127* C,T2 a1,T2 a2);
void r1127check_closing(T1127* C);
void r1127check_opening(T1127* C);
void r1127opcode_runtime_trace_instructions(T1127* C,T6 a1);
void r1127resolve_u2_branch(T2 a1);
void r1127opcode_new(T1127* C,T2 a1);
T2 r1127opcode_ifeq(T1127* C);
void r1127append_u2(T0* a1,T2 a2);
void r1127opcode_push_as_float(T1127* C,T0* a1);
extern int fBC1127runtime;
extern T0*oBC1127runtime;
T0* r1127runtime(void);
extern T0*oBC1127tmp_string;
void r1127opcode_anewarray(T1127* C,T2 a1);
T2 r1127opcode_ifge(T1127* C);
T2 r1127opcode_ifle(T1127* C);
T2 r1127opcode_ifne(T1127* C);
void r1127opcode_system_out(T1127* C);
void r1127opcode_system_exit(T1127* C);
void r1127opcode_string2double(T1127* C,T0* a1);
void r1127append_u4(T0* a1,T2 a2);
T2 r1127extra_local_size1(T1127* C);
void r1127push_strange_integer(T1127* C,T2 a1);
void r1127opcode_push_as_double(T1127* C,T0* a1);
T0* r1120system_name(T1120* C);
extern T0*oBC266help_file_name;
void r1120print_help(T1120* C,T0* a1);
void r1120automat(T1120* C);
T0* r1120small_eiffel_directory(T1120* C);
T0* r1120get_environment_variable(T1120* C,T0* a1);
T0* r1120command_name(void);
T6 r1120file_exists(T0* a1);
void r1120error_level(T1120* C,T0* a1);
T0* r1120argument(T2 a1);
void r1120add_directory(T1120* C,T0* a1,T0* a2);
void r1120make(T1120* C);
extern int fBC1command_arguments;
extern T0*oBC1command_arguments;
T0* r1120command_arguments(void);
void r882jvm_initialize_local(T2 a1);
extern int fBC882used_as_reference;
void r882used_as_reference(void);
T0* r882to_runnable(T882* C,T0* a1);
T0* r882run_class(T882* C);
T0* r882smallest_ancestor(T882* C,T0* a1);
T0* r882run_time_mark(void);
extern int fBC266type_character_ref;
extern T0*oBC266type_character_ref;
T0* r882type_character_ref(void);
T6 r882is_a(T882* C,T0* a1);
T0* r882written_mark(void);
void r882error(T0* a1,T0* a2);
void r882make(T882* C,T0* a1);
T2 r882jvm_convert_to(T0* a1);
void r882fatal_error_generic_list(T882* C);
T2 r882jvm_push_default(void);
T0* r882generic_list(T882* C);
T0* r882base_class(T882* C);
T6 r882is_a_in(T882* C,T0* a1,T0* a2);
T0* r882look_up_for(T882* C,T0* a1,T0* a2);
T6 r882has_creation(T882* C,T0* a1);
void r882load_ref(T0* a1);
extern int fBC882check_type;
void r882check_type(T882* C);
T2 r882jvm_stack_space(void);
T6 r810has_redefine(T810* C,T0* a1);
void r810inherit_cycle_check(T810* C);
T0* r810up_to_original(T810* C,T0* a1,T0* a2);
T6 r810has(T810* C,T0* a1);
void r810collect_invariant(T810* C,T0* a1);
T0* r810next_parent_for(T810* C,T0* a1,T0* a2);
T0* r810going_up(T810* C,T0* a1,T0* a2,T0* a3);
T0* r810clients_for(T810* C,T0* a1);
T0* r810repeated_inheritance(T810* C,T0* a1,T0* a2,T0* a3);
T0* r810look_up_for(T810* C,T0* a1,T0* a2);
void r810get_started(T810* C);
T0* r810first_parent_for(T810* C,T0* a1);
void r810make(T810* C,T0* a1,T0* a2,T0* a3,T0* a4);
void r810collect_for(T810* C,T2 a1,T0* a2);
T6 r810is_a_vncg(T810* C,T0* a1,T0* a2);
T6 r810has_parent(T810* C,T0* a1);
T0* r810smallest_ancestor(T810* C,T0* a1);
T0* r425base_class(T425* C);
T6 r425is_subclass_of(T425* C,T0* a1);
void r425identify(T425* C,T0* a1);
void r425make_unknown(T425* C);
void r425make(T425* C,T0* a1,T0* a2);
T0* r1436add_comment(T1436* C,T0* a1);
T6 r1436call_is_static(T1436* C);
T2 r1436to_integer(T1436* C);
T6 r1436use_current(T1436* C);
T0* r1436to_runnable(T1436* C,T0* a1);
T2 r1436compile_to_jvm_into(T1436* C,T0* a1);
void r1436cpc_to_runnable(T1436* C,T0* a1);
void r1436standard_compile_target_to_jvm(T1436* C);
void r1436compile_to_jvm_old(T1436* C);
T0* r1436twin(T1436* C);
void r1436to_runnable_0(T1436* C,T0* a1);
T2 r1436jvm_standard_branch_if_false(T1436* C);
T6 r1436is_a(T1436* C,T0* a1);
void r1436error(T0* a1,T0* a2);
void r1436make(T1436* C,T0* a1,T0* a2,T0* a3);
T2 r1436standard_compile_to_jvm_into(T1436* C,T0* a1);
void r1436make_call_1(T1436* C,T0* a1,T0* a2,T0* a3);
T2 r1436jvm_standard_branch_if_true(T1436* C);
void r1436afd_check(T1436* C);
T2 r708item(T708* C,T0* a1);
void r708make(T708* C);
void r708add2(T708* C,T0* a1,T2 a2);
T2 r708hash_code(T0* a1);
void r18add_when_item_1(T18* C,T0* a1);
T0* r18to_runnable_integer(T18* C,T0* a1);
void r18add_slice(T18* C,T0* a1,T0* a2);
void r18from_e_when(T18* C,T0* a1);
T6 r18use_current(T18* C);
T6 r18includes_integer(T18* C,T2 a1);
void r18add_when_item_2(T18* C,T0* a1);
void r18add_value(T18* C,T0* a1);
extern T0*oBC18points1;
void r18err_occ(T18* C,T2 a1,T0* a2);
void r18error(T0* a1,T0* a2);
void r18make(T18* C,T0* a1,T0* a2);
void r18compile_to_jvm(T18* C,T0* a1,T2 a2);
void r18afd_check(T18* C);
T0* r18to_runnable_character(T18* C,T0* a1);
T0* r1024start_position(T1024* C);
T6 r1024is_merge_with(T1024* C,T0* a1,T0* a2);
void r1024make_e_feature(T1024* C,T0* a1,T0* a2);
void r1024add_into(T1024* C,T0* a1);
T6 r1024can_hide(T1024* C,T0* a1,T0* a2);
T0* r1024try_to_undefine(T1024* C,T0* a1,T0* a2);
T0* r1024to_run_feature(T1024* C,T0* a1,T0* a2);
T0* r1024try_to_undefine_aux(T1024* C,T0* a1,T0* a2);
void r1024error(T0* a1,T0* a2);
void r1024make(T1024* C,T0* a1,T0* a2,T0* a3);
void r1024collect_for(T2 a1);
void r1081fall_down(T1081* C);
void r1081routine_mapping_jvm(T1081* C);
T6 r1081use_current(T1081* C);
void r1081routine_afd_check(T1081* C);
void r1081std_compute_use_current(T1081* C);
T0* r1081run_class(T1081* C);
T2 r1081jvm_local_variable_offset(T1081* C,T0* a1);
T2 r1081arg_count(T1081* C);
T6 r1081is_exported_in(T1081* C,T0* a1);
T2 r1081jvm_argument_offset(T1081* C,T0* a1);
void r1081initialize(T1081* C);
T2 r1081jvm_max_locals(T1081* C);
void r1081jvm_define_opening(T1081* C);
void r1081jvm_define_closing(T1081* C);
void r1081add_client(T1081* C,T0* a1);
void r1081method_info_start(T1081* C);
void r1081make(T1081* C,T0* a1,T0* a2,T0* a3);
void r1081jvm_define(T1081* C);
T2 r1081jvm_result_offset(T1081* C);
void r1081routine_update_tmp_jvm_descriptor(T1081* C);
T0* r1081clients(T1081* C);
T0* r1081jvm_descriptor(T1081* C);
void r345good_end(T345* C,T0* a1);
void r345warning(T0* a1,T0* a2);
void r345make(T345* C,T0* a1,T0* a2);
void r345append(T345* C,T0* a1);
void r1008append_in(T1008* C,T0* a1);
void r1008make(T1008* C,T0* a1,T0* a2);
T0* r590start_position(T590* C);
T6 r590use_current(T590* C);
T0* r590to_runnable(T590* C,T0* a1);
T6 r590is_pre_computable(T590* C);
void r590error(T0* a1,T0* a2);
void r590make(T590* C,T0* a1,T0* a2,T0* a3);
void r590compile_to_jvm_old(T590* C);
extern T0*oBC590tmp_string;
void r590compile_to_jvm(T590* C,T6 a1);
void r590afd_check(T590* C);
T2 r590idx_error_message(T590* C);
T0* r1866start_position(T1866* C);
T0* r1866add_comment(T1866* C,T0* a1);
T0* r1866right_type(T1866* C);
T6 r1866use_current(T1866* C);
T0* r1866to_runnable(T1866* C,T0* a1);
void r1866warning(T0* a1,T0* a2);
T0* r1866current_type(T1866* C);
T0* r1866left_type(T1866* C);
void r1866error(T0* a1,T0* a2);
void r1866make(T1866* C,T0* a1,T0* a2);
void r1866compile_to_jvm(T1866* C);
void r1866afd_check(T1866* C);
void r683set_require_else(T683* C,T0* a1,T0* a2,T0* a3);
T0* r683to_cst_att_integer(T683* C,T0* a1);
T0* r683to_external_routine(T683* C,T0* a1,T0* a2);
T0* r683to_deferred_routine(T683* C);
extern T0*oBC683names;
T0* r683to_cst_att_boolean(T683* C,T0* a1);
T0* r683to_writable_attribute(T683* C);
T0* r683to_procedure_or_function(T683* C);
void r683set_require(T683* C,T0* a1,T0* a2,T0* a3);
void r683initialize(T683* C);
T0* r683n(void);
T0* r683to_cst_att_bit(T683* C,T0* a1);
T0* r683to_cst_att_real(T683* C,T0* a1);
void r683to_cst_att_check_result_type(T683* C);
T0* r683to_cst_att_unique(T683* C);
void r683error(T0* a1,T0* a2);
T0* r683to_cst_att_string(T683* C,T0* a1);
T0* r683to_cst_att_character(T683* C,T0* a1);
T0* r683to_once_routine(T683* C);
void r380increment(T380* C);
T0* r991run_require(T0* a1);
T0* r991start_position(T991* C);
T6 r991is_merge_with(T991* C,T0* a1,T0* a2);
T0* r991runnable(T0* a1,T0* a2,T0* a3);
void r991make_e_feature(T991* C,T0* a1,T0* a2);
void r991add_into(T991* C,T0* a1);
T6 r991can_hide(T991* C,T0* a1,T0* a2);
T0* r991run_ensure(T0* a1);
void r991check_obsolete(T991* C);
T0* r991try_to_undefine(T991* C,T0* a1,T0* a2);
void r991make_routine(T991* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T0* r991to_run_feature(T991* C,T0* a1,T0* a2);
void r991warning(T0* a1,T0* a2);
T0* r991try_to_undefine_aux(T991* C,T0* a1,T0* a2);
void r991error(T0* a1,T0* a2);
void r991make(T991* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7);
void r991collect_for(T991* C,T2 a1);
void r991set_header_comment(T991* C,T0* a1);
void r816print_as_warning(T816* C);
extern T0*oBC816explanation;
void r816print_as_error(T816* C);
void r816print_as_fatal_error(T816* C);
void r816incr_nb_errors(T816* C);
void r816incr_nb_warnings(T816* C);
void r816warning(T816* C,T0* a1);
void r816error(T816* C,T0* a1);
extern T0*oBC816positions;
void r816add_position(T0* a1);
T6 r816empty(void);
void r816add_type(T0* a1,T0* a2);
void r816do_print(T0* a1);
void r816fatal_error(T816* C,T0* a1);
T6 r261has(T261* C,T0* a1);
extern T0*oBC261forbidden_parent_list;
void r261select_conflict(T0* a1,T0* a2);
T0* r261start_position(T261* C);
T0* r261going_up(T261* C,T0* a1,T0* a2,T0* a3);
T0* r261look_up_for(T261* C,T0* a1,T0* a2);
void r261get_started(T261* C,T0* a1);
T0* r261apply_undefine(T261* C,T0* a1,T0* a2);
void r261set_select(T261* C,T0* a1);
T0* r261smallest_ancestor(T261* C,T0* a1);
T6 r261has_redefine(T261* C,T0* a1);
void r261set_redefine(T261* C,T0* a1);
T0* r261get_new_name(T261* C,T0* a1);
T0* r261up_to_original(T261* C,T0* a1,T0* a2);
void r261missing_select(T0* a1,T0* a2);
T0* r261get_old_name(T261* C,T0* a1);
T0* r261clients_for(T261* C,T0* a1);
T6 r261has_undefine(T261* C,T0* a1);
void r261set_undefine(T261* C,T0* a1);
T0* r261do_rename(T261* C,T0* a1);
void r261add_rename(T261* C,T0* a1);
T0* r261going_down(T261* C,T0* a1,T0* a2);
void r261multiple_check(T261* C,T0* a1);
T6 r261has_select_for(T261* C,T0* a1);
void r261make(T261* C,T0* a1);
void r261collect_for(T261* C,T2 a1,T0* a2);
T6 r261is_a_vncg(T261* C,T0* a1,T0* a2);
T0* r21add_comment(T21* C,T0* a1);
T6 r21use_current(T21* C);
T0* r21to_runnable(T21* C,T0* a1);
T0* r21current_type(T21* C);
void r21error(T0* a1,T0* a2);
void r21make(T21* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6);
void r21compile_to_jvm(T21* C);
void r21afd_check(T21* C);
T0* r1633add_comment(T1633* C,T0* a1);
T6 r1633call_is_static(T1633* C);
T2 r1633to_integer(T1633* C);
T6 r1633use_current(T1633* C);
T0* r1633to_runnable(T1633* C,T0* a1);
T2 r1633compile_to_jvm_into(T1633* C,T0* a1);
void r1633cpc_to_runnable(T1633* C,T0* a1);
void r1633make_call0(T1633* C,T0* a1,T0* a2);
void r1633standard_compile_target_to_jvm(T1633* C);
void r1633compile_to_jvm_old(T1633* C);
T6 r1633can_be_dropped(T1633* C);
T0* r1633twin(T1633* C);
void r1633to_runnable_0(T1633* C,T0* a1);
T2 r1633jvm_standard_branch_if_false(T1633* C);
T6 r1633is_a(T1633* C,T0* a1);
void r1633error(T0* a1,T0* a2);
T2 r1633standard_compile_to_jvm_into(T1633* C,T0* a1);
T2 r1633jvm_standard_branch_if_true(T1633* C);
void r1633afd_check(T1633* C);
T0* r372start_position(T372* C);
T0* r372add_comment(T372* C,T0* a1);
T2 r372to_integer(T372* C);
T0* r372to_runnable(T372* C,T0* a1);
T2 r372compile_to_jvm_into(T0* a1);
extern int fBC372result_type;
extern T0*oBC372result_type;
T0* r372result_type(void);
T0* r372twin(T372* C);
T0* r372type_any(void);
T6 r372is_a(T372* C,T0* a1);
void r372error(T0* a1,T0* a2);
void r372make(T372* C,T0* a1,T0* a2);
void r372afd_check(T372* C);
void r722add_index_value(T722* C,T0* a1);
void r1189make(T1189* C,T0* a1,T0* a2);
void r22jvm_initialize_local(T2 a1);
T2 r22id(T22* C);
T0* r22to_runnable(T22* C,T0* a1);
void r22load_basic_features(T22* C);
T0* r22run_class(T22* C);
void r22make_runnable(T22* C,T0* a1,T0* a2);
T0* r22smallest_ancestor(T22* C,T0* a1);
T0* r22run_time_mark(T22* C);
T6 r22is_a(T22* C,T0* a1);
void r22error(T0* a1,T0* a2);
void r22make(T22* C,T0* a1,T0* a2);
T2 r22jvm_push_default(void);
T0* r22base_class(T22* C);
T6 r22is_a_in(T22* C,T0* a1,T0* a2);
T0* r22look_up_for(T22* C,T0* a1,T0* a2);
T0* r22twin(T22* C);
void r22jvm_descriptor_in(T22* C,T0* a1);
T0* r22type_any(void);
T6 r22is_run_type(T22* C);
void r22jvm_target_descriptor_in(T22* C,T0* a1);
T2 r22jvm_stack_space(void);
void r567jvm_initialize_local(T2 a1);
extern int fBC567used_as_reference;
void r567used_as_reference(void);
T0* r567to_runnable(T567* C,T0* a1);
T0* r567run_class(T567* C);
T0* r567smallest_ancestor(T567* C,T0* a1);
T0* r567run_time_mark(void);
T2 r567jvm_if_x_eq(void);
T6 r567is_a(T567* C,T0* a1);
T0* r567written_mark(void);
void r567error(T0* a1,T0* a2);
void r567make(T567* C,T0* a1);
T2 r567jvm_convert_to(T0* a1);
void r567fatal_error_generic_list(T567* C);
T2 r567jvm_push_default(void);
T0* r567generic_list(T567* C);
T0* r567base_class(T567* C);
T2 r567jvm_if_x_ne(void);
T6 r567is_a_in(T567* C,T0* a1,T0* a2);
T0* r567look_up_for(T567* C,T0* a1,T0* a2);
extern int fBC266type_double_ref;
extern T0*oBC266type_double_ref;
T0* r567type_double_ref(void);
T6 r567has_creation(T567* C,T0* a1);
void r567load_ref(T0* a1);
extern int fBC567check_type;
void r567check_type(T567* C);
T2 r567jvm_stack_space(void);
T0* r940start_position(T940* C);
T6 r940is_merge_with(T940* C,T0* a1,T0* a2);
void r940make_e_feature(T940* C,T0* a1,T0* a2);
void r940add_into(T940* C,T0* a1);
T6 r940can_hide(T940* C,T0* a1,T0* a2);
T0* r940try_to_undefine(T940* C,T0* a1,T0* a2);
T0* r940to_run_feature(T940* C,T0* a1,T0* a2);
T0* r940try_to_undefine_aux(T940* C,T0* a1,T0* a2);
void r940error(T0* a1,T0* a2);
void r940make(T940* C,T0* a1,T0* a2,T0* a3);
void r940collect_for(T2 a1);
T0* r1248start_position(T1248* C);
T6 r1248is_merge_with(T1248* C,T0* a1,T0* a2);
void r1248make_e_feature(T1248* C,T0* a1,T0* a2);
void r1248add_into(T1248* C,T0* a1);
T6 r1248can_hide(T1248* C,T0* a1,T0* a2);
T0* r1248try_to_undefine(T1248* C,T0* a1,T0* a2);
T0* r1248to_run_feature(T1248* C,T0* a1,T0* a2);
T0* r1248try_to_undefine_aux(T1248* C,T0* a1,T0* a2);
extern T0*oBC1248counter;
void r1248error(T0* a1,T0* a2);
void r1248make(T1248* C,T0* a1,T0* a2);
void r1248collect_for(T2 a1);
void r40routine_mapping_jvm(T40* C);
T6 r40use_current(T40* C);
void r40routine_afd_check(T40* C);
void r40std_compute_use_current(T40* C);
T0* r40run_class(T40* C);
T6 r40is_exported_in(T40* C,T0* a1);
void r40jvm_define_opening(T40* C);
void r40jvm_define_closing(T40* C);
void r40add_client(T40* C,T0* a1);
void r40make(T40* C,T0* a1,T0* a2,T0* a3);
void r40jvm_define(T40* C);
T0* r40clients(T40* C);
void r40fall_down(T40* C);
T6 r40is_pre_computable(T40* C);
T2 r40jvm_local_variable_offset(T40* C,T0* a1);
extern T0*oBC40frozen_general;
T2 r40arg_count(T40* C);
T2 r40jvm_argument_offset(T40* C,T0* a1);
void r40initialize(T40* C);
T6 r40can_be_dropped(T40* C);
T2 r40jvm_max_locals(T40* C);
void r40method_info_start(T40* C);
T2 r40jvm_result_offset(T40* C);
void r40routine_update_tmp_jvm_descriptor(T40* C);
T0* r40jvm_descriptor(T40* C);
void r357jvm_initialize_local(T2 a1);
extern int fBC357used_as_reference;
void r357used_as_reference(void);
T0* r357to_runnable(T357* C,T0* a1);
T0* r357run_class(T357* C);
T0* r357smallest_ancestor(T357* C,T0* a1);
T0* r357run_time_mark(void);
T2 r357jvm_if_x_eq(void);
T6 r357is_a(T357* C,T0* a1);
T0* r357written_mark(void);
void r357error(T0* a1,T0* a2);
void r357make(T357* C,T0* a1);
T2 r357jvm_convert_to(T0* a1);
void r357fatal_error_generic_list(T357* C);
T2 r357jvm_push_default(void);
T0* r357generic_list(T357* C);
T0* r357base_class(T357* C);
T2 r357jvm_if_x_ne(void);
T6 r357is_a_in(T357* C,T0* a1,T0* a2);
T0* r357look_up_for(T357* C,T0* a1,T0* a2);
T6 r357has_creation(T357* C,T0* a1);
extern int fBC266type_real_ref;
extern T0*oBC266type_real_ref;
T0* r357type_real_ref(void);
void r357load_ref(T0* a1);
extern int fBC357check_type;
void r357check_type(T357* C);
T2 r357jvm_stack_space(void);
void r1974get_started(T1974* C,T0* a1);
void r1789make(T1789* C,T0* a1,T0* a2);
T2 r1789index_of(T1789* C,T0* a1);
T0* r640start_position(T640* C);
T6 r640is_merge_with(T640* C,T0* a1,T0* a2);
void r640make_e_feature(T640* C,T0* a1,T0* a2);
void r640add_into(T640* C,T0* a1);
T6 r640can_hide(T640* C,T0* a1,T0* a2);
T0* r640try_to_undefine(T640* C,T0* a1,T0* a2);
T0* r640to_run_feature(T640* C,T0* a1,T0* a2);
T0* r640try_to_undefine_aux(T640* C,T0* a1,T0* a2);
void r640error(T0* a1,T0* a2);
void r640make(T640* C,T0* a1,T0* a2,T0* a3);
void r640collect_for(T2 a1);
void r11write_bytes(T11* C);
void r11append_u2(T0* a1,T2 a2);
void r11add(T11* C,T2 a1,T2 a2,T2 a3);
void r11clear(T11* C);
extern T0*oBC11storage;
void r24fe_c2jvm(T0* a1);
void r24jvm_mapping_procedure(T0* a1,T0* a2,T0* a3);
T6 r42use_current(T42* C);
extern T0*oBC42points1;
void r42compile_to_jvm(T42* C);
void r42afd_check(T42* C);
T0* r994add_comment(T994* C,T0* a1);
T2 r994to_integer(T994* C);
T6 r994use_current(T994* C);
T0* r994to_runnable(T994* C,T0* a1);
T2 r994compile_to_jvm_into(T994* C,T0* a1);
void r994cpc_to_runnable(T994* C,T0* a1);
void r994standard_compile_target_to_jvm(T994* C);
void r994compile_to_jvm_old(T994* C);
T0* r994twin(T994* C);
void r994to_runnable_0(T994* C,T0* a1);
T2 r994jvm_standard_branch_if_false(T994* C);
T6 r994is_a(T994* C,T0* a1);
void r994error(T0* a1,T0* a2);
void r994make(T994* C,T0* a1,T0* a2,T0* a3);
T2 r994standard_compile_to_jvm_into(T994* C,T0* a1);
void r994make_call_1(T994* C,T0* a1,T0* a2,T0* a3);
T0* r994operator(void);
T2 r994jvm_standard_branch_if_true(T994* C);
void r994afd_check(T994* C);
T0* r625add_comment(T625* C,T0* a1);
T2 r625to_integer(T625* C);
T2 r625jvm_branch_if_true(T625* C);
T0* r625to_runnable(T625* C,T0* a1);
T2 r625compile_to_jvm_into(T625* C,T0* a1);
void r625standard_compile_target_to_jvm(T625* C);
void r625compile_to_jvm_assignment(T625* C,T0* a1);
void r625make_runnable(T625* C,T0* a1,T0* a2,T0* a3);
void r625jvm_assign(T625* C);
T2 r625jvm_branch_if_false(T625* C);
void r625compile_to_jvm(T625* C);
T0* r625base_class_written(T625* C);
T0* r625written_in(T625* C);
T6 r625is_a(T625* C,T0* a1);
void r625name_clash_for(T625* C,T0* a1);
void r625error(T0* a1,T0* a2);
void r625make(T625* C,T0* a1,T0* a2);
T2 r625standard_compile_to_jvm_into(T625* C,T0* a1);
T0* r899clients_for(T899* C,T0* a1);
void r899make(T899* C,T0* a1,T0* a2);
T6 r879is_static(T879* C);
T0* r879add_comment(T879* C,T0* a1);
T2 r879to_integer(T879* C);
T6 r879use_current(T879* C);
T2 r879jvm_branch_if_true(T879* C);
T0* r879to_runnable(T879* C,T0* a1);
T2 r879compile_to_jvm_into(T879* C,T0* a1);
void r879cpc_to_runnable(T879* C,T0* a1);
void r879standard_compile_target_to_jvm(T879* C);
void r879compile_to_jvm_old(T879* C);
T2 r879jvm_branch_if_false(T879* C);
T0* r879twin(T879* C);
void r879to_runnable_0(T879* C,T0* a1);
T2 r879jvm_standard_branch_if_false(T879* C);
T6 r879is_a(T879* C,T0* a1);
void r879error(T0* a1,T0* a2);
void r879make(T879* C,T0* a1,T0* a2,T0* a3);
T2 r879standard_compile_to_jvm_into(T879* C,T0* a1);
void r879make_call_1(T879* C,T0* a1,T0* a2,T0* a3);
T0* r879operator(void);
T2 r879jvm_standard_branch_if_true(T879* C);
void r879afd_check(T879* C);
T6 r939is_static(T939* C);
T0* r939add_comment(T939* C,T0* a1);
T2 r939to_integer(T939* C);
T6 r939use_current(T939* C);
T2 r939jvm_branch_if_true(T939* C);
T0* r939to_runnable(T939* C,T0* a1);
T2 r939compile_to_jvm_into(T939* C,T0* a1);
void r939cpc_to_runnable(T939* C,T0* a1);
void r939standard_compile_target_to_jvm(T939* C);
void r939compile_to_jvm_old(T939* C);
T2 r939jvm_branch_if_false(T939* C);
T0* r939twin(T939* C);
void r939to_runnable_0(T939* C,T0* a1);
T2 r939jvm_standard_branch_if_false(T939* C);
T6 r939is_a(T939* C,T0* a1);
void r939error(T0* a1,T0* a2);
void r939make(T939* C,T0* a1,T0* a2,T0* a3);
T2 r939standard_compile_to_jvm_into(T939* C,T0* a1);
void r939make_call_1(T939* C,T0* a1,T0* a2,T0* a3);
T0* r939operator(void);
T2 r939jvm_standard_branch_if_true(T939* C);
void r939afd_check(T939* C);
T0* r1141twin(T1141* C);
T0* r1141runnable(T0* a1,T0* a2,T0* a3);
T6 r1141use_current(T1141* C);
T0* r1141to_runnable(T1141* C,T0* a1);
void r1141error(T0* a1,T0* a2);
void r1141make(T1141* C,T0* a1,T0* a2,T0* a3);
void r1141compile_to_jvm(T1141* C,T6 a1);
void r1141afd_check(T1141* C);
T0* r1678generic_list(T1678* C);
T0* r1678base_class(T1678* C);
T2 r1678jvm_if_x_ne(T1678* C);
T0* r1678base_class_name(T1678* C);
void r1678jvm_initialize_local(T1678* C,T2 a1);
T6 r1678is_a_in(T1678* C,T0* a1,T0* a2);
void r1678used_as_reference(T1678* C);
T6 r1678is_user_expanded(T1678* C);
T2 r1678id(T1678* C);
void r1678jvm_check_class_invariant(T1678* C);
T6 r1678is_pointer(T1678* C);
T0* r1678look_up_for(T1678* C,T0* a1,T0* a2);
T0* r1678to_runnable(T1678* C,T0* a1);
void r1678jvm_to_reference(T1678* C);
T0* r1678run_class(T1678* C);
T6 r1678has_creation(T1678* C,T0* a1);
T0* r1678expanded_initializer(T1678* C);
T2 r1678jvm_method_flags(T1678* C);
T6 r1678is_boolean(T1678* C);
T6 r1678is_generic(T1678* C);
void r1678jvm_xaload(T1678* C);
T6 r1678is_bit(T1678* C);
T6 r1678is_real(T1678* C);
void r1678jvm_write_local(T1678* C,T2 a1);
T6 r1678is_any(T1678* C);
T0* r1678smallest_ancestor(T1678* C,T0* a1);
T0* r1678run_time_mark(T1678* C);
T6 r1678is_expanded(T1678* C);
T2 r1678jvm_if_x_eq(T1678* C);
T6 r1678is_basic_eiffel_expanded(T1678* C);
void r1678jvm_xnewarray(T1678* C);
void r1678jvm_descriptor_in(T1678* C,T0* a1);
void r1678jvm_push_local(T1678* C,T2 a1);
T6 r1678is_string(T1678* C);
T6 r1678is_integer(T1678* C);
T6 r1678is_a(T1678* C,T0* a1);
T6 r1678is_reference(T1678* C);
T6 r1678is_character(T1678* C);
T0* r1678written_mark(void);
T2 r1678jvm_convert_to(T1678* C,T0* a1);
void r1678make(T1678* C,T0* a1,T0* a2);
T6 r1678is_none(T1678* C);
void r1678jvm_target_descriptor_in(T1678* C,T0* a1);
void r1678jvm_return_code(T1678* C);
T6 r1678is_array(T1678* C);
void r1678fatal_error_generic_list(T1678* C);
void r1678jvm_xastore(T1678* C);
T2 r1678jvm_push_default(T1678* C);
T6 r1678is_dummy_expanded(T1678* C);
T2 r1678jvm_stack_space(T1678* C);
T6 r1678is_double(T1678* C);
T0* r623jvm_root_class(void);
void r623jvm_initialize_local(T2 a1);
T2 r623id(T623* C);
T0* r623to_runnable(T623* C,T0* a1);
void r623load_basic_features(T623* C);
T0* r623run_class(T623* C);
void r623standard_jvm_check_class_invariant(T623* C);
void r623make_runnable(T623* C,T0* a1,T0* a2);
T0* r623smallest_ancestor(T623* C,T0* a1);
T0* r623run_time_mark(T623* C);
T6 r623is_a(T623* C,T0* a1);
void r623error(T0* a1,T0* a2);
void r623make(T623* C,T0* a1,T0* a2);
T2 r623jvm_push_default(void);
T0* r623base_class(T623* C);
T6 r623is_a_in(T623* C,T0* a1,T0* a2);
T0* r623look_up_for(T623* C,T0* a1,T0* a2);
T6 r623has_creation(T623* C,T0* a1);
T0* r623jvm_root_descriptor(void);
T0* r623twin(T623* C);
T6 r623is_run_type(T623* C);
extern T0*oBC623tmp_written_mark;
T2 r623jvm_stack_space(void);
T0* r1038add_comment(T1038* C,T0* a1);
T2 r1038to_integer(T1038* C);
T0* r1038to_runnable(T1038* C,T0* a1);
T2 r1038compile_to_jvm_into(T1038* C,T0* a1);
extern int fBC1038result_type;
extern T0*oBC1038result_type;
T0* r1038result_type(void);
T0* r1038twin(T1038* C);
T2 r1038isa_dca_inline_argument(void);
T6 r1038is_a(T1038* C,T0* a1);
void r1038error(T0* a1,T0* a2);
void r1038make(T1038* C,T0* a1,T0* a2);
T2 r1038standard_compile_to_jvm_into(T1038* C,T0* a1);
T0* r636add_comment(T636* C,T0* a1);
T2 r636to_integer(T636* C);
T2 r636jvm_branch_if_true(T636* C);
T0* r636to_runnable(T636* C,T0* a1);
T2 r636compile_to_jvm_into(T636* C,T0* a1);
void r636standard_compile_target_to_jvm(T636* C);
void r636compile_to_jvm_assignment(T636* C,T0* a1);
void r636make_runnable(T636* C,T0* a1,T0* a2,T0* a3);
void r636jvm_assign(T636* C);
T2 r636jvm_branch_if_false(T636* C);
void r636compile_to_jvm(T636* C);
T6 r636is_a(T636* C,T0* a1);
void r636refer_to(T636* C,T0* a1,T0* a2,T2 a3);
void r636error(T0* a1,T0* a2);
T2 r636standard_compile_to_jvm_into(T636* C,T0* a1);
void r1107fall_down(T1107* C);
void r1107routine_mapping_jvm(T1107* C);
T6 r1107use_current(T1107* C);
void r1107mapping_jvm(T1107* C);
void r1107routine_afd_check(T1107* C);
void r1107std_compute_use_current(T1107* C);
T0* r1107run_class(T1107* C);
T2 r1107jvm_local_variable_offset(T1107* C,T0* a1);
T2 r1107arg_count(T1107* C);
T6 r1107is_exported_in(T1107* C,T0* a1);
T2 r1107jvm_argument_offset(T1107* C,T0* a1);
void r1107initialize(T1107* C);
T2 r1107jvm_max_locals(T1107* C);
void r1107jvm_opening(T1107* C);
void r1107jvm_define_opening(T1107* C);
void r1107jvm_define_closing(T1107* C);
void r1107add_client(T1107* C,T0* a1);
void r1107compute_use_current(T1107* C);
void r1107method_info_start(T1107* C);
void r1107make(T1107* C,T0* a1,T0* a2,T0* a3);
void r1107jvm_define(T1107* C);
T2 r1107jvm_result_offset(T1107* C);
void r1107routine_update_tmp_jvm_descriptor(T1107* C);
void r1107jvm_field_or_method(T1107* C);
void r1107jvm_closing(T1107* C);
T0* r1107clients(T1107* C);
T0* r1107jvm_descriptor(T1107* C);
T0* r510add_comment(T510* C,T0* a1);
T2 r510to_integer(T510* C);
T2 r510jvm_branch_if_true(T510* C);
T0* r510to_runnable(T510* C,T0* a1);
T2 r510compile_to_jvm_into(T510* C,T0* a1);
void r510standard_compile_target_to_jvm(T510* C);
void r510compile_to_jvm_assignment(T510* C,T0* a1);
void r510jvm_assign(T510* C);
T2 r510jvm_branch_if_false(T510* C);
void r510compile_to_jvm(T510* C);
T6 r510is_a(T510* C,T0* a1);
void r510error(T0* a1,T0* a2);
void r510make(T510* C,T0* a1);
T2 r510standard_compile_to_jvm_into(T510* C,T0* a1);
T0* r614jvm_root_class(void);
void r614jvm_initialize_local(T614* C,T2 a1);
void r614used_as_reference(T614* C);
T6 r614is_user_expanded(T614* C);
T2 r614id(T614* C);
T0* r614to_runnable(T614* C,T0* a1);
T0* r614run_class(T614* C);
void r614standard_jvm_check_class_invariant(T614* C);
void r614make_runnable(T614* C,T0* a1,T0* a2);
void r614jvm_write_local(T614* C,T2 a1);
T0* r614smallest_ancestor(T614* C,T0* a1);
T0* r614run_time_mark(T614* C);
T6 r614is_expanded(T614* C);
void r614jvm_push_local(T614* C,T2 a1);
T6 r614is_a(T614* C,T0* a1);
extern T0*oBC614tmp_mark;
void r614make(T614* C,T0* a1,T0* a2);
T2 r614jvm_push_default(T614* C);
T6 r614is_dummy_expanded(T614* C);
T0* r614base_class(T614* C);
T6 r614is_a_in(T614* C,T0* a1,T0* a2);
T0* r614look_up_for(T614* C,T0* a1,T0* a2);
T0* r614run_type(T614* C);
T6 r614has_creation(T614* C,T0* a1);
void r614basic_checks(T614* C);
T0* r614expanded_initializer(T614* C);
T2 r614jvm_method_flags(T614* C);
T0* r614jvm_root_descriptor(void);
T0* r614twin(T614* C);
T6 r614is_written_runnable(T614* C);
void r614jvm_descriptor_in(T614* C,T0* a1);
T0* r614type_any(void);
T6 r614is_run_type(T614* C);
T6 r614is_reference(T614* C);
void r614jvm_target_descriptor_in(T614* C,T0* a1);
void r614jvm_return_code(T614* C);
T2 r614jvm_stack_space(void);
T0* r773jvm_root_class(void);
void r773jvm_initialize_local(T2 a1);
T0* r773to_runnable(T773* C,T0* a1);
T0* r773run_class(T773* C);
void r773standard_jvm_check_class_invariant(T773* C);
T0* r773smallest_ancestor(T773* C,T0* a1);
T0* r773run_time_mark(void);
T6 r773is_a(T773* C,T0* a1);
T0* r773written_mark(void);
void r773error(T0* a1,T0* a2);
void r773make(T773* C,T0* a1);
void r773fatal_error_generic_list(T773* C);
T2 r773jvm_push_default(void);
T0* r773generic_list(T773* C);
T0* r773base_class(T773* C);
T6 r773is_a_in(T773* C,T0* a1,T0* a2);
T0* r773look_up_for(T773* C,T0* a1,T0* a2);
T6 r773has_creation(T773* C,T0* a1);
T0* r773jvm_root_descriptor(void);
extern int fBC773check_type;
void r773check_type(T773* C);
T2 r773jvm_stack_space(void);
void r639jvm_initialize_local(T2 a1);
extern int fBC639used_as_reference;
void r639used_as_reference(void);
T0* r639to_runnable(T639* C,T0* a1);
T0* r639run_class(T639* C);
T0* r639smallest_ancestor(T639* C,T0* a1);
T0* r639run_time_mark(void);
extern int fBC266type_boolean_ref;
extern T0*oBC266type_boolean_ref;
T0* r639type_boolean_ref(void);
T6 r639is_a(T639* C,T0* a1);
T0* r639written_mark(void);
void r639error(T0* a1,T0* a2);
void r639make(T639* C,T0* a1);
T2 r639jvm_convert_to(T0* a1);
void r639fatal_error_generic_list(T639* C);
T2 r639jvm_push_default(void);
T0* r639generic_list(T639* C);
T0* r639base_class(T639* C);
T6 r639is_a_in(T639* C,T0* a1,T0* a2);
T0* r639look_up_for(T639* C,T0* a1,T0* a2);
T6 r639has_creation(T639* C,T0* a1);
void r639load_ref(T0* a1);
extern int fBC639check_type;
void r639check_type(T639* C);
T2 r639jvm_stack_space(void);
void r1243fe_c2jvm(T0* a1);
extern T0*oBC1373ms_list;
void r1373add_last(T0* a1);
T6 r1373not_dummy(T0* a1);
extern T0*oBC1373dummy_ms_list;
T0* r436add_comment(T436* C,T0* a1);
T0* r436to_runnable(T436* C,T0* a1);
void r436compile_to_jvm(T436* C);
void r10put_string(T10* C,T0* a1);
extern T0*oBC1070tmp_string;
void r10put_integer(T10* C,T2 a1);
void r1867fe_c2jvm(T0* a1);
T6 r1653is_static(T1653* C);
T0* r1653add_comment(T1653* C,T0* a1);
T2 r1653to_integer(T1653* C);
T6 r1653use_current(T1653* C);
T0* r1653to_runnable(T1653* C,T0* a1);
T2 r1653compile_to_jvm_into(T1653* C,T0* a1);
void r1653cpc_to_runnable(T1653* C,T0* a1);
void r1653standard_compile_target_to_jvm(T1653* C);
void r1653compile_to_jvm_old(T1653* C);
T0* r1653twin(T1653* C);
void r1653to_runnable_0(T1653* C,T0* a1);
T2 r1653jvm_standard_branch_if_false(T1653* C);
T6 r1653is_a(T1653* C,T0* a1);
void r1653error(T0* a1,T0* a2);
void r1653make(T1653* C,T0* a1,T0* a2,T0* a3);
T2 r1653standard_compile_to_jvm_into(T1653* C,T0* a1);
void r1653make_call_1(T1653* C,T0* a1,T0* a2,T0* a3);
T2 r1653jvm_standard_branch_if_true(T1653* C);
void r1653afd_check(T1653* C);
T6 r43is_static(T43* C);
void r43routine_mapping_jvm(T43* C);
T2 r43integer_value(T43* C,T0* a1);
T6 r43use_current(T43* C);
void r43mapping_jvm(T43* C);
void r43routine_afd_check(T43* C);
void r43std_compute_use_current(T43* C);
T0* r43run_class(T43* C);
T6 r43is_exported_in(T43* C,T0* a1);
void r43jvm_opening(T43* C);
void r43jvm_define_opening(T43* C);
void r43jvm_define_closing(T43* C);
void r43add_client(T43* C,T0* a1);
void r43make(T43* C,T0* a1,T0* a2,T0* a3);
void r43jvm_define(T43* C);
T0* r43clients(T43* C);
T0* r43type_string(void);
void r43fall_down(T43* C);
T2 r43jvm_local_variable_offset(T43* C,T0* a1);
T2 r43arg_count(T43* C);
T2 r43jvm_argument_offset(T43* C,T0* a1);
void r43initialize(T43* C);
T2 r43jvm_max_locals(T43* C);
void r43compute_use_current(T43* C);
void r43jvm_closing_fast(T43* C);
void r43method_info_start(T43* C);
T2 r43jvm_result_offset(T43* C);
void r43routine_update_tmp_jvm_descriptor(T43* C);
void r43jvm_field_or_method(T43* C);
void r43jvm_closing(T43* C);
T0* r43jvm_descriptor(T43* C);
T0* r1695jvm_root_class(void);
void r1695prepare_descriptor(T0* a1);
T2 r1695idx_name_for_result(T0* a1);
void r1695add_procedure(T0* a1);
void r1695prepare_result(T0* a1);
extern T0*oBC1695procedure_list;
void r1695jvm_define_fields(T1695* C);
void r1695prepare_flag(T0* a1);
extern T0*oBC1695descriptor_string;
extern T0*oBC1695flag_string;
extern T0*oBC1695result_string;
T2 r1695idx_name_for_flag(T0* a1);
T2 r1695idx_fieldref_for_flag(T0* a1);
void r1695add_function(T0* a1);
extern T0*oBC1695flag_list;
T2 r1695idx_descriptor(T0* a1);
T2 r1695idx_fieldref_for_result(T0* a1);
extern T0*oBC1695function_list;
T0* r1695jvm_root_descriptor(void);
void r1375anchor_cycle_start(T1375* C);
void r1375anchor_cycle_end(T1375* C);
void r1375jvm_initialize_local(T1375* C,T2 a1);
void r1375used_as_reference(T1375* C);
T2 r1375id(T1375* C);
T6 r1375is_user_expanded(T1375* C);
void r1375jvm_check_class_invariant(T1375* C);
T6 r1375is_pointer(T1375* C);
T0* r1375to_runnable(T1375* C,T0* a1);
T0* r1375run_class(T1375* C);
T6 r1375is_bit(T1375* C);
extern T0*oBC712visited;
void r1375jvm_write_local(T1375* C,T2 a1);
T0* r1375smallest_ancestor(T1375* C,T0* a1);
T0* r1375ultimate_run_type(T1375* C,T0* a1);
T0* r1375run_time_mark(T1375* C);
T6 r1375is_expanded(T1375* C);
T2 r1375jvm_if_x_eq(T1375* C);
void r1375jvm_xnewarray(T1375* C);
void r1375jvm_push_local(T1375* C,T2 a1);
T6 r1375is_a(T1375* C,T0* a1);
T6 r1375is_character(T1375* C);
void r1375error(T0* a1,T0* a2);
void r1375make(T1375* C,T0* a1,T0* a2);
T2 r1375jvm_convert_to(T1375* C,T0* a1);
void r1375fatal_error_generic_list(T1375* C);
T6 r1375is_array(T1375* C);
T2 r1375jvm_push_default(T1375* C);
T6 r1375is_dummy_expanded(T1375* C);
T0* r1375generic_list(T1375* C);
T0* r1375base_class(T1375* C);
T2 r1375jvm_if_x_ne(T1375* C);
T0* r1375base_class_name(T1375* C);
T6 r1375is_a_in(T1375* C,T0* a1,T0* a2);
T0* r1375look_up_for(T1375* C,T0* a1,T0* a2);
void r1375jvm_to_reference(T1375* C);
T6 r1375has_creation(T1375* C,T0* a1);
T0* r1375expanded_initializer(T1375* C);
T2 r1375jvm_method_flags(T1375* C);
T6 r1375is_boolean(T1375* C);
T6 r1375is_generic(T1375* C);
void r1375jvm_xaload(T1375* C);
T6 r1375is_real(T1375* C);
T6 r1375is_any(T1375* C);
T0* r1375twin(T1375* C);
T6 r1375is_basic_eiffel_expanded(T1375* C);
void r1375jvm_descriptor_in(T1375* C,T0* a1);
T6 r1375is_string(T1375* C);
T6 r1375is_integer(T1375* C);
T6 r1375is_reference(T1375* C);
extern T0*oBC712tmp_written_mark;
T6 r1375is_none(T1375* C);
void r1375jvm_target_descriptor_in(T1375* C,T0* a1);
void r1375jvm_return_code(T1375* C);
void r1375jvm_xastore(T1375* C);
T2 r1375jvm_stack_space(T1375* C);
T6 r1375is_double(T1375* C);
T2 r1584idx_methodref(T0* a1);
void r1584jvm_mapping_function(T0* a1,T0* a2,T0* a3);
T6 r1562is_static(T1562* C);
T0* r1562add_comment(T1562* C,T0* a1);
T2 r1562to_integer(T1562* C);
T6 r1562use_current(T1562* C);
T0* r1562to_runnable(T1562* C,T0* a1);
T2 r1562compile_to_jvm_into(T1562* C,T0* a1);
void r1562cpc_to_runnable(T1562* C,T0* a1);
void r1562standard_compile_target_to_jvm(T1562* C);
void r1562compile_to_jvm_old(T1562* C);
T0* r1562twin(T1562* C);
void r1562to_runnable_0(T1562* C,T0* a1);
T2 r1562jvm_standard_branch_if_false(T1562* C);
T6 r1562is_a(T1562* C,T0* a1);
void r1562error(T0* a1,T0* a2);
void r1562make(T1562* C,T0* a1,T0* a2,T0* a3);
T2 r1562standard_compile_to_jvm_into(T1562* C,T0* a1);
void r1562make_call_1(T1562* C,T0* a1,T0* a2,T0* a3);
T0* r1562operator(void);
T2 r1562jvm_standard_branch_if_true(T1562* C);
void r1562afd_check(T1562* C);
T0* r573start_position(T573* C);
T0* r573add_comment(T573* C,T0* a1);
T6 r573use_current(T573* C);
T0* r573to_runnable(T573* C,T0* a1);
void r573to_runnable_0(T573* C,T0* a1);
void r573cpc_to_runnable(T573* C,T0* a1);
T0* r573current_type(T573* C);
void r573error(T0* a1,T0* a2);
void r573make(T573* C,T0* a1,T0* a2);
T0* r573make_runnable(T573* C,T0* a1,T0* a2,T0* a3,T0* a4);
void r573afd_check(T573* C);
void r1735anchor_cycle_start(T1735* C);
void r1735anchor_cycle_end(T1735* C);
void r1735jvm_initialize_local(T1735* C,T2 a1);
void r1735used_as_reference(T1735* C);
T6 r1735is_user_expanded(T1735* C);
T2 r1735id(T1735* C);
void r1735jvm_check_class_invariant(T1735* C);
T6 r1735is_pointer(T1735* C);
T0* r1735to_runnable(T1735* C,T0* a1);
T0* r1735run_class(T1735* C);
T6 r1735is_bit(T1735* C);
void r1735jvm_write_local(T1735* C,T2 a1);
T0* r1735smallest_ancestor(T1735* C,T0* a1);
T0* r1735ultimate_run_type(T1735* C,T0* a1);
T0* r1735run_time_mark(T1735* C);
T6 r1735is_expanded(T1735* C);
T2 r1735jvm_if_x_eq(T1735* C);
void r1735jvm_xnewarray(T1735* C);
void r1735jvm_push_local(T1735* C,T2 a1);
T6 r1735is_a(T1735* C,T0* a1);
T6 r1735is_character(T1735* C);
void r1735error(T0* a1,T0* a2);
void r1735make(T1735* C,T0* a1,T0* a2);
T2 r1735jvm_convert_to(T1735* C,T0* a1);
void r1735fatal_error_generic_list(T1735* C);
T6 r1735is_array(T1735* C);
T2 r1735jvm_push_default(T1735* C);
T6 r1735is_dummy_expanded(T1735* C);
T0* r1735generic_list(T1735* C);
T0* r1735base_class(T1735* C);
T2 r1735jvm_if_x_ne(T1735* C);
T0* r1735base_class_name(T1735* C);
T6 r1735is_a_in(T1735* C,T0* a1,T0* a2);
T0* r1735look_up_for(T1735* C,T0* a1,T0* a2);
void r1735jvm_to_reference(T1735* C);
T6 r1735has_creation(T1735* C,T0* a1);
T0* r1735expanded_initializer(T1735* C);
T2 r1735jvm_method_flags(T1735* C);
T6 r1735is_boolean(T1735* C);
T6 r1735is_generic(T1735* C);
void r1735jvm_xaload(T1735* C);
T6 r1735is_real(T1735* C);
T6 r1735is_any(T1735* C);
T0* r1735twin(T1735* C);
T6 r1735is_basic_eiffel_expanded(T1735* C);
void r1735jvm_descriptor_in(T1735* C,T0* a1);
T6 r1735is_string(T1735* C);
T6 r1735is_integer(T1735* C);
T6 r1735is_reference(T1735* C);
T6 r1735is_none(T1735* C);
void r1735jvm_target_descriptor_in(T1735* C,T0* a1);
void r1735jvm_return_code(T1735* C);
void r1735jvm_xastore(T1735* C);
T2 r1735jvm_stack_space(T1735* C);
T6 r1735is_double(T1735* C);
T0* r1230start_position(T1230* C);
T6 r1230is_merge_with(T1230* C,T0* a1,T0* a2);
void r1230make_e_feature(T1230* C,T0* a1,T0* a2);
void r1230add_into(T1230* C,T0* a1);
T6 r1230can_hide(T1230* C,T0* a1,T0* a2);
T0* r1230try_to_undefine(T1230* C,T0* a1,T0* a2);
T0* r1230to_run_feature(T1230* C,T0* a1,T0* a2);
T0* r1230try_to_undefine_aux(T1230* C,T0* a1,T0* a2);
void r1230error(T0* a1,T0* a2);
void r1230make(T1230* C,T0* a1,T0* a2,T0* a3);
void r1230collect_for(T2 a1);
extern T0*oBC1094tmp_info;
T2 r1094idx_fieldref5(T1094* C,T2 a1,T2 a2,T2 a3);
T0* r1094jvm_root_class(void);
T2 r1094idx_string2(T1094* C,T0* a1);
T2 r1094idx_eiffel_string_storage_fieldref(T1094* C);
T2 r1094idx_eiffel_string_class(T1094* C);
T2 r1094idx_fieldref(T1094* C,T0* a1);
void r1094string_to_uft8(T0* a1,T0* a2);
T0* r1094add_last(T1094* C);
T2 r1094idx_fieldref4(T1094* C,T2 a1,T0* a2,T0* a3);
void r1094write_bytes(T1094* C);
T2 r1094idx_name_and_type3(T1094* C,T2 a1,T2 a2);
extern T0*oBC1094tmp_uft8;
extern T0*oBC1094cp;
T2 r1094idx_fieldref3(T1094* C,T0* a1,T0* a2,T0* a3);
T2 r1094idx_name_and_type(T1094* C,T0* a1);
T2 r1094idx_string(T1094* C,T0* a1);
T2 r1094idx_eiffel_string_count_fieldref(T1094* C);
T2 r1094idx_fieldref2(T1094* C,T2 a1,T2 a2);
T2 r1094idx_name_and_type2(T1094* C,T0* a1,T0* a2);
T2 r1094idx_eiffel_string_capacity_fieldref(T1094* C);
T2 r1094idx_methodref(T1094* C,T0* a1);
T2 r1094idx_eiffel_string_descriptor(T1094* C);
T2 r1094idx_uft8(T1094* C,T0* a1);
T2 r1094idx_methodref1(T1094* C,T2 a1,T0* a2,T0* a3);
T2 r1094idx_methodref2(T1094* C,T2 a1,T2 a2);
T2 r1094idx_fieldref_generating_type(T1094* C,T2 a1);
T2 r1094idx_methodref3(T1094* C,T0* a1,T0* a2,T0* a3);
void r1094append_u2(T0* a1,T2 a2);
T2 r1094idx_name_and_type1(T1094* C,T0* a1,T2 a2);
extern int fBC1094jvm_string_class;
extern T0*oBC1094jvm_string_class;
T0* r1094jvm_string_class(void);
T2 r1094idx_fieldref_for_manifest_string(T1094* C,T0* a1);
T2 r1094idx_class2(T1094* C,T0* a1);
extern int fBC1094jvm_string_descriptor;
extern T0*oBC1094jvm_string_descriptor;
T0* r1094jvm_string_descriptor(void);
T2 r1094idx_fieldref_generator(T1094* C,T2 a1);
void r1094clear(T1094* C);
T0* r1137add_comment(T1137* C,T0* a1);
T2 r1137to_integer(T1137* C);
T6 r1137use_current(T1137* C);
T0* r1137to_runnable(T1137* C,T0* a1);
T2 r1137compile_to_jvm_into(T1137* C,T0* a1);
T6 r1137is_pre_computable(T1137* C);
T0* r1137sd(T0* a1);
void r1137compile_to_jvm_old(T1137* C);
void r1137compile_to_jvm(T1137* C);
void r1137compile_target_to_jvm(T1137* C);
T0* r1137type_any(void);
T6 r1137is_a(T1137* C,T0* a1);
void r1137error(T0* a1,T0* a2);
void r1137make(T1137* C,T0* a1,T0* a2);
extern T0*oBC1137tmp_string;
void r1137afd_check(T1137* C);
T0* r1564run_require(T0* a1);
void r1564set_rescue_compound(T1564* C,T0* a1);
T0* r1564start_position(T1564* C);
T6 r1564is_merge_with(T1564* C,T0* a1,T0* a2);
T0* r1564runnable(T0* a1,T0* a2,T0* a3);
void r1564make_e_feature(T1564* C,T0* a1,T0* a2);
void r1564add_into(T1564* C,T0* a1);
T6 r1564can_hide(T1564* C,T0* a1,T0* a2);
T0* r1564run_ensure(T0* a1);
void r1564check_obsolete(T1564* C);
T0* r1564try_to_undefine(T1564* C,T0* a1,T0* a2);
void r1564make_routine(T1564* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T0* r1564to_run_feature(T1564* C,T0* a1,T0* a2);
void r1564warning(T0* a1,T0* a2);
void r1564error(T0* a1,T0* a2);
void r1564make(T1564* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6);
void r1564collect_for(T1564* C,T2 a1);
void r1564from_effective(T1564* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6);
void r1564set_header_comment(T1564* C,T0* a1);
T6 r1358use_current(T0* a1);
void r1358jvm_mapping_procedure(T0* a1,T0* a2,T0* a3);
void r1358jvm_se_string2double(T0* a1);
void r1358jvm_define_function(T0* a1,T0* a2,T0* a3);
void r1358jvm_mapping_bit_procedure(T0* a1,T0* a2);
void r1358jvm_standard_twin_aux(T0* a1,T0* a2);
void r1358fe_nyi(T0* a1);
void r1358jvm_standard_is_equal(T0* a1);
void r1358jvm_sfr_open(T0* a1);
void r1358jvm_sfw_open(T0* a1);
void r1358jvm_add_method_for_function(T0* a1,T0* a2,T0* a3);
void r1358jvm_object_size(T0* a1);
void r1358jvm_mapping_integer_function(T0* a1,T0* a2);
T6 r1358native_array(T0* a1);
void r1358jvm_mapping_native_array_procedure(T0* a1,T0* a2);
void r1358jvm_bit_to_int(T2 a1);
void r1358jvm_mapping_real_function(T0* a1,T0* a2);
void r1358jvm_int_to_bit(T0* a1,T2 a2);
void r1358jvm_mapping_function(T0* a1,T0* a2,T0* a3);
void r1358jvm_mapping_native_array_function(T0* a1,T0* a2);
void r1358jvm_copy(T0* a1);
void r1358jvm_define_se_remove(T0* a1);
void r1358jvm_define_se_rename(T0* a1);
void r1358jvm_define_procedure(T0* a1,T0* a2,T0* a3);
void r1358jvm_standard_twin(T0* a1);
void r1358jvm_mapping_bit_function(T0* a1,T0* a2);
void r1358jvm_add_method_for_procedure(T0* a1,T0* a2,T0* a3);
void r1358jvm_mapping_double_function(T0* a1,T0* a2);
void r1358jvm_standard_is_equal_aux(T0* a1,T0* a2);
void r1358jvm_define_twin(T0* a1,T0* a2,T0* a3);
void r1358jvm_define_sprintf_double(T0* a1);
T6 r1106has(T1106* C,T0* a1);
T0* r1106expanded_initializer(T1106* C,T0* a1);
void r1106make(T1106* C,T0* a1,T0* a2,T0* a3,T0* a4);
void r1106check_expanded_with(T1106* C,T0* a1);
T0* r707to_runnable_integer(T707* C,T0* a1);
T0* r707start_position(T707* C);
T0* r707twin(T707* C);
void r707error(T0* a1,T0* a2);
T0* r707to_runnable_character(T707* C,T0* a1);
T0* r251start_position(T251* C);
T0* r251add_comment(T251* C,T0* a1);
T6 r251call_is_static(T251* C);
T2 r251to_integer(T251* C);
T6 r251use_current(T251* C);
T0* r251to_runnable(T251* C,T0* a1);
T2 r251compile_to_jvm_into(T251* C,T0* a1);
void r251cpc_to_runnable(T251* C,T0* a1);
void r251standard_compile_target_to_jvm(T251* C);
void r251compile_to_jvm_old(T251* C);
T0* r251twin(T251* C);
void r251to_runnable_0(T251* C,T0* a1);
T2 r251jvm_standard_branch_if_false(T251* C);
T6 r251is_a(T251* C,T0* a1);
void r251error(T0* a1,T0* a2);
void r251make(T251* C,T0* a1,T0* a2,T0* a3);
T2 r251standard_compile_to_jvm_into(T251* C,T0* a1);
T2 r251jvm_standard_branch_if_true(T251* C);
void r251afd_check(T251* C);
T6 r245is_static(T245* C);
T0* r245start_position(T245* C);
T0* r245add_comment(T245* C,T0* a1);
T6 r245call_is_static(T245* C);
T2 r245to_integer(T245* C);
T6 r245use_current(T245* C);
T0* r245to_runnable(T245* C,T0* a1);
T2 r245compile_to_jvm_into(T245* C,T0* a1);
void r245cpc_to_runnable(T245* C,T0* a1);
T6 r245is_pre_computable(T245* C);
void r245standard_compile_target_to_jvm(T245* C);
void r245compile_to_jvm_old(T245* C);
void r245compile_to_jvm(T245* C);
T6 r245can_be_dropped(T245* C);
T0* r245twin(T245* C);
void r245to_runnable_0(T245* C,T0* a1);
T2 r245jvm_standard_branch_if_false(T245* C);
T6 r245is_a(T245* C,T0* a1);
void r245error(T0* a1,T0* a2);
void r245make(T245* C,T0* a1,T0* a2);
T2 r245standard_compile_to_jvm_into(T245* C,T0* a1);
T2 r245jvm_standard_branch_if_true(T245* C);
void r245afd_check(T245* C);
T0* r1160start_position(T1160* C);
T0* r1160get_clause(T1160* C,T0* a1);
T0* r1160expanded_initializer(T1160* C,T0* a1);
void r1160check_expanded_with(T1160* C,T0* a1);
void r478jvm_expanded_write_local(T478* C,T2 a1);
T0* r478jvm_root_class(void);
T2 r478jvm_expanded_if_x_eq(T478* C);
T0* r478unqualified_name(T478* C);
void r478used_as_reference(T478* C);
T0* r478get_rf(T478* C,T0* a1);
extern T0*oBC478to_reference_memory;
T0* r478get_feature(T478* C,T0* a1);
void r478jvm_check_class_invariant(T478* C);
T0* r478writable_attributes(T478* C);
extern int fBC266class_general;
extern T0*oBC266class_general;
T0* r478class_general(void);
T0* r478at(T478* C,T0* a1);
extern T0*oBC478ci_collector;
T6 r478gt(T0* a1,T0* a2);
T0* r478get_copy(T478* C);
void r478runnable_class_invariant(T478* C);
void r478jvm_expanded_push_default(T478* C);
void r478set_at_run_time(T478* C);
T0* r478get_rf_with(T478* C,T0* a1);
void r478jvm_expanded_push_local(T478* C,T2 a1);
T0* r478class_with(T0* a1);
void r478add_running(T478* C,T0* a1);
void r478add_client(T478* C,T0* a1);
void r478error(T0* a1,T0* a2);
void r478make(T478* C,T0* a1);
extern int fBC266id_provider;
extern T0*oBC266id_provider;
T0* r478id_provider(void);
void r478efnf(T478* C,T0* a1,T0* a2);
void r478jvm_push_default(T478* C);
extern T0*oBC478tmp_string;
void r478afd_check(T478* C);
void r478jvm_expanded_descriptor_in(T478* C,T0* a1);
void r478jvm_expanded_return_code(T478* C);
T0* r478get_feature_with(T478* C,T0* a1);
T0* r478base_class(T478* C);
void r478jvm_expanded_xastore(T478* C);
T2 r478jvm_expanded_if_x_ne(T478* C);
T0* r478get_or_fatal_error(T478* C,T0* a1);
T0* r478runnable(T0* a1,T0* a2,T0* a3);
void r478jvm_invoke(T478* C,T2 a1,T2 a2);
extern T0*oBC478ucpn;
T0* r478dynamic(T478* C,T0* a1);
void r478compile_to_jvm(T478* C);
T0* r478jvm_root_descriptor(void);
void r478store_feature(T478* C,T0* a1);
T2 r478fully_qualified_constant_pool_index(T478* C);
T6 r478is_running_of(T478* C,T0* a1);
void r478jvm_expanded_xaload(T478* C);
T0* r478fully_qualified_name(T478* C);
void r478sort_wam(T0* a1);
void r478falling_down(T478* C);
void r478jvm_define_class_invariant(T478* C);
T0* r580add_comment(T580* C,T0* a1);
T2 r580to_integer(T580* C);
T2 r580jvm_branch_if_true(T580* C);
T0* r580to_runnable(T580* C,T0* a1);
T2 r580compile_to_jvm_into(T580* C,T0* a1);
void r580standard_compile_target_to_jvm(T580* C);
T2 r580jvm_branch_if_false(T580* C);
void r580compile_to_jvm(T580* C);
void r580compile_target_to_jvm(T580* C);
T6 r580is_a(T580* C,T0* a1);
void r580error(T0* a1,T0* a2);
void r580make(T580* C,T0* a1,T6 a2);
T2 r580standard_compile_to_jvm_into(T580* C,T0* a1);
T0* r475twin(T475* C);
void r475add_when(T475* C,T0* a1);
T0* r475add_comment(T475* C,T0* a1);
void r475set_else_compound(T475* C,T0* a1,T0* a2);
T6 r475use_current(T475* C);
T0* r475to_runnable(T475* C,T0* a1);
T0* r475current_type(T475* C);
void r475error(T0* a1,T0* a2);
void r475make(T475* C,T0* a1,T0* a2);
void r475compile_to_jvm(T475* C);
void r475afd_check(T475* C);
T0* r1149add_comment(T1149* C,T0* a1);
T2 r1149to_integer(T1149* C);
T2 r1149jvm_branch_if_true(T1149* C);
T0* r1149to_runnable(T1149* C,T0* a1);
T2 r1149compile_to_jvm_into(T1149* C,T0* a1);
void r1149standard_compile_target_to_jvm(T1149* C);
void r1149make_runnable(T1149* C,T0* a1,T0* a2,T0* a3);
T2 r1149jvm_branch_if_false(T1149* C);
void r1149compile_to_jvm(T1149* C);
T0* r1149base_class_written(T1149* C);
T0* r1149written_in(T1149* C);
T6 r1149is_a(T1149* C,T0* a1);
void r1149name_clash_for(T1149* C,T0* a1);
void r1149error(T0* a1,T0* a2);
void r1149make(T1149* C,T0* a1,T0* a2);
T2 r1149standard_compile_to_jvm_into(T1149* C,T0* a1);
T0* r584start_position(T584* C);
T0* r584add_comment(T584* C,T0* a1);
T6 r584use_current(T584* C);
T0* r584to_runnable(T584* C,T0* a1);
void r584cpc_to_runnable(T584* C,T0* a1);
T6 r584standard_use_current(T584* C);
T0* r584make_runnable(T584* C,T0* a1,T0* a2,T0* a3,T0* a4);
void r584compile_to_jvm(T584* C);
void r584to_runnable_0(T584* C,T0* a1);
T0* r584current_type(T584* C);
void r584error(T0* a1,T0* a2);
void r584make(T584* C,T0* a1,T0* a2,T0* a3);
void r584afd_check(T584* C);
T6 r1647is_static(T1647* C);
T0* r1647add_comment(T1647* C,T0* a1);
T2 r1647to_integer(T1647* C);
T6 r1647use_current(T1647* C);
T0* r1647to_runnable(T1647* C,T0* a1);
T2 r1647compile_to_jvm_into(T1647* C,T0* a1);
void r1647cpc_to_runnable(T1647* C,T0* a1);
void r1647standard_compile_target_to_jvm(T1647* C);
void r1647compile_to_jvm_old(T1647* C);
T0* r1647twin(T1647* C);
void r1647to_runnable_0(T1647* C,T0* a1);
T2 r1647jvm_standard_branch_if_false(T1647* C);
T6 r1647is_a(T1647* C,T0* a1);
void r1647error(T0* a1,T0* a2);
void r1647make(T1647* C,T0* a1,T0* a2,T0* a3);
T2 r1647standard_compile_to_jvm_into(T1647* C,T0* a1);
void r1647make_call_1(T1647* C,T0* a1,T0* a2,T0* a3);
T2 r1647jvm_standard_branch_if_true(T1647* C);
void r1647afd_check(T1647* C);
T0* r19to_runnable_integer(T19* C,T0* a1);
T0* r19start_position(T19* C);
T6 r19use_current(T19* C);
T6 r19includes_integer(T19* C,T2 a1);
void r19from_when_list(T19* C,T0* a1);
void r19compile_to_jvm_resolve_branch(T19* C);
void r19error(T0* a1,T0* a2);
void r19compile_to_jvm(T19* C,T0* a1);
void r19afd_check(T19* C);
T0* r19to_runnable_character(T19* C,T0* a1);
T0* r1594run_require(T0* a1);
void r1594set_rescue_compound(T1594* C,T0* a1);
T0* r1594start_position(T1594* C);
T6 r1594is_merge_with(T1594* C,T0* a1,T0* a2);
T0* r1594runnable(T0* a1,T0* a2,T0* a3);
void r1594make_e_feature(T1594* C,T0* a1,T0* a2);
void r1594add_into(T1594* C,T0* a1);
T6 r1594can_hide(T1594* C,T0* a1,T0* a2);
T0* r1594run_ensure(T0* a1);
void r1594check_obsolete(T1594* C);
T0* r1594try_to_undefine(T1594* C,T0* a1,T0* a2);
void r1594make_routine(T1594* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T0* r1594to_run_feature(T1594* C,T0* a1,T0* a2);
void r1594warning(T0* a1,T0* a2);
void r1594error(T0* a1,T0* a2);
void r1594collect_for(T1594* C,T2 a1);
void r1594from_effective(T1594* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r1594set_header_comment(T1594* C,T0* a1);
T0* r1185twin(T1185* C);
T0* r1185runnable(T0* a1,T0* a2,T0* a3);
T6 r1185use_current(T1185* C);
T0* r1185to_runnable(T1185* C,T0* a1);
T6 r1185is_pre_computable(T1185* C);
void r1185error(T0* a1,T0* a2);
void r1185make(T1185* C,T0* a1,T0* a2,T0* a3);
void r1185compile_to_jvm(T1185* C,T6 a1);
void r1185afd_check(T1185* C);
void r982store_in(T0* a1);
extern T0*oBC982from_pc;
void r982append_u2(T0* a1,T2 a2);
extern T0*oBC982to_pc;
extern T0*oBC982type_idx;
extern T0*oBC982handler_pc;
T0* r431start_position(T431* C);
T6 r431use_current(T431* C);
T0* r431to_runnable(T431* C,T0* a1);
T6 r431is_pre_computable(T431* C);
T0* r431first(T431* C);
T2 r431count(T431* C);
T0* r431run_class(T431* C);
void r431make(T431* C,T0* a1,T0* a2);
void r431compile_to_jvm(T431* C);
void r431afd_check(T431* C);
T0* r1078add_comment(T1078* C,T0* a1);
T6 r1078use_current(T1078* C);
void r1078check_created_type(T1078* C,T0* a1);
T0* r1078to_runnable(T1078* C,T0* a1);
void r1078warning(T0* a1,T0* a2);
T0* r1078current_type(T1078* C);
T6 r1078is_pre_computable(T1078* C);
void r1078error(T0* a1,T0* a2);
void r1078make(T1078* C,T0* a1,T0* a2);
void r1078check_writable(T1078* C,T0* a1);
void r1078check_creation_clause(T1078* C,T0* a1);
void r1078compile_to_jvm(T1078* C);
T0* r718to_runnable_integer(T718* C,T0* a1);
T0* r718start_position(T718* C);
T0* r718twin(T718* C);
void r718error(T0* a1,T0* a2);
void r718make(T718* C,T0* a1,T0* a2);
T0* r718to_runnable_character(T718* C,T0* a1);
T6 r684is_static(T684* C);
T0* r684add_comment(T684* C,T0* a1);
T2 r684to_integer(T684* C);
T6 r684use_current(T684* C);
T2 r684jvm_branch_if_true(T684* C);
T0* r684to_runnable(T684* C,T0* a1);
T2 r684compile_to_jvm_into(T684* C,T0* a1);
void r684cpc_to_runnable(T684* C,T0* a1);
void r684standard_compile_target_to_jvm(T684* C);
void r684compile_to_jvm_old(T684* C);
T2 r684jvm_branch_if_false(T684* C);
T0* r684twin(T684* C);
void r684to_runnable_0(T684* C,T0* a1);
T2 r684jvm_standard_branch_if_false(T684* C);
T6 r684is_a(T684* C,T0* a1);
void r684error(T0* a1,T0* a2);
void r684make(T684* C,T0* a1,T0* a2,T0* a3);
T2 r684standard_compile_to_jvm_into(T684* C,T0* a1);
void r684make_call_1(T684* C,T0* a1,T0* a2,T0* a3);
T0* r684operator(void);
T2 r684jvm_standard_branch_if_true(T684* C);
void r684afd_check(T684* C);
T6 r744is_static(T744* C);
T0* r744add_comment(T744* C,T0* a1);
T2 r744to_integer(T744* C);
T6 r744use_current(T744* C);
T2 r744jvm_branch_if_true(T744* C);
T0* r744to_runnable(T744* C,T0* a1);
T2 r744compile_to_jvm_into(T744* C,T0* a1);
void r744cpc_to_runnable(T744* C,T0* a1);
void r744standard_compile_target_to_jvm(T744* C);
void r744compile_to_jvm_old(T744* C);
T2 r744jvm_branch_if_false(T744* C);
T0* r744twin(T744* C);
void r744to_runnable_0(T744* C,T0* a1);
T2 r744jvm_standard_branch_if_false(T744* C);
T6 r744is_a(T744* C,T0* a1);
void r744error(T0* a1,T0* a2);
void r744make(T744* C,T0* a1,T0* a2,T0* a3);
T2 r744standard_compile_to_jvm_into(T744* C,T0* a1);
void r744make_call_1(T744* C,T0* a1,T0* a2,T0* a3);
T0* r744operator(void);
T2 r744jvm_standard_branch_if_true(T744* C);
void r744afd_check(T744* C);
T6 r992is_static(T992* C);
void r992jvm_void_cmp(T0* a1);
void r992error_comparison(T992* C,T0* a1);
T0* r992add_comment(T992* C,T0* a1);
T2 r992to_integer(T992* C);
T6 r992use_current(T992* C);
T0* r992to_runnable(T992* C,T0* a1);
T2 r992compile_to_jvm_into(T992* C,T0* a1);
T6 r992is_static_neq_void(T992* C,T0* a1);
void r992standard_compile_target_to_jvm(T992* C);
void r992compile_to_jvm_old(T992* C);
void r992compile_to_jvm(T992* C);
void r992bit_limitation(T992* C,T0* a1,T0* a2);
void r992jvm_standard_is_neq_aux(T0* a1,T0* a2);
T0* r992type_boolean(void);
T6 r992is_manifest_array(T0* a1);
T2 r992jvm_standard_branch_if_false(T992* C);
T6 r992is_a(T992* C,T0* a1);
void r992error(T0* a1,T0* a2);
void r992make(T992* C,T0* a1,T0* a2,T0* a3);
T2 r992standard_compile_to_jvm_into(T992* C,T0* a1);
void r992make_call_1(T992* C,T0* a1,T0* a2,T0* a3);
void r992to_runnable_equal_not_equal(T992* C,T0* a1);
T2 r992jvm_standard_branch_if_true(T992* C);
void r992afd_check(T992* C);
T0* r449run_require(T0* a1);
T0* r449start_position(T449* C);
T6 r449is_merge_with(T449* C,T0* a1,T0* a2);
T0* r449runnable(T0* a1,T0* a2,T0* a3);
void r449make_e_feature(T449* C,T0* a1,T0* a2);
void r449add_into(T449* C,T0* a1);
T6 r449can_hide(T449* C,T0* a1,T0* a2);
T0* r449run_ensure(T0* a1);
void r449check_obsolete(T449* C);
T0* r449try_to_undefine(T449* C,T0* a1,T0* a2);
void r449make_routine(T449* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T0* r449to_run_feature(T449* C,T0* a1,T0* a2);
void r449warning(T0* a1,T0* a2);
T0* r449try_to_undefine_aux(T449* C,T0* a1,T0* a2);
void r449error(T0* a1,T0* a2);
void r449make(T449* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7);
void r449collect_for(T449* C,T2 a1);
void r449set_header_comment(T449* C,T0* a1);
T0* r1241jvm_root_class(void);
void r1241jvm_initialize_local(T2 a1);
void r1241standard_jvm_check_class_invariant(T1241* C);
T0* r1241smallest_ancestor(T0* a1);
T6 r1241is_a(T1241* C,T0* a1);
void r1241make(T1241* C,T0* a1);
T2 r1241jvm_push_default(void);
T0* r1241generic_list(T1241* C);
T0* r1241base_class(T1241* C);
T0* r1241base_class_name(T1241* C);
T6 r1241is_a_in(T1241* C,T0* a1,T0* a2);
T0* r1241look_up_for(T1241* C,T0* a1,T0* a2);
T6 r1241is_generic(T1241* C);
T0* r1241jvm_root_descriptor(void);
T2 r1241jvm_stack_space(void);
T0* r44jvm_root_class(void);
T2 r44id(T44* C);
T0* r44run_class(T44* C);
T0* r44smallest_ancestor(T44* C,T0* a1);
T6 r44is_a(T44* C,T0* a1);
void r44make(T44* C,T0* a1);
T2 r44jvm_convert_to(T0* a1);
void r44fatal_error_generic_list(T44* C);
T0* r44generic_list(T44* C);
T0* r44base_class(T44* C);
extern int fBC44base_class_name;
extern T0*oBC44base_class_name;
T0* r44base_class_name(void);
T6 r44is_a_in(T44* C,T0* a1,T0* a2);
T0* r44look_up_for(T44* C,T0* a1,T0* a2);
T0* r44jvm_root_descriptor(void);
T0* r44type_any(void);
T2 r44jvm_stack_space(void);
T6 r1652isa_dca_inline(T1652* C,T0* a1,T0* a2);
extern T0*oBC1652isa_dca_inline_memory;
T6 r1652is_static(T1652* C);
T0* r1652start_position(T1652* C);
T0* r1652expression(T1652* C,T2 a1);
T6 r1652use_current(T1652* C);
T2 r1652compile_to_jvm_ith(T1652* C,T0* a1,T2 a2);
T0* r1652to_runnable(T1652* C,T0* a1);
T6 r1652is_pre_computable(T1652* C);
T0* r1652first(T1652* C);
void r1652match_with(T1652* C,T0* a1);
T2 r1652count(T1652* C);
T0* r1652run_class(T1652* C);
void r1652error(T0* a1,T0* a2);
void r1652compile_to_jvm_old(T1652* C);
T6 r1652is_like_argument(T1652* C,T0* a1,T0* a2,T0* a3);
T2 r1652compile_to_jvm(T1652* C,T0* a1);
void r1652afd_check(T1652* C);
T6 r1635is_static(T1635* C);
T0* r1635add_comment(T1635* C,T0* a1);
T2 r1635to_integer(T1635* C);
T6 r1635use_current(T1635* C);
T0* r1635to_runnable(T1635* C,T0* a1);
T2 r1635compile_to_jvm_into(T1635* C,T0* a1);
void r1635cpc_to_runnable(T1635* C,T0* a1);
void r1635make_call0(T1635* C,T0* a1,T0* a2);
void r1635standard_compile_target_to_jvm(T1635* C);
void r1635compile_to_jvm_old(T1635* C);
T6 r1635can_be_dropped(T1635* C);
T0* r1635twin(T1635* C);
void r1635to_runnable_0(T1635* C,T0* a1);
T2 r1635isa_dca_inline_argument(T1635* C);
T2 r1635jvm_standard_branch_if_false(T1635* C);
T6 r1635is_a(T1635* C,T0* a1);
void r1635error(T0* a1,T0* a2);
void r1635make(T1635* C,T0* a1,T0* a2);
T2 r1635standard_compile_to_jvm_into(T1635* C,T0* a1);
T0* r1635operator(void);
T2 r1635jvm_standard_branch_if_true(T1635* C);
void r1635afd_check(T1635* C);
T6 r1578is_static(T1578* C);
T0* r1578add_comment(T1578* C,T0* a1);
T2 r1578to_integer(T1578* C);
T6 r1578use_current(T1578* C);
T0* r1578to_runnable(T1578* C,T0* a1);
T2 r1578compile_to_jvm_into(T1578* C,T0* a1);
void r1578cpc_to_runnable(T1578* C,T0* a1);
void r1578standard_compile_target_to_jvm(T1578* C);
void r1578compile_to_jvm_old(T1578* C);
T0* r1578twin(T1578* C);
void r1578to_runnable_0(T1578* C,T0* a1);
T2 r1578isa_dca_inline_argument(T1578* C);
T2 r1578jvm_standard_branch_if_false(T1578* C);
T6 r1578is_a(T1578* C,T0* a1);
void r1578error(T0* a1,T0* a2);
void r1578make(T1578* C,T0* a1,T0* a2,T0* a3);
T2 r1578standard_compile_to_jvm_into(T1578* C,T0* a1);
void r1578make_call_1(T1578* C,T0* a1,T0* a2,T0* a3);
T0* r1578operator(void);
T2 r1578jvm_standard_branch_if_true(T1578* C);
void r1578afd_check(T1578* C);
T6 r1408is_static(T1408* C);
T0* r1408add_comment(T1408* C,T0* a1);
T2 r1408to_integer(T1408* C);
T6 r1408use_current(T1408* C);
T0* r1408to_runnable(T1408* C,T0* a1);
T2 r1408compile_to_jvm_into(T1408* C,T0* a1);
void r1408cpc_to_runnable(T1408* C,T0* a1);
void r1408standard_compile_target_to_jvm(T1408* C);
void r1408compile_to_jvm_old(T1408* C);
T0* r1408twin(T1408* C);
void r1408to_runnable_0(T1408* C,T0* a1);
T2 r1408jvm_standard_branch_if_false(T1408* C);
T6 r1408is_a(T1408* C,T0* a1);
void r1408error(T0* a1,T0* a2);
void r1408make(T1408* C,T0* a1,T0* a2,T0* a3);
T2 r1408standard_compile_to_jvm_into(T1408* C,T0* a1);
void r1408make_call_1(T1408* C,T0* a1,T0* a2,T0* a3);
T0* r1408operator(void);
T2 r1408jvm_standard_branch_if_true(T1408* C);
void r1408afd_check(T1408* C);
T0* r513start_position(T513* C);
T0* r513add_comment(T513* C,T0* a1);
T2 r513to_integer(T513* C);
T0* r513to_runnable(T513* C,T0* a1);
void r513compile_to_jvm(T513* C);
extern int fBC266type_pointer;
extern T0*oBC266type_pointer;
T0* r513type_pointer(void);
void r513compile_target_to_jvm(T513* C);
T6 r513is_a(T513* C,T0* a1);
void r513error(T0* a1,T0* a2);
T0* r1300start_position(T1300* C);
T6 r1300is_merge_with(T1300* C,T0* a1,T0* a2);
void r1300make_e_feature(T1300* C,T0* a1,T0* a2);
void r1300add_into(T1300* C,T0* a1);
T6 r1300can_hide(T1300* C,T0* a1,T0* a2);
T0* r1300try_to_undefine(T1300* C,T0* a1,T0* a2);
T0* r1300to_run_feature(T1300* C,T0* a1,T0* a2);
T0* r1300try_to_undefine_aux(T1300* C,T0* a1,T0* a2);
void r1300error(T0* a1,T0* a2);
void r1300make(T1300* C,T0* a1,T0* a2,T0* a3);
void r1300collect_for(T2 a1);
T0* r411jvm_root_class(void);
void r411jvm_initialize_local(T2 a1);
T2 r411id(T411* C);
T0* r411to_runnable(T411* C,T0* a1);
T0* r411run_class(T411* C);
T0* r411run_time_mark(void);
T6 r411is_a(T411* C,T0* a1);
T0* r411written_mark(void);
void r411error(T0* a1,T0* a2);
void r411make(T411* C,T0* a1);
void r411fatal_error_generic_list(T411* C);
T2 r411jvm_push_default(void);
T0* r411generic_list(T411* C);
T0* r411base_class(T411* C);
T6 r411is_a_in(T411* C,T0* a1,T0* a2);
T0* r411look_up_for(T411* C,T0* a1,T0* a2);
T6 r411has_creation(T411* C,T0* a1);
T0* r411jvm_root_descriptor(void);
extern int fBC411check_type;
void r411check_type(T411* C);
T2 r411jvm_stack_space(void);
T6 r502is_general(T502* C);
T0* r502root_procedure(T502* C,T0* a1);
void r502fatal_undefine(T502* C,T0* a1);
T0* r502going_up(T502* C,T0* a1,T0* a2,T0* a3);
void r502add_feature_clause(T502* C,T0* a1);
void r502get_started(T502* C);
T0* r502new_name_of_original(T502* C,T0* a1,T0* a2);
T0* r502run_class(T502* C);
T0* r502get_copy(T502* C);
T0* r502super_look_up_for(T502* C,T0* a1,T0* a2);
extern T0*oBC502visited;
void r502collect_invariant(T502* C,T0* a1);
T0* r502clients_for(T502* C,T0* a1);
void r502warning(T0* a1,T0* a2);
T0* r502class_with(T0* a1);
extern int fBC266class_any;
extern T0*oBC266class_any;
T0* r502class_any(void);
void r502error(T0* a1,T0* a2);
void r502make(T502* C);
T0* r502id_provider(void);
void r502collect_for(T502* C,T2 a1,T0* a2);
extern T0*oBC502going_up_trace;
T6 r502has(T502* C,T0* a1);
T6 r502has_simple_feature_name(T502* C,T0* a1);
T6 r502is_subclass_of(T502* C,T0* a1);
void r502set_invariant(T502* C,T0* a1,T0* a2,T0* a3);
T0* r502look_up_for(T502* C,T0* a1,T0* a2);
T6 r502is_subclass_of_aux(T502* C,T0* a1);
extern int fBC502mem_fn;
extern T0*oBC502mem_fn;
T0* r502mem_fn(void);
void r502set_parent_list(T502* C,T0* a1,T0* a2,T0* a3);
T6 r502has_creation(T502* C,T0* a1);
T0* r502expanded_initializer(T502* C,T0* a1);
T6 r502proper_has(T502* C,T0* a1);
void r502add_index_clause(T502* C,T0* a1);
T6 r502super_has(T502* C,T0* a1);
T6 r502is_any(T502* C);
void r502check_expanded_with(T502* C,T0* a1);
T6 r502has_redefine(T502* C,T0* a1);
void r502inherit_cycle_check(T502* C);
T0* r502up_to_original(T502* C,T0* a1,T0* a2);
T0* r502new_name_of(T502* C,T0* a1,T0* a2);
T6 r502is_a_vncg(T502* C,T0* a1,T0* a2);
void r502set_is_expanded(T502* C);
void r502set_is_deferred(T502* C);
void r502add_creation_clause(T502* C,T0* a1);
T6 r694use_current(T694* C);
T0* r694to_runnable(T694* C,T0* a1);
void r694compile_to_jvm_resolve_branch(T694* C);
T2 r694compile_to_jvm(T694* C);
void r694afd_check(T694* C);
T6 r2038is_static(T2038* C);
T0* r2038start_position(T2038* C);
T0* r2038add_comment(T2038* C,T0* a1);
T2 r2038to_integer(T2038* C);
T6 r2038use_current(T2038* C);
T2 r2038jvm_branch_if_true(T2038* C);
T0* r2038to_runnable(T2038* C,T0* a1);
T2 r2038compile_to_jvm_into(T2038* C,T0* a1);
T6 r2038is_pre_computable(T2038* C);
T0* r2038result_type(T2038* C);
void r2038compile_to_jvm_assignment(T2038* C,T0* a1);
void r2038compile_to_jvm_old(T2038* C);
void r2038jvm_assign(T2038* C);
T2 r2038jvm_branch_if_false(T2038* C);
void r2038compile_to_jvm(T2038* C);
T6 r2038can_be_dropped(T2038* C);
T0* r2038twin(T2038* C);
void r2038compile_target_to_jvm(T2038* C);
T2 r2038isa_dca_inline_argument(T2038* C);
T6 r2038is_a(T2038* C,T0* a1);
void r2038error(T0* a1,T0* a2);
void r2038make(T2038* C,T0* a1,T0* a2);
void r2038afd_check(T2038* C);
T6 r1787is_static(T1787* C);
T0* r1787add_comment(T1787* C,T0* a1);
T2 r1787to_integer(T1787* C);
T6 r1787use_current(T1787* C);
T0* r1787to_runnable(T1787* C,T0* a1);
T2 r1787compile_to_jvm_into(T1787* C,T0* a1);
void r1787cpc_to_runnable(T1787* C,T0* a1);
void r1787make_call0(T1787* C,T0* a1,T0* a2);
void r1787standard_compile_target_to_jvm(T1787* C);
void r1787compile_to_jvm_old(T1787* C);
T6 r1787can_be_dropped(T1787* C);
T0* r1787twin(T1787* C);
void r1787to_runnable_0(T1787* C,T0* a1);
T2 r1787isa_dca_inline_argument(T1787* C);
T2 r1787jvm_standard_branch_if_false(T1787* C);
T6 r1787is_a(T1787* C,T0* a1);
void r1787error(T0* a1,T0* a2);
void r1787make(T1787* C,T0* a1,T0* a2);
T2 r1787standard_compile_to_jvm_into(T1787* C,T0* a1);
T0* r1787operator(void);
T2 r1787jvm_standard_branch_if_true(T1787* C);
void r1787afd_check(T1787* C);
T0* r210add_comment(T210* C,T0* a1);
T2 r210jvm_branch_if_true(void);
T0* r210to_runnable(T210* C,T0* a1);
T2 r210compile_to_jvm_into(T0* a1);
T0* r210type_boolean(void);
T0* r210twin(T210* C);
T2 r210isa_dca_inline_argument(void);
T6 r210is_a(T210* C,T0* a1);
void r210error(T0* a1,T0* a2);
T2 r210standard_compile_to_jvm_into(T0* a1);
T0* r1163add_comment(T1163* C,T0* a1);
T2 r1163to_integer(T1163* C);
T2 r1163jvm_branch_if_true(T1163* C);
T0* r1163to_runnable(T1163* C,T0* a1);
T2 r1163compile_to_jvm_into(T1163* C,T0* a1);
void r1163standard_compile_target_to_jvm(T1163* C);
void r1163make_runnable(T1163* C,T0* a1,T0* a2,T0* a3);
T2 r1163jvm_branch_if_false(T1163* C);
void r1163compile_to_jvm(T1163* C);
T6 r1163is_a(T1163* C,T0* a1);
void r1163refer_to(T1163* C,T0* a1,T0* a2,T2 a3);
void r1163error(T0* a1,T0* a2);
T2 r1163standard_compile_to_jvm_into(T1163* C,T0* a1);
T0* r1324start_position(T1324* C);
T6 r1324use_current(T1324* C);
T0* r1324to_runnable(T1324* C,T0* a1);
T6 r1324is_pre_computable(T1324* C);
void r1324error(T0* a1,T0* a2);
void r1324make(T1324* C,T0* a1,T0* a2);
void r1324compile_to_jvm(T1324* C);
void r1324afd_check(T1324* C);
T0* r519twin(T519* C);
T0* r519add_comment(T519* C,T0* a1);
T6 r519use_current(T519* C);
void r519add_if_then(T519* C,T0* a1,T0* a2);
T0* r519to_runnable(T519* C,T0* a1);
T0* r519current_type(T519* C);
void r519copy(T519* C,T0* a1);
void r519compile_to_jvm(T519* C);
void r519afd_check(T519* C);
void r1029fall_down(T1029* C);
T6 r1029is_static(T1029* C);
T0* r1029start_position(T1029* C);
T6 r1029use_current(T1029* C);
void r1029mapping_jvm(T1029* C);
void r1029std_compute_use_current(T1029* C);
T0* r1029run_class(T1029* C);
T2 r1029static_value_mem(T1029* C);
T2 r1029jvm_local_variable_offset(T1029* C,T0* a1);
T2 r1029arg_count(T1029* C);
T6 r1029is_exported_in(T1029* C,T0* a1);
T2 r1029jvm_argument_offset(T1029* C,T0* a1);
void r1029initialize(T1029* C);
T2 r1029jvm_max_locals(T1029* C);
void r1029add_client(T1029* C,T0* a1);
void r1029make(T1029* C,T0* a1,T0* a2,T0* a3);
T2 r1029jvm_result_offset(T1029* C);
T0* r1029clients(T1029* C);
T0* r1029jvm_descriptor(void);
T0* r969run_require(T0* a1);
T0* r969start_position(T969* C);
T6 r969is_merge_with(T969* C,T0* a1,T0* a2);
T0* r969runnable(T0* a1,T0* a2,T0* a3);
void r969make_e_feature(T969* C,T0* a1,T0* a2);
void r969add_into(T969* C,T0* a1);
T6 r969can_hide(T969* C,T0* a1,T0* a2);
T0* r969run_ensure(T0* a1);
void r969check_obsolete(T969* C);
T0* r969try_to_undefine(T969* C,T0* a1,T0* a2);
void r969make_routine(T969* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T0* r969to_run_feature(T969* C,T0* a1,T0* a2);
void r969make_effective_routine(T969* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7);
void r969warning(T0* a1,T0* a2);
T0* r969try_to_undefine_aux(T969* C,T0* a1,T0* a2);
void r969error(T0* a1,T0* a2);
void r969make(T969* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7,T0* a8);
void r969collect_for(T969* C,T2 a1);
void r969set_header_comment(T969* C,T0* a1);
void r500read_line(T500* C);
void r500read_line_in(T500* C,T0* a1);
void r500read_word(T500* C);
void r500skip_separators(T500* C);
extern T0*oBC869last_string;
void r500connect_to(T500* C,T0* a1);
T6 r500end_of_input(T500* C);
void r500disconnect(T500* C);
void r500read_character(T500* C);
extern T0*oBC673std_fr1;
void r673mkdir(T0* a1);
T6 r673is_readable(T0* a1);
void r602jvm_initialize_local(T602* C,T2 a1);
void r602used_as_reference(T602* C);
T2 r602id(T602* C);
T0* r602to_runnable(T602* C,T0* a1);
void r602set_run_time_mark(T602* C);
T0* r602run_class(T602* C);
void r602jvm_write_local(T2 a1);
T0* r602smallest_ancestor(T602* C,T0* a1);
T2 r602jvm_if_x_eq(void);
T6 r602is_a(T602* C,T0* a1);
void r602make(T602* C,T0* a1,T0* a2);
T2 r602jvm_convert_to(T602* C,T0* a1);
void r602fatal_error_generic_list(T602* C);
T2 r602jvm_push_default(T602* C);
void r602to_runnable_1_2(T602* C);
T0* r602generic_list(T602* C);
T0* r602base_class(T602* C);
T2 r602jvm_if_x_ne(void);
T0* r602base_class_name(void);
T6 r602is_a_in(T602* C,T0* a1,T0* a2);
T0* r602look_up_for(T602* C,T0* a1,T0* a2);
void r602jvm_to_reference(T602* C);
T2 r602jvm_stack_space(void);
T6 r16is_static(T16* C);
T0* r16add_comment(T16* C,T0* a1);
T2 r16to_integer(T16* C);
T6 r16use_current(T16* C);
T0* r16to_runnable(T16* C,T0* a1);
T2 r16compile_to_jvm_into(T16* C,T0* a1);
void r16cpc_to_runnable(T16* C,T0* a1);
void r16standard_compile_target_to_jvm(T16* C);
void r16compile_to_jvm_old(T16* C);
T0* r16twin(T16* C);
void r16to_runnable_0(T16* C,T0* a1);
T2 r16isa_dca_inline_argument(T16* C);
T2 r16jvm_standard_branch_if_false(T16* C);
T6 r16is_a(T16* C,T0* a1);
void r16error(T0* a1,T0* a2);
void r16make(T16* C,T0* a1,T0* a2,T0* a3);
T2 r16standard_compile_to_jvm_into(T16* C,T0* a1);
void r16make_call_1(T16* C,T0* a1,T0* a2,T0* a3);
T0* r16operator(void);
T2 r16jvm_standard_branch_if_true(T16* C);
void r16afd_check(T16* C);
T6 r1873is_static(T1873* C);
T0* r1873add_comment(T1873* C,T0* a1);
T0* r1873to_runnable(T1873* C,T0* a1);
T2 r1873compile_to_jvm_into(T1873* C,T0* a1);
extern int fBC1873result_type;
extern T0*oBC1873result_type;
T0* r1873result_type(void);
T0* r1873twin(T1873* C);
T2 r1873isa_dca_inline_argument(T1873* C);
T6 r1873is_a(T1873* C,T0* a1);
void r1873error(T0* a1,T0* a2);
void r1873make(T1873* C,T0* a1,T3 a2,T2 a3);
T2 r1873standard_compile_to_jvm_into(T1873* C,T0* a1);
T6 r847ensure_check(T847* C);
T6 r847debug_check(T847* C);
T6 r847invariant_check(T847* C);
T6 r847all_check(T847* C);
T6 r847boost(T847* C);
T6 r847no_check(T847* C);
T6 r847require_check(T847* C);
T6 r847loop_check(T847* C);
extern T0*oBC1070tmp_file_read;
void r878put_string(T878* C,T0* a1);
void r878put_integer(T878* C,T2 a1);
void r878append_file(T878* C,T0* a1);
T0* r12base_class(T12* C);
void r12append_in(T12* C,T0* a1);
void r12show(T12* C);
T0* r12get_line(T12* C);
T0* r12path(T12* C);
T6 r12is_equal(T12* C,T0* a1);
void r12make(T12* C,T2 a1,T2 a2);
T6 r12before(T12* C,T0* a1);
void r12set_line_column(T12* C,T2 a1,T2 a2);
void r12with(T12* C,T2 a1,T2 a2,T0* a3);
void r1133fall_down(T1133* C);
T0* r1133start_position(T1133* C);
T6 r1133use_current(T1133* C);
void r1133routine_afd_check(T1133* C);
T0* r1133run_class(T1133* C);
T2 r1133jvm_local_variable_offset(T1133* C,T0* a1);
T2 r1133arg_count(T1133* C);
T6 r1133is_exported_in(T1133* C,T0* a1);
T2 r1133jvm_argument_offset(T1133* C,T0* a1);
void r1133initialize(T1133* C);
T2 r1133jvm_max_locals(T1133* C);
void r1133add_client(T1133* C,T0* a1);
void r1133make(T1133* C,T0* a1,T0* a2,T0* a3);
T2 r1133jvm_result_offset(T1133* C);
void r1133routine_update_tmp_jvm_descriptor(T1133* C);
void r1133afd_check(T1133* C);
T0* r1133clients(T1133* C);
T0* r1133jvm_descriptor(T1133* C);
extern T1120*eiffel_root_object;
extern int se_argc;
extern char**se_argv;
void initialize_eiffel_runtime(int argc,char*argv[]);
extern T7*ms1_1068;
extern T7*ms242_2027;
extern T7*ms243_2027;
extern T7*ms244_2027;
extern T7*ms194_2027;
extern T7*ms195_2027;
extern T7*ms217_2027;
extern T7*ms218_2027;
extern T7*ms198_2027;
extern T7*ms216_2027;
extern T7*ms203_2027;
extern T7*ms219_2027;
extern T7*ms11_1866;
extern T7*ms1_584;
extern T7*ms237_2027;
extern T7*ms238_2027;
extern T7*ms1_1511;
extern T7*ms1_1556;
extern T7*ms1_1463;
extern T7*ms59_2027;
extern T7*ms8_18;
extern T7*ms61_2027;
extern T7*ms9_18;
extern T7*ms10_18;
extern T7*ms220_2027;
extern T7*ms221_2027;
extern T7*ms223_2027;
extern T7*ms222_2027;
extern T7*ms186_2027;
extern T7*ms187_2027;
extern T7*ms184_2027;
extern T7*ms183_2027;
extern T7*ms185_2027;
extern T7*ms68_1358;
extern T7*ms67_1358;
extern T7*ms1_1127;
extern T7*ms200_2027;
extern T7*ms201_2027;
extern T7*ms202_2027;
extern T7*ms236_2027;
extern T7*ms241_2027;
extern T7*ms226_2027;
extern T7*ms163_2027;
extern T7*ms229_2027;
extern T7*ms196_2027;
extern T7*ms210_2027;
extern T7*ms211_2027;
extern T7*ms96_1358;
extern T7*ms97_1358;
extern T7*ms225_2027;
extern T7*ms224_2027;
extern T7*ms85_1358;
extern T7*ms230_2027;
extern T7*ms175_2027;
extern T7*ms173_2027;
extern T7*ms174_2027;
extern T7*ms6_87;
extern T7*ms1_231;
extern T7*ms1_26;
extern T7*ms1_444;
extern T7*ms1_1319;
extern T7*ms1_411;
extern T7*ms12_1866;
extern T7*ms13_1866;
extern T7*ms14_1866;
extern T7*ms15_1866;
extern T7*ms16_1866;
extern T7*ms63_2027;
extern T7*ms64_2027;
extern T7*ms2_653;
extern T7*ms4_737;
extern T7*ms5_653;
extern T7*ms3_653;
extern T7*ms4_653;
extern T7*ms1_1601;
extern T7*ms5_1601;
extern T7*ms2_1601;
extern T7*ms3_1601;
extern T7*ms4_1601;
extern T7*ms1_1586;
extern T7*ms2_1586;
extern T7*ms1_688;
extern T7*ms2_688;
extern T7*ms3_688;
extern T7*ms4_688;
extern T7*ms5_688;
extern T7*ms1_1537;
extern T7*ms2_1537;
extern T7*ms3_1537;
extern T7*ms4_21;
extern T7*ms5_21;
extern T7*ms2_846;
extern T7*ms1_846;
extern T7*ms6_21;
extern T7*ms8_21;
extern T7*ms7_21;
extern T7*ms9_21;
extern T7*ms2_475;
extern T7*ms3_475;
extern T7*ms12_18;
extern T7*ms11_18;
extern T7*ms1_19;
extern T7*ms5_475;
extern T7*ms9_201;
extern T7*ms8_201;
extern T7*ms1_1324;
extern T7*ms1_140;
extern T7*ms1_573;
extern T7*ms1_298;
extern T7*ms209_2027;
extern T7*ms208_2027;
extern T7*ms204_2027;
extern T7*ms1_342;
extern T7*ms1_935;
extern T7*ms159_2027;
extern T7*ms2_1241;
extern T7*ms4_261;
extern T7*ms1_614;
extern T7*ms72_2027;
extern T7*ms1_1485;
extern T7*ms2_1485;
extern T7*ms1_612;
extern T7*ms75_2027;
extern T7*ms1_23;
extern T7*ms1_559;
extern T7*ms1_357;
extern T7*ms2_935;
extern T7*ms1_763;
extern T7*ms1_567;
extern T7*ms1_882;
extern T7*ms1_639;
extern T7*ms2_411;
extern T7*ms2_1375;
extern T7*ms1_1375;
extern T7*ms55_2027;
extern T7*ms1_44;
extern T7*ms2_44;
extern T7*ms62_2027;
extern T7*ms2_614;
extern T7*ms1_1241;
extern T7*ms232_2027;
extern T7*ms239_2027;
extern T7*ms12_128;
extern T7*ms8_87;
extern T7*ms7_87;
extern T7*ms11_87;
extern T7*ms12_87;
extern T7*ms9_87;
extern T7*ms10_87;
extern T7*ms2_1499;
extern T7*ms233_2027;
extern T7*ms234_2027;
extern T7*ms240_2027;
extern T7*ms1_14;
extern T7*ms146_2027;
extern T7*ms193_2027;
extern T7*ms191_2027;
extern T7*ms192_2027;
extern T7*ms231_2027;
extern T7*ms235_2027;
extern T7*ms77_2027;
extern T7*ms212_2027;
extern T7*ms213_2027;
extern T7*ms214_2027;
extern T7*ms1_1347;
extern T7*ms6_1347;
extern T7*ms5_1347;
extern T7*ms9_1347;
extern T7*ms10_1347;
extern T7*ms11_1347;
extern T7*ms4_1347;
extern T7*ms3_1347;
extern T7*ms2_1347;
extern T7*ms7_1347;
extern T7*ms8_1347;
extern T7*ms1_105;
extern T7*ms2_773;
extern T7*ms57_2027;
extern T7*ms5_1652;
extern T7*ms56_2027;
extern T7*ms14_1652;
extern T7*ms4_1652;
extern T7*ms12_1652;
extern T7*ms3_1652;
extern T7*ms13_1652;
extern T7*ms2_1652;
extern T7*ms2_513;
extern T7*ms3_1511;
extern T7*ms2_1511;
extern T7*ms4_1511;
extern T7*ms2_14;
extern T7*ms1_478;
extern T7*ms2_478;
extern T7*ms3_478;
extern T7*ms1_79;
extern T7*ms1_229;
extern T7*ms1_1137;
extern T7*ms60_2027;
extern T7*ms1_537;
extern T7*ms8_40;
extern T7*ms7_40;
extern T7*ms1_883;
extern T7*ms2_883;
extern T7*ms16_1120;
extern T7*ms17_1120;
extern T7*ms15_1120;
extern T7*ms14_1120;
extern T7*ms13_1120;
extern T7*ms12_1120;
extern T7*ms11_1120;
extern T7*ms10_1120;
extern T7*ms9_1120;
extern T7*ms8_1120;
extern T7*ms7_1120;
extern T7*ms6_1120;
extern T7*ms5_1120;
extern T7*ms4_1120;
extern T7*ms1_571;
extern T7*ms2_571;
extern T7*ms3_1120;
extern T7*ms1_504;
extern T7*ms38_504;
extern T7*ms9_504;
extern T7*ms8_504;
extern T7*ms10_502;
extern T7*ms11_502;
extern T7*ms12_502;
extern T7*ms4_792;
extern T7*ms8_502;
extern T7*ms7_502;
extern T7*ms9_502;
extern T7*ms13_502;
extern T7*ms14_502;
extern T7*ms15_502;
extern T7*ms179_2027;
extern T7*ms16_502;
extern T7*ms39_504;
extern T7*ms40_504;
extern T7*ms41_504;
extern T7*ms73_2027;
extern T7*ms1_502;
extern T7*ms6_1106;
extern T7*ms7_1106;
extern T7*ms8_1106;
extern T7*ms9_1106;
extern T7*ms66_2027;
extern T7*ms10_1106;
extern T7*ms9_266;
extern T7*ms2_327;
extern T7*ms5_1105;
extern T7*ms1_1149;
extern T7*ms6_1105;
extern T7*ms3_1499;
extern T7*ms3_625;
extern T7*ms25_502;
extern T7*ms1_431;
extern T7*ms2_431;
extern T7*ms42_504;
extern T7*ms7_898;
extern T7*ms8_898;
extern T7*ms1_556;
extern T7*ms43_504;
extern T7*ms44_504;
extern T7*ms74_2027;
extern T7*ms58_2027;
extern T7*ms45_504;
extern T7*ms76_504;
extern T7*ms49_504;
extern T7*ms48_504;
extern T7*ms46_504;
extern T7*ms47_504;
extern T7*ms37_504;
extern T7*ms1_87;
extern T7*ms2_87;
extern T7*ms207_2027;
extern T7*ms181_2027;
extern T7*ms11_12;
extern T7*ms12_12;
extern T7*ms13_12;
extern T7*ms36_504;
extern T7*ms43_2027;
extern T7*ms115_2027;
extern T7*ms16_87;
extern T7*ms17_87;
extern T7*ms18_87;
extern T7*ms19_87;
extern T7*ms168_2027;
extern T7*ms169_2027;
extern T7*ms170_2027;
extern T7*ms111_2027;
extern T7*ms167_2027;
extern T7*ms161_2027;
extern T7*ms189_2027;
extern T7*ms177_2027;
extern T7*ms158_2027;
extern T7*ms2_502;
extern T7*ms3_502;
extern T7*ms4_502;
extern T7*ms33_478;
extern T7*ms34_478;
extern T7*ms19_214;
extern T7*ms180_2027;
extern T7*ms176_2027;
extern T7*ms162_2027;
extern T7*ms182_2027;
extern T7*ms188_2027;
extern T7*ms172_2027;
extern T7*ms102_2027;
extern T7*ms164_2027;
extern T7*ms2_1492;
extern T7*ms37_266;
extern T7*ms15_87;
extern T7*ms13_87;
extern T7*ms14_87;
extern T7*ms1_1094;
extern T7*ms113_2027;
extern T7*ms117_2027;
extern T7*ms160_2027;
extern T7*ms205_2027;
extern T7*ms206_2027;
extern T7*ms114_2027;
extern T7*ms165_2027;
extern T7*ms171_2027;
extern T7*ms166_2027;
extern T7*ms148_2027;
extern T7*ms3_261;
extern T7*ms1_616;
extern T7*ms31_502;
extern T7*ms32_502;
extern T7*ms33_502;
extern T7*ms2_810;
extern T7*ms71_2027;
extern T7*ms20_502;
extern T7*ms21_502;
extern T7*ms22_502;
extern T7*ms2_461;
extern T7*ms4_461;
extern T7*ms3_461;
extern T7*ms9_461;
extern T7*ms9_1184;
extern T7*ms10_1184;
extern T7*ms23_502;
extern T7*ms24_502;
extern T7*ms36_478;
extern T7*ms37_478;
extern T7*ms38_478;
extern T7*ms3_883;
extern T7*ms4_883;
extern T7*ms5_883;
extern T7*ms4_816;
extern T7*ms6_816;
extern T7*ms3_12;
extern T7*ms4_12;
extern T7*ms5_12;
extern T7*ms6_12;
extern T7*ms7_12;
extern T7*ms1_898;
extern T7*ms3_425;
extern T7*ms134_898;
extern T7*ms50_898;
extern T7*ms147_898;
extern T7*ms25_898;
extern T7*ms94_898;
extern T7*ms1_1789;
extern T7*ms95_898;
extern T7*ms51_898;
extern T7*ms1_261;
extern T7*ms2_261;
extern T7*ms112_898;
extern T7*ms1_535;
extern T7*ms107_898;
extern T7*ms108_898;
extern T7*ms93_898;
extern T7*ms92_898;
extern T7*ms13_898;
extern T7*ms65_2027;
extern T7*ms15_898;
extern T7*ms14_898;
extern T7*ms2_683;
extern T7*ms1_683;
extern T7*ms113_898;
extern T7*ms19_898;
extern T7*ms18_898;
extern T7*ms17_898;
extern T7*ms144_898;
extern T7*ms16_898;
extern T7*ms20_898;
extern T7*ms115_898;
extern T7*ms90_898;
extern T7*ms29_2027;
extern T7*ms28_2027;
extern T7*ms89_898;
extern T7*ms88_898;
extern T7*ms87_898;
extern T7*ms86_898;
extern T7*ms85_898;
extern T7*ms84_898;
extern T7*ms83_898;
extern T7*ms82_898;
extern T7*ms129_898;
extern T7*ms130_898;
extern T7*ms131_898;
extern T7*ms81_898;
extern T7*ms92_2027;
extern T7*ms100_2027;
extern T7*ms91_2027;
extern T7*ms99_2027;
extern T7*ms150_898;
extern T7*ms91_898;
extern T7*ms30_502;
extern T7*ms114_898;
extern T7*ms39_898;
extern T7*ms38_898;
extern T7*ms37_898;
extern T7*ms36_898;
extern T7*ms35_898;
extern T7*ms68_898;
extern T7*ms67_898;
extern T7*ms66_898;
extern T7*ms65_898;
extern T7*ms64_898;
extern T7*ms63_898;
extern T7*ms62_898;
extern T7*ms127_898;
extern T7*ms79_2027;
extern T7*ms126_898;
extern T7*ms55_898;
extern T7*ms54_898;
extern T7*ms149_898;
extern T7*ms43_898;
extern T7*ms44_898;
extern T7*ms42_898;
extern T7*ms41_898;
extern T7*ms40_898;
extern T7*ms125_898;
extern T7*ms116_2027;
extern T7*ms102_898;
extern T7*ms104_898;
extern T7*ms103_898;
extern T7*ms105_898;
extern T7*ms106_898;
extern T7*ms99_898;
extern T7*ms135_898;
extern T7*ms101_898;
extern T7*ms100_898;
extern T7*ms30_898;
extern T7*ms123_898;
extern T7*ms122_898;
extern T7*ms124_898;
extern T7*ms137_898;
extern T7*ms61_898;
extern T7*ms60_898;
extern T7*ms69_898;
extern T7*ms70_898;
extern T7*ms71_898;
extern T7*ms48_898;
extern T7*ms49_898;
extern T7*ms57_898;
extern T7*ms58_898;
extern T7*ms59_898;
extern T7*ms8_683;
extern T7*ms9_683;
extern T7*ms6_683;
extern T7*ms10_683;
extern T7*ms7_683;
extern T7*ms4_683;
extern T7*ms3_683;
extern T7*ms5_683;
extern T7*ms11_683;
extern T7*ms12_683;
extern T7*ms142_898;
extern T7*ms56_898;
extern T7*ms146_898;
extern T7*ms1_1198;
extern T7*ms116_898;
extern T7*ms1_992;
extern T7*ms118_898;
extern T7*ms1_1647;
extern T7*ms117_898;
extern T7*ms1_1653;
extern T7*ms119_898;
extern T7*ms1_560;
extern T7*ms76_898;
extern T7*ms77_898;
extern T7*ms80_898;
extern T7*ms70_2027;
extern T7*ms151_898;
extern T7*ms29_898;
extern T7*ms132_898;
extern T7*ms140_898;
extern T7*ms190_2027;
extern T7*ms28_898;
extern T7*ms27_898;
extern T7*ms26_898;
extern T7*ms139_898;
extern T7*ms1_1379;
extern T7*ms24_898;
extern T7*ms21_898;
extern T7*ms23_898;
extern T7*ms22_898;
extern T7*ms141_898;
extern T7*ms79_898;
extern T7*ms78_898;
extern T7*ms128_898;
extern T7*ms34_898;
extern T7*ms33_898;
extern T7*ms148_898;
extern T7*ms145_898;
extern T7*ms31_898;
extern T7*ms32_898;
extern T7*ms121_898;
extern T7*ms133_898;
extern T7*ms143_898;
extern T7*ms136_898;
extern T7*ms138_898;
extern T7*ms96_898;
extern T7*ms97_898;
extern T7*ms47_898;
extern T7*ms46_898;
extern T7*ms45_898;
extern T7*ms2_1065;
extern T7*ms98_898;
extern T7*ms109_898;
extern T7*ms110_898;
extern T7*ms111_898;
extern T7*ms1_1501;
extern T7*ms120_898;
extern T7*ms75_898;
extern T7*ms74_898;
extern T7*ms73_898;
extern T7*ms11_898;
extern T7*ms12_898;
extern T7*ms1_1065;
extern T7*ms72_898;
extern T7*ms152_898;
extern T7*ms53_2027;
extern T7*ms52_2027;
extern T7*ms49_2027;
extern T7*ms50_2027;
extern T7*ms51_2027;
extern T7*ms47_2027;
extern T7*ms48_2027;
extern T7*ms44_2027;
extern T7*ms45_2027;
extern T7*ms46_2027;
extern T7*ms38_2027;
extern T7*ms39_2027;
extern T7*ms40_2027;
extern T7*ms41_2027;
extern T7*ms42_2027;
extern T7*ms37_2027;
extern T7*ms33_2027;
extern T7*ms34_2027;
extern T7*ms35_2027;
extern T7*ms30_2027;
extern T7*ms31_2027;
extern T7*ms32_2027;
extern T7*ms21_2027;
extern T7*ms22_2027;
extern T7*ms23_2027;
extern T7*ms24_2027;
extern T7*ms25_2027;
extern T7*ms27_2027;
extern T7*ms17_2027;
extern T7*ms18_2027;
extern T7*ms19_2027;
extern T7*ms20_2027;
extern T7*ms10_2027;
extern T7*ms11_2027;
extern T7*ms13_2027;
extern T7*ms14_2027;
extern T7*ms15_2027;
extern T7*ms16_2027;
extern T7*ms7_2027;
extern T7*ms8_2027;
extern T7*ms9_2027;
extern T7*ms4_2027;
extern T7*ms5_2027;
extern T7*ms6_2027;
extern T7*ms1_2027;
extern T7*ms2_2027;
extern T7*ms3_2027;
extern T7*ms26_2027;
extern T7*ms53_898;
extern T7*ms69_2027;
extern T7*ms52_898;
extern T7*ms12_2027;
extern T7*ms9_898;
extern T7*ms10_898;
extern T7*ms4_898;
extern T7*ms5_898;
extern T7*ms140_2027;
extern T7*ms6_898;
extern T7*ms2_12;
extern T7*ms1_12;
extern T7*ms8_461;
extern T7*ms3_816;
extern T7*ms76_2027;
extern T7*ms5_816;
extern T7*ms3_697;
extern T7*ms4_697;
extern T7*ms9_261;
extern T7*ms10_261;
extern T7*ms11_261;
extern T7*ms16_261;
extern T7*ms15_261;
extern T7*ms14_261;
extern T7*ms2_2006;
extern T7*ms4_2006;
extern T7*ms5_2006;
extern T7*ms6_2006;
extern T7*ms7_2006;
extern T7*ms8_2006;
extern T7*ms9_2006;
extern T7*ms10_2006;
extern T7*ms11_2006;
extern T7*ms12_2006;
extern T7*ms13_2006;
extern T7*ms14_2006;
extern T7*ms15_2006;
extern T7*ms16_2006;
extern T7*ms17_2006;
extern T7*ms18_2006;
extern T7*ms19_2006;
extern T7*ms20_2006;
extern T7*ms21_2006;
extern T7*ms22_2006;
extern T7*ms23_2006;
extern T7*ms24_2006;
extern T7*ms25_2006;
extern T7*ms26_2006;
extern T7*ms27_2006;
extern T7*ms28_2006;
extern T7*ms29_2006;
extern T7*ms30_2006;
extern T7*ms31_2006;
extern T7*ms32_2006;
extern T7*ms33_2006;
extern T7*ms34_2006;
extern T7*ms35_2006;
extern T7*ms36_2006;
extern T7*ms37_2006;
extern T7*ms38_2006;
extern T7*ms39_2006;
extern T7*ms40_2006;
extern T7*ms41_2006;
extern T7*ms42_2006;
extern T7*ms43_2006;
extern T7*ms44_2006;
extern T7*ms45_2006;
extern T7*ms46_2006;
extern T7*ms47_2006;
extern T7*ms48_2006;
extern T7*ms49_2006;
extern T7*ms50_2006;
extern T7*ms51_2006;
extern T7*ms52_2006;
extern T7*ms53_2006;
extern T7*ms54_2006;
extern T7*ms55_2006;
extern T7*ms56_2006;
extern T7*ms57_2006;
extern T7*ms58_2006;
extern T7*ms59_2006;
extern T7*ms60_2006;
extern T7*ms61_2006;
extern T7*ms62_2006;
extern T7*ms63_2006;
extern T7*ms64_2006;
extern T7*ms65_2006;
extern T7*ms66_2006;
extern T7*ms67_2006;
extern T7*ms68_2006;
extern T7*ms69_2006;
extern T7*ms70_2006;
extern T7*ms71_2006;
extern T7*ms72_2006;
extern T7*ms73_2006;
extern T7*ms74_2006;
extern T7*ms75_2006;
extern T7*ms76_2006;
extern T7*ms77_2006;
extern T7*ms78_2006;
extern T7*ms79_2006;
extern T7*ms80_2006;
extern T7*ms81_2006;
extern T7*ms82_2006;
extern T7*ms83_2006;
extern T7*ms84_2006;
extern T7*ms85_2006;
extern T7*ms86_2006;
extern T7*ms87_2006;
extern T7*ms88_2006;
extern T7*ms89_2006;
extern T7*ms90_2006;
extern T7*ms91_2006;
extern T7*ms92_2006;
extern T7*ms93_2006;
extern T7*ms94_2006;
extern T7*ms95_2006;
extern T7*ms96_2006;
extern T7*ms97_2006;
extern T7*ms98_2006;
extern T7*ms99_2006;
extern T7*ms100_2006;
extern T7*ms101_2006;
extern T7*ms102_2006;
extern T7*ms103_2006;
extern T7*ms104_2006;
extern T7*ms105_2006;
extern T7*ms106_2006;
extern T7*ms107_2006;
extern T7*ms108_2006;
extern T7*ms109_2006;
extern T7*ms110_2006;
extern T7*ms111_2006;
extern T7*ms112_2006;
extern T7*ms113_2006;
extern T7*ms114_2006;
extern T7*ms115_2006;
extern T7*ms116_2006;
extern T7*ms117_2006;
extern T7*ms118_2006;
extern T7*ms119_2006;
extern T7*ms121_2006;
extern T7*ms120_2006;
extern T7*ms122_2006;
extern T7*ms123_2006;
extern T7*ms124_2006;
extern T7*ms125_2006;
extern T7*ms126_2006;
extern T7*ms127_2006;
extern T7*ms128_2006;
extern T7*ms129_2006;
extern T7*ms130_2006;
extern T7*ms131_2006;
extern T7*ms132_2006;
extern T7*ms133_2006;
extern T7*ms134_2006;
extern T7*ms135_2006;
extern T7*ms136_2006;
extern T7*ms137_2006;
extern T7*ms138_2006;
extern T7*ms139_2006;
extern T7*ms140_2006;
extern T7*ms141_2006;
extern T7*ms142_2006;
extern T7*ms143_2006;
extern T7*ms144_2006;
extern T7*ms145_2006;
extern T7*ms146_2006;
extern T7*ms147_2006;
extern T7*ms148_2006;
extern T7*ms149_2006;
extern T7*ms150_2006;
extern T7*ms151_2006;
extern T7*ms1_2006;
extern T7*ms10_345;
extern T7*ms3_128;
extern T7*ms68_2027;
extern T7*ms1_816;
extern T7*ms17_502;
extern T7*ms18_502;
extern T7*ms19_502;
extern T7*ms67_2027;
extern T7*ms6_502;
extern T7*ms2_816;
extern T7*ms10_504;
extern T7*ms142_2027;
extern T7*ms13_504;
extern T7*ms14_504;
extern T7*ms15_504;
extern T7*ms16_504;
extern T7*ms17_504;
extern T7*ms22_266;
extern T7*ms11_504;
extern T7*ms12_504;
extern T7*ms77_504;
extern T7*ms2_504;
extern T7*ms3_504;
extern T7*ms4_504;
extern T7*ms5_504;
extern T7*ms78_504;
extern T7*ms79_504;
extern T7*ms81_504;
extern T7*ms82_504;
extern T7*ms80_504;
extern T7*ms7_504;
extern T7*ms6_504;
extern T7*ms9_12;
extern T7*ms10_12;
extern T7*ms8_12;
extern T7*ms7_816;
extern T7*ms3_2006;
extern T7*ms4_87;
extern T7*ms5_87;
extern T7*ms2_1094;
extern T7*ms1_11;
extern T7*ms1_578;
extern T7*ms3_87;
extern T7*ms9_85;
extern T7*ms7_85;
extern T7*ms8_85;
extern T7*ms246_2027;
extern T7*ms1_1120;
extern T7*ms2_1120;
extern T7*ms2_266;
extern T7*ms131_2027;
extern T7*ms3_85;
extern T7*ms17_266;
extern T7*ms132_2027;
extern T7*ms18_266;
extern T7*ms124_2027;
extern T7*ms1_266;
extern T7*ms21_266;
extern T7*ms19_266;
extern T7*ms20_266;
extern T7*ms10_266;
extern T7*ms11_266;
extern T7*ms12_266;
extern T7*ms13_266;
extern T7*ms15_266;
extern T7*ms16_266;
extern T7*ms14_266;
extern T7*ms36_266;
extern T7*ms3_266;
extern T7*ms247_2027;
void se_msi1(void);
void se_msi2(void);
void se_msi3(void);
void se_msi4(void);
void se_msi5(void);
void se_msi6(void);
void se_msi7(void);
void se_msi8(void);
void se_msi9(void);
void se_msi10(void);
void se_msi11(void);
void se_msi12(void);
void se_msi13(void);
void se_msi14(void);
void se_msi15(void);
void se_msi16(void);
void se_msi17(void);
void se_msi18(void);
void se_msi19(void);
void se_msi20(void);
void se_msi21(void);
void se_msi22(void);
void se_msi23(void);
void se_msi24(void);
void se_msi25(void);
void se_msi26(void);
void se_msi27(void);
void se_msi28(void);
void se_msi29(void);
void se_msi30(void);
void se_msi31(void);
void se_msi32(void);
void se_msi33(void);
void se_msi34(void);
void se_msi35(void);
void se_msi36(void);
void se_msi37(void);
void se_msi38(void);
void se_msi39(void);
void se_msi40(void);
void se_msi41(void);
void se_msi42(void);
void*se_ma1926(int argc,...);
void*se_ma1545(int argc,...);
void*se_ma874(int argc,...);
void*se_ma1746(int argc,...);
void*se_ma20(int argc,...);
void*se_ma1461(int argc,...);
void*se_ma28(int argc,...);
void*se_ma701(int argc,...);
void*se_ma1277(int argc,...);
void*se_ma1280(int argc,...);
void*se_ma33(int argc,...);
void*se_ma705(int argc,...);
void*se_ma36(int argc,...);
void*se_ma1098(int argc,...);
void*se_ma1388(int argc,...);
void*se_ma1772(int argc,...);
void*se_ma911(int argc,...);
void*se_ma1104(int argc,...);
void*se_ma1211(int argc,...);
void*se_ma1409(int argc,...);
void*se_ma931(int argc,...);
void*se_ma1124(int argc,...);
void*se_ma742(int argc,...);
void*se_ma1231(int argc,...);
void*se_ma2001(int argc,...);
void*se_ma1244(int argc,...);
T6 X846use_current(void *C);
T0* X846to_runnable(void *C,T0* a1);
void X846set_current_type(void *C,T0* a1);
void X846afd_check(void *C);
void X1499add_last(void *C,T0* a1);
T2 X342nb(void *C);
T6 X342is_a(void *C,T0* a1);
T2 X342jvm_convert_to(void *C,T0* a1);
T2 X342jvm_push_default(void *C);
T6 X616is_frozen(void *C);
void X616undefine_in(void *C,T0* a1);
T0* X616origin_base_class(void *C);
T0* X616start_position(void *C);
T0* X616to_string(void *C);
T0* X616to_key(void *C);
void X616set_is_frozen(void *C,T6 a1);
T0* X461to_run_feature(void *C,T0* a1,T0* a2);
T0* X461arguments(void *C);
T0* X461start_position(void *C);
T6 X461is_merge_with(void *C,T0* a1,T0* a2);
void X461add_into(void *C,T0* a1);
T6 X461can_hide(void *C,T0* a1,T0* a2);
void X461collect_for(void *C,T2 a1);
T0* X461try_to_undefine(void *C,T0* a1,T0* a2);
void X461set_header_comment(void *C,T0* a1);
T6 X461is_deferred(void *C);
T0* X461clients(void *C);
void X461set_clients(void *C,T0* a1);
T0* X1463run_require(void *C,T0* a1);
T0* X1463start_position(void *C);
T0* X1463run_ensure(void *C,T0* a1);
void X2020resize(void *C,T2 a1);
T2 X737static_value(void *C);
T6 X737is_static(void *C);
T6 X737can_be_dropped(void *C);
T6 X737is_manifest_string(void *C);
T0* X737start_position(void *C);
T0* X737add_comment(void *C,T0* a1);
T2 X737to_integer(void *C);
void X737compile_target_to_jvm(void *C);
T2 X737jvm_branch_if_true(void *C);
T6 X737use_current(void *C);
T0* X737to_runnable(void *C,T0* a1);
T2 X737compile_to_jvm_into(void *C,T0* a1);
T2 X737isa_dca_inline_argument(void *C);
T6 X737is_pre_computable(void *C);
T6 X737is_a(void *C,T0* a1);
T0* X737result_type(void *C);
T2 X737static_value_mem(void *C);
void X737compile_to_jvm_assignment(void *C,T0* a1);
T6 X737is_current(void *C);
T6 X737is_void(void *C);
void X737compile_to_jvm_old(void *C);
void X737jvm_assign(void *C);
T2 X737jvm_branch_if_false(void *C);
void X737compile_to_jvm(void *C);
void X737afd_check(void *C);
T6 X737is_result(void *C);
T0* X79arguments(void *C);
T2 X79arg_count(void *C);
void X1085put(void *C,T0* a1,T2 a2);
T0* X298arguments(void *C);
T0* X298make_runnable(void *C,T0* a1,T0* a2,T0* a3,T0* a4);
T2 X298arg_count(void *C);
T0* X1746twin(void *C);
void X1746add_last(void *C,T0* a1);
T0* X1746first(void *C);
T2 X1746count(void *C);
void X1610force(void *C,T0* a1,T2 a2);
void X670append_in(void *C,T0* a1);
T2 X670count(void *C);
T0* X14feature_name(void *C);
T0* X14arguments(void *C);
T0* X14start_position(void *C);
T0* X14target(void *C);
T0* X14run_feature(void *C);
T0* X1105start_position(void *C);
T0* X1105to_string(void *C);
void X1105set_rank(void *C,T2 a1);
void X691fall_down(void *C);
T2 X691jvm_argument_offset(void *C,T0* a1);
T6 X691is_static(void *C);
T6 X691can_be_dropped(void *C);
T0* X691start_position(void *C);
void X691do_not_inline(void *C);
T2 X691jvm_max_locals(void *C);
T6 X691use_current(void *C);
void X691mapping_jvm(void *C);
T6 X691is_pre_computable(void *C);
void X691add_client(void *C,T0* a1);
T0* X691run_class(void *C);
T0* X691base_feature(void *C);
T2 X691static_value_mem(void *C);
T2 X691jvm_local_variable_offset(void *C,T0* a1);
void X691jvm_define(void *C);
T0* X691local_vars(void *C);
T2 X691jvm_result_offset(void *C);
void X691jvm_field_or_method(void *C);
void X691afd_check(void *C);
T2 X691arg_count(void *C);
T0* X691jvm_descriptor(void *C);
T6 X691is_exported_in(void *C,T0* a1);
void X327set_rescue_compound(void *C,T0* a1);
void X327set_ensure_assertion(void *C,T0* a1);
T0* X17start_position(void *C);
T0* X17value(void *C,T2 a1);
void X1794add_last(void *C,T0* a1);
void X1794resize(void *C,T2 a1);
T6 X1794fast_has(void *C,T0* a1);
void X1546add_last(void *C,T0* a1);
T0* X1556start_position(void *C);
T0* X128generic_list(void *C);
T0* X128base_class(void *C);
T2 X128jvm_if_x_ne(void *C);
T0* X128base_class_name(void *C);
T0* X128start_position(void *C);
void X128jvm_initialize_local(void *C,T2 a1);
T6 X128is_formal_generic(void *C);
void X128used_as_reference(void *C);
T6 X128is_a_in(void *C,T0* a1,T0* a2);
T2 X128id(void *C);
T6 X128is_user_expanded(void *C);
void X128jvm_check_class_invariant(void *C);
T6 X128is_pointer(void *C);
T0* X128look_up_for(void *C,T0* a1,T0* a2);
T0* X128to_runnable(void *C,T0* a1);
void X128jvm_to_reference(void *C);
T0* X128run_type(void *C);
T0* X128run_class(void *C);
T6 X128has_creation(void *C,T0* a1);
T0* X128expanded_initializer(void *C);
T2 X128jvm_method_flags(void *C);
T6 X128is_like_current(void *C);
T6 X128is_boolean(void *C);
T6 X128is_generic(void *C);
void X128jvm_xaload(void *C);
T6 X128is_bit(void *C);
T6 X128is_real(void *C);
void X128jvm_write_local(void *C,T2 a1);
T6 X128is_any(void *C);
T0* X128smallest_ancestor(void *C,T0* a1);
T0* X128run_time_mark(void *C);
T6 X128is_expanded(void *C);
T2 X128jvm_if_x_eq(void *C);
void X128jvm_xnewarray(void *C);
T6 X128is_basic_eiffel_expanded(void *C);
void X128jvm_descriptor_in(void *C,T0* a1);
void X128jvm_push_local(void *C,T2 a1);
T6 X128is_string(void *C);
T6 X128is_integer(void *C);
T6 X128is_like_feature(void *C);
T6 X128is_anchored(void *C);
T6 X128is_run_type(void *C);
T6 X128is_a(void *C,T0* a1);
T6 X128is_character(void *C);
T6 X128is_reference(void *C);
T0* X128written_mark(void *C);
T2 X128jvm_convert_to(void *C,T0* a1);
T6 X128is_none(void *C);
void X128jvm_target_descriptor_in(void *C,T0* a1);
T6 X128is_array(void *C);
void X128jvm_return_code(void *C);
void X128jvm_xastore(void *C);
T2 X128jvm_push_default(void *C);
T6 X128is_dummy_expanded(void *C);
T2 X128jvm_stack_space(void *C);
T6 X128is_double(void *C);
T0* X890start_position(void *C);
T0* X890add_comment(void *C,T0* a1);
T6 X890use_current(void *C);
T0* X890to_runnable(void *C,T0* a1);
T6 X890is_pre_computable(void *C);
void X890compile_to_jvm(void *C);
void X890afd_check(void *C);
void X231jvm_define_function(void *C,T0* a1,T0* a2,T0* a3);
void X231jvm_add_method_for_function(void *C,T0* a1,T0* a2,T0* a3);
T6 X231use_current(void *C,T0* a1);
void X231jvm_add_method_for_procedure(void *C,T0* a1,T0* a2,T0* a3);
void X231jvm_mapping_function(void *C,T0* a1,T0* a2,T0* a3);
void X231jvm_mapping_procedure(void *C,T0* a1,T0* a2,T0* a3);
void X231jvm_define_procedure(void *C,T0* a1,T0* a2,T0* a3);
T0* X421to_runnable_integer(void *C,T0* a1);
T0* X421twin(void *C);
T0* X421to_runnable_character(void *C,T0* a1);

