;;

(define-class <date> (<object>) :immob)

(define-method write-object ((self <date>) port)
  (write-string port (date->string self)))

(define (ymd->date y m d)
  (day->date (ymd->day y m d)))

(define (date->ymd (date <date>))
  (day->ymd (date->day date)))

(define (date->string (self <date>))
  (bind ((year month day (day->ymd (date->day self))))
    (string-append (number->string year)
		   "."
		   (if (fixnum<? month 10)
		       "0"
		       "")
		   (number->string month)
		   "."
		   (if (fixnum<? day 10)
		       "0"
		       "")
		   (number->string day))))


;; idea:
;;
;; <immob>
;;    |
;;   <date>  (secondary tag DATE_TAG)
;;
;;  27 bits can handle from 1.1.1 to 367476.08.27
;;



;;  operations on <date> objects

(define (date->day (d <date>))
  (get-immob-value d))

(define (day->date (day <integer>))
  (make-immob 7 day))

(define (date+ (a <date>) (b <integer>))
  (make-immob 7 (fixnum+ (get-immob-value a) b)))

(define (date- (a <date>) b)
  (if (integer? b)
      (make-immob 7 (fixnum- (get-immob-value a) b))
      (if (instance? b <date>)
	  (fixnum- (get-immob-value a) (get-immob-value b))
	  (error "~s: invalid args" (list 'date- a b)))))

(define (date=? (a <date>) (b <date>)) (eq? a b))
(define (date>? (a <date>) (b <date>)) (fixnum>? (date->day a) (date->day b)))
(define (date>=? (a <date>) (b <date>))(fixnum>=? (date->day a) (date->day b)))
(define (date<? (a <date>) (b <date>)) (fixnum<? (date->day a) (date->day b)))
(define (date<=? (a <date>) (b <date>))(fixnum<=? (date->day a) (date->day b)))

;;


(define date-pattern #f)

(define (string->date n)
  (bind ((start end yy mm dd (date-pattern n)))
    (if start
	(make-immob 7 (ymd->day (string->number yy)
				(string->number mm)
				(string->number dd)))
	#f)))

(define (date->time (date <date>) (time <fixnum>))
  (day->time (date->day date) time))

(%early-once-only
  (rscheme-global-set! 26 <date>)
  (if (not date-pattern)
      (set! date-pattern (reg-expr->proc
			  '(entire (seq (let year (+ digit))
					#\.
					(let month (+ digit))
					#\.
					(let day (+ digit)))))))
  (set-alternate-number-parser! string->date))
