#|------------------------------------------------------------*-Scheme-*--|
 | File:    modules/corelib/threadv.scm
 |
 |          Copyright (C)1997 Donovan Kolbly <d.kolbly@rscheme.org>
 |          as part of the RScheme project, licensed for free use.
 |          See <http://www.rscheme.org/> for the latest information.
 |
 | File version:     1.2
 | File mod date:    1997.11.29 23:10:39
 | System build:     v0.7.2, 97.12.21
 | Owned by module:  corelib
 |
 `------------------------------------------------------------------------|#

#|

(define *thread-var-reg* #f)

(define-syntax (get-thread-state-reg)
  *thread-var-reg*)

(define-syntax (set-thread-state-reg! v)
  (set! *thread-var-reg* v))
|#

;;;

(define *thread-var-prototype* '#(#f #f #f #f))
(define *direct-names* '#(#f #f #f))
(define *thread-var-init-values* #f)

(define (thread-var-default-state)
  (let ((v (clone *thread-var-prototype*)))
    (vector-set! v 0 *thread-var-init-values*)
    v))

(define (add-thread-var! name init)
  (set! *thread-var-init-values*
	(make-gvec <vector> name init *thread-var-init-values*)))

(define (add-direct-thread-var! name init index)
  (vector-set! *thread-var-prototype* index init)
  (vector-set! *direct-names* (sub1 index) name))

;;;

(define-syntax (direct-thread-var-ref index)
  (gvec-ref (get-thread-state-reg) index))

(define (indirect-thread-var-ref name)
  (let loop ((p (gvec-ref (get-thread-state-reg) 0)))
    (if p
	(if (eq? (gvec-ref p 0) name)
	    (gvec-ref p 1)
	    (loop (gvec-ref p 2)))
	(loop *thread-var-init-values*))))

;;;

(define-macro (define-thread-var name init . opts)
  (if (and (pair? opts)
	   (eq? (car opts) 'direct:))
      (let ((index (cadr opts)))
	`(begin
	   (%early-once-only (add-direct-thread-var! ',name ,init ,index))
	   (define-syntax ,name
	     (setter-form (val tv)
	       (make-gvec <vector>
			  ,@(map (lambda (i)
				   (if (eq? i index)
				       'val
				       `(gvec-ref tv ,i)))
				 (range 4))))
	     (else (direct-thread-var-ref ,index)))))
      `(begin
	 (add-thread-var! ',name ,init)
	 (define-syntax ,name
	   (setter-form (val tv)
             (make-gvec <vector>
			(make-gvec <vector>
				   ',name
				   val 
				   (gvec-ref tv 0))
			,@(map (lambda (i)
				 `(gvec-ref tv ,i))
			       (cdr (range 4)))))
	   (else (indirect-thread-var-ref ',name))))))

;;;

(define-macro (thread-let bdgs . body)
  (if (null? bdgs)
      `(begin ,@body)
      (let ((n-save (gensym))
	    (n (gensym)))
	`(let ((,n-save (get-thread-state-reg))
	       (,n #f))
	   ,@(map (lambda (src b)
		    `(set! ,n (set! ,(car b) ,(cadr b) ,src)))
		  (cons n-save (cdr (map (lambda (x) n) bdgs)))
		  bdgs)
	   (dynamic-call-thunk
	    #f
	    #f
	    (lambda () ,@body)
	    (get-dynamic-state-reg)
	    ,n)))))

#|
(define-thread-var *inp* 'inp direct: 1)
(define-thread-var *out* 'out direct: 2)
(define-thread-var *foo* '())
(define-thread-var *bar* 0)

(set-thread-state-reg! (thread-var-default-state))

(define (test-2)
  (format #t "inp => ~s\n" *inp*)
  (format #t "out => ~s\n" *out*)
  (format #t "foo => ~s\n" *foo*)
  (format #t "bar => ~s\n\n" *bar*))

(define (test-1)
  (test-2)
  (thread-let ((*inp* 10)
	       (*out* 20)
	       (*foo* (cons 'x *foo*)))
    (test-2))
  (test-2))
|#
