#|------------------------------------------------------------*-Scheme-*--|
 | File:    compiler/c.scm
 |
 |          Copyright (C)1997 Donovan Kolbly <d.kolbly@rscheme.org>
 |          as part of the RScheme project, licensed for free use.
 |          See <http://www.rscheme.org/> for the latest information.
 |
 | File version:     1.18
 | File mod date:    1997.11.29 23:10:29
 | System build:     v0.7.2, 97.12.21
 | Owned by module:  (rsc)
 |
 `------------------------------------------------------------------------|#

;; forward decls

(define-generic-function c-name)

;; Modular Compiler

,(use paths mlink tables)

;,(use objsys)
;,(use compiler)

;;----------------------------------------------------------------
;;
;;  blech!  our REPL module system makes everything shared writable
;;
;;  since we are a compiler, insulate ourselves from redefinitions...
;;

#|
(define load
  (let ((load load))
    (lambda (arg)
      (format #t "loading => ~s\n" arg)
      (load arg))))
|#

(if (eq? *save-image-signature* 'old)
    (eval '(define (add-mifio-class name class)
	     (set! *mifio-defs*
		   (cons (cons name class) 
			 (delq (assoc name *mifio-defs*) *mifio-defs*)))
	     (set! *mif-load-defs* #f)
	     (set! *mif-save-defs* #f))
	  *self*))


(load "target.scm")

(load "../modules/compiler/compiler.scm")

(define-class <definer> (<special-form>))

(add-mifio-class "<definer>" <definer>)
(add-mifio-class "<substitution>" <substitution>)



;;----------------------------------------------------------------

;; collect initialization procedures all together
 
(define $init-thunks '())

(define-syntax (on-startup . body)
  (set! $init-thunks (append $init-thunks
			     (list (lambda () (begin . body))))))

(load "misc.scm")

;; some other stuff

(define-generic-function link-name)

;;----------------------------------------------------------------
;;  bytecode generation

(load "../modules/codegen/genaml.scm")
(load "../modules/codegen/loops.scm")
(load "../modules/codegen/lexaddr.scm")
(load "../modules/codegen/aml2bc.scm")
(load "../modules/codegen/support.scm")
(load "../modules/codegen/rearrnge.scm")
(load "../modules/codegen/parassmt.scm")

;;----------------------------------------------------------------
;; C-code generation

(load "cgen/assem.scm")
(load "cgen/estsize.scm")
(load "cgen/wrvinsn.scm")

;;----------------------------------------------------------------

;; these should be thread variables if the compiler is to run in a thread

(define *current-module* #f)
(define *build-context* #f)


;; note:  using the bytecode strategy causes an addition
;;        word in the template to appear after the code-properties
;;        but before the literals (it's the bytecode bvec itself)

(load "modules/imported.scm")
(load "config.scm")

(load "configv.scm")
(load "util/resource.scm")

(load "modules/bldctx.scm")
(load "cgen/parts.scm")
(load "modules/mcfload.scm")
(load "modules/document.scm")
(load "modules/use.scm")
(load "modules/findmodl.scm")
(load "modules/findhier.scm")

(load "cgen/bldfiles.scm")

(load "util/util.scm")
(load "toplevel/builtin.scm")

(load "toplevel/compileclass.scm")

(load "boot/makeinit.scm")
(load "boot/bootable.scm")
(load "util/config-release.scm")

(load "util/genbcode.scm")
(load "amlstubs.scm")

(add-special-form-compiler! top-level-compiler->proc)
(add-special-form-compiler! objsys-compiler->proc)

(define (configure-basis-from-modules m-names)
  (let* ((envt (make-top-level-contour))
	 (tbl (table envt)))
    (for-each (lambda (mn)
		(let ((src-tbl (table (top-level-envt (get-ct-module mn)))))
		  #|(format #t "  *basis* includes: ~s (~d bdgs)\n"
			  mn
			  (table-size src-tbl))|#
		  (flush-output-port (current-output-port))
		  (table-for-each
		   src-tbl
		   (lambda (h k v)
		     (table-insert! tbl k v)))))
	      m-names)
    (set-compiler-basis! envt)))

(for-each 
 (lambda (thunk) (thunk))
 $init-thunks)

