/* Quinn Diff, Compares two Packages files looking for differences between Archs */
/* Copyright (C) 1997-1998, James Troup <james@nocrew.org> */

/* This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <string.h>
#include "main.h"
#include "list.h"
#include "xmalloc.h"
#include "error.h"
#include "utils.h"
#include "common.h"
#include "hash.h"
#include "arch_specific.h"
#include "output.h"
#include "vercmp.h"
#include "primary.h"

void
process_primary (primary_package_info *primary, secondary_package_info *secondary)
{

  want_node *want_data;
  Qlist *want_list = NULL;
  Qlist *want_temp;
  output_info *source_package;
  int package_exists_on_secondary, q = 0;
  unsigned int i;
  char source_version[PACKAGE_NAME_LENGTH];

  want_data = xmalloc (sizeof(*want_data));

  /* Read the primary architecture Packages file, comparing to the
     secondary via the hash table as we go */

  strcpy (want_data->search_string, "Version: ");
  want_data->destination_string = primary->version;
  want_list = want_append (want_list, want_data);
  strcpy (want_data->search_string, "Priority: ");
  want_data->destination_string = primary->priority;
  want_list = want_append (want_list, want_data);
  strcpy (want_data->search_string, "Section: ");
  want_data->destination_string = primary->section;
  want_list = want_append (want_list, want_data);
  strcpy (want_data->search_string, "Pre-Depends: ");
  want_data->destination_string = primary->predepends;
  want_list = want_append (want_list, want_data);
  strcpy (want_data->search_string, "Depends: ");
  want_data->destination_string = primary->depends;
  want_list = want_append (want_list, want_data);
  strcpy (want_data->search_string, "Recommends: ");
  want_data->destination_string = primary->recommends;
  want_list = want_append (want_list, want_data);
  strcpy (want_data->search_string, "Suggests: ");
  want_data->destination_string = primary->suggests;
  want_list = want_append (want_list, want_data);
  strcpy (want_data->search_string, "source: ");
  want_data->destination_string = primary->source;
  want_list = want_append (want_list, want_data);

  while (primary->buffer_pos < primary->file_length)
    {
      
      source_version[0] = '\0';

      if (primary->buffer[primary->buffer_pos] == 'P')
	{
	  read_line (primary->buffer, &primary->buffer_pos, primary->name);

	  debug(debug_primary, "process_primary: readline() => \"%s\"", primary->name); 

 	  if (!(strncmp ("Package: ", primary->name, 9))) 
	    {
	      strcpy (primary->name, primary->name + 9);
	      debug(debug_primary, "process_primary: Searching for package \"%s\"", primary->name);
	      
	      parse_package (primary->buffer, primary->buffer_pos, primary->file_length, want_list, 
			     primary->name);

	      /* Sanity check for the existence of a Version: field. */

	      want_temp = want_find (want_list, "Version: ");
	      if (!((want_node *)(want_temp->data))->found)
		fubar (NONSYS, "Package: \"%s\" has no version field I could fine; please tell James", 
		       primary->name);

	      /* nonus has no Sections or Priorities, compensate. */

	      want_temp = want_find (want_list, "Section: ");
	      if (!((want_node *)(want_temp->data))->found)
		strcpy (primary->section, "none"); 
	      want_temp = want_find (want_list, "Priority: ");
	      if (!((want_node *)(want_temp->data))->found)
		strcpy (primary->priority, "-");

	      package_exists_on_secondary = secondary_hash_retrieve ( primary->name, secondary );

	      if ((!package_exists_on_secondary || 
		   (strcmp (primary->version, secondary->version))) && 
		  !is_arch_specific (primary->name))
		{

		  determine_needsx (primary->suggests, primary->recommends, primary->depends, 
				  primary->predepends, &primary->needs_x);

		  if (!package_exists_on_secondary)
		    strcpy (secondary->version, ""); 
		  else 
		    q = compare_versions (primary->version, secondary);
		  
/* 		  printf ("%s: %d '%c'\n", primary->name, primary->source[0], primary->source[0]); */

		  if (primary->source[0])
		    {
		      debug (debug_mbs, "process_primary: %s has source: %s", primary->name, primary->source);

		      /* Some people stick the version number in brackets in the source: line; compensate */

		      i = 0;
		      while (i < strlen (primary->source))
			{
			  if (primary->source[i] == ' ') /* FIXME check for other non package name chars */
			    {
			      int package_ends_at;
			      package_ends_at = i;
			      i++;
			      if (primary->source[i] == '(')
				{
				  /* It's a version, grab it */
				  int j = 0;

				  i++;
				  while (i < strlen (primary->source) && primary->source[i] != ')')
				    source_version[j++] = primary->source[i++];
				  source_version[j] = '\0';
				  debug (debug_mbs, "process_primary: source version => \"%s\"", source_version);
				}
			      primary->source[package_ends_at] = '\0';
			      break;
			    }
			  i++;
			}

		      source_package = output_retrieve (primary->source);
		      if (source_package)
			{
			  debug (debug_mbs, "process_primary: %s (source: %s) was found in the hash table as a source package, updating.", primary->name, primary->source);
			  debug (debug_mbs, "* Calling output_mbs_update()");
			  output_mbs_update (primary->priority, primary->needs_x, 
					     source_package, source_version);
			  debug (debug_mbs, "**-");
			}
		      else /* not already in the hash table */
			{
			  debug (debug_mbs, "process_primary: %s was not found in the hash table as a source package, adding.", primary->source);
			  i = output_add (primary->source, primary->version, 
					  secondary->version, primary->priority, 
					  primary->section, primary->needs_x, 
					  q, TRUE, source_version);
			  if (i)
			    fubar (NONSYS, "couldn't add \"%s\" to output hash table (put returned %d)", 
				   primary->name, i);	
			}
		    }
		  else
		    {
		      debug (debug_mbs, "process_primary: %s has no source line", primary->name);
		      i = output_add (primary->name, primary->version, 
				       secondary->version, primary->priority, 
				       primary->section, primary->needs_x, q,
				       FALSE, NULL);

		      if (i == 1)
			{
			  source_package = output_retrieve (primary->name);
			  if (source_package)
			    {
			      debug (debug_mbs, "process_primary: %s was found in the hash table as a source package, updating.", primary->name);
			      debug (debug_mbs, "* Calling output_mbs_update()");
			      output_mbs_update (primary->priority, primary->needs_x, 
						 source_package, NULL);
			      debug (debug_mbs, "**-");
			    }
			  else
			    {
			      error ("Warning: \"%s\" is already in the output hash table, skipping duplicate", primary->name);
			      error ("This is probably a bug in ftp.debian.org or nonus.debian.org; if it's not please mail James.");
			    }
			}
		      else if (i != 0)
			fubar (NONSYS, "couldn't add \"%s\" to output hash table (put returned %d)", 
			       primary->name, i);	

		    }
		}
	    }
	}
      else
	skip_line(primary->buffer, &primary->buffer_pos, primary->file_length);
    }

  qlist_destroy (want_list);
}
