/* Quinn diff, another program to do something or other */
/* Copyright (C) 1997, 1998, James Troup <james@nocrew.org> */

/* This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef HASH_H
#define HASH_H

#include <sys/types.h>
#include <db.h>
#include "main.h"

#define PACKAGE_STR_LENGTH 35
#define VERSION_STR_LENGTH 45
#define PRIORTY_STR_LENGTH 25
#define SECTION_STR_LENGTH 25
#define LIBC_LENGTH 10

struct package_info {
  char package_name[PACKAGE_STR_LENGTH];
  char version[VERSION_STR_LENGTH];
};

void secondary_hash_create (void);
void secondary_hash_add (const char *package, const char *version);
int secondary_hash_retrieve (const char *package, secondary_package_info *secondary);
void secondary_hash_destroy(void);

#endif /* HASH_H */
