/*
 * ULTRA.H - the main header supporting the Ultra system
 *
 * Source Version: 4.0
 * Software Release #92-0043
 *
 */

#ifndef PCK_ULTRA

#include "cpyright.h"
 
#define PCK_ULTRA

/* Think C compiler defines THINK_C; CodeWarrior defines __MWERKS__ */
#ifdef THINK_C
# include "sx.h"
#else
# ifdef __MWERKS__
#  include "sx.h"
# else
#  include <sx.h>
# endif
#endif

#undef CODE
#define CODE "ULTRA 2.4"

#ifdef DOS
#define MAXPTS 100
#else
#define MAXPTS  2000                   /* number of points in buffer arrays */
#endif

#define NDISPLAY 26

#define UL_INTEGER   SC_INTEGER_I
#define UL_REAL      SC_DOUBLE_I
#define UL_LONG      SC_LONG_I
#define UL_CHAR      SC_CHAR_I
#define UL_STRING    SC_STRING_I
#define UL_P_STRING  SC_POINTER_I
#define UL_UNKNOWN   ERR_OBJ

#define UL_CURVE_INDEX_I 500
#define UL_DATA_ID_I     501   

#define HIST_LEFT    -10
#define HIST_RIGHT   -11
#define HIST_CENTER  -12

#define UL_prep_arg  SX_prep_arg
#define UL_prep_ret SX_prep_ret

/*--------------------------------------------------------------------------*/

/*                            PROCEDURAL MACROS                             */

/*--------------------------------------------------------------------------*/

/* ALLOC_CHECK - monitor the memory */

#ifdef MSC

#ifdef DEBUG

#define ALLOC_CHECK(s)                                                       \
    heapch = _heapchk();                                                     \
    if ((heapch != _HEAPOK) && (heapch != _HEAPEMPTY))                       \
       {heap_dump(TRUE);                                                     \
        sprintf(pbuffer, "HEAP ERROR IN %s", s);                             \
        SS_error(pbuffer, SS_null);}

#else

#define ALLOC_CHECK(s)

#endif

#else

#define ALLOC_CHECK(s)

#endif

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* UL_GET_STRING - return the printing representation of the ULTRA object */

#define UL_get_string(obj) (SS_get_string(obj))

/*--------------------------------------------------------------------------*/

/*                          TYPEDEFS AND STRUCTS                            */

/*--------------------------------------------------------------------------*/

struct s_UL_bin_info
  {FILE *stream;                            /* file pointer for binary file */
   long fileaddr;};                                 /* disk address of data */

typedef struct s_UL_bin_info bin_info;

struct s_UL_pdb_info
  {PDBfile *file;                           /* file pointer for binary file */
   char *curve_name;};                            /* curve name in PDB file */

typedef struct s_UL_pdb_info pdb_info;

#ifdef __cplusplus
extern "C" {
#endif

/*--------------------------------------------------------------------------*/

/*                           VARIABLE DECLARATIONS                          */

/*--------------------------------------------------------------------------*/

extern int
 UL_data_index[],
 UL_gr_mode,
 UL_n_curves_read,
 _UL_next_available_number,
 *UL_number,
 UL_default_npts,
 UL_simple_append,
 UL_N_Curves;

extern REAL
 UL_derivative_tolerance,
 UL_gxmin,
 UL_gxmax,
 UL_gymin,
 UL_gymax,
 UL_window_x,
 UL_window_x_P,
 UL_window_y,
 UL_window_y_P,
 UL_window_width,
 UL_window_width_P,
 UL_window_height,
 UL_window_height_P,
 UL_window_x_PS,
 UL_window_y_PS,
 UL_window_width_PS,
 UL_window_height_PS,
 UL_window_x_CGM,
 UL_window_y_CGM,
 UL_window_width_CGM,
 UL_window_height_CGM,
#ifdef HAVE_JPEGLIB
 UL_window_x_JPEG,
 UL_window_y_JPEG,
 UL_window_width_JPEG,
 UL_window_height_JPEG,
#endif
 UL_view_x,
 UL_view_y,
 UL_view_width,
 UL_view_height,
 UL_view_aspect;

extern REAL
 *UL_buf1x,
 *UL_buf1y,
 *UL_buf2x,
 *UL_buf2y;

extern curve
 *UL_dataset;

extern object
 *UL_ann_lst;

extern char
 *UL_ascii_output_format,
 *UL_display_name,
 *UL_display_type,
 *UL_display_title,
 *UL_OBJECT_S,
 UL_data_directory[];

extern FILE
 *UL_out_ascii,
 *UL_out_bin;

extern PDBfile
 *UL_out_pdb;
    
extern jmp_buf
 UL_jump_buffer;

extern PG_device
 *UL_CGM_device,
 *UL_graphics_device,
 *UL_PS_device;

#ifdef HAVE_JPEGLIB
extern PG_device
 *UL_JPEG_device;
#endif

/*--------------------------------------------------------------------------*/

/*                          PROCEDURE DECLARATIONS                          */

/*--------------------------------------------------------------------------*/


/* ULAUXF.C declarations */

extern object
 SC_DECLARE(*UL_fft, (int j)),
 SC_DECLARE(*UL_ifft, (object *argl)),
 SC_DECLARE(*UL_cfft, (object *argl)),
 SC_DECLARE(*UL_get_value, 
            (REAL *sp, REAL *vp, double val, int n, int id)),
 SC_DECLARE(*UL_curve_eval, (object *arg)),
 SC_DECLARE(*UL_getx, (object *obj, object *tok)),
 SC_DECLARE(*UL_gety, (object *obj, object *tok)),
 SC_DECLARE(*UL_fit, (object *obj, object *tok)),
 SC_DECLARE(*UL_fit_curve, (object *argl)),
 SC_DECLARE(*UL_dupx, (int j)),
 SC_DECLARE(*UL_stat, (int j)),
 SC_DECLARE(*UL_stats, (object *argl)),
 SC_DECLARE(*UL_disp, (int j, double d1, double d2));

extern void
 SC_DECLARE(UL_install_aux_funcs, (byte));

extern PM_matrix
 SC_DECLARE(*UL_lsq, (PM_matrix *a, PM_matrix *ay));


/* ULCNTL.C declarations */

extern void
 SC_DECLARE(UL_init_hash, (byte)),
 SC_DECLARE(UL_install_global_vars, (byte)),
 SC_DECLARE(UL_plot_limits, (PG_device *dev, int pflg,
	    REAL *pxmn, REAL *pxmx, REAL *pymn, REAL *pymx)),
 SC_DECLARE(UL_pause, (int pf));

extern object
 SC_DECLARE(*UL_describe, (object *s)),
 SC_DECLARE(*UL_apropos, (object *obj));


/* ULFUNC.C declarations */

extern void
 SC_DECLARE(_UL_quit, (int i)),
 SC_DECLARE(UL_install_scheme_funcs, (byte)),
 SC_DECLARE(UL_install_funcs, (byte));

extern object
 SC_DECLARE(*UL_delete, (object *s)),
 SC_DECLARE(*UL_sort, (int k)),
 SC_DECLARE(*_UL_make_ln,
	 (double slope, double interc, 
          double first, double last, int n));


/* ULHAND.C declarations */

extern void
 SC_DECLARE(UL_lmt, 
            (REAL *pt, int n, REAL *mymin, REAL *mymax)),
 SC_DECLARE(UL_check_order, (REAL *p, int n, int i));

extern int
 SC_DECLARE(UL_get_curve, (object *obj)),
 SC_DECLARE(UL_curvep_b, (object *obj)),
 SC_DECLARE(UL_curve_strp, (object *obj)),
 SC_DECLARE(UL_curvep_a, (object *obj)),
 SC_DECLARE(_UL_curvep, (char *s));

extern object
 SC_DECLARE(*UL_curveobjp, (object *obj)),
 SC_DECLARE(*UL_bltov, (PFInt basicf, object *argl)),
 SC_DECLARE(*UL_us, (PFInt basicf, object *argl)),
 SC_DECLARE(*UL_uc, (PFInt basicf, object *argl)),
 SC_DECLARE(*UL_opxc, (PFInt basicf, object *argl)),
 SC_DECLARE(*UL_opyc, (PFInt basicf, object *argl)),
 SC_DECLARE(*UL_ul2toc, (PFInt basicf, object *argl)),
 SC_DECLARE(*UL_ul2tocnp, (PFInt basicf, object *argl)),
 SC_DECLARE(*_UL_ul2toc, 
            (PFInt basicf, object *argl, int flag)),
 SC_DECLARE(*UL_ulntoc, (PFInt basicf, object *argl)),
 SC_DECLARE(*UL_uopxc, (PFInt basicf, object *argl)),
 SC_DECLARE(*UL_uopyc, (PFInt basicf, object *argl)),
 SC_DECLARE(*UL_bftoc, (PFInt basicf, object *argl)),
 SC_DECLARE(*UL_bltoc, (PFInt basicf, object *argl)),
 SC_DECLARE(*UL_bltocnp, (PFInt basicf, object *argl)),
 SC_DECLARE(*UL_bc, (PFInt basicf, object *argl)),
 SC_DECLARE(*UL_bcxl, (PFInt basicf, object *argl));


/* ULIO.C declarations */

extern object
 SC_DECLARE(*UL_valid_ultra_filep, (object *obj)),
 SC_DECLARE(*UL_read_data, (object *obj)),
 SC_DECLARE(*UL_read_ver1, (object *obj)),
 SC_DECLARE(*UL_read_ascii_table, (object *argl)),
 SC_DECLARE(*UL_table_curve, (object *argl)),
 SC_DECLARE(*UL_table_attr, (byte)),
 SC_DECLARE(*UL_file_info, (object *obj)),
 SC_DECLARE(*UL_write_data, (object *argl));

extern void
 SC_DECLARE(UL_uncache_curve, (curve *crv)),
 SC_DECLARE(UL_push_open_file, (FILE *fp)),
 SC_DECLARE(UL_close_open_files, (byte));


/* ULTRA.C declarations */

#ifdef DEBUG

extern int
 heapch;

#endif

extern object
 SC_DECLARE(*UL_mode_text, (byte)),
 SC_DECLARE(*UL_mode_graphics, (byte)),
 SC_DECLARE(*UL_plot, (byte)),
 SC_DECLARE(*UL_printscr, (byte)),
 SC_DECLARE(*UL_mk_curve_proc, (int i)),
 SC_DECLARE(*UL_set_id, (object *argl)),
 SC_DECLARE(*UL_thru, (object *s)),
 SC_DECLARE(*UL_copy_curve, (int j)),
 SC_DECLARE(*UL_extract_curve, (object *argl)),
 SC_DECLARE(*UL_xindex_curve, (int j)),
 SC_DECLARE(*_UL_mk_curve,
	 (int na, REAL *xa, REAL *ya, 
          char *UL_label, char *filename)),
 SC_DECLARE(*UL_rl_curve, (int j));

extern void
 SC_DECLARE(UL_init_view, (byte)),
 SC_DECLARE(UL_set_graphics_state, (PG_device *d)),
 SC_DECLARE(UL_enlarge_dataset, (byte)),
 SC_DECLARE(UL_zero_curve, (int i)),
 SC_DECLARE(UL_init_curves, (byte)),
 SC_DECLARE(UL_print_banner, (byte));

extern int
 SC_DECLARE(UL_next_space, (byte)),
 SC_DECLARE(UL_next_mark, (byte)),
 SC_DECLARE(_UL_curve_id, (int c)),
 SC_DECLARE(UL_curve_id, (object *c)),
 SC_DECLARE(UL_next_prefix, (void));


#ifdef __cplusplus
}
#endif

#endif

