/*
 * PDBDIR.C - provides a directory capability for PDBLib
 *
 * Source Version: 9.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"

#include "pdb.h"

int
 _PD_link_attribute = FALSE;

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PD_CD - change the current working directory
 *       - The directory may be specified by an absolute or relative path.
 */

int PD_cd(file, dirname)
   PDBfile *file;
   char *dirname;
   {char name[MAXLINE];
    syment *ep;

    PD_err[0] = '\0';

    if (file == NULL)
       {sprintf(PD_err, "ERROR: BAD FILE ID - PD_CD\n");
        return(FALSE);};
     
    if (dirname == NULL)
       strcpy(name, "/");
    else
       {strcpy(name, _PD_fixname(file, dirname));
        if (name[strlen(name) - 1] != '/')
           strcat(name, "/");};

    ep = PD_inquire_entry(file, name, FALSE, NULL);
    if (ep == NULL)
       {if (dirname == NULL)
           return(FALSE);

        else
           {if (strcmp(name, "/") != 0)
               {name[strlen(name) - 1] = '\0';
                ep = PD_inquire_entry(file, name, FALSE, NULL);
                strcat(name, "/");};

            if (ep == NULL)
               {sprintf(PD_err,
                        "ERROR: DIRECTORY %s NOT FOUND - PD_CD\n",
                        dirname);
                return(FALSE);};};};

    if (strcmp(ep->type, "Directory") != 0)
       {sprintf(PD_err, "ERROR: BAD DIRECTORY %s - PD_CD\n", dirname);
        return(FALSE);}

    else
       {if (file->current_prefix)
           SFREE(file->current_prefix);
        file->current_prefix = SC_strsavef(name, "char*:PD_CD:name");}

    return(TRUE);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PD_LN - create a link to a variable
 *       - This function simply installs a new symbol table entry. The new
 *       - syment is a copy of an already existing one, but with a new name.
 */

int PD_ln(file, oldname, newname)
   PDBfile *file;
   char *oldname, *newname;
   {syment *oldep;
    char newpath[MAXLINE], oldpath[MAXLINE], dirname[MAXLINE];
    char *nname, *s, **avl;

    PD_err[0] = '\0';

    if (file == NULL)
       {sprintf(PD_err, "ERROR: BAD FILE ID - PD_LN\n");
        return(FALSE);};

    if (oldname == NULL)
       {sprintf(PD_err, "ERROR: VARIABLE NAME NULL - PD_LN\n");
        return(FALSE);};

/* if opened in read-only mode */
    if (file->mode == PD_OPEN)
       {sprintf(PD_err, "ERROR: FILE OPENED READ-ONLY - PD_LN\n");
        return(FALSE);};
     
    strcpy(newpath, _PD_fixname(file, newname));
    nname = SC_firsttok(newpath, ".([ ");

    strcpy(oldpath, _PD_fixname(file, oldname));

/* make sure the directory in newname already exists */
    strcpy(dirname, nname);
    s = strrchr(dirname, '/');
    if ((s != NULL) && (PD_has_directories(file)))
       {s[1] = '\0';
        if (PD_inquire_entry(file, dirname, FALSE, NULL) == NULL)
           {dirname[strlen(dirname) - 1] = '\0';
            sprintf(PD_err,
                    "ERROR: DIRECTORY %s DOES NOT EXIST - PD_LN\n", dirname);
            return(FALSE);};};

    oldep = PD_inquire_entry(file, oldpath, TRUE, NULL);
    if (oldep == NULL)
       {sprintf(PD_err, "ERROR: VARIABLE %s NOT FOUND - PD_LN\n", oldname);
        return(FALSE);};
           
    _PD_e_install(nname, oldep, file->symtab);

    if (_PD_link_attribute)
       {if (!PD_inquire_attribute(file, "LINK", NULL))
	   if (!PD_def_attribute(file, "LINK", "char *"))
	      {sprintf(PD_err,
		       "ERROR: CANNOT CREATE LINK ATTRIBUTE - PD_LN\n");
	       return(FALSE);};

	avl  = FMAKE(char *, "PD_LN:avl");
	*avl = SC_strsavef(_PD_fixname(file, oldname),
			   "char*:PD_LN:fname");

	if (!PD_set_attribute(file, nname, "LINK", (byte *) avl))
	   {sprintf(PD_err, "ERROR: CANNOT SET LINK ATTRIBUTE - PD_LN\n");
	    return(FALSE);};};

    return(TRUE);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PD_LS - return a list of all variables and directories of the specified
 *       - type in the specified directory. If type is null, all types are
 *       - returned. If path is null, the root directory is searched.
 *       - Directories are terminated with a slash.
 */

char **PD_ls(file, path, type, num)
   PDBfile *file;
   char *path;
   char *type;
   int *num;
   {syment *ep;
    char **varlist, **outlist;
    char *name;
    char pattern[MAXLINE];
    int ne, nvars, i, has_dirs, head, pass;
     
    PD_err[0] = '\0';

    *num = 0;
    ne   = file->symtab->nelements;

    if (file == NULL)
       {sprintf(PD_err, "ERROR: BAD FILE ID - PD_LS\n");
        return(NULL);};

    if (num == NULL)
       {sprintf(PD_err, "ERROR: LAST ARGUMENT NULL - PD_LS\n");
        return(NULL);};

    if (ne == 0)
       return(NULL);
    
/* determine if file contains directories and
 * build a pattern which names must match e.g., '/dir/abc*'
 */
    if (PD_has_directories(file))
       {has_dirs = TRUE;
        if (path == NULL)
           {if (strcmp(PD_pwd(file), "/") == 0)
               strcpy(pattern, "/*");
            else
               sprintf(pattern, "%s/*", PD_pwd(file));}
        else
           {strcpy(pattern, _PD_fixname(file, path));
            ep = PD_inquire_entry(file, pattern, FALSE, NULL);
            if ((ep != NULL) && (strcmp(ep->type, "Directory") == 0))
               {if (pattern[strlen(pattern) - 1] == '/')
                   strcat(pattern, "*");
                else
                   strcat(pattern, "/*");}
            else
               {if (pattern[strlen(pattern) - 1] != '/')
                   {strcat(pattern, "/");
                    ep = PD_inquire_entry(file, pattern, FALSE, NULL);
                    if ((ep != NULL) && (strcmp(ep->type, "Directory") == 0))
                       strcat(pattern, "*");
                    else
                       pattern[strlen(pattern) - 1] = '\0';}
                else
                   {pattern[strlen(pattern) - 1] = '\0';
                    ep = PD_inquire_entry(file, pattern, FALSE, NULL);
                    if ((ep != NULL) && (strcmp(ep->type, "Directory") == 0))
                       strcat(pattern, "/*");
                    else
                       strcat(pattern, "/");};};};}
    else
       {has_dirs = FALSE;
        if (path == NULL)
           strcpy(pattern, "*");
        else
           strcpy(pattern, path);};
     
/* Generate the list of matching names. Note that this returns items which
 * are in the requested directory AND items which are in sub-directories of
 * the requested directory. In other words, all names which BEGIN with the
 * requested pattern are returned.
 */
    nvars = 0;
    outlist = FMAKE_N(char *, ne + 1, "PD_LS:outlist");
     
/*  The second pass is in case variables were written to the file before
 *  the first directory was created. Such variables lack an initial slash.
 */
    for (pass = 1; pass <= 2; pass++)

        {if (pass == 2)
            if (has_dirs && (strchr(pattern + 1, '/') == NULL))
               strcpy(pattern, pattern + 1);
            else
               break;

         varlist = SC_hash_dump(file->symtab, pattern);
     
         if ((varlist == NULL) || (varlist[0] == NULL))
            continue;
     
/* save only those variables which are IN the requested directory
 * (not in sub-directories), and are of the requested type
 */
         for (i = 0; (i < ne) && (varlist[i] != NULL); i++)
          
/* The entry '/' (the root directory) is a special case. It
 * is not a child of any directory, so should be ignored.
 */
             {if (strcmp("/", varlist[i]) == 0)
                 continue;
          
/* check to see if type of this variable matches request */
              if (type != NULL)
                 {ep = PD_inquire_entry(file, varlist[i], FALSE, NULL);
                  if (strcmp(ep->type, type) != 0)
		     continue;};

/*  If here, then variable is of right type. If this file has directories,
 *  check for any more slashes (/'s) in the name. If any are found, this
 *  is not a leaf element. NOTE: if directories are not used, slashes are
 *  valid charcters in file names.
 */
              if (has_dirs)
                 {if (pattern[0] != '/')
                     head = 0;
                  else
                     head = strlen(pattern) - strlen(strrchr(pattern, '/')) + 1;
                  name = &(varlist[i])[head];
                  if ((strlen(name) == 0) ||
                      ((pass == 2) && (name[0] == '/')) ||
                      ((strchr(name, '/') != NULL) &&
                       (strchr(name, '/') != ((name + strlen(name) - 1)))))
                     continue;}
              else
                 name = varlist[i];
          
/* variable is of right type and is a leaf in the requested directory */
              outlist[nvars++] = name;};};
     
         SFREE(varlist);
     
/* store a null string to terminate list (just a precaution) */
    outlist[nvars] = NULL;

    if (has_dirs)
       SC_string_sort(outlist, nvars);
     
    *num = nvars;
     
    return(outlist);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PD_MKDIR - create a directory
 *          - The directory may be specified by an absolute or relative path.
 */

int PD_mkdir(file, dirname)
   PDBfile *file;
   char *dirname;
   {int *dir, ret;
    char name[MAXLINE], head[MAXLINE];
    char *s;
    static int dir_num = 0;
     
    PD_err[0] = '\0';

    if (file == NULL)
       {sprintf(PD_err, "ERROR: BAD FILE ID - PD_MKDIR\n");
        return(FALSE);};

    if (dirname == NULL)
       {sprintf(PD_err, "ERROR: DIRECTORY NAME NULL - PD_MKDIR\n");
        return(FALSE);};
     
/* define type "Directory", if it hasn't been already */
    if (!PD_has_directories(file))
       {if ((PD_defncv(file, "Directory", 1, 0)) == NULL)
           return(FALSE);
          
/* write out the root directory */
        dir  = FMAKE(int,"PD_MKDIR:dir");
        *dir = dir_num;
        ret  = PD_write(file, "/", "Directory", dir);
        SFREE(dir);
        if (!ret)
           return(FALSE);
	file->current_prefix = SC_strsavef("/", "char*:PD_MKDIR:slash");
        dir_num++;}

/* build an absolute pathname */
    strcpy(name, _PD_fixname(file, dirname));
    if (name[strlen(name) - 1] != '/')
       strcat(name, "/");

/* make sure this directory hasn't already been created */
    if (PD_inquire_entry(file, name, FALSE, NULL) != NULL)
       {sprintf(PD_err,
                "ERROR: DIRECTORY %s ALREADY EXISTS - PD_MKDIR\n", name);
        return(FALSE);};

/* make sure the next higher level directory already exists */
    strcpy(head, name);
    head[strlen(head) - 1] = '\0';
    s = strrchr(head, '/');
    if (s != NULL)
       {s[1] = '\0';
        if (PD_inquire_entry(file, head, FALSE, NULL) == NULL)
           {head[strlen(head) - 1] = '\0';
            sprintf(PD_err,
                    "ERROR: DIRECTORY %s DOES NOT EXIST - PD_MKDIR\n", head);
            return(FALSE);};};

/* write the directory variable */
    dir  = FMAKE(int,"PD_MKDIR:dir");
    *dir = dir_num;
    ret  = PD_write(file, name, "Directory", dir);
    SFREE(dir);

    if (ret)
       dir_num++;

    return(ret);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PD_PWD - return the current working directory */

char *PD_pwd(file)
   PDBfile *file;
   {static char cwd[MAXLINE];

    PD_err[0] = '\0';

    if (file == NULL)
       {sprintf(PD_err, "ERROR: BAD FILE ID - PF_PWD\n");
        return(NULL);};

    if ((file->current_prefix == NULL) ||
        (strcmp(file->current_prefix, "/") == 0))
       strcpy(cwd, "/");
    else
       {strcpy(cwd, file->current_prefix);
        cwd[strlen(cwd) - 1] = '\0';}
    return(cwd);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PD_FIXNAME - make full pathname from current working directory
 *                  - and the given pathname (absolute or relative)
 */

char *_PD_fixname(file, inname)
   PDBfile *file;
   char *inname;
   {static char outname[MAXLINE];
    char *node, *s;
    char tmpstr[MAXLINE];

    if ((file == NULL) || (inname == NULL))
       return(NULL);

    outname[0] = '\0';

    if (!PD_has_directories(file))

/* if no directories, just copy verbatim */
       strcpy(outname, inname);

    else
          
/* Break path into slash-separated tokens.
 * Process each node individually.
 */
       {if (inname[0] != '/')
           strcpy(outname, PD_pwd(file));
        strcpy(tmpstr, inname);
        node = (char *) SC_strtok(tmpstr, "/", s);
          
        while (node != NULL)
           {if (strcmp(".",  node) == 0)
               {/* no-op */}

/* go up one level, unless already at top */
            else if (strcmp("..", node) == 0)
               {if (strcmp("/", outname) != 0)
                   {char  *s;
                    if (outname[strlen(outname) - 1] == '/')
                       outname[strlen(outname) - 1] = '\0';
                    s = strrchr(outname, '/');
                    if (s != NULL)
                       s[0] = '\0';};}

/* append to end of current path */
            else
               {if (outname[strlen(outname) - 1] != '/')
                   strcat(outname, "/");
                strcat(outname, node);}
            node = (char *) SC_strtok(NULL, "/", s);};

        if ((inname[strlen(inname) - 1] == '/') &&
            (outname[strlen(outname) - 1] != '/'))
           strcat(outname, "/");};

    if (outname[0] == '\0')
       strcpy(outname, "/");

    return(outname);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/



