// -*- Mode: C++; -*-
//                            Package   : omniORB2
// t_seq_objref.cc            Created on: 06/12/96
//                            Author    : Sai Lai Lo (sll)
//
// Copyright (C) Olivetti Research Limited, 1996
//
// Description:
 
/*
  $Log$
  */

#include <assert.h>
#include "seq1.hh"
#include <iostream.h>

static
const char* test_ior1 = "IOR:000000000000000d49444c3a4563686f3a312e3000051160000000010000000000000028000100000000000d3139322e352e3233392e363100208fec0000000c000000000000000000000004";


static
const char* test_ior2 = "IOR:000000000000000d49444c3a4563686f3a312e3000051160000000010000000000000028000100000000000d3139322e352e3233392e363100208fec0000000c000000000000000000000003";

static
CORBA::ORB_ptr orb;

static
void
test_seq_objref()
{
  int i;

  seq_echo s1;			// ctor seq_echo()

  seq_echo s2(15);		// ctor seq_echo(CORBA::ULong max);
  s2.length(10);
  for (i=0; i<10; i++)
    assert(CORBA::is_nil(s2[i]));

  CORBA::Object_ptr obj = orb->string_to_object(test_ior1);
  Echo_ptr e1 = Echo::_narrow(obj);
  assert(!CORBA::is_nil(e1));
  CORBA::release(obj);

  for (i=0; i<10; i++)
    s2[i] = Echo::_duplicate(e1);
  for (i=0; i<10; i++) {
    assert(e1->_is_equivalent(s2[i]));
  }

  obj = orb->string_to_object(test_ior2);
  Echo_ptr e2 = Echo::_narrow(obj);
  CORBA::release(obj);

  Echo_var echo_var = e2;
  for (i=0; i<10; i++)
    s2[i] = echo_var;
  for (i=0; i<10; i++) {
    assert(e2->_is_equivalent(s2[i]));
    assert(!e1->_is_equivalent(s2[i]));
  }
  
  seq_echo s3(s2);		// ctor seq_echo(const seq_echo &);
  for (i=0; i<10; i++) {
    assert(s3[i]->_is_equivalent(s2[i]));
  }

  s1 = s2;		// seq_echo &operator= (const seq_echo &);
  for (i=0; i<10; i++) {
    assert(s1[i]->_is_equivalent(s2[i]));
  }

  seq_echo_var s1_var;	// ctor seq_echo_var();
  assert(s1_var.operator->() == 0);
  s1_var = new seq_echo(s1);	// seq_echo_var &operator=(seq_echo *);
  for (i=0; i<10; i++) {
    assert(s1_var[i]->_is_equivalent(s1[i]));
  }

  Echo_var echo_var2 = s1[1]; // ctor Echo_var(_CORBA_ObjRef_Member<Echo> &);
  Echo_var echo_var3;
  echo_var3 = s1[1];	// Echo_var &Echo_var::operator=(_CORBA_ObjRef_Member<Echo> &)
  // Don't forget to release e1.
  // e2 is managed by e2_var and will be released by the dtor of e2_var
  CORBA::release(e1);
}

static
void
test_seqseq_objref()
{
  int i;
  CORBA::Object_ptr obj = orb->string_to_object(test_ior1);
  Echo_var e1 = Echo::_narrow(obj);
  assert(!CORBA::is_nil(e1));
  CORBA::release(obj);

  seq_echo s1(100);
  s1.length(100);
  for (i=0; i<100; i++) {
    s1[i] = e1;
  }

  seqseq_echo ss1; 		// ctor seqseq_echo();
  ss1.length(10);
  for (i=0; i<10; i++) {
    assert(ss1[i].length() == 0);
    ss1[i] = s1;
    assert(ss1[i].length() == 100);
  }

  seqseq_echo ss2(ss1);      // ctor seqseq_echo(const seqseq_echo &);
  assert(ss2.length() == 10);
  assert(ss2.maximum() == 10);
  for (i=0; i<10; i++) {
    assert(ss2[i].length() == 100);
  }

  seqseq_echo  ss3;
  ss3 = ss1;		  // seqseq_echo &operator= (const seqseq_echo&);
  assert(ss3.length() == 10);
  assert(ss3.maximum() == 10);
  for (i=0; i<10; i++) {
    assert(ss3[i].length() == 100);
  }
}

static
void
test_seqseqseq_objref()
{
  int i;
  CORBA::Object_ptr obj = orb->string_to_object(test_ior1);
  Echo_var e1 = Echo::_narrow(obj);
  assert(!CORBA::is_nil(e1));
  CORBA::release(obj);

  seq_echo s1(100);
  s1.length(100);
  for (i=0; i<100; i++) {
    s1[i] = e1;
  }

  seqseq_echo ss1;
  ss1.length(10);
  for (i=0; i<10; i++) {
    ss1[i] = s1;
  }

  seqseqseq_echo sss1;
  sss1.length(5);
  for (i=0; i<5; i++) {
    assert(sss1[i].length() == 0);
    sss1[i] = ss1;
    assert(sss1[i].length() == 10);
  }

  seqseqseq_echo sss2(sss1);
  assert(sss2.length() == 5);
  assert(sss2.maximum() == 5);
  for (i=0; i<5; i++) {
    assert(sss2[i].length() == 10);
  }

  seqseqseq_echo sss3;
  sss3 = sss1;
  assert(sss3.length() == 5);
  assert(sss3.maximum() == 5);
  for (i=0; i<5; i++) {
    assert(sss3[i].length() == 10);
  }

}


int
main(int argc, char **argv)
{
  int loopcount = 1;

  orb = CORBA::ORB_init(argc,argv,"omniORB2");

  while (loopcount--) {
    cerr << "Testing sequence<objref>...";
    test_seq_objref();
    cerr << "PASSED." << endl;
    cerr << "Testing sequence<sequence<objref> >...";
    test_seqseq_objref();
    cerr << "PASSED." << endl;
    cerr << "Testing sequence<sequence<sequence<objref> > >...";
    test_seqseqseq_objref();
    cerr << "PASSED." << endl;
  }

  return 0;

}
