/* 
   test-classes.m

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author: Mircea Oancea <mircea@jupiter.elcom.pub.ro>
   Date: 1996

   This file is part of the GNUstep Database Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <stdio.h>
#include <stdlib.h>

#include <Foundation/NSObject.h>
#include <Foundation/NSException.h>
#include <Foundation/NSArray.h>
#include <Foundation/NSDictionary.h>
#include <Foundation/NSString.h>

#include "test-classes.h"

@implementation TestClass

- init
{
    return self;
}

- initWithInt:(int)anInt
{
    [self init];
    i = anInt;
    return self;
}

- (void)dealloc
{
    printf("TestClass:dealloc:%d\n", i);
    [super dealloc];
}

- (int)intValue
{
    return i;
}

- retain
{
    refs++;
    return self;
}

- (void)release
{
    if (refs <= 0)
	[self dealloc];
    else
	refs--;
}

- (int)retainCount
{
    return refs+1;
}

@end
