/* 
   KeyValueCoding.m

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author: Mircea Oancea <mircea@jupiter.elcom.pub.ro>
   Date: August 1996

   This file is part of the GNUstep Database Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <Foundation/NSObject.h>
#include <eoaccess/EOKeyValueCoding.h>

/*
 * Interface for classes
 */

@interface KeyValueCodingIvar : NSObject
{
    id			ivarId;
    char		ivarChar;
    unsigned char	ivarUnsignedChar;
    short		ivarShort;
    unsigned short	ivarUnsignedShort;
    int			ivarInt;
    unsigned int	ivarUnsignedInt;
    long		ivarLong;
    unsigned long	ivarUnsignedLong;
    long long		ivarLongLong;
    unsigned long long	ivarUnsignedLongLong;
    float		ivarFloat;
    double		ivarDouble;
}
- (void)setTheIvarId:(id)arg;
@end

@interface KeyValueCodingMethod : KeyValueCodingIvar

- (id)ivarId;
- (char)ivarChar;
- (unsigned char)ivarUnsignedChar;
- (short)ivarShort;
- (unsigned short)ivarUnsignedShort;
- (int)ivarInt;
- (unsigned int)ivarUnsignedInt;
- (long)ivarLong;
- (unsigned long)ivarUnsignedLong;
- (long long)ivarLongLong;
- (unsigned long long)ivarUnsignedLongLong;
- (float)ivarFloat;
- (double)ivarDouble;

- (void)setIvarId:(id)arg;
- (void)setIvarChar:(char)arg;
- (void)setIvarUnsignedChar:(unsigned char)arg;
- (void)setIvarShort:(short)arg;
- (void)setIvarUnsignedShort:(unsigned short)arg;
- (void)setIvarInt:(int)arg;
- (void)setIvarUnsignedInt:(unsigned int)arg;
- (void)setIvarLong:(long)arg;
- (void)setIvarUnsignedLong:(unsigned long)arg;
- (void)setIvarLongLong:(long long)arg;
- (void)setIvarUnsignedLongLong:(unsigned long long)arg;
- (void)setIvarFloat:(float)arg;
- (void)setIvarDouble:(double)arg;

@end

@interface KeyValueCodingSpecial: NSObject
{
    id 	_ivarId;
    int	_ivarInt;
}

- (void)setIvarId:(const id)arg;
- (const id)ivarId;
- (id)setIvarInt:(int)arg;
- (void)ivarInt;

- (id)getId;
- (void)setId:(id)arg;
- (int)getInt;
- (void)setInt:(int)arg;
@end

/*
 * Implementation for classes
 */

@implementation KeyValueCodingIvar

- (void)setTheIvarId:(id)arg
{
    [ivarId autorelease];
    ivarId = [arg retain];
}

@end

@implementation KeyValueCodingMethod

- (id)ivarId 						{return ivarId;}
- (char)ivarChar 					{return ivarChar;}
- (unsigned char)ivarUnsignedChar 			{return ivarUnsignedChar;}
- (short)ivarShort 					{return ivarShort;}
- (unsigned short)ivarUnsignedShort			{return ivarUnsignedShort;}
- (int)ivarInt						{return ivarInt;}
- (unsigned int)ivarUnsignedInt				{return ivarUnsignedInt;}
- (long)ivarLong					{return ivarLong;}
- (unsigned long)ivarUnsignedLong			{return ivarUnsignedLong;}
- (long long)ivarLongLong				{return ivarLongLong;}
- (unsigned long long)ivarUnsignedLongLong		{return ivarUnsignedLongLong;}
- (float)ivarFloat					{return ivarFloat;}
- (double)ivarDouble					{return ivarDouble;}

- (void)setIvarId:(id)arg
{
    [ivarId autorelease];
    ivarId = [arg retain];
}

- (void)setIvarChar:(char)arg				{ivarChar = arg;}
- (void)setIvarUnsignedChar:(unsigned char)arg		{ivarUnsignedChar = arg;}
- (void)setIvarShort:(short)arg				{ivarShort = arg;}
- (void)setIvarUnsignedShort:(unsigned short)arg;	{ivarUnsignedShort = arg;}
- (void)setIvarInt:(int)arg				{ivarInt = arg;}
- (void)setIvarUnsignedInt:(unsigned int)arg		{ivarUnsignedInt = arg;}
- (void)setIvarLong:(long)arg				{ivarLong = arg;}
- (void)setIvarUnsignedLong:(unsigned long)arg		{ivarUnsignedLong = arg;}
- (void)setIvarLongLong:(long long)arg			{ivarLongLong = arg;}
- (void)setIvarUnsignedLongLong:(unsigned long long)arg	{ivarUnsignedLongLong = arg;}
- (void)setIvarFloat:(float)arg				{ivarFloat = arg;}
- (void)setIvarDouble:(double)arg			{ivarDouble = arg;}

@end


@implementation KeyValueCodingSpecial

- (void)setIvarId:(const id)arg			{[_ivarId autorelease]; _ivarId = [arg retain];}
- (const id)ivarId				{return _ivarId;}
- (id)setIvarInt:(int)arg			{_ivarInt = arg; return self;}
- (void)ivarInt					{}

- (id)getId					{return _ivarId;}
- (void)setId:(id)arg				{[_ivarId autorelease]; _ivarId = [arg retain];}
- (int)getInt					{return _ivarInt;}
- (void)setInt:(int)arg				{_ivarInt = arg;}
@end


