/* 
   EOQualifiedAssociation.m

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author: Mircea Oancea <mircea@jupiter.elcom.pub.ro>
   Date: November 1996

   This file is part of the GNUstep Database Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <eoaccess/common.h>

#if NeXT_foundation_LIBRARY
typedef void NXTypedStream;
#endif

#include <eointerface/EOQualifiedAssociation.h>

@implementation EOQualifiedAssociation

- (void)_masterChanged
{
	id sel = [controller selectedObjects];
	id src = [destination dataSource];
	id kar;
	
	if (!src) {
		src = [(id)[controller dataSource] 
		    dataSourceQualifiedByKey:key];
		[destination setDataSource:src];
	}
	if ([sel count] != 1) {
		[src qualifyWithRelationshipKey:key ofObject:nil];
		[destination fetch];
		masterEO = masterValue = nil;
		return;
	}
	sel = [sel objectAtIndex:0];

	kar = [[NSArray alloc] initWithObjects:key,nil];
	if (masterEO != sel || 
		[[sel valuesForKeys:kar] objectForKey:key] != masterValue) {
		[src qualifyWithRelationshipKey:key ofObject:sel];

		if ([controller respondsToSelector:@selector(fetchInProgress)])
		{
			if (![controller fetchInProgress])
				[destination fetch];
		}
		else
			[destination fetch];

		masterValue = [[sel valuesForKeys:kar] objectForKey:key];
		masterEO = sel;
	}
	[kar release];
}

- (void)contentsDidChange 
{
	[self _masterChanged];
}

- (void)selectionDidChange
{
	[self _masterChanged];
}

- (void)endEditing 
{
	[destination endEditing];
}

@end /* EOQualifiedAssociation */
