/* 
   SybaseValues.h

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author: Ovidiu Predescu <ovidiu@bx.logicnet.ro>
   Date: October 1996

   This file is part of the GNUstep Database Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef __SybaseValues_h__
#define __SybaseValues_h__

#include <Foundation/NSString.h>
#include <Foundation/NSValue.h>
#include <Foundation/NSData.h>
#include <Foundation/NSDate.h>
#include <eoaccess/EONull.h>

@class EOAttribute;
@class SybaseChannel;

@interface NSString (SybaseValueCreation)
+ valueFromBytes:(const char*)bytes
  length:(unsigned)lenth
  sybaseType:(int)type
  attribute:(EOAttribute*)attribute
  adaptorChannel:(SybaseChannel*)channel
  zone:(NSZone*)zone;
- (NSString*)stringValueForSybaseType:(int)type
  attribute:(EOAttribute*)attribute;
@end

@interface NSNumber (SybaseValueCreation)
+ valueFromBytes:(const char*)bytes
  length:(unsigned)lenth
  sybaseType:(int)type
  attribute:(EOAttribute*)attribute
  adaptorChannel:(SybaseChannel*)channel
  zone:(NSZone*)zone;
- (NSString*)stringValueForSybaseType:(int)type
  attribute:(EOAttribute*)attribute;
@end

@interface NSData (SybaseValueCreation)
+ valueFromBytes:(const char*)bytes
  length:(unsigned)lenth
  sybaseType:(int)type
  attribute:(EOAttribute*)attribute
  adaptorChannel:(SybaseChannel*)channel
  zone:(NSZone*)zone;
- (NSString*)stringValueForSybaseType:(int)type
  attribute:(EOAttribute*)attribute;
@end

@interface NSCalendarDate (SybaseValueCreation)
+ valueFromBytes:(const char*)bytes
  length:(unsigned)lenth
  sybaseType:(int)type
  attribute:(EOAttribute*)attribute
  adaptorChannel:(SybaseChannel*)channel
  zone:(NSZone*)zone;
- (NSString*)stringValueForSybaseType:(int)type
  attribute:(EOAttribute*)attribute;
@end

@interface EONull (SybaseValueCreation)
- (NSString*)stringValueForSybaseType:(int)type
  attribute:(EOAttribute*)attribute;
@end

@interface NSObject (SybaseValueCreation)
+ valueFromBytes:(const char*)bytes
  length:(unsigned)lenth
  sybaseType:(int)type
  attribute:(EOAttribute*)attribute
  adaptorChannel:(SybaseChannel*)channel
  zone:(NSZone*)zone;
- (NSString*)stringValueForSybaseType:(int)type
  attribute:(EOAttribute*)attribute;
@end

#endif /* __SybaseValues_h__ */
