/* 
   Postgres95Context.m

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author: Mircea Oancea <mircea@jupiter.elcom.pub.ro>
	      based on the Sybase Adaptor written by 
	   Ovidiu Predescu <ovidiu@bx.logicnet.ro>
   Date: December 1996

   This file is part of the GNUstep Database Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <Foundation/NSString.h>
#include <Foundation/NSArray.h>
#include <Foundation/NSValue.h>

#include <eoadaptors/Postgres95/Postgres95Adaptor.h>
#include <eoadaptors/Postgres95/Postgres95Context.h>
#include <eoadaptors/Postgres95/Postgres95Channel.h>

@implementation Postgres95Context

- (BOOL)primaryBeginTransaction
{
    return [[[channels objectAtIndex:0] nonretainedObjectValue]
		evaluateExpression:@"BEGIN TRANSACTION"];
}

- (BOOL)primaryCommitTransaction
{
    return [[[channels objectAtIndex:0] nonretainedObjectValue]
		evaluateExpression:@"END TRANSACTION"];
}

- (BOOL)primaryRollbackTransaction
{
    return [[[channels objectAtIndex:0] nonretainedObjectValue]
		evaluateExpression:@"ABORT TRANSACTION"];
}

- (BOOL)canNestTransactions		{ return NO; }

@end /* Postgres95Context */
