/* 
   Postgres95Adaptor.h

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author: Mircea Oancea <mircea@jupiter.elcom.pub.ro>
	      based on the Sybase Adaptor written by 
	   Ovidiu Predescu <ovidiu@bx.logicnet.ro>
   Date: December 1996

   This file is part of the GNUstep Database Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef __Postgres95Adaptor_h__
#define __Postgres95Adaptor_h__

#include <eoaccess/EOAdaptor.h>

/* Include Postgres 95 Headers */

#undef Assert
#include <stdio.h>
#include <libpq-fe.h>
#include <libpq/libpq-fs.h>
#undef Assert

@class NSMutableArray;
@class NSMutableSet;

/* The following keys are meaningful in the connectionDictionary in a model:

    databaseServer or hostName - the name of the server 
	(default getenv(PGHOST) or localhost)
    databaseName - the name of the database to use 
	(default getenv(PGDATABASE))
    options - additional options sent to the POSTGRES95 backend
	(default getenv(PGOPTIONS))
    port - port to communicate with POSTGRES95 backend
	(default getenv(PGPORT))
    debugTTY - filename (file/device) used for debugging output
	(default getenv(PGTTY))

    NOTE: user name is not given explicitly - the library uses the 
          real user id of the user running the program and that user id
	  is interpreted by the server (AFAIK)
*/

@interface Postgres95Adaptor : EOAdaptor
{
    NSMutableSet* validQualifierTypes;
    NSMutableArray *pgConnPool;
    int pgConnPoolLimit;

    struct {
	BOOL cachePGconn:1;
    } flags;
}

/* Reporting errors */
- (void)privateReportError:(PGconn*)pgConn;

/* Getting the Postgres95 constant that represents a native type */
- (void)setTypeName:(NSString*)typeName validForQualifier:(BOOL)flag;
- (void)initValidTypeNamesForQualifier;

/* Configure the adaptor to share the PGconn or not. The default is not to
   share PGconn. */ 
- (void)setCachePGconn:(BOOL)flag;
- (BOOL)cachePGconn;
- (void)setPGconnPoolLimit:(int)newLimit;
- (int)pgConnPoolLimit;

/* Inherited methods */
- (Class)adaptorChannelClass;
- (BOOL)isValidQualifierType:(NSString*)typeName;

// Private methods

/* Obtaining and releasing a PGconn from pool */
- (PGconn*)createPGconn;
- (PGconn*)newPGconn;
- (void)releasePGconn:(PGconn*)pgConn force:(BOOL)flag;

@end

#endif /* __Postgres95Adaptor_h__ */
