/* 
   common.h

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author: Ovidiu Predescu <ovidiu@bx.logicnet.ro>
	   Mircea Oancea <mircea@jupiter.elcom.pub.ro>
	   Florin Mihaila <florinm@pathcom.com>
	   Bogdan Baliuc <stark@protv.ro>
   Date: 1995, 1996

   This file is part of the GNUstep Database Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef __common_h__
#define __common_h__

#include "../config.h"

#if HAVE_STRING_H
# include <string.h>
#endif

#if HAVE_STDLIB_H
# include <stdlib.h>
#else
extern void* malloc();
extern void* calloc();
extern void* realloc();
extern void free();
extern atoi();
extern atol();
#endif

#if HAVE_LIBC_H
# include <libc.h>
#else
#ifndef __WIN32__
# include <unistd.h>
#endif /* !__WIN32__ */
#endif

#include <sys/types.h>
#ifndef __WIN32__
#include <pwd.h>
#endif /* !__WIN32__ */
#include <stdarg.h>

#include <Foundation/NSZone.h>

@class NSString;

#if (__GNUC__ == 2) && (__GNUC_MINOR__ <= 6) && !defined(__attribute__)
#  define __attribute__(x)
#endif

static inline void *Malloc(int) __attribute__((unused));
static inline void Free(void*) __attribute__((unused));
static inline void *Calloc(int, int) __attribute__((unused));
static inline void *Realloc(void*, int) __attribute__((unused));
static inline int Strlen(const char*) __attribute__((unused));
static inline char* Strdup(const char*) __attribute__((unused));
static inline char* Strcpy (char*, const char*) __attribute__((unused));
static inline char* Strncpy (char*, const char*, unsigned)
    __attribute__((unused));
static inline char* Strcat (char*, const char*) __attribute__((unused));
static inline char* Strncat (char*, const char*, unsigned)
    __attribute__((unused));
static inline int Strcmp(const char*, const char*) __attribute__((unused));
static inline int Strncmp(const char*, const char*, unsigned)
    __attribute__((unused));
static inline int Atoi(const char*) __attribute__((unused));
static inline long Atol(const char*) __attribute__((unused));

static inline void *Malloc(int size)
{
    return malloc(size);
}

static inline void Free(void* p)
{
    if(p) free(p);
}

static inline void *Calloc(int elem, int size)
{
    return calloc(elem, size);
}

static inline void *Realloc(void* p, int size)
{
    return realloc(p, size);
}

static inline int Strlen(const char* s)
{
    return s ? strlen(s) : 0;
}

static inline char* Strdup(const char* s)
{
    return s ? strcpy(Malloc(strlen(s) + 1), s) : NULL;
}

static inline char* Strcpy (char* d, const char* s)
{
    return s && d ? strcpy(d, s) : d;
}

static inline char* Strncpy (char* d, const char* s, unsigned size)
{
    return s && d ? strncpy(d, s, size) : d;
}

static inline char* Strcat (char* d, const char* s)
{
    return s && d ? strcat(d, s) : d;
}

static inline char* Strncat (char* d, const char* s , unsigned size)
{
    return s && d ? strncat(d, s , size) : d;
}

static inline int Strcmp(const char* p, const char* q)
{
    if(!p) {
        if(!q)
            return 0;
        else return -1;
    }
    else {
        if(!q)
            return 1;
        else return strcmp(p, q);
    }
}

static inline int Strncmp(const char* p, const char* q, unsigned size)
{
    if(!p) {
        if(!q)
            return 0;
        else return -1;
    }
    else {
        if(!q)
            return 1;
        else return strncmp(p, q, size);
    }
}

static inline int Atoi(const char* str)
{
    return str ? atoi(str) : 0;
}

static inline long Atol(const char *str)
{
    return str ? atol(str) : 0;
}

extern char *Ltoa(long nr, char *str, int base);

#ifndef MAX
#define MAX(a, b) \
    ({typedef _ta = (a), _tb = (b);   \
	_ta _a = (a); _tb _b = (b);     \
	_a > _b ? _a : _b; })
#endif

#ifndef MIN
#define MIN(a, b) \
    ({typedef _ta = (a), _tb = (b);   \
	_ta _a = (a); _tb _b = (b);     \
	_a < _b ? _a : _b; })
#endif

#ifndef ASSIGN
#define ASSIGN(var, value) \
  if (var != value) \
    { \
    [value retain]; \
    [var release]; \
    var = value; \
    }
#endif

#endif /* __common_h__ */
