/* 
   EOSQLExpression.h

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author: Ovidiu Predescu <ovidiu@bx.logicnet.ro>
   Date: September 1996

   This file is part of the GNUstep Database Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef __EOSQLExpression_h__
#define __EOSQLExpression_h__

#include <Foundation/NSDictionary.h>
#include <Foundation/NSArray.h>

#include <eoaccess/EOExpressionArray.h>
#include <eoaccess/EOJoin.h>

@class EOAdaptor;
@class EOAdaptorChannel;
@class EOEntity;
@class EOQualifier;

@interface EOSQLExpression : NSObject <EOExpressionContext>
{
    EOEntity* entity;
    EOAdaptor* adaptor;
    NSMutableDictionary* entitiesAndPropertiesAliases;
    NSMutableArray* fromListEntities;
    NSMutableString* content;
}

/* Building SQL expressions */
+ deleteExpressionWithQualifier:(EOQualifier*)qualifier
  channel:(EOAdaptorChannel*)channel;
+ insertExpressionForRow:(NSDictionary*)row
  entity:(EOEntity*)entity
  channel:(EOAdaptorChannel*)channel;
+ selectExpressionForAttributes:(NSArray*)attributes
  lock:(BOOL)flag
  qualifier:(EOQualifier*)qualifier
  fetchOrder:(NSArray*)fetchOrder
  channel:(EOAdaptorChannel*)channel;
+ updateExpressionForRow:(NSDictionary*)row
  qualifier:(EOQualifier*)qualifier
  channel:(EOAdaptorChannel*)channel;

- deleteExpressionWithQualifier:(EOQualifier*)qualifier
  channel:(EOAdaptorChannel*)channel;
- insertExpressionForRow:(NSDictionary*)row
  entity:(EOEntity*)entity
  channel:(EOAdaptorChannel*)channel;
- selectExpressionForAttributes:(NSArray*)attributes
  lock:(BOOL)flag
  qualifier:(EOQualifier*)qualifier
  fetchOrder:(NSArray*)fetchOrder
  channel:(EOAdaptorChannel*)channel;
- updateExpressionForRow:(NSDictionary*)row
  qualifier:(EOQualifier*)qualifier
  channel:(EOAdaptorChannel*)channel;

+ (Class)selectExpressionClass;
+ (Class)insertExpressionClass;
+ (Class)deleteExpressionClass;
+ (Class)updateExpressionClass;

/* Getting the adaptor */
- (EOAdaptor*)adaptor;

// Private methods.

/* Creating components for the SELECT operation */
- (NSString*)selectListWithAttributes:(NSArray*)attributes;
- (NSString*)fromClause;
- (NSString*)whereClauseForQualifier:(EOQualifier*)qualifier
  joinExpresssion:(NSString*)joinExpression;
- (NSString*)joinExpressionForOperator:(EOJoinOperator)operator 
  semantic:(EOJoinSemantic)semantic;
- (NSString*)joinExpressionForOperator:(EOJoinOperator)operator 
  semantic:(EOJoinSemantic)semantic
  source:source
  destination:destination;
- (NSString*)joinExpressionForRelationshipPaths:(NSArray*)relationshipPaths;
- (NSString*)lockClause;
- (NSString*)orderByClauseForFetchOrder:(NSArray*)fetchOrder;

/* Creating components for the UPDATE operation */
- updateListForRow:(NSDictionary*)row;

/* Creating components for the INSERT operation */
- columnListForRow:(NSDictionary*)row;
- valueListForRow:(NSDictionary*)row;

/* Final initialization */
- finishBuildingExpression;

/* Caching aliases */
- (NSArray*)relationshipPathsForAttributes:(NSArray*)attributes
  qualifier:(EOQualifier*)qualifier
  fetchOrder:(NSArray*)fetchOrder;

/* Getting the entity */
- (EOEntity*)entity;

/* Getting the expression value of an attribute in a given context. This
   method is used by the expressionValueForAttribute: method. */
- (NSString*)expressionValueForAttribute:(EOAttribute*)attribute
  context:context;

@end


/* Private subclasses used by EOSQLExpression. */

@interface EOSelectSQLExpression : EOSQLExpression
@end

@interface EOUpdateSQLExpression : EOSQLExpression
@end

@interface EOInsertSQLExpression : EOSQLExpression
@end

@interface EODeleteSQLExpression : EOSQLExpression
@end

#endif /* __EOSQLExpression_h__ */
