/* 
   EOQualifier.h

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author: Ovidiu Predescu <ovidiu@bx.logicnet.ro>
   Date: September 1996

   This file is part of the GNUstep Database Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef __EOQualifier_h__
#define __EOQualifier_h__

#include <extensions/GCObject.h>
#include <eoaccess/EOExpressionArray.h>

@class NSDictionary;
@class NSString;
@class NSMutableSet;

@class EOEntity;
@class EORelationship;
@class EOExpressionArray;

@interface EOQualifier : GCObject <NSCopying>
{
    /* TODO: these should be GCMutableSet */
    NSMutableSet* relationshipPaths;
    NSMutableSet* additionalEntities;

    /* Garbage collectable objects */
    EOEntity* entity;
    EOExpressionArray* content;
    BOOL usesDistinct;
}

/* Creating instances */
+ (EOQualifier*)qualifierForRow:(NSDictionary*)row
  entity:(EOEntity*)entity;
+ (EOQualifier*)qualifierForPrimaryKey:(NSDictionary*)key
  entity:(EOEntity*)entity;
+ (EOQualifier*)qualifierForRow:(NSDictionary*)row 
  relationship:(EORelationship*)relationship;
+ (EOQualifier*)qualifierForObject:sourceObject 
  relationship:(EORelationship*)relationship;
- initWithEntity:(EOEntity*)entity 
  qualifierFormat:(NSString*)qualifierFormat, ...;

/* Combining qualifiers */
- (void)negate;
- (void)conjoinWithQualifier:(EOQualifier*)qualifier;
- (void)disjoinWithQualifier:(EOQualifier*)qualifier;

/* Getting the entity */
- (EOEntity*)entity;

/* Checking the definition */
- (BOOL)isEmpty;

/* Accessing the distinct selection */
- (void)setUsesDistinct:(BOOL)flag;
- (BOOL)usesDistinct;

/* Accessing the relationships referred within qualifier */
- (NSMutableSet*)relationshipPaths;
- (NSMutableSet*)additionalEntities;

/* Getting the expression value */
- (NSString*)expressionValueForContext:(id<EOExpressionContext>)ctx;

/* Private methods */
- (void)_computeRelationshipPaths;

@end

#endif /* __EOQualifier_h__ */
