/* 
   EONull.m

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author: Mircea Oancea <mircea@jupiter.elcom.pub.ro>
   Date: 1996

   This file is part of the GNUstep Database Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <eoaccess/EOExpressionArray.h>
#include "EONull.h"

@implementation EONull

static EONull* sharedEONull = nil;

+ (void)initialize
{
    // THREAD - do this operation under a lock
    sharedEONull = (EONull*)NSAllocateObject(self, 0, NSDefaultMallocZone());
}

+ null
{
    return sharedEONull;
}

+ allocWithZone
{
    return sharedEONull;
}

- copy
{
    return self;
}

- copyWithZone:(NSZone*)zone
{
    return self;
}

// One cannot destroy the shared null object

- retain
{
    return self;
}

- autorelease
{
    return self;
}

- (void)release
{
}

- (void)dealloc
{
}

// Coding Methods are OK in NSObject since we do not have anything to encode
// execept the class name and when decoding first allocWithZone: is called
// to create a new instance of the class (and this returns the shared null).

- (NSString*)expressionValueForContext:(id<EOExpressionContext>)context
{
    return @"NULL";
}

@end /* EONull */

