// $Id: writers.cc,v 1.35 1998/10/08 07:18:44 cvs_christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#define WITH_STRUCT_FILLING
#include "writers.hh"

static bool ReturnTrue(const Widget &w)
{  return true;
}

static bool ReturnFalse(const Widget &w)
{  return false;
}

const WriterType Writer::writers[]=
{  // sort by: 'sort -t \( -k 2'
   STRUCT_BASIC		("GtkAdjustment",Gtk_Adjustment),
   STRUCT_BASIC		("GtkArrow",Gtk_Arrow),
   STRUCT_BASIC		("GtkButton",Gtk_Button),
   STRUCT_BASIC_SUBW_SAMP	("GtkCList",Gtk_CList),
   STRUCT_BASIC		("GtkCheckButton",Gtk_CheckButton),
   STRUCT_BASIC_SAMP	("GtkCombo",Gtk_Combo),
   STRUCT_CONTAINER_SUBW	("GtkDialog",Gtk_Dialog),
   STRUCT_BASIC		("GtkEntry",Gtk_Entry),
   STRUCT_CONTAINER	("GtkFixed",Gtk_Fixed),
   STRUCT_CONTAINER	("GtkFrame",Gtk_Frame),
   STRUCT_CONTAINER	("GtkHBox",Gtk_Box),
   STRUCT_CONTAINER	("GtkHPaned",Gtk_Paned),
   STRUCT_BASIC		("GtkHRuler",Gtk_Ruler),
   STRUCT_BASIC_NEED	("GtkHScale",Gtk_Scale),
   STRUCT_BASIC_NEED	("GtkHScrollbar",Gtk_Scrollbar),
   STRUCT_BASIC		("GtkHSeparator",Gtk_Separator),
   STRUCT_BASIC		("GtkLabel",Gtk_Label),
   STRUCT_AMBIG		("GtkMenu",Gtk_Menu),
   STRUCT_CONTAINER_NEED_SAMP	("GtkMenuBar",Gtk_MenuBar),
   STRUCT_AMBIG		("GtkMenuItem",Gtk_MenuItem),
   STRUCT_CONTAINER_NEED	("GtkNotebook",Gtk_Notebook),
   STRUCT_BASIC_NEED_SAMP	("GtkOptionMenu",Gtk_OptionMenu),
   STRUCT_BASIC_SAMP	("GtkProgressBar",Gtk_ProgressBar),
   STRUCT_BASIC_NEED	("GtkRadioButton",Gtk_RadioButton),
   STRUCT_CONTAINER	("GtkScrolledWindow",Gtk_ScrolledWindow),
   STRUCT_BASIC_NEED	("GtkSpinButton",Gtk_SpinButton),
   STRUCT_BASIC_SAMP	("GtkStatusbar",Gtk_Statusbar),
   STRUCT_CONTAINER	("GtkTable",Gtk_Table),
   STRUCT_BASIC		("GtkText",Gtk_Text),
   STRUCT_BASIC		("GtkToggleButton",Gtk_ToggleButton),
   STRUCT_BASIC_SAMP	("GtkToolbar",Gtk_Toolbar), // might get container
   STRUCT_BASIC_SAMP	("GtkTree",Gtk_Tree), // might get container
   STRUCT_CONTAINER	("GtkVBox",Gtk_Box),
   STRUCT_CONTAINER	("GtkVPaned",Gtk_Paned),
   STRUCT_BASIC		("GtkVRuler",Gtk_Ruler),
   STRUCT_BASIC_NEED	("GtkVScale",Gtk_Scale),
   STRUCT_BASIC_NEED	("GtkVScrollbar",Gtk_Scrollbar),
   STRUCT_BASIC		("GtkVSeparator",Gtk_Separator),
   STRUCT_CONTAINER_SAMP	("GtkWindow",Gtk_Window),
   STRUCT_BASIC		("Placeholder",Placeholder),
   STRUCT_BASIC		(0,Default) 
};

const int Writer::maxindex=(sizeof(Writer::writers)/sizeof(Writer::writers[0]))-1;
