// $Id: window.cc,v 1.22 1998/09/25 13:33:51 cvs_christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "writers.hh"
#include "../Configuration.hh"

void Gtk_Window::Include(File &f,const Widget &w)
{  f.include("gtk--/window.h");
   if (Configuration.sample_code) f.include("gtk--/main.h");
   Gtk_Container::Include(f,w);
}

void Gtk_Window::Declare(File &f,const Widget &w)
{  cerr << "Warning: container contains Window ???\n";
   StandardWriter::Declare(f,w,"Gtk_Window");
}

void Gtk_Window::Derive(File &f,const Widget &w)
{  f << "Gtk_Window"; // compound ???
}

void Gtk_Window::Construct(File &f,const Widget &w,bool is_member)
{  const string type=w.getString("type","GTK_WINDOW_TOPLEVEL");
   f << StandardWriter::ConstructName(f,w,is_member,"Gtk_Window");
   f << "(" << type << ")";
}

bool Gtk_Window::NeedConstruct(const Widget &w,bool is_member)
{  return w.hasTag("type");
}

void Gtk_Window::Customize(File &f,const Widget &w,const string instance)
{  Gtk_Container::Customize(f,w,instance);
   string title(w.getString("title",""));
   if (title.size())
      f << instance << "set_title(\"" << f.CString(title) << "\");\n\t";
   string position(w.getString("position",""));
   if (position.size() && position!="GTK_WIN_POS_NONE")
      f << instance << "position(\"" << position << "\");\n\t";
   bool allow_shrink=w.getBool("allow_shrink",false);
   bool allow_grow=w.getBool("allow_grow",true);
   bool auto_shrink=w.getBool("auto_shrink",false);
   if (allow_shrink || !allow_grow || auto_shrink)
      f << instance << "set_policy(" << (allow_shrink?"true":"false")
        << ", " << (allow_grow?"true":"false")
        << ", " << (auto_shrink?"true":"false") << ");\n\t";
   StandardWriter::AddChildren(f,w,instance);
}

bool Gtk_Window::SampleCode(File &f,const Widget &w,enum WriterType::CodePosition pos,const string misc)
{  switch(pos)
   {  
#if 0
      case WriterType::ContainingConstructor: // not needed now ...
   	 break;
#endif
      case WriterType::Constructor:
         {  Widget::const_iterator i=w.get_Signals();
            for (;i!=w.end() && (*i).getString("name","")!="delete_event";++i);
            if (i==w.end())
               f << "\tconnect_to_method(destroy, "
               		"Gtk_Main::instance(), &Gtk_Main::quit);\n";
   	 }
   	 break;
      default: break;
   }
   return false;
}
