// $Id: statusbar.cc,v 1.6 1998/09/24 13:19:49 cvs_christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "writers.hh"

void Gtk_Statusbar::Include(File &f,const Widget &w)
{  f.include("gtk--/statusbar.h");
}

void Gtk_Statusbar::Declare(File &f,const Widget &w)
{  StandardWriter::Declare(f,w,"Gtk_Statusbar");
}

void Gtk_Statusbar::Construct(File &f,const Widget &w,bool is_member)
{  f << StandardWriter::ConstructName(f,w,is_member,"Gtk_Statusbar");
   f << "()";
}

bool Gtk_Statusbar::NeedConstruct(const Widget &w,bool is_member)
{  return false;
}

void Gtk_Statusbar::Customize(File &f,const Widget &w,const string instance)
{  Gtk_Widget::Customize(f,w,instance);
   // append
}

bool Gtk_Statusbar::SampleCode(File &f,const Widget &w,enum WriterType::CodePosition pos,const string misc)
{  switch(pos)
   {  case WriterType::ContainingConstructor:
         {  f << "\t" << f.InstanceName(w.Name()) << (w.isPointer() ? "->" : "." )
              << "push(1, \"some status text\");\n";
            f << "\t" << f.InstanceName(w.Name()) << (w.isPointer() ? "->" : "." )
              << "push(2, \"yet another status text\");\n";
   	 }
   	 break;
      default: break;
   }
   return false;
}
