// $Id: spinbutton.cc,v 1.13 1998/09/24 13:19:49 cvs_christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "writers.hh"

void Gtk_SpinButton::Include(File &f,const Widget &w)
{  f.include("gtk--/spinbutton.h");
}

void Gtk_SpinButton::DeclareNeeded(File &f,const Widget &w)
{  Gtk_Adjustment::Declare(f,Widget(w,f.InstanceName(w.Name())+"_adj"));
}

void Gtk_SpinButton::Declare(File &f,const Widget &w)
{  StandardWriter::Declare(f,w,"Gtk_SpinButton");
}

void Gtk_SpinButton::Construct(File &f,const Widget &w,bool is_member)
{  int climb=w.getInt("climb_rate",0);
   int digits=w.getInt("digits",0);
   const Widget adj(w,f.InstanceName(w.Name())+"_adj");
      
   if (is_member)
   {  Gtk_Adjustment::Construct(f,adj,true);
      f << ", "
        << StandardWriter::ConstructName(f,w,is_member,"Gtk_SpinButton")
        << "(&" << (f.InstanceName(w.Name())+"_adj") << ", " << climb << ", "
        << digits << ")";
   }
   else
   {  f << StandardWriter::ConstructName(f,w,is_member,"Gtk_SpinButton")
        << "(0, " << climb << ", " << digits << "), ";
      cerr << "Gtk_SpinButton::Construct: not member, you will run into trouble\n";
      Gtk_Adjustment::Construct(f,adj,true);
   }
}

void Gtk_SpinButton::ConstructPointer(File &f,const Widget &w)
{  int climb=w.getInt("climb_rate",0);
   int digits=w.getInt("digits",0);
   
   Gtk_Adjustment::ConstructPointer(f,Widget(w,f.InstanceName(w.Name())+"_adj"));
   f << ";\n\t" << f.InstanceName(w.Name()) << " = new Gtk_SpinButton"
     << "(" << (f.InstanceName(w.Name())+"_adj") << ", " << climb << ", "
     << digits << ")";
}

void Gtk_SpinButton::DestructPointer(File &f,const Widget &w)
{  f << "\tdelete " << f.InstanceName(w.Name()) << ";\n";
   Gtk_Adjustment::DestructPointer(f,Widget(w,f.InstanceName(w.Name())+"_adj"));
}

bool Gtk_SpinButton::NeedConstruct(const Widget &w,bool is_member)
{  return true;
}

void Gtk_SpinButton::Customize(File &f,const Widget &w,const string instance)
{  //Gtk_Widget::Customize(f,w,instance);
   Gtk_Entry::Customize(f,w,instance);
   string update_policy=w.getString("update_policy","GTK_UPDATE_ALWAYS");
   if (update_policy!="GTK_UPDATE_ALWAYS")
      f << instance << "set_update_policy(" << update_policy << ");\n\t";
   // find out if we must set Adjustment and do so
   // snap
   // wrap
   // numeric
   // can_focus
}
