// $Id: fixed.cc,v 1.3 1998/09/24 13:19:45 cvs_christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "writers.hh"

void Gtk_Fixed::Include(File &f,const Widget &w)
{  f.include("gtk--/fixed.h");
   Gtk_Container::Include(f,w);
}

void Gtk_Fixed::Declare(File &f,const Widget &w)
{  StandardWriter::Declare(f,w,"Gtk_Fixed");
}

void Gtk_Fixed::Derive(File &f,const Widget &w)
{  f << "Gtk_Fixed";
}

void Gtk_Fixed::Construct(File &f,const Widget &w,bool is_member)
{  f << StandardWriter::ConstructName(f,w,is_member,"Gtk_Fixed") << "()";
}

bool Gtk_Fixed::NeedConstruct(const Widget &w,bool is_member)
{  return false;
}

static void PlaceChild(File &f,const Widget &w,const string instance)
{  int x=w.getInt("x",0);
   int y=w.getInt("y",0);
   f << instance << "put" << "(" << f.Pointer(w) << ", " << x << ", " 
     << y << ");\n\t";
}

void Gtk_Fixed::Customize(File &f,const Widget &w,const string instance)
{  Gtk_Container::Customize(f,w,instance);
   for (Widget::const_iterator i=w.begin();i!=w.end();++i)
      PlaceChild(f,*i,instance);
}
