// $Id: Widget.hh,v 1.18 1998/10/09 13:43:28 cvs_christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef WIDGET_HH
#define WIDGET_HH
#include "Tag.hh"
#include <iterator>
#include <algo.h>
#include "Widget_type.hh"

class Widget
{  	Tag *tag;
	string name;
public:
	Widget(Tag *t) throw() : tag(t), name("") {}
	Widget(Tag *t,const string _name) throw() : tag(t), name(_name) {}
	Widget(const Widget &w,const string _name) throw() 
		: tag(w.tag), name(_name) {}
//	Widget(const Tag *t) throw() : tag(t) {}

	const string Class() const throw()
	{  return getString("class",""); }
	const string ChildName() const throw()
	{  return getString("child_name",""); }
	// const is not always true
	const string Name() const throw(); 
	
	vector<string> Dependancies() const throw();
	bool hasTag(const string t) const throw();
	bool hasChildren() const throw()
	{  return hasTag("widget"); }
	void debug() const throw()
	{  tag->debug(); }
	
	void mark(const string tag) throw();
	void markCompound() throw()
	{  mark(CXX_COMPOUND_TYPE); }
	bool isCompound() const throw()
	{  return getBool(CXX_COMPOUND_TYPE,false); }
	void markPointer() throw()
	{  mark(CXX_POINTER); }
	bool isPointer() const throw()
	{  return getBool(CXX_POINTER,false); }
	
	bool hasRequirements() const throw();
	const Widget get_Child_params() const throw();
	
	const string getString(const string t,const string def="") const throw();
	bool getBool(const string t,const bool def=false) const throw();
	int getInt(const string t,const int def=-1) const throw();
	float getFloat(const string t,const float def=0) const throw();
	
	// iterator stuff
	class const_iterator : forward_iterator<Tag::const_iterator,ptrdiff_t>
	{	typedef Tag::const_iterator T;
		T ti,end;
		const string subtype;
	public:
		const_iterator(const T &t,const T &e,const string st="widget")
			 : ti(t),end(e),subtype(st) {}
		const_iterator operator++()
		{  const_iterator tmp=*this;
		   if (ti!=end) ti=find(ti+1,end,subtype);
		   return tmp;
		}
		const_iterator operator++(int)
		{  if (ti!=end) ti=find(ti+1,end,subtype);
		   return *this;
		}
		bool operator==(const const_iterator &i)
		{  return i.ti==ti; }
		bool operator!=(const const_iterator &i)
		{  return i.ti!=ti; }
		const Widget operator *()
		{  return Widget((Tag*)&*ti);
		}
	};
	class iterator : forward_iterator<Tag::iterator,ptrdiff_t>
	{	typedef Tag::iterator T;
		T ti,end;
		const string subtype;
	public:
		iterator(const T &t,const T &e,const string st="widget")
			: ti(t),end(e),subtype(st) {}
		iterator operator++()
		{  iterator tmp=*this;
		   if (ti!=end) ti=find(ti+1,end,subtype);
		   return tmp;
		}
		iterator operator++(int)
		{  if (ti!=end) ti=find(ti+1,end,subtype);
		   return *this;
		}
		bool operator==(const iterator &i)
		{  return i.ti==ti; }
		bool operator!=(const iterator &i)
		{  return i.ti!=ti; }
		Widget operator *()
		{  return Widget(&*ti);
		}
	};
	const_iterator begin() const 
	{  return const_iterator(find(tag->begin(),tag->end(),"widget"),tag->end());
	}
	const_iterator end() const
	{  return const_iterator(tag->end(),tag->end()); }
	iterator begin()
	{  return iterator(find(tag->begin(),tag->end(),"widget"),tag->end());
	}
	iterator end()
	{  return iterator(tag->end(),tag->end()); }

	const_iterator get_Signals() const throw()
	{  return const_iterator(find(tag->begin(),tag->end(),"Signal"),tag->end(),"Signal");
	}
};
#endif
