// $Id: File.hh,v 1.13 1998/10/09 13:05:23 cvs_christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef FILE_HH
#define FILE_HH
#include <fstream>
#include <string>
#include <vector>
#include "Widget.hh"
#include "Naming.hh"

// class Widget;

class File : public ofstream, public Naming
{	vector<string> includes;
	vector<string> types;
	vector<string> remembered_lines;
	File_type filetype;
	// topmost widget of this file
	const Widget *widget;
	bool has_requirements;
	string basename;
	
public:
	File() : filetype(File_UNKNOWN), widget(0), has_requirements(false),
		basename("foo")
	{}
	File(const Widget *w,File_type tp);
	void open(const Widget *w,File_type tp);
	void close();
	void include(const string name,bool local=false);
	bool contains_type(const string name);
	void add_type(const string name);
	void markRequirements() throw()
	{  has_requirements=true; }
	bool hasRequirements() const throw()
	{  return has_requirements; }
	string FileName(File_type tp=File_UNKNOWN,int flags=File_NODIR) const throw();
	string FileName(const string tag,File_type tp,int flags=File_NODIR) const
	{  return Naming::FileName(tag,tp,flags); }
	File_type type() const throw()
	{  return filetype; }
	const string widgetName() const throw()
	{  if (widget) return widget->Name(); 
	   else return "<null>";
	}
	void remember(const string &s) throw()
	{  remembered_lines.push_back(s); }
	vector <string> &get_remembered() throw()
	{  return remembered_lines; }
	void write_remembered();
	
	friend ostream &operator<<(ostream &,const File &f);
};

extern ostream &operator<<(ostream &,const File &f);
#endif
