// $Id: File.cc,v 1.21 1998/10/09 13:15:56 cvs_christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "File.hh"
#include "Naming.hh"
#include <cstdio>

File::File(const Widget *w,File_type tp) 
	: ofstream(FileName(w?w->Name():"<null>",tp,File_NOREPLACE).c_str()), filetype(tp), 
		widget(w), has_requirements(false), basename(w?w->Name():"<null>")
{  
}

void File::open(const Widget *w,File_type tp)
{  if (w) basename=w->Name(); // force duplication
   else basename="<null>";
   ofstream::open(FileName(basename,tp,File_NOREPLACE).c_str(),ios::out,
	tp==File_AUTOGEN_SH?0755:0644);
   filetype=tp;
   widget=w;
   has_requirements=false;
   if (!good()) perror(FileName(basename,tp,File_NOREPLACE).c_str());
}

void File::close()
{  ofstream::close();
   includes.erase(includes.begin(),includes.end());
   types.erase(types.begin(),types.end());
   remembered_lines.erase(remembered_lines.begin(),remembered_lines.end());
}

void File::include(const string name,bool local)
{  // suchen ob schon ?
   if (!name[0]) return;
   if (find(includes.begin(),includes.end(),name)!=includes.end()) return;
   *this << "#include " << (local?'"':'<') << name << (local?'"':'>') << "\n";
   includes.push_back(name);
}

string File::FileName(File_type tp,int flags) const throw()
{  if (tp==File_UNKNOWN) tp=filetype;
   return FileName(basename,tp,flags);
}

void File::write_remembered()
{  for (vector<string>::iterator i=remembered_lines.begin();
            		i!=remembered_lines.end();++i)
   {  *this<<(*i);
   }
   remembered_lines.erase(remembered_lines.begin(),remembered_lines.end());
}

ostream &operator<<(ostream &o,const vector<string> x)
{  o << "(";
   for (vector<string>::const_iterator i=x.begin();i!=x.end();++i)
   {  o << (i!=x.begin() ? ", \"" : "\"") << (*i) << "\""; 
   }
   return o << ")";
}

ostream &operator<<(ostream &o,const File &f)
{ return o << "{filetype=" << (int)(f.filetype) << " widget=" << f.widget
     << ( f.has_requirements ? " has_requirements" : " !has_requirements")
     << " basename=\"" << f.basename << "\" includes=" << f.includes << " types="
     << f.types << " remembered_lines=" << f.remembered_lines << "}";
}
