/* Checker stubs for functions defined in libgcc.
   Copyright 1998 Tristan Gingold
		  Written August 1998 by Tristan Gingold

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License 
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.

 The author may be reached by US/French mail:
		Tristan Gingold 
		8 rue Parmentier
		F-91120 PALAISEAU
		FRANCE
*/
#include "available-stubs.h"

#include <sys/types.h>
#include "checker_api.h"

#ifdef HAVE_op_new
void *chkr_stub___builtin_new (size_t sz)
     __asm__ (CHKR_PREFIX ("__builtin_new"));
void *
chkr_stub___builtin_new (size_t sz)
{
  return __builtin_new (sz);
}
#endif /* HAVE_op_new */

#ifdef HAVE_op_vnew
void *chkr_stub___builtin_vec_new (size_t sz)
     __asm__ (CHKR_PREFIX ("__builtin_vec_new"));
void *
chkr_stub___builtin_vec_new (size_t sz)
{
  return __builtin_vec_new (sz);
}
#endif /* HAVE_op_vnew */

#ifdef HAVE_new_handler
typedef void (*vfp)(void);

void *chkr_stub_set_new_handler (vfp handler)
     __asm__ (CHKR_PREFIX ("set_new_handler"));
void *
chkr_stub_set_new_handler (vfp handler)
{
  stubs_chkr_check_exec (handler, "handler");
  return set_new_handler (handler);
}
#endif /* HAVE_set_new_handler */

#ifdef HAVE_op_del
void chkr_stub___builtin_delete (void *ptr)
     __asm__ (CHKR_PREFIX ("__builtin_delete"));
void 
chkr_stub___builtin_delete (void *ptr)
{
  __builtin_delete (ptr);
}
#endif /* HAVE_op_del */

#ifdef HAVE_op_vdel
void chkr_stub___builtin_vec_delete (void *ptr)
     __asm__ (CHKR_PREFIX ("__builtin_vec_delete"));
void 
chkr_stub___builtin_vec_delete (void *ptr)
{
  __builtin_vec_delete (ptr);
}
#endif /* HAVE_op_vdel */

#ifdef HAVE_pure
void chkr_stub___pure_virtual (void)
     __asm__ (CHKR_PREFIX ("__pure_virtual"));
void 
chkr_stub___pure_virtual (void)
{
  __pure_virtual ();
}
#endif /* HAVE_pure */
