{
Copyright (C) 1998-99 Free Software Foundation, Inc.

Authors: Dr Abimbola A. Olowofoyeku (The African Chief) <laa12@keele.ac.uk>
           Homepage: http://ourworld.compuserve.com/homepages/African_Chief
         Frank Heckenbach <frank@pascal.gnu.de>

Some utility routines, mainly for BP compatibility.
Includes some Turbo Power compatibility

This unit is released as part of the GNU Pascal project.
@@NOTE - SOME OF THE ROUTINES IN THIS UNIT MAY NOT WORK CORRECTLY.
TEST CAREFULLY AND USE WITH CARE!

This library is free software; you can redistribute it and/or modify
it under the terms of the GNU Library General Public License as published by
the Free Software Foundation, version 2.

This library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
License for more details.

You should have received a copy of the GNU Library General Public License
along with this library; see the file COPYING.LIB.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
MA 02111-1307, USA.
}

{$if __GPC_RELEASE__ < 19981206}
{$error This unit requires GPC release 19981206 or newer}
{$endif}

unit GPCUtil;

interface

uses GPC;

{ Replace all occurences of OldC with NewC in s and return the result }
function  ReplaceChar (const s : String; OldC, NewC : Char) : TString;

{ Return the current working directory }
function  ThisDirectory : TString; asmname '_p_get_current_directory';

{ Does a directory exist? }
function  IsDirectory (const FileName : String) : Boolean; asmname '_p_directory_exists';

{ Break a string into 2 parts, using Ch as a marker }
function  BreakStr (const Src : String; var Dest1, Dest2 : String; Ch : Char) : Boolean;

{ Convert a CString to an Integer }
function  pChar2Int (s : CString) : Integer;

{ Convert a CString to a LongInt }
function  pChar2Long (s : CString) : LongInt;

{ Convert a CString to a Double }
function  pChar2Double (s : CString) : Double;

{ Search for filename as an executable in the path and return its location
  (full pathname) }
function  PathLocate (const s : String) : TString;

{ Copy file Src to file Dest and return the number of bytes written }
function  CopyFile (const Src, Dest : String; BufSize : Integer) : LongInt;

{ Copy file Src to file Dest and return the number of bytes written;
  report the number of bytes written versus total size of the source file }
function  CopyFileEx (const Src, Dest : String; BufSize : Integer;
  function Report (Reached, Total : LongInt) : LongInt) : LongInt;

{ Turbo Power compatibility }

{ Does a string contain wildcard characters? }
function  HasWildCards (const s : String) : Boolean;

{ Execute the program prog; Dum1 and Dum2 are for compatibility only;
  they are ignored }
function  ExecDos (const Prog : String; Dum1 : Boolean; Dum2 : Pointer) : Integer;

{ Return whether Src exists in the path as an executable -- if so return its
  full location in Dest }
function  ExistOnPath (const Src : String; var Dest : String) : Boolean;

{ Does filename s exist? }
function  ExistFile (const FileName : String) : Boolean; asmname '_p_file_exists';

{ Return just the directory path of the filename s. Strip out the filename part }
function  JustPathName (const Path : String) : TString; asmname '_p_dir_from_path';

{ Return just the filename part of the filename s. Strip out the directory
  path. Empty if Path contains no filename. }
function  JustFileName (const Path : String) : TString; asmname '_p_name_from_path';

{ Return just the extension of the filename s. Empty if Path contains no
  extension. }
function  JustExtension (const Path : String) : TString; asmname '_p_ext_from_path';

{ Change the extension of s to ext (do not include the dot! }
function  ForceExtension (const s, Ext : String) : TString;

{ Return the full pathname of the filename s }
function  FullPathName (const Path : String) : TString; asmname '_p_fexpand';

{ Add a DirSeparator to the end of s if one isn't there already }
function  AddBackSlash (const s : String) : TString; asmname '_p_adddirseparator';

{ Convert Integer to pChar; uses StrNew to allocate memory for the
  result, so you must call StrDispose to free the memory later }
function  Int2pChar (i : Integer) : PChar;

{ Convert Integer to string }
function  Int2Str (i : Integer) : TString;

{ Convert string to Integer }
function  Str2Int (const s : String; var i : Integer) : Boolean;

{ Convert string to LongInt }
function  Str2Long (const s : String; var i : LongInt) : Boolean;

{ Convert string to Double }
function  Str2Real (const s : String; var i : Double) : Boolean;

{ Return a string stripped of leading spaces }
function  TrimLead (const s : String) : TString; asmname '_p_trimleft_str';

{ Return a string stripped of trailing spaces }
function  TrimTrail (const s : String) : TString; asmname '_p_trimright_str';

{ Return a string stripped of leading and trailing spaces }
function  Trim (const s : String) : TString; asmname '_p_trimboth_str';

{ Return a string right-padded to length len with ch }
function  PadCh (const s : String; ch : Char; len : Integer) : TString;

{ Return a string right-padded to length len with spaces }
function  Pad (const s : String; len : Integer) : TString;

{ Return a string left-padded to length len with ch }
function  LeftPadCh (const s : String; ch : Char; len : Byte) : TString;

{ Return a string left-padded to length len with blanks }
function  LeftPad (const s : String; len : Integer) : TString;

{ Convert a string to lowercase }
function  StLoCase (const s : String) : TString; asmname '_p_locase_str';

{ Convert a string to uppercase }
function  StUpCase (const s : String) : TString; asmname '_p_upcase_str';

implementation

{$B-,I-}

function PathLocate (const s : String) : TString;
begin
  PathLocate := FSearchExecutable (s, GetEnv (PathEnvVar))
end;

function ExistOnPath (const Src : String; var Dest : String) = Result : Boolean;
begin
  Dest := PathLocate (Src);
  Result := Dest <> '';
  if Result then Dest := FExpand (Dest)
end;

function ForceExtension (const s, Ext : String) = Result : TString;
var i : Integer;
begin
  i := Pos (ExtSeparator, s);
  if i = 0
    then Result := s
    else Result := Copy (s, 1, i - 1);
  if Ext [1] <> ExtSeparator then Result := Result + ExtSeparator;
  Result := Result + Ext
end;

function ExecDos (const Prog : String; Dum1 : Boolean; Dum2 : Pointer) : Integer;
begin
  ExecDos := CSystem (Prog)
end;

function PadCh (const s : String; ch : Char; len : Integer) = Result : TString;
begin
  Result := s;
  while Length (Result) < len do Result := Result + ch
end;

function Pad (const s : String; len : Integer) : TString;
begin
  Pad := PadCh (s, ' ', Len)
end;

function LeftPadCh (const s : String; ch : Char; len : Byte) = Result : TString;
begin
  Result := s;
  while Length (Result) < len do Result := ch + Result
end;

function LeftPad (const s : String; len : Integer) : TString;
begin
  LeftPad := LeftPadCh (s, ' ', len)
end;

function Int2pChar (i : Integer) : PChar;
var s : TString;
begin
  Str (i, s);
  Int2pChar := StrNew (s)
end;

function Int2Str (i : Integer) = Result : TString;
begin
  Str (i, Result)
end(*@@*)(*$W-*);(*$W+*)

function Str2Int (const s : String; var i : Integer) : Boolean;
begin
  ReadStr (s, i);
  Str2Int := IOResult = 0
end;

function Str2Long (const s : String; var i : LongInt) : Boolean;
begin
  ReadStr (s, i);
  Str2Long := IOResult = 0
end;

function Str2Real (const s : String; var i : Double) : Boolean;
begin
  ReadStr (s, i);
  Str2Real := IOResult = 0
end;

function CopyFile (const Src, Dest : String; BufSize : Integer) : LongInt;
type T = function (Reached, Total : LongInt) : LongInt; (* @@fjf258 *)
begin
  CopyFile := CopyFileEx (Src, Dest, BufSize, T (nil))
end;

function CopyFileEx (const Src, Dest : String; BufSize : Integer;
  function Report (Reached, Total : LongInt) : LongInt) = Result : LongInt;
var
  Size : LongInt;
  Count : Integer;
  SrcFile, DestFile : File;
  Buf : ^Byte;
  B : BindingType;
begin
  Reset (SrcFile, Src, 1);
  if IOResult <> 0 then
    begin
      Result := - 2;
      Exit
    end;
  Rewrite (DestFile, Dest, 1);
  if IOResult <> 0 then
    begin
      Close (SrcFile);
      Result := - 3;
      Exit
    end;
  B := Binding (SrcFile);
  Size := FileSize (SrcFile);
  GetMem (Buf, BufSize);
  Result := 0;
  repeat
    BlockRead (SrcFile, Buf^, BufSize, Count);
    Inc (Result, Count);
    if IOResult <> 0 then
      Result := - 100 { Read error }
    else if Count > 0 then
      begin
        BlockWrite (DestFile, Buf^, Count);
        if IOResult <> 0 then
          Result := - 200 { Write error }
        else if Assigned (Report) and_then (Report (Result, Size) < 0) then
          Result := - 300 { User Abort }
      end
  until (Result < 0) or (Count = 0);
  FreeMem (Buf);
  Close (SrcFile);
  if Result >= 0 then SetFileTime ((*@@*)AnyFile( DestFile), B.ModificationTime);
  Close (DestFile)
end;

function BreakStr (const Src : String; var Dest1, Dest2 : String; Ch : Char) : Boolean;
var i : Integer;
begin
  i := Pos (Ch, Src);
  BreakStr := i <> 0;
  if i = 0 then i := Length (Src) + 1;
  Dest1 := Trim (Copy (Src, 1, i - 1));
  Dest2 := Trim (Copy (Src, i + 1))
end;

{$X+}
function pChar2Int (s : CString) = Result : Integer;
begin
  ReadStr (s, Result)
end;

function pChar2Long (s : CString) = Result : LongInt;
begin
  ReadStr (s, Result)
end;

function pChar2Double (s : CString) = Result : Double;
begin
  ReadStr (s, Result)
end;
{$X-}

function ReplaceChar (const s : String; OldC, NewC : Char) = Result : TString;
var i : Integer;
begin
  Result := s;
  if OldC <> NewC then
    for i := 1 to Length (Result) do
      if Result [i] = OldC then Result [i] := NewC
end;

function HasWildCards (const s : String) : Boolean;
begin
  HasWildCards := CharPos (WildCardChars, s) <> 0
end;

end.
