#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <ctype.h>
#include "xutil.h"
#include "lutil.h"

char *xmalloc(size)
size_t size;
{
	char *tmp;

	tmp=malloc(size);
	if (!tmp) abort();
	
	return tmp;
}

char *xstrcpy(src)
char *src;
{
	char	*tmp;

	if (src == NULL) return(NULL);
	tmp=xmalloc(strlen(src)+1);
	strcpy(tmp,src);
	return tmp;
}

char *xstrcat(src,add)
char *src,*add;
{
	char *tmp;
	size_t size=0;

	if ((add == NULL) || (strlen(add) == 0)) return src;
	if (src) size=strlen(src);
	size+=strlen(add);
	tmp=xmalloc(size+1);
	*tmp='\0';
	if (src) 
	{
		strcpy(tmp,src);
		free(src);
	}
	strcat(tmp,add);
	return tmp;
}

char *xtodos(char *orig)	/* return a _new_copy_ like xstrcpy() */
{
  int i;
  char buf[8+1+3+1], *copy, *p, *q, *r;

  if (orig == NULL)
    return NULL;

  copy = xstrcpy(orig);
  if ((p = strrchr(copy, '/')))
    p++;
  else
    p = copy;

  if (strcmp(q = copy + strlen(copy) - strlen(".tar.gz"), ".tar.gz") == 0)
  {
    *q = '\0';
    q = "tgz";
  }
  else if (strcmp(q = copy + strlen(copy) - strlen(".tar.z"), ".tar.z") == 0)
  {
    *q = '\0';
    q = "tgz";
  }
  else if (strcmp(q = copy + strlen(copy) - strlen(".tar.Z"), ".tar.Z") == 0)
  {
    *q = '\0';
    q = "taz";
  }
  else if ((q = strrchr(p, '.')))
  {
    *q++ = '\0';
  }
  else
  {
    q = NULL;
  }

  r = buf;
  for (i = 0; (i < 8) && (*p); i++, p++, r++)
  {
    switch (*p)
    {
     case '.':
     case '\\':
      *r='_';
      break;

     default:
      *r = toupper(*p);
    }
  }

  if (q)
  {
    *r++ = '.';
    for (i = 0; (i < 3) && (*q); i++, q++, r++)
    {
      switch (*q)
      {
       case '.':
       case '\\':
	*r='_';
	break;

       default:
	*r = toupper(*q);
      }
    }
  }
  *r++ = '\0';

  free(copy);
  return xstrcpy(buf);
}
