/*

smashy smashy

k.arp.ski (karpski) - A network protocol analyzer / sniffer
Copyright (C) 1998  Brian Costello

*/

#include <stdio.h>
#include <config.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <netinet/tcp.h>
#include <gtk/gtk.h>
#include <pthread.h>

#include "proto.h"
#include "connects.h"
#include "karpski.h"
#include "smashy.h"
#include "guidefs.h"

t_smashy_type *first_smashy = NULL;
GtkWidget *smashy_window;

extern t_arp_rec *selected_ar;

void set_off_smash(t_smashy_type *clicked_smashy)
{
   char *args[256];
   char *s;
   int arg_index=0;
   pid_t pid;
   
   if (!selected_ar)
      return;
      
   if (!clicked_smashy)
   {
      printf("ERRRRRRRROR\n");
      exit(1);
   }

/*   printf("Executing %s with args %s.\n", clicked_smashy->program_name, clicked_smashy->program_args); */
   
   if (clicked_smashy->needs_shell)
   {
      args[arg_index++] = (char *)STRDUP("xterm", "Smashy strdup 1");
      args[arg_index++] = (char *)STRDUP("-e", "Smashy strdup 2");
   }

   args[arg_index++] = (char *)STRDUP(clicked_smashy->program_name, "Smashy strdup 3");
   s=strtok(clicked_smashy->program_args, " ");
   if (s)
   {
      do
      {
         if (!strcasecmp(s, "ipaddress$"))
         {
/*            printf("ipaddress$ -> %s", selected_ar->machine_addr); */
            args[arg_index++] = (char *) STRDUP(selected_ar->machine_addr, "smashy strdup 4");
         }
         else
         {
            args[arg_index++] = (char *) STRDUP(s, "smashy strdup 5");
         }
      } while ((s=strtok(NULL, " ")));
   }

   args[arg_index] = NULL;
   
   if ((pid = fork()) < 0)
   {
      perror("fork");
      exit(1);
   }
   if (!pid)
   {
      if (clicked_smashy->needs_shell)
      {
         if (execvp("xterm", args)<0)
            fprintf(stderr, "error: program xterm not found.\n");
      }
      else
      {
         if (execvp(clicked_smashy->program_name, args)<0)
            fprintf(stderr, "error: program %s not found.\n", clicked_smashy->program_name);
      }
      exit(0);
   }
   
   arg_index--;
   while (arg_index>0)
   {
      free(args[arg_index--]);
   }
   
}

void switch_smashy_window()
{
   GtkWidget *separator;
   GtkWidget *box1, *box2, *button;
   t_smashy_type *tmp_smash;
   
   if (!smashy_window)
   {
      smashy_window= gtk_window_new(GTK_WINDOW_TOPLEVEL);
      gtk_widget_set_name(smashy_window, "Smashy array");
/*      gtk_widget_set_usize(smashy_window, SMASHY_WIDTH, SMASHY_HEIGHT); */
      
      gtk_widget_set_uposition(smashy_window, 1024-300-5, 0);

      gtk_window_set_policy (GTK_WINDOW(smashy_window), TRUE, TRUE, FALSE);
         
      gtk_signal_connect (GTK_OBJECT (smashy_window), "destroy",
                          GTK_SIGNAL_FUNC(gtk_widget_destroyed), &smashy_window);
      gtk_window_set_title (GTK_WINDOW (smashy_window), "Smashy array");
      gtk_container_border_width (GTK_CONTAINER (smashy_window), 0);
      box1 = gtk_vbox_new (FALSE, 0);
      gtk_container_add (GTK_CONTAINER (smashy_window), box1);
      gtk_widget_show (box1);
      box2 = gtk_vbox_new (FALSE, 10);
      gtk_container_border_width (GTK_CONTAINER (box2), 10);
      gtk_box_pack_start (GTK_BOX (box1), box2, TRUE, TRUE, 0);
      gtk_widget_show (box2);

      for (tmp_smash = first_smashy; tmp_smash; tmp_smash = tmp_smash->next)
      {
         button = gtk_button_new_with_label (tmp_smash->program_title);
         gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
                                   GTK_SIGNAL_FUNC(set_off_smash),
                                   GTK_OBJECT(tmp_smash));
         gtk_box_pack_start (GTK_BOX (box2), button, TRUE, TRUE, 0);
         gtk_widget_show(button);
      }  
      separator = gtk_hseparator_new ();
      gtk_box_pack_start (GTK_BOX (box1), separator, FALSE, TRUE, 0);
      gtk_widget_show (separator);
      box2 = gtk_vbox_new (FALSE, 10);
      gtk_container_border_width (GTK_CONTAINER (box2), 10);
      gtk_box_pack_start (GTK_BOX (box1), box2, FALSE, TRUE, 0);
      gtk_widget_show (box2);
      button = gtk_button_new_with_label ("close");
      gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
                                GTK_SIGNAL_FUNC(gtk_widget_destroy),
                                GTK_OBJECT (smashy_window));
      gtk_box_pack_start (GTK_BOX (box2), button, TRUE, TRUE, 0);
      GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
      gtk_widget_grab_default (button);
      gtk_widget_show (button);
   }
   if (!GTK_WIDGET_VISIBLE(smashy_window))
      gtk_widget_show(smashy_window);
   else
      gtk_widget_destroy(smashy_window);
      
   return;

}

char *stripnl(char *str)
{
   char *tmp;
   
   for (tmp = str; (*tmp); tmp++)
   {
      if (*tmp == '\n')
         *tmp = '\0';
   }
   return(str);
}

int load_smashy_dat()
{
   FILE *infile;
   char buf[256];
   char *s;
   int num_smashys=0;
   t_smashy_type *newrec;
   
   sprintf(buf, "%ssmashy.dat", KARPSKI_DATA_DIR);
   
   if (!(infile=fopen(buf,"r")))
   {
      perror("fopen smashy.dat");
      exit(1);
   }
   
   while (fgets(buf, 256, infile))
   {
      if ((buf[0] == '\n') || (!buf[0]) || (buf[0] == '#'))
         continue;
      
      if ((toupper(buf[0]) != 'N') && (toupper(buf[0]) != 'Y'))
      {
         fprintf(stderr,"Error: %c is not Y or N.\nFix your smashy.dat file.\n", buf[0]);
         exit(1);
      }
      
      newrec = (t_smashy_type *) MALLOC(sizeof(t_smashy_type), "New smashy rec - smashy.c");
      if (!newrec)
      {
         perror("malloc smashy rec");
         exit(1);
      }
      
      newrec->needs_shell = (toupper(buf[0]) == 'Y');

      s = strtok(&buf[2], "@");
      if (s)
      {
         strcpy(newrec->program_title, s);
      }
      else
      {
         fprintf(stderr,"Error parsing smashy.dat file/1- %s\n", &buf[2]);
         exit(1);
      }
      s = strtok(NULL, "@");
      if (s)
         strcpy(newrec->program_name, s);
      else
      {
         fprintf(stderr,"Error parsing smashy.dat file/2- %s\n", &buf[2]);
         exit(1);
      }
      
      s = strtok(NULL, "@");
      if (s)
         strcpy(newrec->program_args, stripnl(s));
      else
      {
         fprintf(stderr,"Error parsing smashy.dat file/2- %s\n", &buf[2]);
         exit(1);
      }
      
      newrec->next = first_smashy;
      first_smashy = newrec;
      num_smashys++;
   }
   
   fclose(infile);
   return(num_smashys);
}

