#ifndef __GRAPH_H__
#define __GRAPH_H__

#include <gtk/gtk.h>

#define GRAPH_DEFAULT_COLORS 4
extern GdkColor graph_default_colors [GRAPH_DEFAULT_COLORS];

enum _GraphCmd {
	GRAPH_FIRST,
	GRAPH_NEXT,
	GRAPH_VALUE,
	GRAPH_LABEL,
	GRAPH_HEAD,
	GRAPH_TAIL,
};

typedef enum _GraphCmd GraphCmd;

typedef struct _Graph Graph;

struct _Graph {
	GtkWidget *da;

	GdkPixmap *bs;
	GdkColor *colors;

	gint colors_allocated;
	gint n;
	gint height;

	gpointer (*data_fn) (GraphCmd, gpointer);
};

Graph       * graph_new (gpointer (*data_fn) (GraphCmd, gpointer));
GtkWidget   * graph_widget (Graph *g);
void          graph_update (Graph *g);
void          graph_colors_set (Graph *g, GdkColor *cs, gint n);
void          graph_minimal_height_set (Graph *g, gint h);

#endif
