#include "dinstall.h"
#include <stdio.h>
#include <fcntl.h>
#include INCLINGUA

int configure_keyboard_m (void) {
	return configure_keyboard(NULL);
}

int configure_keyboard (char *kbd)
{
  int rs=-1;
  char msg[]=MSG_SELECT_KEYBOARD_L;
  char title[]=MSG_SELECT_KEYBOARD;
  char *prefix;

#if #cpu (m68k)
  struct d_choices keymaps_ami[]={
    { "amiga-us",        MSG_KBD_AMIGA_US      , 1},
    { "amiga-de",        MSG_KBD_AMIGA_DE      , 0}
  };
  int nchoices_ami=2;
  struct d_choices keymaps_ata[]={
    { "atari-us",        MSG_KBD_ATARI_US            , 1},
    { "atari-de",        MSG_KBD_ATARI_DE            , 0},
    { "atari-se",        MSG_KBD_ATARI_SE            , 0},
    { "atari-uk", 	 MSG_KBD_ATARI_UK            , 0}
  };
  int nchoices_ata=4;
  struct d_choices keymaps_mac[]={
    { "mac-us-std",      MSG_KBD_MAC_US_STD                , 1},
    { "mac-us-ext",      MSG_KBD_MAC_US_EXT                , 0},
    { "mac-fr2-ext",     MSG_KBD_MAC_FR2_EXT               , 0},
    { "mac-de-ext",      MSG_KBD_MAC_DE_EXT                , 0}
  };
  int nchoices_mac=3;
  int nchoices;
#elif #cpu (powerpc)
  struct d_choices keymaps[]={
    { "i386/qwerty/us",                  MSG_KBD_QWERTY_US                 , 1},
    { "i386/azerty/be-latin1",           MSG_KBD_AZERTY_BE_LAT1            , 0},
    { "i386/qwerty/bg",                  MSG_KBD_QWERTY_BG                 , 0},
    { "i386/qwerty/cf",                  MSG_KBD_QWERTY_CF                 , 0},
    { "i386/qwertz/croat",               MSG_KBD_QWERTY_CROAT              , 0},
    { "i386/qwerty/cz-lat2",             MSG_KBD_QWERTY_CZ_LAT2            , 0},
    { "i386/qwertz/de-latin1-nodeadkeys",MSG_KBD_QWERTZ_DE_LAT1N           , 0},
    { "i386/qwerty/dk-latin1",           MSG_KBD_QWERTY_DK_LAT1            , 0},
    { "i386/dvorak/dvorak",              MSG_KBD_DVORAK_DVORAK             , 0},
    { "i386/qwerty/es",                  MSG_KBD_QWERTY_ES                 , 0},
    { "i386/qwerty/fi-latin1",           MSG_KBD_QWERTY_FI_LAT1            , 0},
    { "i386/azerty/fr-latin1",           MSG_KBD_AZERTY_FR_LAT1            , 0},
    { "i386/qwerty/gr",                  MSG_KBD_QWERTY_GR                 , 0},
    { "i386/qwerty/hebrew",              MSG_KBD_QWERTY_HEBREW             , 0},
    { "i386/qwertz/hu",                  MSG_KBD_QWERTZ_HU                 , 0},
    { "i386/qwerty/is-latin1",           MSG_KBD_QWERTY_IS_LAT1            , 0},
    { "i386/qwerty/it",                  MSG_KBD_QWERTY_IT                 , 0},
    { "i386/qwerty/jp106",               MSG_KBD_QWERTY_JP106              , 0},
    { "i386/qwerty/no-latin1",           MSG_KBD_QWERTY_NO_LAT1            , 0},
    { "i386/qwerty/pl",                  MSG_KBD_QWERTY_PL                 , 0},
    { "i386/qwerty/ru",                  MSG_KBD_QWERTY_RU                 , 0},
    { "i386/qwerty/se-latin1",           MSG_KBD_QWERTY_SE_LAT1            , 0},
    { "i386/qwertz/slovene",             MSG_KBD_QWERTZ_SLOVENE            , 0},
    { "i386/fgGIod/tr_f-latin5",         MSG_KBD_FGGIOD_TR_F_LAT5          , 0},
    { "i386/qwerty/uk",                  MSG_KBD_QWERTY_UK                 , 0},
    { "mac/mac-de-latin1-nodeadkeys",    MSG_KBD_MAC_DE_LAT1N              , 0},
    { "mac/mac-fr2-ext",                 MSG_KBD_MAC_FR2_EXT               , 0},
    { "mac/mac-us-ext",                  MSG_KBD_MAC_US_EXT                , 0},
    { "mac/mac-us-std",                  MSG_KBD_MAC_US_STD                , 1}
  };
  int nchoices=29;
#elif #cpu (sparc)
  struct d_choices keymaps[]={
    { "sun/sunkeymap",       MSG_KBD_SUN_SUNKEYMAP       , 1},
    { "sun/sunt4-es",        MSG_KBD_SUN_SUNT4_ES        , 0},
    { "sun/sunt5-es",        MSG_KBD_SUN_SUNT5_ES        , 0},
    { "sun/sunt5-de-latin1", MSG_KBD_SUN_SUNT5_DE_LAT1   , 0},
    { "sun/sunt5-fi-latin1", MSG_KBD_SUN_SUNT5_FI_LAT1   , 0},
    { "sun/sunt5-fr-latin1", MSG_KBD_SUN_SUNT5_FR_LAT1   , 0},
    { "sun/sunt5-ru",        MSG_KBD_SUN_SUNT5_RU        , 0},
    { "i386/qwerty/us",                  MSG_KBD_QWERTY_US       , 1},
    { "i386/azerty/be-latin1",           MSG_KBD_AZERTY_BE_LAT1  , 0},
    { "i386/qwerty/bg",                  MSG_KBD_QWERTY_BG       , 0},
    { "i386/qwerty/cf",                  MSG_KBD_QWERTY_CF       , 0},
    { "i386/qwertz/croat",               MSG_KBD_QWERTY_CROAT    , 0},
    { "i386/qwerty/cz-lat2",             MSG_KBD_QWERTY_CZ_LAT2  , 0},
    { "i386/qwertz/de-latin1-nodeadkeys",MSG_KBD_QWERTZ_DE_LAT1N , 0},
    { "i386/qwerty/dk-latin1",           MSG_KBD_QWERTY_DK_LAT1  , 0},
    { "i386/dvorak/dvorak",              MSG_KBD_DVORAK_DVORAK   , 0},
    { "i386/qwerty/es",                  MSG_KBD_QWERTY_ES       , 0},
    { "i386/qwerty/fi-latin1",           MSG_KBD_QWERTY_FI_LAT1  , 0},
    { "i386/azerty/fr-latin1",           MSG_KBD_AZERTY_FR_LAT1  , 0},
    { "i386/qwerty/gr",                  MSG_KBD_QWERTY_GR       , 0},
    { "i386/qwerty/hebrew",              MSG_KBD_QWERTY_HEBREW   , 0},
    { "i386/qwertz/hu",                  MSG_KBD_QWERTZ_HU       , 0},
    { "i386/qwerty/is-latin1",           MSG_KBD_QWERTY_IS_LAT1  , 0},
    { "i386/qwerty/it",                  MSG_KBD_QWERTY_IT       , 0},
    { "i386/qwerty/jp106",               MSG_KBD_QWERTY_JP106    , 0},
    { "i386/qwerty/no-latin1",           MSG_KBD_QWERTY_NO_LAT1  , 0},
    { "i386/qwerty/pl",                  MSG_KBD_QWERTY_PL       , 0},
    { "i386/qwerty/ru",                  MSG_KBD_QWERTY_RU       , 0},
    { "i386/qwerty/se-latin1",           MSG_KBD_QWERTY_SE_LAT1  , 0},
    { "i386/qwertz/slovene",             MSG_KBD_QWERTZ_SLOVENE  , 0},
    { "i386/fgGIod/tr_f-latin5",         MSG_KBD_FGGIOD_TR_F_LAT5, 0},
    { "i386/qwerty/uk",                  MSG_KBD_QWERTY_UK       , 0}
  };
  int nchoices=32;
#else
  struct d_choices keymaps[]={
    { "qwerty/us",			MSG_KBD_QWERTY_US       , 1},
    { "azerty/be-latin1",		MSG_KBD_AZERTY_BE_LAT1  , 0 },
    { "qwerty/bg",			MSG_KBD_QWERTY_BG       , 0 },
    { "qwerty/cf",			MSG_KBD_QWERTY_CF       , 0 },
    { "qwertz/croat",			MSG_KBD_QWERTZ_CROAT    , 0 },
    { "qwerty/cz-lat2",			MSG_KBD_QWERTY_CZ_LAT2  , 0 },
    { "qwertz/de-latin1-nodeadkeys",	MSG_KBD_QWERTZ_DE_LAT1N , 0 },
    { "qwerty/dk-latin1",		MSG_KBD_QWERTY_DK_LAT1  , 0 },
    { "dvorak/dvorak",			MSG_KBD_DVORAK_DVORAK   , 0 },
    { "qwerty/es",			MSG_KBD_QWERTY_ES       , 0 },
    { "qwerty/fi-latin1",		MSG_KBD_QWERTY_FI_LAT1  , 0 },
    { "azerty/fr-latin1",		MSG_KBD_AZERTY_FR_LAT1  , 0 },
    { "qwerty/gr",			MSG_KBD_QWERTY_GR       , 0 },
    { "qwerty/hebrew",			MSG_KBD_QWERTY_HEBREW   , 0 },
    { "qwertz/hu",			MSG_KBD_QWERTZ_HU       , 0 },
    { "qwerty/is-latin1",		MSG_KBD_QWERTY_IS_LAT1  , 0 },
    { "qwerty/it",			MSG_KBD_QWERTY_IT       , 0 },
    { "qwerty/jp106",			MSG_KBD_QWERTY_JP106    , 0 },
    { "qwerty/no-latin1",		MSG_KBD_QWERTY_NO_LAT1  , 0 },
    { "qwerty/pl",			MSG_KBD_QWERTY_PL       , 0 },
    { "qwerty/ru",			MSG_KBD_QWERTY_RU       , 0 },
    { "qwerty/se-latin1",		MSG_KBD_QWERTY_SE_LAT1  , 0 },
    { "qwertz/slovene",			MSG_KBD_QWERTZ_SLOVENE  , 0 },
    { "fgGIod/tr_f-latin5",		MSG_KBD_FGGIOD_TR_F_LAT5, 0 },
    { "qwerty/uk",			MSG_KBD_QWERTY_UK       , 0 }
  };
  int nchoices=25;
#endif

    struct d_choices* choices;

#if #cpu (m68k)
    if (strcmp(Arch2, "Atari") == 0) {
	choices = keymaps_ata;
	nchoices = nchoices_ata;
	prefix="atari/";
    }
    else if (strcmp(Arch2, "Amiga") == 0) {
	choices = keymaps_ami;
	nchoices = nchoices_ami;
	prefix="amiga/";
    }
    else if (strcmp(Arch2, "Macintosh") == 0) {
	choices = keymaps_mac;
	nchoices = nchoices_mac;
	prefix="mac/";
    }
    else if (strcmp(Arch2, "VME") == 0) {
	problemBox(MSG_VME_NO_KEYMAPS,MSG_INFORMATION);
	return 255;
    }
    else
	return 255;
#elif #cpu (sparc)
    prefix="";
    choices= keymaps;
#elif #cpu (powerpc)
    prefix="";
    choices= keymaps;
#else
    prefix="i386/";
    choices= keymaps;
#endif
    if (kbd) {
	int i;
	for (i=0;i<nchoices;i++) {
		if (0 == strcmp(choices[i].tag,kbd)) {
			rs=i;
			break;
		}
	}
	if (rs == -1)
		problemBox(MSG_WRONG_KBD,MSG_WRONG_PARAM);
    }
    if (rs == -1)
	    rs=menuBox(msg,title,choices,nchoices,1);

    if(rs!=-1)
      {
	FILE *kbdconf;
	if (NULL==(kbdconf=fopen("/tmp/kbdconf","w"))) {
		problemBox(MSG_CANT_OPEN_KBDCONF,MSG_WRITE_ERROR);
		return 1;
	}
	fprintf(kbdconf,"%s%s",prefix,choices[rs].tag);
        fclose(kbdconf);
	sprintf(prtbuf,
		"zcat < /etc/keymaps.tgz | /bin/tarcat %s%s.bmap | /bin/loadkmap",
		prefix,choices[rs].tag);
#ifdef _TESTING_
	problemBox(prtbuf,"Test Box");
#else
	system(prtbuf);
#endif
      }
#ifdef _TESTING_
    else
      {
	problemBox("Configuration Cancelled","Test Box");
      }
#endif
  return rs;
}

/*
 * Trigger the case where there is no keyboard connected to the host
 * (full serial console install).
 * In this case, just write an empty kbdconf file used to tell the base setup
 * script to also skip keyboard configuration step.
 */
void check_for_keyboard(void)
{
#ifdef SERIAL_CONSOLE
    int tty0_avail;
#if #cpu (m68k)
    if (strcmp(Arch2, "VME") == 0)
	/* no keyboard connected to a VME board */
	tty0_avail = -1;
    else
	/* try to open /dev/tty0 ... */
#endif
    tty0_avail = open("/dev/tty0", O_RDWR);
    if (tty0_avail >= 0)
	/* don't get the FD opened */
	close( tty0_avail );
    else {
	/* write an empty kbdconf */
	int fd = open( "/tmp/kbdconf", O_WRONLY|O_CREAT, 0644 );
	close( fd );
    }
#endif
}


#ifdef _TESTING_
/* To test, compile using: make kbdconfig_test */
void main()
{
#if #cpu (m68k)
    Arch2 = "Atari";
#endif
    initScreen("Keyboard Config test program");

/* Use the following to test automatic kbd selection */
//    configure_keyboard("qwerty/es");

    configure_keyboard_m();

    finishScreen();
}
#endif
