// -*- mode: cpp; mode: fold -*-
// Description								/*{{{*/
// $Id: widget-thread.cc,v 1.1 1998/09/12 02:46:47 jgg Exp $
/* ######################################################################
   
   Widget Thread Support - Provides funcionality to allow the library
   to function in a multi-threaded environment.
   
   ###################################################################### */
									/*}}}*/
// Include Files							/*{{{*/
#ifdef __GNUG__
#pragma implementation "deity/widget-thread.h"
#endif
#include <deity/widget-thread.h>
#include <iostream.h>
#include <pthread.h>
									/*}}}*/

pthread_mutex_t Widget::Lock::Mutex = PTHREAD_MUTEX_INITIALIZER;
unsigned int Widget::Lock::Depth = 0;
pthread_t Widget::Lock::Owner;

// SNotify::SNotify - Constructor					/*{{{*/
// ---------------------------------------------------------------------
/* */
SNotify::SNotify(Tag Id) : Notifyer(Id), Counter(0)
{
   pthread_cond_init(&WaitCond,0);
   pthread_mutex_init(&WaitMutex,0);
}
									/*}}}*/
// SNotify::SNotify - Destructor					/*{{{*/
// ---------------------------------------------------------------------
/* */
SNotify::~SNotify()
{
   pthread_cond_destroy(&WaitCond);
   pthread_mutex_destroy(&WaitMutex);
}
									/*}}}*/
// SNotify::Trigger - Signal that the event has occured			/*{{{*/
// ---------------------------------------------------------------------
/* */
void SNotify::Trigger()
{
   pthread_mutex_lock(&WaitMutex);
   Counter++;
   if (Counter == 1)
      pthread_cond_signal(&WaitCond);
   pthread_mutex_unlock(&WaitMutex);
}
									/*}}}*/
// SNotify::Wait - Wait for this event to Trigger			/*{{{*/
// ---------------------------------------------------------------------
/* */
void SNotify::Wait()
{
   Widget::Detach Det;
   
   pthread_mutex_lock(&WaitMutex);
   if (Counter == 0)
      pthread_cond_wait(&WaitCond,&WaitMutex);
   Counter = 0;
   pthread_mutex_unlock(&WaitMutex);
}
									/*}}}*/

// Widget::Lock::Lock - Constructor					/*{{{*/
// ---------------------------------------------------------------------
/* This grabs the mutex and if it is the first lock for this thread then
   it records ownership. Otherwise it increments the depth counter. */
Widget::Lock::Lock() : Connected(true)
{
   if (pthread_mutex_trylock(&Mutex) != 0)
   {
      if (pthread_equal(pthread_self(),Owner) == 0)
	 pthread_mutex_lock(&Mutex);
      else
      {
	 Depth++;
	 return;
      }      
   }

   Depth = 1;
   Owner = pthread_self();
};
									/*}}}*/
// Widget::Lock::Detach - Release the lock				/*{{{*/
// ---------------------------------------------------------------------
/* This handles the recursive case */
void Widget::Lock::Detach()
{
   if (Connected == false)
      return;

   Connected = false;
   Depth--;
   if (Depth != 0)
      return;
   
   if (Root != 0)
      Root->DoActions();
   if (GenGC::GC != 0)
      GenGC::GC->Flush();
   pthread_mutex_unlock(&Mutex);
}
									/*}}}*/
// Widget::Lock::IsOwner - Check if this thread owns the lock		/*{{{*/
// ---------------------------------------------------------------------
/* */
bool Widget::Lock::IsOwner()
{
   if (pthread_mutex_trylock(&Mutex) != 0)
   {
      if (pthread_equal(pthread_self(),Owner) == 0)
	 return false;
      return true;
   }

   pthread_mutex_unlock(&Mutex);
   return false;
}
									/*}}}*/
// Widget::Detach::Detach - Detach from the widget library		/*{{{*/
// ---------------------------------------------------------------------
/* This allows widget event processing to continue while the class is in
   scope*/
Widget::Detach::Detach() : Connected(false)
{
   if (Lock::IsOwner() == false)
   {
      clog << "Lock owner check failed" << endl;
      Connected = true;
      return;
   }
   
   OldDepth = Lock::Depth;
   Lock::Depth = 0;
   
   if (Root != 0)
      Root->DoActions();
   if (GenGC::GC != 0)
      GenGC::GC->Flush();   
   
   pthread_mutex_unlock(&Lock::Mutex);
}
									/*}}}*/
// Widget::Detach::Connect - Reconnect to the library			/*{{{*/
// ---------------------------------------------------------------------
/* */
void Widget::Detach::Connect()
{
   if (Connected == true)
      return;
   
   pthread_mutex_lock(&Lock::Mutex);
   Lock::Depth = OldDepth;
   Connected = true;   
}
									/*}}}*/
