#include "xsidplay.h"

#include "images/mainicon.xpm"

MainDialog* myMainDlg;
QPixmap* myMainIcon;

bool expertMode = false;
AudioConfig bakAudioConfig;

// --------------------------------------------------------------------------

int main(int argc, char** argv)
{
    QApplication a(argc,argv);

    // The SIDPLAY taskbar/panel icon.
    myMainIcon = new QPixmap((const char**)mainicon_xpm);
	
    myMainDlg = new MainDialog;
    a.setMainWidget(myMainDlg);
	
    ConfigFile myConfigFile(".sidplayrc");
    // Somewhat difficult way to retrieve default config from emuEngine.
    myConfigFile.setEmuConfig(myMainDlg->getEmuConfig());

    myConfigFile.load();

    // Copy config to allow additional command line settings.
    AudioConfig myAudioConfig = myConfigFile.getAudioConfig();
    // Check some input parameters.
    if (myAudioConfig.bufSize!=0 && (myAudioConfig.bufSize<256))
        myAudioConfig.bufSize = 256;

    // Although we assume the command line user knows what he is doing,
    // we want to provide defaults for "expert" mode. If available, we copy
    // the argument line settings to a separate config.
    AudioConfig argLineAC = myAudioConfig;

    // -------------------------------------------------- Parse command line.

    unsigned int inFile = 0;
    int commandLineStartSong = 0;
        
    for (int a = 1; a < argc; a++)  
    {
        // Check for options prefix "-".
        if (argv[a][0] == '-')  
        {
            // Single "-" means reading from stdin.
            if (strlen(argv[a]) == 1)
			{
                if ( inFile == 0 )
                {
                    inFile = a;
                    break;
                }
                else
                {
                    cerr << "Command line syntax error." << endl;
                }
            }
            else
            {
                if (strnicmp(&argv[a][1],"-expert",7) == 0)
                    expertMode = true;
                else if (strnicmp(&argv[a][1],"bufsize",7) == 0)
                    argLineAC.bufSize = atoi(&argv[a][1+7]);
                else if (strnicmp(&argv[a][1],"maxfrags",8) == 0)
                    argLineAC.maxFrags = atoi(&argv[a][1+8]);
                else if (strnicmp(&argv[a][1],"fragsize",8) == 0)
                    argLineAC.fragSize = atoi(&argv[a][1+8]);
                else if (strnicmp(&argv[a][1],"o",1) == 0)
                    commandLineStartSong = atoi(&argv[a][1+1]);
            }
        }
        else
        {
            // No prefix. Thus is considered a filename argument.
            if ( inFile == 0 )
            {
                inFile = a;
            }
            else 
            {
                cerr << "Command line syntax error." << endl;
                break;
            }
        }
    }

    // ----------------------------------------------------------------------

    if (!expertMode)
    {
        // If the user has provided any command line arguments, these have
        // made it into the argLineAC. Override config file settings here.
        myAudioConfig.bufSize = argLineAC.bufSize;
        myAudioConfig.maxFrags = argLineAC.maxFrags;
        myAudioConfig.fragSize = argLineAC.fragSize;
        // Backup config will be saved on exit instead of run-time settings.
        // This makes sure, zeroes (0 => default) make it into the config
        // file again.
        bakAudioConfig = myAudioConfig;
    }
    else  // expert mode
    {
        // See whether to take command line settings or
        // provide moderate defaults.
        if (argLineAC.bufSize != myAudioConfig.bufSize)
            myAudioConfig.bufSize = argLineAC.bufSize;
        else
            myAudioConfig.bufSize = 2048;
        if (argLineAC.maxFrags != myAudioConfig.maxFrags)
            myAudioConfig.maxFrags = argLineAC.maxFrags;
        else
            myAudioConfig.maxFrags = 2;
        if (argLineAC.fragSize != myAudioConfig.fragSize)
            myAudioConfig.fragSize = argLineAC.fragSize;
        else
            myAudioConfig.fragSize = 11;
            
        if (myAudioConfig.bufSize < 4*280)  // waveView w=280!
            myAudioConfig.bufSize = 4*280;
    }
    myMainDlg->enableWaveViewDlg(expertMode);

    // Order is important for current implementation.
    myMainDlg->setEmuConfig(myConfigFile.getEmuConfig());
    myMainDlg->setHVSCconfig(myConfigFile.getHVSCconfig());
    myMainDlg->setAudioConfig(myAudioConfig);
    myMainDlg->setVariousConfig(myConfigFile.getVariousConfig());

    myMainDlg->show();

    if (inFile != 0)
    {
        //cout << "Loading sidtune ..." << endl;
        myMainDlg->loadSidTune(argv[inFile],commandLineStartSong);
    }

    // Give control to Qt.
    int qret = a.exec();
    
    delete myMainDlg;
    delete myMainIcon;
        
    return qret;
}
