
#include <OffiX/DragAndDrop.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Form.h>
#include <stdio.h>

XtAppContext app;

void DisplayDndData(XEvent *event);

void IconDropEventHandler(Widget,XtPointer,XEvent*,Boolean*);
void UnknownDropEventHandler(Widget,XtPointer,XEvent*,Boolean*);
void RootDropEventHandler(Widget,XtPointer,XEvent*,Boolean*);
void RawDropEventHandler(Widget,XtPointer,XEvent*,Boolean*);
void RawDragEventHandler(Widget,XtPointer,XEvent*,Boolean*);
void FileDropEventHandler(Widget,XtPointer,XEvent*,Boolean*);
void FileDragEventHandler(Widget,XtPointer,XEvent*,Boolean*);
void FilesDropEventHandler(Widget,XtPointer,XEvent*,Boolean*);
void FilesDragEventHandler(Widget,XtPointer,XEvent*,Boolean*);
void TextDropEventHandler(Widget,XtPointer,XEvent*,Boolean*);
void TextDragEventHandler(Widget,XtPointer,XEvent*,Boolean*);
void DirDropEventHandler(Widget,XtPointer,XEvent*,Boolean*);
void DirDragEventHandler(Widget,XtPointer,XEvent*,Boolean*);
void LinkDropEventHandler(Widget,XtPointer,XEvent*,Boolean*);
void LinkDragEventHandler(Widget,XtPointer,XEvent*,Boolean*);
void ExeDropEventHandler(Widget,XtPointer,XEvent*,Boolean*);
void ExeDragEventHandler(Widget,XtPointer,XEvent*,Boolean*);

int
main(int argc, char* argv[])
{
	Widget toplevel,form;
	Widget RawButton,FileButton,FilesButton,TextButton,DirButton,
	       LinkButton,ExeButton;
	
	toplevel=XtVaAppInitialize(&app,"Test2",NULL,0,
				   (Cardinal*)&argc,argv,
				   NULL,NULL);
	
	DndInitialize(toplevel);
	DndRegisterRootDrop(RootDropEventHandler);
	DndRegisterOtherDrop(UnknownDropEventHandler);
	DndRegisterIconDrop(IconDropEventHandler);

	form=XtVaCreateManagedWidget("Form",
		formWidgetClass, toplevel,
		NULL);
	
	RawButton=XtVaCreateManagedWidget("RawButton",
		commandWidgetClass, form,
		XtNlabel, "Raw Data", NULL);
	FileButton=XtVaCreateManagedWidget("FileButton",
		commandWidgetClass, form,
		XtNlabel, "File Name", 
		XtNfromHoriz, RawButton, NULL);
	FilesButton=XtVaCreateManagedWidget("FilesButton",
		commandWidgetClass, form,
		XtNlabel, "File List", 
		XtNfromHoriz, FileButton, NULL);
	TextButton=XtVaCreateManagedWidget("TextButton",
		commandWidgetClass, form,
		XtNlabel, "Text", 
		XtNfromHoriz, FilesButton, NULL);
	DirButton=XtVaCreateManagedWidget("DirButton",
		commandWidgetClass, form,
		XtNlabel, "Directory", 
		XtNfromHoriz, TextButton, NULL);
	LinkButton=XtVaCreateManagedWidget("LinkButton",
		commandWidgetClass, form,
		XtNlabel, "Link", 
		XtNfromHoriz, DirButton, NULL);
	ExeButton=XtVaCreateManagedWidget("ExeButton",
		commandWidgetClass, form,
		XtNlabel, "Program", 
		XtNfromHoriz, LinkButton, NULL);

	DndRegisterDragWidget(RawButton,RawDragEventHandler,NULL);
	DndRegisterDragWidget(FileButton,FileDragEventHandler,NULL);
	DndRegisterDragWidget(FilesButton,FilesDragEventHandler,NULL);
	DndRegisterDragWidget(TextButton,TextDragEventHandler,NULL);
	DndRegisterDragWidget(DirButton,DirDragEventHandler,NULL);
	DndRegisterDragWidget(LinkButton,LinkDragEventHandler,NULL);
	DndRegisterDragWidget(ExeButton,ExeDragEventHandler,NULL);

	DndRegisterDropWidget(RawButton,RawDropEventHandler,NULL);
	DndRegisterDropWidget(FileButton,FileDropEventHandler,NULL);
	DndRegisterDropWidget(FilesButton,FilesDropEventHandler,NULL);
	DndRegisterDropWidget(TextButton,TextDropEventHandler,NULL);
	DndRegisterDropWidget(DirButton,DirDropEventHandler,NULL);
	DndRegisterDropWidget(LinkButton,LinkDropEventHandler,NULL);
	DndRegisterDropWidget(ExeButton,ExeDropEventHandler,NULL);
	
	XtRealizeWidget(toplevel);
	XtAppMainLoop(app);
	return 0;		
}

void DisplayDndData(XEvent *event)
{
	static char *names[]={
		"Unknown data",
		"Raw data",
		"File name",
		"File list",
		"Text",
		"Directory",
		"Link",
		"Program"
	};
	char *filename; unsigned long i;
	unsigned char *Data;
	int Type;
	unsigned long Size;
		
	Type=DndDataType(event);
	DndGetData(&Data,&Size);
	
	fprintf(stderr,"Data type: %s : Data Size : %ld\n",names[Type],Size);
	fprintf(stderr,"Raw Contents : ");
	for(i=0;i!=Size;i++)
	{	if(Data[i]!=0) fprintf(stderr,"%c",Data[i]);
		else  fprintf(stderr,"#");
	}
	fprintf(stderr,"\nContents:\n");
	if(Type == DndFiles)
	{		
		filename = Data;
		while (filename[0] != '\0')
		{
			fprintf(stderr,"%s\n",filename);
			filename = filename + strlen(filename) + 1;
		}	
	}	
	else
		fprintf(stderr,"%s\n",Data);
	  
	fprintf(stderr,"------------------------------------------\n");
}

void RawDropEventHandler(Widget widget,XtPointer data,XEvent* event,Boolean* b)
{
	fprintf(stderr,"------------------------------------------\n");
	fprintf(stderr,"Dropped on RAW !\n");
	DisplayDndData(event);
}

void FileDropEventHandler(Widget widget,XtPointer data,XEvent* event,Boolean* b)
{
	fprintf(stderr,"------------------------------------------\n");
	fprintf(stderr,"Dropped on FILE !\n");
	DisplayDndData(event);
}

void FilesDropEventHandler(Widget widget,XtPointer data,XEvent* event,Boolean* b)
{
	fprintf(stderr,"------------------------------------------\n");
	fprintf(stderr,"Dropped on FILES !\n");
	DisplayDndData(event);
}

void TextDropEventHandler(Widget widget,XtPointer data,XEvent* event,Boolean* b)
{
	fprintf(stderr,"------------------------------------------\n");
	fprintf(stderr,"Dropped on TEXT !\n");
	DisplayDndData(event);
}

void DirDropEventHandler(Widget widget,XtPointer data,XEvent* event,Boolean* b)
{
	fprintf(stderr,"------------------------------------------\n");
	fprintf(stderr,"Dropped on DIR !\n");
	DisplayDndData(event);
}

void LinkDropEventHandler(Widget widget,XtPointer data,XEvent* event,Boolean* b)
{
	fprintf(stderr,"------------------------------------------\n");
	fprintf(stderr,"Dropped on LINK !\n");
	DisplayDndData(event);
}

void ExeDropEventHandler(Widget widget,XtPointer data,XEvent* event,Boolean* b)
{
	fprintf(stderr,"------------------------------------------\n");
	fprintf(stderr,"Dropped on PROG !\n");
	DisplayDndData(event);
}

void RawDragEventHandler(Widget widget,XtPointer data,XEvent* event,Boolean* b)
{
	DndSetData(DndRawData,"Anything!",10);
	DndHandleDragging(widget,event);
}

void FileDragEventHandler(Widget widget,XtPointer data,XEvent* event,Boolean* b)
{
	DndSetData(DndFile,"Makefile",9);
	DndHandleDragging(widget,event);
}

void FilesDragEventHandler(Widget widget,XtPointer data,XEvent* event,Boolean* b)
{
	DndSetData(DndFiles,"Makefile\0Imakefile\0",20);
	DndHandleDragging(widget,event);
}

void TextDragEventHandler(Widget widget,XtPointer data,XEvent* event,Boolean* b)
{
	DndSetData(DndText,"Hello. I'm DND!",16);
	DndHandleDragging(widget,event);
}

void DirDragEventHandler(Widget widget,XtPointer data,XEvent* event,Boolean* b)
{
	DndSetData(DndDir,"..",3);
	DndHandleDragging(widget,event);
}

void LinkDragEventHandler(Widget widget,XtPointer data,XEvent* event,Boolean* b)
{
	DndSetData(DndLink,"Stale link",11);
	DndHandleDragging(widget,event);
}

void ExeDragEventHandler(Widget widget,XtPointer data,XEvent* event,Boolean* b)
{
	DndSetData(DndExe,"sed",4);
	DndHandleDragging(widget,event);
}

void RootDropEventHandler(Widget widget,XtPointer data,XEvent* event,Boolean* b)
{
	fprintf(stderr,"Dropped on root window!\n");
}

void UnknownDropEventHandler(Widget widget,XtPointer data,XEvent* event,Boolean* b)
{
	fprintf(stderr,"Dropped somewhere here!\n");
}

void IconDropEventHandler(Widget widget,XtPointer data,XEvent* event,Boolean* b)
{
	fprintf(stderr,"Dropped on my icon!\n");
}
