#define BLOCKS_PER_WRITE	4
#define CD_BLOCK_SIZE	2048
#define WRITE_BLOCK_SIZE	(CD_BLOCK_SIZE * BLOCKS_PER_WRITE)

extern int pack_id;
extern int auto_request_sense;

/* SCSI command opcodes */
#define TEST_UNIT_READY 	0x00
#define REZERO_UNIT		0x01
#define REQUEST_SENSE		0x03
#define WRITE_6			0x0a
#define INQUIRY			0x12
#define MODE_SELECT		0x15
#define START_STOP		0x1b
#define ALLOW_MEDIUM_REMOVAL	0x1e
#define READ_CAPACITY		0x25
#define SYNCRONIZE_CACHE	0x35

/* SCSI-commands - PHILLIPS specific.  If we fix the program to use multiple
   writers, this would be something that needs attention. */
#define RESERVE_TRACK	0xE4
#define WRITE_TRACK	0xE6
#define LOAD_UNLOAD	0xE7
#define FIXATION	0xE9	/* Write table of contents */
#define RECOVER		0xEC

/* This is the definition of the linux header for the scsi-generic interface.
   I am not sure how best to generalize this to other platforms */

struct sg_header
 {
  int pack_len;    /* length of incoming packet <4096 (including header) */
  int reply_len;   /* maximum length <4096 of expected reply */
  int pack_id;     /* id number of packet */
  int result;      /* 0==ok, otherwise refer to errno codes */
  int flags;			/* for future use */
  unsigned char sense_buffer[16]; /* used only by reads */
  /* command follows then data for command */
 };


struct sg_request {
   struct sg_header header;
   unsigned char bytes[WRITE_BLOCK_SIZE];
} sg_request;

struct sg_reply {
   struct sg_header header;
   unsigned char bytes[100];
};


