.TH Xlife 6 
.SH NAME
Xlife - Conway's Game of Life for X, version 2.0
.SH SYNTAX
.B xlife [-geometry string] [-bw width] [initial pattern file]
.SH DESCRIPTION
.NXR "xlife"
.PN xlife
brings up a single window in which the user may play the game of life.

The universe is effectivly unbounded (4.2 billion on a side)
The algorithim uses hashed 8x8 boxes of cells, and computes the next 
generation by using lookup tables for added speed.

By default Xlife will run in a window taking up your entire screen. The -bw
option allows you to pass Xlife the width of the borders created by your window
manager, for use in the internal window size calculation.

The -geometry option sets the Xlife window size and position as per usual for
X applications.

If possible, you should tell your window manager to create Xlife without a
title bar; otherwise you will have to use -geometry to set the window's
vertical size enough smaller than the default that the title bar doesn't
crowd the bottom of the window off the screen.

.SH COMMANDS
.IP \fB8\fR 20 
Move your view of the universe up.
.IP \fB2\fR 20 
Move your view of the universe down.
.IP \fB6\fR 20
Move your view of the universe right.
.IP \fB4\fR 20
Move your view of the universe left.
.IP \fB5\fR 20
Center the universe on the screen (based on average position of the cells).
.IP \fB=,+\fR 20
Zoom the view in, magnifying the area around the mouse cursor.
.IP \fB\-\fR 20
Zoom the view out.
.IP \fBg\fR 20
Toggle running the game.
.IP \fBo\fR 20
Step forward one generation.
.IP \fBS\fR 20
Save the universe to a file adding extention .life.
.IP \fBl\fR 20
Load (actually add to) the universe from a file with extention .life.
This lets you overlay multiple saved states to make for some interesting
effects. Clear the universe if you want to start from scratch.
.IP \fBh\fR 20
(Hide) stop displaying after each generation, does not iconify.
.IP \fBc\fR 20
Toggle showing of cell counts
.IP \fB?\fR 20
Help for xlife.
.IP \fB!\fR 20
Place random cells on the area of the universe on the screen.
.IP \fBr\fR 20
Redraw the screen.
.IP \fBR\fR 20
Change the rules in "stays alive on"/"born on"
format. The standard rules are 23/3 (alive on two or three
neighbors, birth on three neighbors for an empty cell).
.IP \fBN\fR 20
Change the file's internal name.
.IP \fBA\fR 20
Add comments.
.IP \fBV\fR 20
View comments.
.IP \fBC\fR 20
Clear the universe.
.IP \fBQ\fR 20
Quit
.IP \fBButtons\fR 20
.IP \fB1\fR 20
Activate a cell at the cursor.
.IP \fB2\fR 20 
Center the universe view on the cursor.
.IP \fB3\fR 20 
Delete a cell at the cursor.
.IP \fBf\fR 20 
Run at a fast speed (no delay)
.IP \fBm\fR 20 
Run at a medium speed
.IP \fBs\fR 20 
Run at a slow speed

.SH LOAD FILE FORMAT
A .life image file is an ordinary text file consisting of lines terminated by
the newline character. It is interpreted as one or more image sections
separated by section lines beginning with '#'. Lines led by `##' are
considered comments and ignored.

Each image section is interpreted according to the format letter following its
section line #. The format letters are:

A -- Absolute.
Each line is interpreted as an absolute (x,y) coordinate pair.

R -- Relative.
Each line is interpreted as a relative (x,y) coordinate pair.

P -- Picture.
Each line in the section is interpreted as a scan line of a relative image.
Each '*' character turns the corresponding bit on. All other characters leave
the corresponding bit off.

I -- Include.
A #I line should have whitespace-separated fields after the #I; a pattern name
and optionally two integers interpreted as x and y offsets. The named pattern
file is loaded as if it had been included in the image at this point. The
offsets, if present, displace the load point of the pattern relative to the
current mouse position. The include facility is useful for assembling `sampler'
collections of interesting patterns.

Relative image sections are normally drawn with 0,0 on the current mouse
position (coordinates may be negative). This may be changed by including a
pair of whitespace-separated integers after the format character. If this is
done, these will be interpreted as a pair of x and y offsets, and the image
section will be drawn with its upper left corner displaced from the cursor
position by those offsets. This facility can be used to write image files
that will load patterns centered on the cursor.

A leading image section with no header line is treated as though it had a `#A'
header. Thus, version 1.00 image files will load properly.

N -- Name
This line contains the internal name of the pattern (which may differ from the
XXX.life name of the file.

O -- Owner
This line contains information on the person who wrote the file, it is written
in the form: id "name"@machine date, for example.

#O jb7m "Jon C. R. Bennett"@sushi.andrew.cmu.edu Fri Jan 12 18:25:54 1990

C -- Comment
Lines begining with "C" are comments that the user may have automaticaly writen
to the save file, and which may be viewed from withen Xlife.

More section formats may be added in the future. 

.SH RESTRICTIONS
none

.SH AUTHORS
Algorithm, implementation and file format enhancements:
	Jon Bennett jcrb@cs.cmu.edu

Original X code:
	Chuck Silvers cs4n@andrew.cmu.edu

Auto-sizing, X options and load format enhancements:
	Eric S. Raymond (eric@snark.uu.net)

.SH SEE ALSO   
xtrek(6)
