------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                               I T Y P E S                                --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.17 $                             --
--                                                                          --
--   Copyright (C) 1992,1993,1994,1995,1996 Free Software Foundation, Inc.  --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- GNAT was originally developed  by the GNAT team at  New York University. --
-- It is now maintained by Ada Core Technologies Inc (http://www.gnat.com). --
--                                                                          --
------------------------------------------------------------------------------

--  This package contains declarations for handling of implicit types

with Einfo;    use Einfo;
with Sem_Util; use Sem_Util;
with Types;    use Types;

package Itypes is

   --------------------
   -- Implicit Types --
   --------------------

   --  Implicit types are types and subtypes created by the semantic phase
   --  or the expander to reflect the underlying semantics. These could be
   --  generated by building trees for corresponding declarations and then
   --  analyzing these trees, but there are two reasons for not doing this:

   --    1. The declarations would require more tree nodes

   --    2. In some cases, the elaboration of these types is associated
   --       with internal nodes in the tree.

   --  So instead, implicit types are constructed by simply creating an
   --  appropriate entity with the help of routines in this package. These
   --  entities are fully decorated, as described in Einfo (just as though
   --  they had been created by the normal analysis procedure).

   --  Implicit types appear in two contexts. Most of the time, they appear
   --  on N_Implicit_Types nodes, which serve as a place holder for the
   --  elaboration of implicit types. These nodes are equivalent to any
   --  other declaration, and may appear whereever a declaration node would
   --  be appropriate.

   --  The other situation in which implicit types occur is attached to
   --  certain interior nodes in the tree. In this case, the semantics
   --  is that these types are elaborated after the elaboration of any
   --  children of the node, and before the elaboration of the node itself.
   --  The following nodes can contain such embedded implicit types:

   --  (THIS LIST IS PROBABLY BADLY OUT OF DATE ???)

   --    * N_Procedure_Specification:
   --    * N_Entry_Body:
   --    * N_Accept_Statement:
   --        -  implicit formal access type

   --    * N_Entry_Declaration:
   --        - implicit formal access type
   --        - implicit index (for families)

   --    * N_Freeze_Entity:
   --        - implicit types attached to a N_Object_Declaration may be moved
   --          to their own N_Freeze node when this one is inserted before the
   --          object declaration

   --    * N_Implicit_Types:

   --        These nodes are introduced when it is not possible to attach an
   --        implicit type to the related syntax node because it causes
   --        order of elaboration problems. This situation happens for
   --        object declarations where two potentially contradictory
   --        situations must be handled
   --
   --          X : Uncontrained_Type := Init_Value_Aggregate;
   --          X : Uncontrained_Type (Constraints) := Init_Value_Aggregate;
   --
   --        in the first case the anonymous constained_type depends on the
   --        anonymous aggregate types. In the second case, the dependancy
   --        is the other way around.

   --  Subexpression nodes

   --    * N_Slice:
   --        - implicit index type
   --        - implicit slice Subtype

   --    * N_Aggregate:
   --        - implicit constrained subtypes

   --    * N_String_Literal:
   --        - implicit string subtype

   --    * N_Allocator:
   --        - implicit access type
   --        - explicit constrained designated subtype (this one is not an
   --          implicit type, i.e. the tree is generated for its declaration)
   --          this is a peculiarity.

   --    * N_Reference
   --        - implicit access type

   --  Note: the set of nodes listed above is covered by the subtype
   --  N_Has_Itypes. Such nodes have a First_Itype field that is either
   --  Empty if there are no associated Itypes, or points to the first
   --  entity on the list of Itypes if there are Itypes. In addition such
   --  nodes have a Has_Dynamic_Itype flag that is set if any of the
   --  entities in the list is for a dynamic implicit type (one which has
   --  variable bounds or other data that must be elaborated).

   --  Note: N_Has_Itypes includes N_Subtype_Indication, even though it is
   --  not listed above. This is for purely technical reasons, to accomodate
   --  the restriction that the node types for which Itypes are present must
   --  have contiguous codes so that N_Has_Itypes can be declared. The two
   --  fields are always unused, i.e. First_Itype is always Empty for a
   --  subtype indication node, and Has_Dynamic_Itype is always False.

   -----------------
   -- Subprograms --
   -----------------

   function Create_Itype
     (Ekind        : Entity_Kind;
      Loc          : Source_Ptr;
      Related_Id   : Entity_Id := Empty;
      Suffix       : Character := ' ';
      Suffix_Index : Nat       := 0;
      Scope_Id     : Entity_Id := Current_Scope)
      return         Entity_Id;
   --  Used to create a new Itype. The Itype is not yet inserted in the tree
   --  so the caller must make a subsequent call to Insert_Itype to place it
   --  in the tree at the appropriate point.

   --   Related_Id is present only if the implicit type name may be referenced
   --   as a public symbol, and thus needs a unique external name. The name
   --   is created by a call to:
   --
   --     New_External_Name (Chars (Related_Id), Suffix, Suffix_Index, 'T')
   --
   --   If the implicit type does not need an external name, then the
   --   Related_Id parameter is omitted (and hence Empty). In this case
   --   Suffix and Suffix_Index are ignored and the implicit type name is
   --   created by a call to New_Internal_Name ('T').
   --
   --   Note that in all cases, the name starts with "T". This is used
   --   to identify implicit types in the error message handling circuits.
   --
   --  The Scope_Id parameter specifies the scope of the created type, and
   --  is normally the Current_Scope as shown, but can be set otherwise.

   procedure Insert_Itype (Ins_Node : Node_Id; E : Entity_Id);
   --  The Itype whose entity is given by E is inserted into the tree at
   --  the position given by node Ins_Node. Usually the result is to insert
   --  a new N_Implicit_Types node referencing E, using Insert_Actions.
   --  However there are some exceptions, where the Itype must be attached
   --  to some other node. See body for further details.

   function Create_Itype_And_Insert
     (Ekind        : Entity_Kind;
      Ins_Node      : Node_Id;
      Related_Id   : Entity_Id   := Empty;
      Suffix       : Character   := ' ';
      Suffix_Index : Nat         := 0;
      Scope_Id     : Entity_Id   := Current_Scope)
      return         Entity_Id;
   --  Combines the functions of Create_Itype and Insert_Itype. The parameters
   --  correspond naturally by name, except that the location (Loc) for the
   --  call to Create_Itype is taken from Loc (Ins_Node).

   procedure Transfer_Itypes (From : Node_Id; To : Node_Id);
   --  Move the implicit types from node From to node To.

end Itypes;
