------------------------------------------------------------------------------

--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                               B C H E C K                                --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.15 $                             --
--                                                                          --
--     Copyright (C) 1992,1993,1994,1995 Free Software Foundation, Inc.     --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- GNAT was originally developed  by the GNAT team at  New York University. --
-- It is now maintained by Ada Core Technologies Inc (http://www.gnat.com). --
--                                                                          --

with ALI;     use ALI;
with Binderr; use Binderr;
with Namet;   use Namet;
with Opt;     use Opt;
with Types;   use Types;

package body Bcheck is

   --------------------
   -- Check_Versions --
   --------------------

   procedure Check_Versions is
   begin
      for A in ALIs.First .. ALIs.Last loop

         if ALIs.Table (A).Ver /= ALIs.Table (ALIs.First).Ver then
            Error_Msg_Name_1 := Unit.Table (ALIs.Table (A).First_Unit).Sfile;
            Error_Msg_Name_2 :=
              Unit.Table (ALIs.Table (ALIs.First).First_Unit).Sfile;

            if Ignore_Time_Stamp_Errors then
               Error_Msg
                 ("?% and % compiled with different GNAT versions");
            else
               Error_Msg
                 ("% and % compiled with different GNAT versions");
            end if;
         end if;

         if ALIs.Table (A).Std /= ALIs.Table (ALIs.First).Std then
            Error_Msg_Name_1 := Unit.Table (ALIs.Table (A).First_Unit).Sfile;
            Error_Msg_Name_2 :=
              Unit.Table (ALIs.Table (ALIs.First).First_Unit).Sfile;

            if Ignore_Time_Stamp_Errors then
               Error_Msg
                 ("?% and % compiled with different versions of Standard");
            else
               Error_Msg
                 ("% and % compiled with different versions of Standard");
            end if;
         end if;
      end loop;
   end Check_Versions;

   -------------------------------------
   -- Check_Configuration_Consistency --
   -------------------------------------

   procedure Check_Configuration_Consistency is
   begin
      --  Check consistent queueng policy

      if Queuing_Policy = 'P' then
         for A1 in ALIs.First .. ALIs.Last loop
            if ALIs.Table (A1).Queuing_Policy = 'F' then
               for A2 in ALIs.First .. ALIs.Last loop
                  if ALIs.Table (A2).Queuing_Policy = 'P' then
                     Error_Msg_Name_1 :=
                       Unit.Table (ALIs.Table (A1).First_Unit).Sfile;
                     Error_Msg_Name_2 :=
                       Unit.Table (ALIs.Table (A2).First_Unit).Sfile;

                     if Ignore_Time_Stamp_Errors then
                        Error_Msg
                          ("?% and % compiled with different " &
                           "queuing policies");
                     else
                        Error_Msg
                          ("% and % compiled with different " &
                           "queuing policies");
                     end if;

                     return;
                  end if;
               end loop;

               pragma Assert (False);
            end if;
         end loop;
      end if;
   end Check_Configuration_Consistency;

   -----------------------
   -- Check_Consistency --
   -----------------------

   procedure Check_Consistency is
      Src : Source_Id;
      --  Source file Id for this Sdep entry

   begin
      --  Loop through ALI files

      ALIs_Loop : for A in ALIs.First .. ALIs.Last loop

         --  Loop through Sdep entries in one ALI file

         Sdep_Loop : for D in
           ALIs.Table (A).First_Sdep .. ALIs.Table (A).Last_Sdep
         loop
            Src := Source_Id (Get_Name_Table_Info (Sdep.Table (D).Sfile));

            --  If stamp does not match, generate error message

            if Sdep.Table (D).Stamp /= Source.Table (Src).Stamp then
               Error_Msg_Name_1 := ALIs.Table (A).Sfile;
               Error_Msg_Name_2 := Sdep.Table (D).Sfile;

               --  Two styles of message, depending on whether or not
               --  the updated file is the one that must be recompiled

               if Error_Msg_Name_1 = Error_Msg_Name_2 then
                  if Ignore_Time_Stamp_Errors then
                     Error_Msg
                        ("?% has been modified and should be recompiled");
                  else
                     Error_Msg
                       ("% has been modified and must be recompiled");
                  end if;

               else
                  if Ignore_Time_Stamp_Errors then
                     Error_Msg
                       ("?% should be recompiled (% has been modified)");
                  else
                     Error_Msg
                       ("% must be recompiled (% has been modified)");
                  end if;
               end if;

               if (not Ignore_Time_Stamp_Errors) and Verbose_Mode then
                  declare
                     Msg : constant String := "file % has time stamp ";
                     Buf : String (1 .. Msg'Length + Time_Stamp_Length);

                  begin
                     Buf (1 .. Msg'Length) := Msg;
                     Buf (Msg'Length + 1 .. Buf'Length) :=
                       Source.Table (Src).Stamp;
                     Error_Msg_Name_1 := ALIs.Table (A).Sfile;
                     Error_Msg (Buf);

                     Buf (Msg'Length + 1 .. Buf'Length) :=
                       Sdep.Table (D).Stamp;
                     Error_Msg_Name_1 := Sdep.Table (D).Sfile;
                     Error_Msg (Buf);
                  end;
               end if;

               --  Exit from the loop through Sdep entries once we find one
               --  that does not match.

               exit Sdep_Loop;
            end if;

         end loop Sdep_Loop;
      end loop ALIs_Loop;
   end Check_Consistency;

end Bcheck;
